/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import io.papermc.paper.inventory.recipe.ItemOrExact;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.ClientboundSetPlayerInventoryPacket;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityEquipment;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftHumanEntity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryHolder;

public class PlayerInventory
implements IInventory,
INamableTileEntity {
    public static final int b = 5;
    public static final int c = 36;
    public static final int d = 9;
    public static final int e = 40;
    public static final int f = -1;
    public static final Int2ObjectMap<EnumItemSlot> g = new Int2ObjectArrayMap(Map.of(EnumItemSlot.c.a(36), EnumItemSlot.c, EnumItemSlot.d.a(36), EnumItemSlot.d, EnumItemSlot.e.a(36), EnumItemSlot.e, EnumItemSlot.f.a(36), EnumItemSlot.f, 40, EnumItemSlot.b));
    private final NonNullList<ItemStack> i = NonNullList.a(36, ItemStack.l);
    private int j;
    public final EntityHuman h;
    public final EntityEquipment k;
    private int l;
    public static final EnumItemSlot[] EQUIPMENT_SLOTS_SORTED_BY_INDEX = (EnumItemSlot[])g.int2ObjectEntrySet().stream().sorted(Comparator.comparingInt(Int2ObjectMap.Entry::getIntKey)).map(Map.Entry::getValue).toArray(EnumItemSlot[]::new);
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 99;

    @Override
    public List<ItemStack> getContents() {
        ArrayList<ItemStack> combined = new ArrayList<ItemStack>(this.i.size() + g.size());
        combined.addAll(this.i);
        for (EnumItemSlot equipmentSlot : EQUIPMENT_SLOTS_SORTED_BY_INDEX) {
            ItemStack itemStack = this.k.a(equipmentSlot);
            combined.add(itemStack);
        }
        return combined;
    }

    public List<ItemStack> getArmorContents() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (EnumItemSlot equipmentSlot : EQUIPMENT_SLOTS_SORTED_BY_INDEX) {
            if (!equipmentSlot.f()) continue;
            items.add(this.k.a(equipmentSlot));
        }
        return items;
    }

    @Override
    public void onOpen(CraftHumanEntity player) {
        this.transaction.add(player);
    }

    @Override
    public void onClose(CraftHumanEntity player) {
        this.transaction.remove(player);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public InventoryHolder getOwner() {
        return this.h.getBukkitEntity();
    }

    @Override
    public int ak_() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    @Override
    public Location getLocation() {
        return this.h.getBukkitEntity().getLocation();
    }

    public PlayerInventory(EntityHuman player, EntityEquipment equipment) {
        this.h = player;
        this.k = equipment;
    }

    public int f() {
        return this.j;
    }

    public void c(int slot) {
        if (!PlayerInventory.e(slot)) {
            throw new IllegalArgumentException("Invalid selected slot");
        }
        this.j = slot;
    }

    public ItemStack g() {
        return this.i.get(this.j);
    }

    public ItemStack b(ItemStack stack) {
        return this.i.set(this.j, stack);
    }

    public static int h() {
        return 9;
    }

    public NonNullList<ItemStack> i() {
        return this.i;
    }

    private boolean a(ItemStack destination, ItemStack origin) {
        return !destination.f() && destination.l() && destination.M() < this.f_(destination) && ItemStack.c(destination, origin);
    }

    public int canHold(ItemStack itemStack) {
        int remains = itemStack.M();
        for (int slot = 0; slot < this.i.size(); ++slot) {
            ItemStack itemInSlot = this.a(slot);
            if (itemInSlot.f()) {
                return itemStack.M();
            }
            if (this.a(itemInSlot, itemStack)) {
                remains -= (itemInSlot.k() < this.ak_() ? itemInSlot.k() : this.ak_()) - itemInSlot.M();
            }
            if (remains > 0) continue;
            return itemStack.M();
        }
        ItemStack itemInOffhand = this.k.a(EnumItemSlot.b);
        if (this.a(itemInOffhand, itemStack)) {
            remains -= (itemInOffhand.k() < this.ak_() ? itemInOffhand.k() : this.ak_()) - itemInOffhand.M();
        }
        if (remains <= 0) {
            return itemStack.M();
        }
        return itemStack.M() - remains;
    }

    public int j() {
        for (int i2 = 0; i2 < this.i.size(); ++i2) {
            if (!this.i.get(i2).f()) continue;
            return i2;
        }
        return -1;
    }

    public void addAndPickItem(ItemStack stack, int targetSlot) {
        int freeSlot;
        this.c(targetSlot);
        if (!this.i.get(this.j).f() && (freeSlot = this.j()) != -1) {
            this.i.set(freeSlot, this.i.get(this.j));
        }
        this.i.set(this.j, stack);
    }

    public void pickSlot(int index, int targetSlot) {
        this.c(targetSlot);
        ItemStack itemStack = this.i.get(this.j);
        this.i.set(this.j, this.i.get(index));
        this.i.set(index, itemStack);
    }

    public static boolean e(int index) {
        return index >= 0 && index < 9;
    }

    public int d(ItemStack stack) {
        for (int i2 = 0; i2 < this.i.size(); ++i2) {
            if (this.i.get(i2).f() || !ItemStack.c(stack, this.i.get(i2))) continue;
            return i2;
        }
        return -1;
    }

    public static boolean e(ItemStack stack) {
        return !stack.n() && !stack.F() && !stack.c(DataComponents.g);
    }

    public int findSlotMatchingCraftingIngredient(ItemOrExact item, ItemStack stack) {
        for (int i2 = 0; i2 < this.i.size(); ++i2) {
            ItemStack itemStack = this.i.get(i2);
            if (itemStack.f() || !item.matches(itemStack) || item instanceof ItemOrExact.Item && !PlayerInventory.e(itemStack) || !stack.f() && !ItemStack.c(stack, itemStack)) continue;
            return i2;
        }
        return -1;
    }

    public int k() {
        int i1;
        for (int i2 = 0; i2 < 9; ++i2) {
            i1 = (this.j + i2) % 9;
            if (!this.i.get(i1).f()) continue;
            return i1;
        }
        for (int ix = 0; ix < 9; ++ix) {
            i1 = (this.j + ix) % 9;
            if (this.i.get(i1).F()) continue;
            return i1;
        }
        return this.j;
    }

    public int a(Predicate<ItemStack> stackPredicate, int maxCount, IInventory inventory) {
        int i2 = 0;
        boolean flag = maxCount == 0;
        i2 += ContainerUtil.a(this, stackPredicate, maxCount - i2, flag);
        i2 += ContainerUtil.a(inventory, stackPredicate, maxCount - i2, flag);
        ItemStack carried = this.h.bR.g();
        i2 += ContainerUtil.a(carried, stackPredicate, maxCount - i2, flag);
        if (carried.f()) {
            this.h.bR.a(ItemStack.l);
        }
        return i2;
    }

    private int k(ItemStack stack) {
        int slotWithRemainingSpace = this.f(stack);
        if (slotWithRemainingSpace == -1) {
            slotWithRemainingSpace = this.j();
        }
        return slotWithRemainingSpace == -1 ? stack.M() : this.d(slotWithRemainingSpace, stack);
    }

    private int d(int slot, ItemStack stack) {
        int i2;
        int min;
        int count = stack.M();
        ItemStack item = this.a(slot);
        if (item.f()) {
            item = stack.c(0);
            this.a(slot, item);
        }
        if ((min = Math.min(count, i2 = this.f_(item) - item.M())) == 0) {
            return count;
        }
        item.g(min);
        item.d(5);
        return count -= min;
    }

    public int f(ItemStack stack) {
        if (this.a(this.a(this.j), stack)) {
            return this.j;
        }
        if (this.a(this.a(40), stack)) {
            return 40;
        }
        for (int i2 = 0; i2 < this.i.size(); ++i2) {
            if (!this.a(this.i.get(i2), stack)) continue;
            return i2;
        }
        return -1;
    }

    public void l() {
        for (int i2 = 0; i2 < this.i.size(); ++i2) {
            ItemStack item = this.a(i2);
            if (item.f()) continue;
            item.a(this.h.dV(), (Entity)this.h, i2 == this.j ? EnumItemSlot.a : null);
        }
    }

    public boolean g(ItemStack stack) {
        return this.c(-1, stack);
    }

    public boolean c(int slot, ItemStack stack) {
        if (stack.f()) {
            return false;
        }
        try {
            int count;
            if (stack.n()) {
                if (slot == -1) {
                    slot = this.j();
                }
                if (slot >= 0) {
                    this.i.set(slot, stack.g());
                    this.i.get(slot).d(5);
                    return true;
                }
                if (this.h.fV()) {
                    stack.e(0);
                    return true;
                }
                return false;
            }
            do {
                count = stack.M();
                if (slot == -1) {
                    stack.e(this.k(stack));
                    continue;
                }
                stack.e(this.d(slot, stack));
            } while (!stack.f() && stack.M() < count);
            if (stack.M() == count && this.h.fV()) {
                stack.e(0);
                return true;
            }
            return stack.M() < count;
        }
        catch (Throwable var6) {
            CrashReport crashReport = CrashReport.a(var6, "Adding item to inventory");
            CrashReportSystemDetails crashReportCategory = crashReport.a("Item being added");
            crashReportCategory.a("Item ID", Item.a(stack.h()));
            crashReportCategory.a("Item data", stack.o());
            crashReportCategory.a("Item name", () -> stack.y().getString());
            throw new ReportedException(crashReport);
        }
    }

    public void h(ItemStack stack) {
        this.a(stack, true);
    }

    public void a(ItemStack stack, boolean sendPacket) {
        while (!stack.f()) {
            EntityHuman entityHuman;
            int slotWithRemainingSpace = this.f(stack);
            if (slotWithRemainingSpace == -1) {
                slotWithRemainingSpace = this.j();
            }
            if (slotWithRemainingSpace == -1) {
                this.h.a(stack, false);
                break;
            }
            int i2 = stack.k() - this.a(slotWithRemainingSpace).M();
            if (!this.c(slotWithRemainingSpace, stack.a(i2)) || !sendPacket || !((entityHuman = this.h) instanceof EntityPlayer)) continue;
            EntityPlayer serverPlayer = (EntityPlayer)entityHuman;
            serverPlayer.f.b(this.f(slotWithRemainingSpace));
        }
    }

    public ClientboundSetPlayerInventoryPacket f(int slot) {
        return new ClientboundSetPlayerInventoryPacket(slot, this.a(slot).v());
    }

    @Override
    public ItemStack a(int index, int count) {
        ItemStack itemStack;
        if (index < this.i.size()) {
            return ContainerUtil.a(this.i, index, count);
        }
        EnumItemSlot equipmentSlot = (EnumItemSlot)g.get(index);
        if (equipmentSlot != null && !(itemStack = this.k.a(equipmentSlot)).f()) {
            return itemStack.a(count);
        }
        return ItemStack.l;
    }

    public void i(ItemStack stack) {
        for (int i2 = 0; i2 < this.i.size(); ++i2) {
            if (this.i.get(i2) != stack) continue;
            this.i.set(i2, ItemStack.l);
            return;
        }
        for (EnumItemSlot equipmentSlot : g.values()) {
            ItemStack itemStack = this.k.a(equipmentSlot);
            if (itemStack != stack) continue;
            this.k.a(equipmentSlot, ItemStack.l);
            return;
        }
    }

    @Override
    public ItemStack b(int index) {
        if (index < this.i.size()) {
            ItemStack itemStack = this.i.get(index);
            this.i.set(index, ItemStack.l);
            return itemStack;
        }
        EnumItemSlot equipmentSlot = (EnumItemSlot)g.get(index);
        return equipmentSlot != null ? this.k.a(equipmentSlot, ItemStack.l) : ItemStack.l;
    }

    @Override
    public void a(int index, ItemStack stack) {
        EnumItemSlot equipmentSlot;
        if (index < this.i.size()) {
            this.i.set(index, stack);
        }
        if ((equipmentSlot = (EnumItemSlot)g.get(index)) != null) {
            this.k.a(equipmentSlot, stack);
        }
    }

    public NBTTagList a(NBTTagList listTag) {
        for (int i2 = 0; i2 < this.i.size(); ++i2) {
            if (this.i.get(i2).f()) continue;
            NBTTagCompound compoundTag = new NBTTagCompound();
            compoundTag.a("Slot", (byte)i2);
            listTag.add(this.i.get(i2).b(this.h.dX(), compoundTag));
        }
        return listTag;
    }

    public void b(NBTTagList listTag) {
        this.i.clear();
        for (int i2 = 0; i2 < listTag.size(); ++i2) {
            NBTTagCompound compoundOrEmpty = listTag.b(i2);
            int i1 = compoundOrEmpty.b("Slot", (byte)0) & 0xFF;
            ItemStack itemStack = ItemStack.a(this.h.dX(), compoundOrEmpty).orElse(ItemStack.l);
            if (i1 >= this.i.size()) continue;
            this.a(i1, itemStack);
        }
    }

    @Override
    public int b() {
        return this.i.size() + g.size();
    }

    @Override
    public boolean c() {
        for (ItemStack itemStack : this.i) {
            if (itemStack.f()) continue;
            return false;
        }
        for (EnumItemSlot equipmentSlot : g.values()) {
            if (this.k.a(equipmentSlot).f()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ItemStack a(int index) {
        if (index < this.i.size()) {
            return this.i.get(index);
        }
        EnumItemSlot equipmentSlot = (EnumItemSlot)g.get(index);
        return equipmentSlot != null ? this.k.a(equipmentSlot) : ItemStack.l;
    }

    @Override
    public IChatBaseComponent ah() {
        return IChatBaseComponent.c("container.inventory");
    }

    public void m() {
        for (int i2 = 0; i2 < this.i.size(); ++i2) {
            ItemStack itemStack = this.i.get(i2);
            if (itemStack.f()) continue;
            this.h.a(itemStack, true, false);
            this.i.set(i2, ItemStack.l);
        }
        this.k.a(this.h);
    }

    @Override
    public void e() {
        ++this.l;
    }

    public int n() {
        return this.l;
    }

    @Override
    public boolean a(EntityHuman player) {
        return true;
    }

    public boolean j(ItemStack stack) {
        for (ItemStack itemStack : this) {
            if (itemStack.f() || !ItemStack.c(itemStack, stack)) continue;
            return true;
        }
        return false;
    }

    public boolean a(TagKey<Item> tag) {
        for (ItemStack itemStack : this) {
            if (itemStack.f() || !itemStack.a(tag)) continue;
            return true;
        }
        return false;
    }

    public boolean b(Predicate<ItemStack> predicate) {
        for (ItemStack itemStack : this) {
            if (!predicate.test(itemStack)) continue;
            return true;
        }
        return false;
    }

    public void a(PlayerInventory playerInventory) {
        for (int i2 = 0; i2 < this.b(); ++i2) {
            this.a(i2, playerInventory.a(i2));
        }
        this.c(playerInventory.f());
    }

    @Override
    public void a() {
        this.i.clear();
        this.k.b();
    }

    public void a(StackedItemContents contents) {
        for (ItemStack itemStack : this.i) {
            contents.a(itemStack);
        }
    }

    public ItemStack a(boolean removeStack) {
        ItemStack selectedItem = this.g();
        return selectedItem.f() ? ItemStack.l : this.a(this.j, removeStack ? selectedItem.M() : 1);
    }
}

