/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Unit;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.OminousItemSpawner;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityThrownTrident;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerPickupArrowEvent;

public abstract class EntityArrow
extends IProjectile {
    private static final double d = 2.0;
    private static final int e = 7;
    private static final float f = 0.6f;
    private static final float g = 0.99f;
    private static final short h = 0;
    private static final byte i = 0;
    private static final boolean j = false;
    private static final boolean k = false;
    private static final byte l = 0;
    private static final DataWatcherObject<Byte> m = DataWatcher.a(EntityArrow.class, DataWatcherRegistry.a);
    private static final DataWatcherObject<Byte> n = DataWatcher.a(EntityArrow.class, DataWatcherRegistry.a);
    private static final DataWatcherObject<Boolean> o = DataWatcher.a(EntityArrow.class, DataWatcherRegistry.k);
    private static final int p = 1;
    private static final int q = 2;
    @Nullable
    private IBlockData r;
    protected int a;
    public PickupStatus b = PickupStatus.a;
    public int c = 0;
    public int s = 0;
    public double t = 2.0;
    private SoundEffect u = this.i();
    @Nullable
    private IntOpenHashSet ay;
    @Nullable
    private List<Entity> az;
    public ItemStack aA = this.n();
    @Nullable
    public ItemStack aB = null;

    protected EntityArrow(EntityTypes<? extends EntityArrow> entityType, World level) {
        super((EntityTypes<? extends IProjectile>)entityType, level);
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> entityType, double x2, double y2, double z2, World level, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        this(entityType, x2, y2, z2, level, pickupItemStack, firedFromWeapon, null);
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> entityType, double x2, double y2, double z2, World level, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon, @Nullable EntityLiving ownerEntity) {
        this(entityType, level);
        this.c(ownerEntity);
        this.aA = pickupItemStack.v();
        this.c(pickupItemStack);
        Unit unit = pickupItemStack.e(DataComponents.u);
        if (unit != null) {
            this.b = PickupStatus.c;
        }
        this.a_(x2, y2, z2);
        if (firedFromWeapon != null && level instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)level;
            if (firedFromWeapon.f()) {
                throw new IllegalArgumentException("Invalid weapon firing an arrow");
            }
            this.aB = firedFromWeapon.v();
            int piercingCount = EnchantmentManager.a(serverLevel, firedFromWeapon, this.aA);
            if (piercingCount > 0) {
                this.a((byte)piercingCount);
            }
        }
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> entityType, EntityLiving owner, World level, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        this(entityType, owner.dA(), owner.dE() - (double)0.1f, owner.dG(), level, pickupItemStack, firedFromWeapon, owner);
    }

    public void b(SoundEffect soundEvent) {
        this.u = soundEvent;
    }

    @Override
    public boolean a(double distance) {
        double d2 = this.cR().a() * 10.0;
        if (Double.isNaN(d2)) {
            d2 = 1.0;
        }
        return distance < (d2 *= 64.0 * EntityArrow.cK()) * d2;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(m, (byte)0);
        builder.a(n, (byte)0);
        builder.a(o, false);
    }

    @Override
    public void c(double x2, double y2, double z2, float velocity, float inaccuracy) {
        super.c(x2, y2, z2, velocity, inaccuracy);
        this.s = 0;
    }

    @Override
    public void k(double x2, double y2, double z2) {
        super.k(x2, y2, z2);
        this.s = 0;
        if (this.e() && MathHelper.f(x2, y2, z2) > 0.0) {
            this.a(false);
        }
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        super.a(key);
        if (!this.ak && this.c <= 0 && key.equals(o) && this.e()) {
            this.c = 7;
        }
    }

    @Override
    public void g() {
        VoxelShape collisionShape;
        boolean flag = !this.v();
        Vec3D deltaMovement = this.dy();
        BlockPosition blockPos = this.dv();
        IBlockData blockState = this.dV().a_(blockPos);
        if (!blockState.l() && flag && !(collisionShape = blockState.g(this.dV(), blockPos)).c()) {
            Vec3D vec3 = this.dt();
            for (AxisAlignedBB aabb : collisionShape.e()) {
                if (!aabb.a(blockPos).d(vec3)) continue;
                this.i(Vec3D.c);
                this.a(true);
                break;
            }
        }
        if (this.c > 0) {
            --this.c;
        }
        if (this.bk() || blockState.a(Blocks.rx)) {
            this.aF();
        }
        if (this.e() && flag) {
            if (!this.dV().A_()) {
                if (this.r != blockState && this.x()) {
                    this.A();
                } else {
                    this.f();
                }
            }
            ++this.a;
            if (this.bJ()) {
                this.aI();
            }
            if (!this.dV().C) {
                this.c(this.aE() > 0);
            }
        } else {
            if (this.af > 200) {
                this.f();
            }
            this.a = 0;
            Vec3D vec31 = this.dt();
            if (this.bi()) {
                this.b(this.u());
                this.a(vec31);
            }
            if (this.s()) {
                for (int i2 = 0; i2 < 4; ++i2) {
                    this.dV().a(Particles.f, vec31.d + deltaMovement.d * (double)i2 / 4.0, vec31.e + deltaMovement.e * (double)i2 / 4.0, vec31.f + deltaMovement.f * (double)i2 / 4.0, -deltaMovement.d, -deltaMovement.e + 0.2, -deltaMovement.f);
                }
            }
            float f2 = !flag ? (float)(MathHelper.d(-deltaMovement.d, -deltaMovement.f) * 180.0 / 3.1415927410125732) : (float)(MathHelper.d(deltaMovement.d, deltaMovement.f) * 180.0 / 3.1415927410125732);
            float f1 = (float)(MathHelper.d(deltaMovement.e, deltaMovement.i()) * 180.0 / 3.1415927410125732);
            this.x(EntityArrow.f(this.dN(), f1));
            this.w(EntityArrow.f(this.dL(), f2));
            if (flag) {
                MovingObjectPositionBlock blockHitResult = this.dV().b(new RayTrace(vec31, vec31.e(deltaMovement), RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, this));
                this.b(blockHitResult);
            } else {
                this.b(vec31.e(deltaMovement));
                this.aI();
            }
            if (!this.bi()) {
                this.b(0.99f);
            }
            if (flag && !this.e()) {
                this.be();
            }
            super.g();
        }
    }

    private void b(MovingObjectPositionBlock hitResult) {
        while (this.bJ()) {
            Vec3D vec3 = this.dt();
            MovingObjectPositionEntity entityHitResult = this.b(vec3, hitResult.g());
            Vec3D location = ((MovingObjectPosition)Objects.requireNonNullElse(entityHitResult, hitResult)).g();
            this.b(location);
            this.a(vec3, location);
            if (this.as != null && this.as.e()) {
                this.bV();
            }
            if (entityHitResult == null) {
                if (!this.bJ() || hitResult.d() == MovingObjectPosition.EnumMovingObjectType.a) break;
                this.preHitTargetOrDeflectSelf(hitResult);
                this.ar = true;
                break;
            }
            if (!this.bJ() || this.ad) continue;
            ProjectileDeflection projectileDeflection = this.preHitTargetOrDeflectSelf(entityHitResult);
            this.ar = true;
            if (this.t() > 0 && projectileDeflection == ProjectileDeflection.a) continue;
        }
    }

    private void b(float intertia) {
        Vec3D deltaMovement = this.dy();
        this.i(deltaMovement.c((double)intertia));
    }

    private void a(Vec3D pos) {
        Vec3D deltaMovement = this.dy();
        for (int i2 = 0; i2 < 4; ++i2) {
            float f2 = 0.25f;
            this.dV().a(Particles.d, pos.d - deltaMovement.d * 0.25, pos.e - deltaMovement.e * 0.25, pos.f - deltaMovement.f * 0.25, deltaMovement.d, deltaMovement.e, deltaMovement.f);
        }
    }

    @Override
    public ProjectileDeflection preHitTargetOrDeflectSelf(MovingObjectPosition hitResult) {
        if (hitResult instanceof MovingObjectPositionEntity) {
            MovingObjectPositionEntity entityHitResult = (MovingObjectPositionEntity)hitResult;
            if (this.hitCancelled && this.t() > 0) {
                if (this.ay == null) {
                    this.ay = new IntOpenHashSet(5);
                }
                this.ay.add(entityHitResult.a().ao());
            }
        }
        return super.preHitTargetOrDeflectSelf(hitResult);
    }

    @Override
    protected double bc() {
        return 0.05;
    }

    private boolean x() {
        return this.e() && this.dV().b(new AxisAlignedBB(this.dt(), this.dt()).g(0.06));
    }

    private void A() {
        this.a(false);
        Vec3D deltaMovement = this.dy();
        this.i(deltaMovement.d(this.ae.i() * 0.2f, this.ae.i() * 0.2f, this.ae.i() * 0.2f));
        this.s = 0;
    }

    public boolean e() {
        return this.al.a(o);
    }

    protected void a(boolean inGround) {
        this.al.a(o, inGround);
    }

    @Override
    public boolean cJ() {
        return !this.e();
    }

    @Override
    public void a(EnumMoveType type, Vec3D pos) {
        super.a(type, pos);
        if (type != EnumMoveType.a && this.x()) {
            this.A();
        }
    }

    protected void f() {
        ++this.s;
        if (this.s >= (this.b == PickupStatus.c ? this.dV().paperConfig().entities.spawning.creativeArrowDespawnRate.value() : (this.b == PickupStatus.a ? this.dV().paperConfig().entities.spawning.nonPlayerArrowDespawnRate.value() : (this instanceof EntityThrownTrident ? this.dV().spigotConfig.tridentDespawnRate : this.dV().spigotConfig.arrowDespawnRate)))) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    private void B() {
        if (this.az != null) {
            this.az.clear();
        }
        if (this.ay != null) {
            this.ay.clear();
        }
    }

    @Override
    protected void b(Item item) {
        this.aB = null;
    }

    @Override
    public void a(boolean downwards, BlockPosition pos) {
        if (!this.e()) {
            super.a(downwards, pos);
        }
    }

    @Override
    public void l(boolean downwards) {
        if (!this.e()) {
            super.l(downwards);
        }
    }

    @Override
    public void push(double x2, double y2, double z2, @Nullable Entity pushingEntity) {
        if (!this.e()) {
            super.push(x2, y2, z2, pushingEntity);
        }
    }

    @Override
    protected void a(MovingObjectPositionEntity result) {
        EntityCombustByEntityEvent combustEvent;
        World world;
        super.a(result);
        Entity entity = result.a();
        float f2 = (float)this.dy().g();
        double d2 = this.t;
        Entity owner = this.p();
        DamageSource damageSource = this.dW().a(this, owner != null ? owner : this);
        if (this.dZ() != null && (world = this.dV()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            d2 = EnchantmentManager.a(serverLevel, this.dZ(), entity, damageSource, (float)d2);
        }
        int ceil = MathHelper.c(MathHelper.a((double)f2 * d2, 0.0, 2.147483647E9));
        if (this.t() > 0) {
            if (this.ay == null) {
                this.ay = new IntOpenHashSet(5);
            }
            if (this.az == null) {
                this.az = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.ay.size() >= this.t() + 1) {
                this.discard(EntityRemoveEvent.Cause.HIT);
                return;
            }
            this.ay.add(entity.ao());
        }
        if (this.s()) {
            long l2 = this.ae.a(ceil / 2 + 2);
            ceil = (int)Math.min(l2 + (long)ceil, Integer.MAX_VALUE);
        }
        if (owner instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)owner;
            livingEntity.B(entity);
        }
        if (this.s()) {
            damageSource = damageSource.critical();
        }
        boolean flag = entity.an() == EntityTypes.O;
        int remainingFireTicks = entity.aE();
        if (this.bX() && !flag && (combustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity(), 5.0f)).callEvent()) {
            entity.igniteForSeconds(combustEvent.getDuration(), false);
        }
        if (entity.b(damageSource, (float)ceil)) {
            if (flag) {
                return;
            }
            if (entity instanceof EntityLiving) {
                EntityPlayer serverPlayer;
                EntityLiving livingEntity1 = (EntityLiving)entity;
                if (!this.dV().C && this.t() <= 0) {
                    livingEntity1.o(livingEntity1.eW() + 1);
                }
                this.a(livingEntity1, damageSource);
                World world2 = this.dV();
                if (world2 instanceof WorldServer) {
                    WorldServer serverLevel1 = (WorldServer)world2;
                    EnchantmentManager.a(serverLevel1, (Entity)livingEntity1, damageSource, this.dZ());
                }
                this.a(livingEntity1);
                if (livingEntity1 instanceof EntityHuman && owner instanceof EntityPlayer) {
                    serverPlayer = (EntityPlayer)owner;
                    if (!this.ba() && livingEntity1 != serverPlayer) {
                        serverPlayer.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.h, 0.0f));
                    }
                }
                if (!entity.bJ() && this.az != null) {
                    this.az.add(livingEntity1);
                }
                if (!this.dV().C && owner instanceof EntityPlayer) {
                    serverPlayer = (EntityPlayer)owner;
                    if (this.az != null) {
                        CriterionTriggers.H.a(serverPlayer, this.az, this.aB);
                    } else if (!entity.bJ()) {
                        CriterionTriggers.H.a(serverPlayer, List.of(entity), this.aB);
                    }
                }
            }
            this.a(this.u, 1.0f, 1.2f / (this.ae.i() * 0.2f + 0.9f));
            if (this.t() <= 0) {
                this.discard(EntityRemoveEvent.Cause.HIT);
            }
        } else {
            entity.h(remainingFireTicks);
            this.a(ProjectileDeflection.b, entity, this.p(), false);
            this.i(this.dy().c(0.2));
            World world3 = this.dV();
            if (world3 instanceof WorldServer) {
                WorldServer serverLevel2 = (WorldServer)world3;
                if (this.dy().h() < 1.0E-7) {
                    if (this.b == PickupStatus.b) {
                        this.a(serverLevel2, this.m(), 0.1f);
                    }
                    this.discard(EntityRemoveEvent.Cause.HIT);
                }
            }
        }
    }

    protected void a(EntityLiving entity, DamageSource damageSource) {
        float f2;
        World world;
        if (this.aB != null && (world = this.dV()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            f2 = EnchantmentManager.d(serverLevel, this.aB, entity, damageSource, 0.0f);
        } else {
            f2 = 0.0f;
        }
        double d2 = f2;
        if (d2 > 0.0) {
            double max = Math.max(0.0, 1.0 - entity.h(GenericAttributes.p));
            Vec3D vec3 = this.dy().d(1.0, 0.0, 1.0).d().c(d2 * 0.6 * max);
            if (vec3.h() > 0.0) {
                entity.push(vec3.d, 0.1, vec3.f, this);
            }
        }
    }

    @Override
    protected void a(MovingObjectPositionBlock result) {
        this.r = this.dV().a_(result.b());
        super.a(result);
        ItemStack weaponItem = this.dZ();
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (weaponItem != null) {
                this.a(serverLevel, result, weaponItem);
            }
        }
        Vec3D deltaMovement = this.dy();
        Vec3D vec3 = new Vec3D(Math.signum(deltaMovement.d), Math.signum(deltaMovement.e), Math.signum(deltaMovement.f));
        Vec3D vec31 = vec3.c((double)0.05f);
        this.b(this.dt().d(vec31));
        this.i(Vec3D.c);
        this.a(this.l(), 1.0f, 1.2f / (this.ae.i() * 0.2f + 0.9f));
        this.a(true);
        this.c = 7;
        this.b(false);
        this.a((byte)0);
        this.b(SoundEffects.aE);
        this.B();
    }

    protected void a(WorldServer level, MovingObjectPositionBlock hitResult, ItemStack stack) {
        EntityLiving livingEntity;
        Vec3D vec3 = hitResult.b().a(hitResult.g());
        Entity entity = this.p();
        EnchantmentManager.a(level, stack, entity instanceof EntityLiving ? (livingEntity = (EntityLiving)entity) : null, this, null, vec3, level.a_(hitResult.b()), item -> {
            this.aB = null;
        });
    }

    @Override
    public ItemStack dZ() {
        return this.aB;
    }

    protected SoundEffect i() {
        return SoundEffects.aE;
    }

    public final SoundEffect l() {
        return this.u;
    }

    protected void a(EntityLiving target) {
    }

    @Nullable
    protected MovingObjectPositionEntity b(Vec3D startVec, Vec3D endVec) {
        return ProjectileHelper.a(this.dV(), this, startVec, endVec, this.cR().b(this.dy()).g(1.0), this::b);
    }

    @Override
    protected boolean b(Entity target) {
        EntityHuman player;
        Entity entity;
        return !(target instanceof EntityHuman && (entity = this.p()) instanceof EntityHuman && !(player = (EntityHuman)entity).a((EntityHuman)target) || !super.b(target) || this.ay != null && this.ay.contains(target.ao()));
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        RegistryOps<NBTBase> registryOps = this.dX().a(DynamicOpsNBT.a);
        compound.a("life", (short)this.s);
        compound.b("inBlockState", IBlockData.a, registryOps, this.r);
        compound.a("shake", (byte)this.c);
        compound.a("inGround", this.e());
        compound.a("pickup", PickupStatus.d, this.b);
        compound.a("damage", this.t);
        compound.a("crit", this.s());
        compound.a("PierceLevel", this.t());
        compound.a("SoundEvent", BuiltInRegistries.b.q(), this.u);
        compound.a("item", ItemStack.b, registryOps, this.aA);
        compound.b("weapon", ItemStack.b, registryOps, this.aB);
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        RegistryOps<NBTBase> registryOps = this.dX().a(DynamicOpsNBT.a);
        this.s = compound.b("life", (short)0);
        this.r = compound.a("inBlockState", IBlockData.a, (DynamicOps<NBTBase>)registryOps).orElse(null);
        this.c = compound.b("shake", (byte)0) & 0xFF;
        this.a(compound.b("inGround", false));
        this.t = compound.b("damage", 2.0);
        this.b = compound.a("pickup", PickupStatus.d).orElse(PickupStatus.a);
        this.b(compound.b("crit", false));
        this.a(compound.b("PierceLevel", (byte)0));
        this.u = compound.a("SoundEvent", BuiltInRegistries.b.q()).orElse(this.i());
        this.a(compound.a("item", ItemStack.b, (DynamicOps<NBTBase>)registryOps).orElse(this.n()));
        this.aB = compound.a("weapon", ItemStack.b, (DynamicOps<NBTBase>)registryOps).orElse(null);
    }

    @Override
    public void c(@Nullable Entity entity) {
        this.setOwner(entity, true);
    }

    public void setOwner(@Nullable Entity entity, boolean resetPickup) {
        PickupStatus pickupStatus;
        super.c(entity);
        if (!resetPickup) {
            return;
        }
        Entity entity2 = entity;
        int n2 = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EntityHuman.class, OminousItemSpawner.class}, (Object)entity2, n2)) {
                case 0: {
                    EntityHuman player = (EntityHuman)entity2;
                    if (this.b != PickupStatus.a) {
                        n2 = 1;
                        continue block4;
                    }
                    pickupStatus = PickupStatus.b;
                    break block4;
                }
                case 1: {
                    OminousItemSpawner ominousItemSpawner = (OminousItemSpawner)entity2;
                    pickupStatus = PickupStatus.a;
                    break block4;
                }
                default: {
                    pickupStatus = this.b;
                    break block4;
                }
            }
            break;
        }
        this.b = pickupStatus;
    }

    @Override
    public void a_(EntityHuman entity) {
        if (!this.dV().C && (this.e() || this.v()) && this.c <= 0) {
            ItemStack itemstack = this.m();
            if (this.b == PickupStatus.b && !itemstack.f() && entity.gj().canHold(itemstack) > 0) {
                EntityItem item = new EntityItem(this.dV(), this.dA(), this.dC(), this.dG(), itemstack);
                PlayerPickupArrowEvent event = new PlayerPickupArrowEvent((Player)entity.getBukkitEntity(), (org.bukkit.entity.Item)item.getBukkitEntity(), (AbstractArrow)this.getBukkitEntity());
                if (!event.callEvent()) {
                    return;
                }
                itemstack = item.e();
            }
            if (this.b == PickupStatus.b && entity.gj().g(itemstack) || this.b == PickupStatus.c && entity.gk().d) {
                entity.a((Entity)this, 1);
                this.discard(EntityRemoveEvent.Cause.PICKUP);
            }
        }
    }

    protected boolean a(EntityHuman player) {
        return switch (this.b.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> false;
            case 1 -> player.gj().g(this.m());
            case 2 -> player.fV();
        };
    }

    public ItemStack m() {
        return this.aA.v();
    }

    protected abstract ItemStack n();

    @Override
    protected Entity.MovementEmission bf() {
        return Entity.MovementEmission.a;
    }

    public ItemStack r() {
        return this.aA;
    }

    public void h(double baseDamage) {
        this.t = baseDamage;
    }

    @Override
    public boolean cB() {
        return this.an().a(TagsEntity.H);
    }

    public void b(boolean critArrow) {
        this.a(1, critArrow);
    }

    public void a(byte pierceLevel) {
        this.al.a(n, pierceLevel);
    }

    private void a(int id, boolean value) {
        byte b2 = this.al.a(m);
        if (value) {
            this.al.a(m, (byte)(b2 | id));
        } else {
            this.al.a(m, (byte)(b2 & ~id));
        }
    }

    public void a(ItemStack pickupItemStack) {
        this.aA = !pickupItemStack.f() ? pickupItemStack : this.n();
    }

    public boolean s() {
        byte b2 = this.al.a(m);
        return (b2 & 1) != 0;
    }

    public byte t() {
        return this.al.a(n);
    }

    public void a(float velocity) {
        this.h((double)(velocity * 2.0f) + this.ae.a((double)this.dV().an().a() * 0.11, 0.57425));
    }

    protected float u() {
        return 0.6f;
    }

    public void q(boolean noPhysics) {
        this.ad = noPhysics;
        this.a(2, noPhysics);
    }

    public boolean v() {
        return !this.dV().C ? this.ad : (this.al.a(m) & 2) != 0;
    }

    @Override
    public boolean bF() {
        return super.bF() && !this.e();
    }

    @Override
    public SlotAccess a_(int slot) {
        return slot == 0 ? SlotAccess.a(this::r, this::a) : super.a_(slot);
    }

    @Override
    protected boolean w() {
        return true;
    }

    public static final class PickupStatus
    extends Enum<PickupStatus> {
        public static final /* enum */ PickupStatus a = new PickupStatus();
        public static final /* enum */ PickupStatus b = new PickupStatus();
        public static final /* enum */ PickupStatus c = new PickupStatus();
        public static final Codec<PickupStatus> d;
        private static final /* synthetic */ PickupStatus[] e;

        public static PickupStatus[] values() {
            return (PickupStatus[])e.clone();
        }

        public static PickupStatus valueOf(String name) {
            return Enum.valueOf(PickupStatus.class, name);
        }

        public static PickupStatus a(int ordinal) {
            if (ordinal < 0 || ordinal > PickupStatus.values().length) {
                ordinal = 0;
            }
            return PickupStatus.values()[ordinal];
        }

        private static /* synthetic */ PickupStatus[] a() {
            return new PickupStatus[]{a, b, c};
        }

        static {
            e = PickupStatus.a();
            d = Codec.BYTE.xmap(PickupStatus::a, pickup -> (byte)pickup.ordinal());
        }
    }
}

