/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.destroystokyo.paper.event.entity.EnderDragonFireballHitEvent;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.EntityFireball;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.DragonFireball;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityDragonFireball
extends EntityFireball {
    public static final float d = 4.0f;

    public EntityDragonFireball(EntityTypes<? extends EntityDragonFireball> entityType, World level) {
        super((EntityTypes<? extends EntityFireball>)entityType, level);
    }

    public EntityDragonFireball(World level, EntityLiving owner, Vec3D movement) {
        super(EntityTypes.K, owner, movement, level);
    }

    @Override
    protected void a(MovingObjectPosition result) {
        super.a(result);
        if (!(result.d() == MovingObjectPosition.EnumMovingObjectType.c && this.e(((MovingObjectPositionEntity)result).a()) || this.dV().C)) {
            List<EntityLiving> entitiesOfClass = this.dV().a(EntityLiving.class, this.cR().c(4.0, 2.0, 4.0));
            EntityAreaEffectCloud areaEffectCloud = new EntityAreaEffectCloud(this.dV(), this.dA(), this.dC(), this.dG());
            Entity owner = this.p();
            if (owner instanceof EntityLiving) {
                areaEffectCloud.a((EntityLiving)owner);
            }
            areaEffectCloud.a(Particles.h);
            areaEffectCloud.a(3.0f);
            areaEffectCloud.a(600);
            areaEffectCloud.d((7.0f - areaEffectCloud.c()) / (float)areaEffectCloud.h());
            areaEffectCloud.b(0.25f);
            areaEffectCloud.a(new MobEffect(MobEffects.g, 1, 1));
            if (!entitiesOfClass.isEmpty()) {
                for (EntityLiving livingEntity : entitiesOfClass) {
                    double d2 = this.g(livingEntity);
                    if (!(d2 < 16.0)) continue;
                    areaEffectCloud.a_(livingEntity.dA(), livingEntity.dC(), livingEntity.dG());
                    break;
                }
            }
            if (new EnderDragonFireballHitEvent((DragonFireball)this.getBukkitEntity(), (Collection)entitiesOfClass.stream().map(EntityLiving::getBukkitLivingEntity).collect(Collectors.toList()), (AreaEffectCloud)areaEffectCloud.getBukkitEntity()).callEvent()) {
                this.dV().c(2006, this.dv(), this.ba() ? -1 : 1);
                this.dV().addFreshEntity(areaEffectCloud, CreatureSpawnEvent.SpawnReason.EXPLOSION);
            } else {
                areaEffectCloud.discard(null);
            }
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }

    @Override
    protected ParticleParam i() {
        return Particles.h;
    }

    @Override
    protected boolean f() {
        return false;
    }
}

