/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.destroystokyo.paper.event.entity.ThrownEggHatchEvent;
import java.util.Optional;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.entity.projectile.EntityProjectileThrowable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftEntityType;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Egg;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerEggThrowEvent;

public class EntityEgg
extends EntityProjectileThrowable {
    private static final EntitySize a = EntitySize.c(0.0f, 0.0f);

    public EntityEgg(EntityTypes<? extends EntityEgg> entityType, World level) {
        super((EntityTypes<? extends EntityProjectileThrowable>)entityType, level);
    }

    public EntityEgg(World level, EntityLiving owner, ItemStack item) {
        super(EntityTypes.M, owner, level, item);
    }

    public EntityEgg(World level, double x2, double y2, double z2, ItemStack item) {
        super(EntityTypes.M, x2, y2, z2, level, item);
    }

    @Override
    public void b(byte id) {
        if (id == 3) {
            double d2 = 0.08;
            for (int i2 = 0; i2 < 8; ++i2) {
                this.dV().a(new ParticleParamItem(Particles.U, this.e()), this.dA(), this.dC(), this.dG(), ((double)this.ae.i() - 0.5) * 0.08, ((double)this.ae.i() - 0.5) * 0.08, ((double)this.ae.i() - 0.5) * 0.08);
            }
        }
    }

    @Override
    protected void a(MovingObjectPositionEntity result) {
        super.a(result);
        result.a().a(this.dW().b((Entity)this, this.p()), 0.0f);
    }

    @Override
    protected void a(MovingObjectPosition result) {
        super.a(result);
        if (!this.dV().C) {
            ThrownEggHatchEvent event;
            boolean hatching = this.ae.a(8) == 0;
            int i2 = 1;
            if (this.ae.a(32) == 0) {
                i2 = 4;
            }
            if (!hatching) {
                i2 = 0;
            }
            Entity shooter = this.p();
            EntityType hatchingType = EntityType.CHICKEN;
            if (shooter instanceof EntityPlayer) {
                event = new PlayerEggThrowEvent((Player)shooter.getBukkitEntity(), (Egg)this.getBukkitEntity(), hatching, (byte)i2, hatchingType);
                event.callEvent();
                hatching = event.isHatching();
                i2 = hatching ? event.getNumHatches() : (byte)0;
                hatchingType = event.getHatchingType();
            }
            event = new ThrownEggHatchEvent((Egg)this.getBukkitEntity(), hatching, (byte)i2, hatchingType);
            event.callEvent();
            hatching = event.isHatching();
            i2 = hatching ? event.getNumHatches() : (byte)0;
            hatchingType = event.getHatchingType();
            EntityTypes<?> newEntityType = CraftEntityType.bukkitToMinecraft(hatchingType);
            for (int i1 = 0; i1 < i2; ++i1) {
                Object chicken = newEntityType.a(this.dV(), EntitySpawnReason.k);
                if (chicken == null) continue;
                CraftEntity craftEntity = ((Entity)chicken).getBukkitEntity();
                if (craftEntity instanceof Ageable) {
                    Ageable ageable = (Ageable)craftEntity;
                    ageable.setBaby();
                }
                ((Entity)chicken).b(this.dA(), this.dC(), this.dG(), this.dL(), 0.0f);
                if (chicken instanceof EntityChicken) {
                    EntityChicken realChicken = (EntityChicken)chicken;
                    Optional.ofNullable(this.e().a(DataComponents.aJ)).flatMap(eitherHolder -> eitherHolder.a(this.dX())).ifPresent(realChicken::j);
                }
                if (!((Entity)chicken).a(a)) break;
                this.dV().addFreshEntity((Entity)chicken, CreatureSpawnEvent.SpawnReason.EGG);
            }
            this.dV().a((Entity)this, (byte)3);
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }

    @Override
    public Item f() {
        return Items.rH;
    }
}

