/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.mojang.serialization.DynamicOps;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityEnderSignal
extends Entity
implements ItemSupplier {
    private static final float a = 12.25f;
    private static final DataWatcherObject<ItemStack> b = DataWatcher.a(EntityEnderSignal.class, DataWatcherRegistry.h);
    public double c;
    public double d;
    public double e;
    public int f;
    public boolean g;

    public EntityEnderSignal(EntityTypes<? extends EntityEnderSignal> entityType, World level) {
        super(entityType, level);
    }

    public EntityEnderSignal(World level, double x2, double y2, double z2) {
        this((EntityTypes<? extends EntityEnderSignal>)EntityTypes.X, level);
        this.a_(x2, y2, z2);
    }

    public void a(ItemStack stack) {
        if (stack.f()) {
            this.ar().a(b, this.f());
        } else {
            this.ar().a(b, stack.c(1));
        }
    }

    @Override
    public ItemStack e() {
        return this.ar().a(b);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(b, this.f());
    }

    @Override
    public boolean a(double distance) {
        if (this.af < 2 && distance < 12.25) {
            return false;
        }
        double d2 = this.cR().a() * 4.0;
        if (Double.isNaN(d2)) {
            d2 = 4.0;
        }
        return distance < (d2 *= 64.0) * d2;
    }

    public void a(BlockPosition pos) {
        this.signalTo(pos, true);
    }

    public void signalTo(BlockPosition pos, boolean update) {
        double d3;
        double d2 = pos.u();
        int y2 = pos.v();
        double d1 = pos.w();
        double d22 = d2 - this.dA();
        double squareRoot = Math.sqrt(d22 * d22 + (d3 = d1 - this.dG()) * d3);
        if (squareRoot > 12.0) {
            this.c = this.dA() + d22 / squareRoot * 12.0;
            this.e = this.dG() + d3 / squareRoot * 12.0;
            this.d = this.dC() + 8.0;
        } else {
            this.c = d2;
            this.d = y2;
            this.e = d1;
        }
        if (update) {
            this.f = 0;
            this.g = this.ae.a(5) > 0;
        }
    }

    @Override
    public void k(double x2, double y2, double z2) {
        this.n(x2, y2, z2);
        if (this.O == 0.0f && this.N == 0.0f) {
            double squareRoot = Math.sqrt(x2 * x2 + z2 * z2);
            this.w((float)(MathHelper.d(x2, z2) * 180.0 / 3.1415927410125732));
            this.x((float)(MathHelper.d(y2, squareRoot) * 180.0 / 3.1415927410125732));
            this.N = this.dL();
            this.O = this.dN();
        }
    }

    @Override
    public void g() {
        super.g();
        Vec3D deltaMovement = this.dy();
        double d2 = this.dA() + deltaMovement.d;
        double d1 = this.dC() + deltaMovement.e;
        double d22 = this.dG() + deltaMovement.f;
        double d3 = deltaMovement.i();
        this.x(IProjectile.f(this.O, (float)(MathHelper.d(deltaMovement.e, d3) * 180.0 / 3.1415927410125732)));
        this.w(IProjectile.f(this.N, (float)(MathHelper.d(deltaMovement.d, deltaMovement.f) * 180.0 / 3.1415927410125732)));
        if (!this.dV().C) {
            double d4 = this.c - d2;
            double d5 = this.e - d22;
            float f2 = (float)Math.sqrt(d4 * d4 + d5 * d5);
            float f1 = (float)MathHelper.d(d5, d4);
            double d6 = MathHelper.d(0.0025, d3, (double)f2);
            double d7 = deltaMovement.e;
            if (f2 < 1.0f) {
                d6 *= 0.8;
                d7 *= 0.8;
            }
            int i2 = this.dC() < this.d ? 1 : -1;
            deltaMovement = new Vec3D(Math.cos(f1) * d6, d7 + ((double)i2 - d7) * (double)0.015f, Math.sin(f1) * d6);
            this.i(deltaMovement);
        }
        float f2 = 0.25f;
        if (this.bi()) {
            for (int i1 = 0; i1 < 4; ++i1) {
                this.dV().a(Particles.d, d2 - deltaMovement.d * 0.25, d1 - deltaMovement.e * 0.25, d22 - deltaMovement.f * 0.25, deltaMovement.d, deltaMovement.e, deltaMovement.f);
            }
        } else {
            this.dV().a(Particles.af, d2 - deltaMovement.d * 0.25 + this.ae.j() * 0.6 - 0.3, d1 - deltaMovement.e * 0.25 - 0.5, d22 - deltaMovement.f * 0.25 + this.ae.j() * 0.6 - 0.3, deltaMovement.d, deltaMovement.e, deltaMovement.f);
        }
        if (!this.dV().C) {
            this.a_(d2, d1, d22);
            ++this.f;
            if (this.f > 80 && !this.dV().C) {
                this.a(SoundEffects.iF, 1.0f, 1.0f);
                this.discard(this.g ? EntityRemoveEvent.Cause.DROP : EntityRemoveEvent.Cause.DESPAWN);
                if (this.g) {
                    this.dV().b(new EntityItem(this.dV(), this.dA(), this.dC(), this.dG(), this.e()));
                } else {
                    this.dV().c(2003, this.dv(), 0);
                }
            }
        } else {
            this.a_(d2, d1, d22);
        }
    }

    @Override
    public void b(NBTTagCompound compound) {
        RegistryOps<NBTBase> registryOps = this.dX().a(DynamicOpsNBT.a);
        compound.a("Item", ItemStack.b, registryOps, this.e());
    }

    @Override
    public void a(NBTTagCompound compound) {
        RegistryOps<NBTBase> registryOps = this.dX().a(DynamicOpsNBT.a);
        this.a(compound.a("Item", ItemStack.b, (DynamicOps<NBTBase>)registryOps).orElse(this.f()));
    }

    private ItemStack f() {
        return new ItemStack(Items.tA);
    }

    @Override
    public float bw() {
        return 1.0f;
    }

    @Override
    public boolean cB() {
        return false;
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        return false;
    }
}

