/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityRemoveEvent;

public abstract class EntityFireball
extends IProjectile {
    public static final double a = 0.1;
    public static final double b = 0.5;
    public double c = 0.1;
    public float bukkitYield = 1.0f;
    public boolean isIncendiary = true;

    protected EntityFireball(EntityTypes<? extends EntityFireball> entityType, World level) {
        super((EntityTypes<? extends IProjectile>)entityType, level);
    }

    protected EntityFireball(EntityTypes<? extends EntityFireball> entityType, double x2, double y2, double z2, World level) {
        this(entityType, level);
        this.a_(x2, y2, z2);
    }

    public EntityFireball(EntityTypes<? extends EntityFireball> entityType, double x2, double y2, double z2, Vec3D movement, World level) {
        this(entityType, level);
        this.b(x2, y2, z2, this.dL(), this.dN());
        this.av();
        this.a(movement, this.c);
    }

    public EntityFireball(EntityTypes<? extends EntityFireball> entityType, EntityLiving owner, Vec3D movement, World level) {
        this(entityType, owner.dA(), owner.dC(), owner.dG(), movement, level);
        this.c(owner);
        this.b(owner.dL(), owner.dN());
    }

    @Override
    protected void a(DataWatcher.a builder) {
    }

    @Override
    public boolean a(double distance) {
        double d2 = this.cR().a() * 4.0;
        if (Double.isNaN(d2)) {
            d2 = 4.0;
        }
        return distance < (d2 *= 64.0) * d2;
    }

    protected RayTrace.BlockCollisionOption ag_() {
        return RayTrace.BlockCollisionOption.a;
    }

    @Override
    public void g() {
        Entity owner = this.p();
        this.n();
        if (this.dV().C || (owner == null || !owner.dQ()) && this.dV().C(this.dv())) {
            MovingObjectPosition hitResultOnMoveVector = ProjectileHelper.a((Entity)this, this::b, this.ag_());
            Vec3D location = hitResultOnMoveVector.d() != MovingObjectPosition.EnumMovingObjectType.a ? hitResultOnMoveVector.g() : this.dt().e(this.dy());
            ProjectileHelper.a((Entity)this, 0.2f);
            this.b(location);
            this.aI();
            super.g();
            if (this.f()) {
                this.e(1.0f);
            }
            if (hitResultOnMoveVector.d() != MovingObjectPosition.EnumMovingObjectType.a && this.bJ()) {
                this.preHitTargetOrDeflectSelf(hitResultOnMoveVector);
            }
            this.r();
        } else {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    @Override
    private void n() {
        float liquidInertia;
        Vec3D deltaMovement = this.dy();
        Vec3D vec3 = this.dt();
        if (this.bi()) {
            for (int i2 = 0; i2 < 4; ++i2) {
                float f2 = 0.25f;
                this.dV().a(Particles.d, vec3.d - deltaMovement.d * 0.25, vec3.e - deltaMovement.e * 0.25, vec3.f - deltaMovement.f * 0.25, deltaMovement.d, deltaMovement.e, deltaMovement.f);
            }
            liquidInertia = this.m();
        } else {
            liquidInertia = this.l();
        }
        this.i(deltaMovement.e(deltaMovement.d().c(this.c)).c((double)liquidInertia));
    }

    private void r() {
        ParticleParam trailParticle = this.i();
        Vec3D vec3 = this.dt();
        if (trailParticle != null) {
            this.dV().a(trailParticle, vec3.d, vec3.e + 0.5, vec3.f, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        return false;
    }

    @Override
    protected boolean b(Entity target) {
        return super.b(target) && !target.ad;
    }

    protected boolean f() {
        return true;
    }

    @Nullable
    protected ParticleParam i() {
        return Particles.ah;
    }

    protected float l() {
        return 0.95f;
    }

    protected float m() {
        return 0.8f;
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("acceleration_power", this.c);
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.c = compound.b("acceleration_power", 0.1);
    }

    @Override
    public float bw() {
        return 1.0f;
    }

    public void a(Vec3D movement, double accelerationPower) {
        this.i(movement.d().c(accelerationPower));
        this.ar = true;
    }

    @Override
    protected void c(@Nullable Entity entity, boolean deflectedByPlayer) {
        super.c(entity, deflectedByPlayer);
        this.c = deflectedByPlayer ? 0.1 : (this.c *= 0.5);
    }
}

