/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import java.util.List;
import java.util.OptionalInt;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityFireworks
extends IProjectile
implements ItemSupplier {
    public static final DataWatcherObject<ItemStack> a = DataWatcher.a(EntityFireworks.class, DataWatcherRegistry.h);
    public static final DataWatcherObject<OptionalInt> b = DataWatcher.a(EntityFireworks.class, DataWatcherRegistry.v);
    public static final DataWatcherObject<Boolean> c = DataWatcher.a(EntityFireworks.class, DataWatcherRegistry.k);
    private static final int d = 0;
    private static final int e = 0;
    private static final boolean f = false;
    public int g = 0;
    public int h = 0;
    @Nullable
    public EntityLiving i;
    @Nullable
    public UUID spawningEntity;

    public EntityFireworks(EntityTypes<? extends EntityFireworks> entityType, World level) {
        super((EntityTypes<? extends IProjectile>)entityType, level);
    }

    public EntityFireworks(World level, double x2, double y2, double z2, ItemStack stack) {
        super((EntityTypes<? extends IProjectile>)EntityTypes.aa, level);
        this.g = 0;
        this.a_(x2, y2, z2);
        this.al.a(a, stack.v());
        int i2 = 1;
        Fireworks fireworks = stack.a(DataComponents.aj);
        if (fireworks != null) {
            i2 += fireworks.a();
        }
        this.n(this.ae.a(0.0, 0.002297), 0.05, this.ae.a(0.0, 0.002297));
        this.h = 10 * i2 + this.ae.a(6) + this.ae.a(7);
    }

    public EntityFireworks(World level, @Nullable Entity shooter, double x2, double y2, double z2, ItemStack stack) {
        this(level, x2, y2, z2, stack);
        this.c(shooter);
    }

    public EntityFireworks(World level, ItemStack stack, EntityLiving shooter) {
        this(level, shooter, shooter.dA(), shooter.dC(), shooter.dG(), stack);
        this.al.a(b, OptionalInt.of(shooter.ao()));
        this.i = shooter;
    }

    public EntityFireworks(World level, ItemStack stack, double x2, double y2, double z2, boolean shotAtAngle) {
        this(level, x2, y2, z2, stack);
        this.al.a(c, shotAtAngle);
    }

    public EntityFireworks(World level, ItemStack stack, Entity shooter, double x2, double y2, double z2, boolean shotAtAngle) {
        this(level, stack, x2, y2, z2, shotAtAngle);
        this.c(shooter);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(a, EntityFireworks.n());
        builder.a(b, OptionalInt.empty());
        builder.a(c, false);
    }

    @Override
    public boolean a(double distance) {
        return distance < 4096.0 && !this.l();
    }

    @Override
    public boolean j(double x2, double y2, double z2) {
        return super.j(x2, y2, z2) && !this.l();
    }

    @Override
    public void inactiveTick() {
        World world;
        ++this.g;
        if (this.g > this.h && (world = this.dV()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (CraftEventFactory.callFireworkExplodeEvent(this)) {
                this.b(serverLevel);
            }
        }
        super.inactiveTick();
    }

    @Override
    public void g() {
        World world;
        MovingObjectPosition hitResultOnMoveVector;
        super.g();
        if (this.l()) {
            if (this.i == null) {
                this.al.a(b).ifPresent(target -> {
                    Entity entity = this.dV().a(target);
                    if (entity instanceof EntityLiving) {
                        this.i = (EntityLiving)entity;
                    }
                });
            }
            if (this.i != null) {
                if (this.i.fJ()) {
                    Vec3D lookAngle = this.i.bS();
                    double d2 = 1.5;
                    double d1 = 0.1;
                    Vec3D deltaMovement = this.i.dy();
                    this.i.i(deltaMovement.b(lookAngle.d * 0.1 + (lookAngle.d * 1.5 - deltaMovement.d) * 0.5, lookAngle.e * 0.1 + (lookAngle.e * 1.5 - deltaMovement.e) * 0.5, lookAngle.f * 0.1 + (lookAngle.f * 1.5 - deltaMovement.f) * 0.5));
                    handHoldingItemAngle = this.i.a(Items.vE);
                } else {
                    handHoldingItemAngle = Vec3D.c;
                }
                this.a_(this.i.dA() + handHoldingItemAngle.d, this.i.dC() + handHoldingItemAngle.e, this.i.dG() + handHoldingItemAngle.f);
                this.i(this.i.dy());
            }
            hitResultOnMoveVector = ProjectileHelper.a((Entity)this, this::b);
        } else {
            if (!this.f()) {
                double d2 = this.P ? 1.0 : 1.15;
                this.i(this.dy().d(d2, 1.0, d2).b(0.0, 0.04, 0.0));
            }
            handHoldingItemAngle = this.dy();
            hitResultOnMoveVector = ProjectileHelper.a((Entity)this, this::b);
            this.a(EnumMoveType.a, handHoldingItemAngle);
            this.aI();
            this.i(handHoldingItemAngle);
        }
        if (!this.ad && this.bJ() && hitResultOnMoveVector.d() != MovingObjectPosition.EnumMovingObjectType.a) {
            this.preHitTargetOrDeflectSelf(hitResultOnMoveVector);
            this.ar = true;
        }
        this.z();
        if (this.g == 0 && !this.ba()) {
            this.dV().a(null, this.dA(), this.dC(), this.dG(), SoundEffects.jt, SoundCategory.i, 3.0f, 1.0f);
        }
        ++this.g;
        if (this.dV().C && this.g % 2 < 2) {
            this.dV().a(Particles.D, this.dA(), this.dC(), this.dG(), this.ae.k() * 0.05, -this.dy().e * 0.5, this.ae.k() * 0.05);
        }
        if (this.g > this.h && (world = this.dV()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (CraftEventFactory.callFireworkExplodeEvent(this)) {
                this.b(serverLevel);
            }
        }
    }

    private void b(WorldServer level) {
        level.a((Entity)this, (byte)17);
        this.a(GameEvent.w, this.p());
        this.e(level);
        this.discard(EntityRemoveEvent.Cause.EXPLODE);
    }

    @Override
    protected void a(MovingObjectPositionEntity result) {
        super.a(result);
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (CraftEventFactory.callFireworkExplodeEvent(this)) {
                this.b(serverLevel);
            }
        }
    }

    @Override
    protected void a(MovingObjectPositionBlock result) {
        BlockPosition blockPos = new BlockPosition(result.b());
        this.dV().a_(blockPos).a(this.dV(), blockPos, (Entity)this, InsideBlockEffectApplier.a);
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (this.i() && CraftEventFactory.callFireworkExplodeEvent(this)) {
                this.b(serverLevel);
            }
        }
        super.a(result);
    }

    private boolean i() {
        return !this.m().isEmpty();
    }

    private void e(WorldServer level) {
        float f2 = 0.0f;
        List<FireworkExplosion> explosions = this.m();
        if (!explosions.isEmpty()) {
            f2 = 5.0f + (float)(explosions.size() * 2);
        }
        if (f2 > 0.0f) {
            if (this.i != null) {
                this.i.a(level, this.dW().a(this, this.p()), 5.0f + (float)(explosions.size() * 2));
            }
            double d2 = 5.0;
            Vec3D vec3 = this.dt();
            for (EntityLiving livingEntity : this.dV().a(EntityLiving.class, this.cR().g(5.0))) {
                if (livingEntity == this.i || this.g(livingEntity) > 25.0) continue;
                boolean flag = false;
                for (int i2 = 0; i2 < 2; ++i2) {
                    Vec3D vec31 = new Vec3D(livingEntity.dA(), livingEntity.e(0.5 * (double)i2), livingEntity.dG());
                    MovingObjectPositionBlock hitResult = this.dV().a(new RayTrace(vec3, vec31, RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, this));
                    if (((MovingObjectPosition)hitResult).d() != MovingObjectPosition.EnumMovingObjectType.a) continue;
                    flag = true;
                    break;
                }
                if (!flag) continue;
                float f1 = f2 * (float)Math.sqrt((5.0 - (double)this.f(livingEntity)) / 5.0);
                livingEntity.a(level, this.dW().a(this, this.p()), f1);
            }
        }
    }

    private boolean l() {
        return this.al.a(b).isPresent();
    }

    public boolean f() {
        return this.al.a(c);
    }

    @Override
    public void b(byte id) {
        if (id == 17 && this.dV().C) {
            Vec3D deltaMovement = this.dy();
            this.dV().a(this.dA(), this.dC(), this.dG(), deltaMovement.d, deltaMovement.e, deltaMovement.f, this.m());
        }
        super.b(id);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("Life", this.g);
        compound.a("LifeTime", this.h);
        RegistryOps<NBTBase> registryOps = this.dX().a(DynamicOpsNBT.a);
        compound.a("FireworksItem", ItemStack.b, registryOps, this.e());
        compound.a("ShotAtAngle", this.al.a(c));
        compound.b("SpawningEntity", UUIDUtil.a, this.spawningEntity);
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.g = compound.b("Life", 0);
        this.h = compound.b("LifeTime", 0);
        RegistryOps<NBTBase> registryOps = this.dX().a(DynamicOpsNBT.a);
        this.al.a(a, compound.a("FireworksItem", ItemStack.b, (DynamicOps<NBTBase>)registryOps).orElse(EntityFireworks.n()));
        this.al.a(c, compound.b("ShotAtAngle", false));
        this.spawningEntity = compound.a("SpawningEntity", UUIDUtil.a).orElse(null);
    }

    private List<FireworkExplosion> m() {
        ItemStack itemStack = this.al.a(a);
        Fireworks fireworks = itemStack.a(DataComponents.aj);
        return fireworks != null ? fireworks.b() : List.of();
    }

    @Override
    public ItemStack e() {
        return this.al.a(a);
    }

    @Override
    public boolean cB() {
        return false;
    }

    public static ItemStack n() {
        return new ItemStack(Items.vE);
    }

    @Override
    public DoubleDoubleImmutablePair a_(EntityLiving entity, DamageSource damageSource) {
        double d2 = entity.dt().d - this.dt().d;
        double d1 = entity.dt().f - this.dt().f;
        return DoubleDoubleImmutablePair.of((double)d2, (double)d1);
    }
}

