/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.mojang.logging.LogUtils;
import io.papermc.paper.annotation.DoNotUse;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R4.CraftEquipmentSlot;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.slf4j.Logger;

public class EntityFishingHook
extends IProjectile {
    private static final Logger a = LogUtils.getLogger();
    private final RandomSource b = RandomSource.a();
    private boolean c;
    public int d;
    private static final int e = 10;
    public static final DataWatcherObject<Integer> f = DataWatcher.a(EntityFishingHook.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> g = DataWatcher.a(EntityFishingHook.class, DataWatcherRegistry.k);
    private int h;
    private int i;
    public int j;
    public int k;
    public float l;
    private boolean m = true;
    @Nullable
    public Entity n;
    public HookState o = HookState.a;
    private final int p;
    private final int q;
    public int minWaitTime = 100;
    public int maxWaitTime = 600;
    public int minLureTime = 20;
    public int maxLureTime = 80;
    public float minLureAngle = 0.0f;
    public float maxLureAngle = 360.0f;
    public boolean applyLure = true;
    public boolean rainInfluenced = true;
    public boolean skyInfluenced = true;

    private EntityFishingHook(EntityTypes<? extends EntityFishingHook> entityType, World level, int luck, int lureSpeed) {
        super((EntityTypes<? extends IProjectile>)entityType, level);
        this.p = Math.max(0, luck);
        this.q = Math.max(0, lureSpeed);
        this.minWaitTime = level.paperConfig().fishingTimeRange.minimum;
        this.maxWaitTime = level.paperConfig().fishingTimeRange.maximum;
    }

    public EntityFishingHook(EntityTypes<? extends EntityFishingHook> entityType, World level) {
        this(entityType, level, 0, 0);
    }

    public EntityFishingHook(EntityHuman player, World level, int luck, int lureSpeed) {
        this(EntityTypes.bU, level, luck, lureSpeed);
        this.c(player);
        float xRot = player.dN();
        float yRot = player.dL();
        float cos = MathHelper.b(-yRot * ((float)Math.PI / 180) - (float)Math.PI);
        float sin = MathHelper.a(-yRot * ((float)Math.PI / 180) - (float)Math.PI);
        float f2 = -MathHelper.b(-xRot * ((float)Math.PI / 180));
        float sin1 = MathHelper.a(-xRot * ((float)Math.PI / 180));
        double d2 = player.dA() - (double)sin * 0.3;
        double eyeY = player.dE();
        double d1 = player.dG() - (double)cos * 0.3;
        this.b(d2, eyeY, d1, yRot, xRot);
        Vec3D vec3 = new Vec3D(-sin, MathHelper.a(-(sin1 / f2), -5.0f, 5.0f), -cos);
        double len = vec3.g();
        vec3 = vec3.d(0.6 / len + this.ae.a(0.5, 0.0103365), 0.6 / len + this.ae.a(0.5, 0.0103365), 0.6 / len + this.ae.a(0.5, 0.0103365));
        this.i(vec3);
        this.w((float)(MathHelper.d(vec3.d, vec3.f) * 180.0 / 3.1415927410125732));
        this.x((float)(MathHelper.d(vec3.e, vec3.i()) * 180.0 / 3.1415927410125732));
        this.N = this.dL();
        this.O = this.dN();
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(f, 0);
        builder.a(g, false);
    }

    @Override
    protected boolean w() {
        return true;
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (f.equals(key)) {
            int i2 = this.ar().a(f);
            Entity entity = this.n = i2 > 0 ? this.dV().a(i2 - 1) : null;
        }
        if (g.equals(key)) {
            this.c = this.ar().a(g);
            if (this.c) {
                this.n(this.dy().d, -0.4f * MathHelper.a(this.b, 0.6f, 1.0f), this.dy().f);
            }
        }
        super.a(key);
    }

    @Override
    public boolean a(double distance) {
        double d2 = 64.0;
        return distance < 4096.0;
    }

    @Override
    public void g() {
        this.b.b(this.cG().getLeastSignificantBits() ^ this.dV().ae());
        super.g();
        EntityHuman playerOwner = this.f();
        if (playerOwner == null) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else if (this.dV().C || !this.a(playerOwner)) {
            boolean flag;
            if (this.aH()) {
                ++this.h;
                if (this.h >= 1200) {
                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                    return;
                }
            } else {
                this.h = 0;
            }
            float f2 = 0.0f;
            BlockPosition blockPos = this.dv();
            Fluid fluidState = this.dV().b_(blockPos);
            if (fluidState.a(TagsFluid.a)) {
                f2 = fluidState.a(this.dV(), blockPos);
            }
            boolean bl = flag = f2 > 0.0f;
            if (this.o == HookState.a) {
                if (this.n != null) {
                    this.i(Vec3D.c);
                    this.o = HookState.b;
                    return;
                }
                if (flag) {
                    this.i(this.dy().d(0.3, 0.2, 0.3));
                    this.o = HookState.c;
                    return;
                }
                this.l();
            } else {
                if (this.o == HookState.b) {
                    if (this.n != null) {
                        if (!this.n.dQ() && this.n.dV().aj() == this.dV().aj()) {
                            this.a_(this.n.dA(), this.n.e(0.8), this.n.dG());
                        } else {
                            this.B(null);
                            this.o = HookState.a;
                        }
                    }
                    return;
                }
                if (this.o == HookState.c) {
                    Vec3D deltaMovement = this.dy();
                    double d2 = this.dC() + deltaMovement.e - (double)blockPos.v() - (double)f2;
                    if (Math.abs(d2) < 0.01) {
                        d2 += Math.signum(d2) * 0.1;
                    }
                    this.n(deltaMovement.d * 0.9, deltaMovement.e - d2 * (double)this.ae.i() * 0.2, deltaMovement.f * 0.9);
                    if (this.i <= 0 && this.k <= 0) {
                        this.m = true;
                    } else {
                        boolean bl2 = this.m = this.m && this.d < 10 && this.b(blockPos);
                    }
                    if (flag) {
                        this.d = Math.max(0, this.d - 1);
                        if (this.c) {
                            this.i(this.dy().b(0.0, -0.1 * (double)this.b.i() * (double)this.b.i(), 0.0));
                        }
                        if (!this.dV().C) {
                            this.a(blockPos);
                        }
                    } else {
                        this.d = Math.min(10, this.d + 1);
                    }
                }
            }
            if (!fluidState.a(TagsFluid.a)) {
                this.i(this.dy().b(0.0, -0.03, 0.0));
            }
            this.a(EnumMoveType.a, this.dy());
            this.aI();
            this.z();
            if (this.o == HookState.a && (this.aH() || this.P)) {
                this.i(Vec3D.c);
            }
            double d1 = 0.92;
            this.i(this.dy().c(0.92));
            this.av();
        }
    }

    private boolean a(EntityHuman player) {
        ItemStack mainHandItem = player.fb();
        ItemStack offhandItem = player.fc();
        boolean isFishingRod = mainHandItem.a(Items.sd);
        boolean isFishingRod1 = offhandItem.a(Items.sd);
        if (!player.dQ() && player.bJ() && (isFishingRod || isFishingRod1) && !(this.g(player) > 1024.0)) {
            return false;
        }
        this.discard(EntityRemoveEvent.Cause.DESPAWN);
        return true;
    }

    private void l() {
        MovingObjectPosition hitResultOnMoveVector = ProjectileHelper.a((Entity)this, this::b);
        this.preHitTargetOrDeflectSelf(hitResultOnMoveVector);
    }

    @Override
    protected boolean b(Entity target) {
        return super.b(target) || target.bJ() && target instanceof EntityItem;
    }

    @Override
    protected void a(MovingObjectPositionEntity result) {
        super.a(result);
        if (!this.dV().C) {
            this.B(result.a());
        }
    }

    @Override
    protected void a(MovingObjectPositionBlock result) {
        super.a(result);
        this.i(this.dy().d().c(result.a(this)));
    }

    public void B(@Nullable Entity hookedEntity) {
        this.n = hookedEntity;
        this.ar().a(f, hookedEntity == null ? 0 : hookedEntity.ao() + 1);
    }

    private void a(BlockPosition pos) {
        WorldServer serverLevel = (WorldServer)this.dV();
        int i2 = 1;
        BlockPosition blockPos = pos.d();
        if (this.rainInfluenced && this.ae.i() < 0.25f && this.dV().r(blockPos)) {
            ++i2;
        }
        if (this.skyInfluenced && this.ae.i() < 0.5f && !this.dV().h(blockPos)) {
            --i2;
        }
        if (this.i > 0) {
            --this.i;
            if (this.i <= 0) {
                this.j = 0;
                this.k = 0;
                this.ar().a(g, false);
                PlayerFishEvent playerFishEvent = new PlayerFishEvent((Player)this.f().getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.FAILED_ATTEMPT);
                playerFishEvent.callEvent();
            }
        } else if (this.k > 0) {
            this.k -= i2;
            if (this.k > 0) {
                double d2;
                double d1;
                this.l += (float)this.ae.a(0.0, 9.188);
                float f2 = this.l * ((float)Math.PI / 180);
                float sin = MathHelper.a(f2);
                float cos = MathHelper.b(f2);
                double d3 = this.dA() + (double)(sin * (float)this.k * 0.1f);
                IBlockData blockState = serverLevel.a_(BlockPosition.a(d3, (d1 = (double)((float)MathHelper.a(this.dC()) + 1.0f)) - 1.0, d2 = this.dG() + (double)(cos * (float)this.k * 0.1f)));
                if (blockState.a(Blocks.J)) {
                    if (this.ae.i() < 0.15f) {
                        serverLevel.a(Particles.d, d3, d1 - (double)0.1f, d2, 1, (double)sin, 0.1, (double)cos, 0.0);
                    }
                    float f1 = sin * 0.04f;
                    float f22 = cos * 0.04f;
                    serverLevel.a(Particles.E, d3, d1, d2, 0, (double)f22, 0.01, (double)(-f1), 1.0);
                    serverLevel.a(Particles.E, d3, d1, d2, 0, (double)(-f22), 0.01, (double)f1, 1.0);
                }
            } else {
                PlayerFishEvent playerFishEvent = new PlayerFishEvent((Player)this.f().getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.BITE);
                if (!playerFishEvent.callEvent()) {
                    return;
                }
                this.a(SoundEffects.jB, 0.25f, 1.0f + (this.ae.i() - this.ae.i()) * 0.4f);
                double d3 = this.dC() + 0.5;
                serverLevel.a(Particles.d, this.dA(), d3, this.dG(), (int)(1.0f + this.dq() * 20.0f), (double)this.dq(), 0.0, (double)this.dq(), (double)0.2f);
                serverLevel.a(Particles.E, this.dA(), d3, this.dG(), (int)(1.0f + this.dq() * 20.0f), (double)this.dq(), 0.0, (double)this.dq(), (double)0.2f);
                this.i = MathHelper.a(this.ae, 20, 40);
                this.ar().a(g, true);
            }
        } else if (this.j > 0) {
            this.j -= i2;
            float f3 = 0.15f;
            if (this.j < 20) {
                f3 += (float)(20 - this.j) * 0.05f;
            } else if (this.j < 40) {
                f3 += (float)(40 - this.j) * 0.02f;
            } else if (this.j < 60) {
                f3 += (float)(60 - this.j) * 0.01f;
            }
            if (this.ae.i() < f3) {
                double d2;
                double d1;
                float sin = MathHelper.a(this.ae, 0.0f, 360.0f) * ((float)Math.PI / 180);
                float cos = MathHelper.a(this.ae, 25.0f, 60.0f);
                double d4 = this.dA() + (double)(MathHelper.a(sin) * cos) * 0.1;
                IBlockData blockState = serverLevel.a_(BlockPosition.a(d4, (d1 = (double)((float)MathHelper.a(this.dC()) + 1.0f)) - 1.0, d2 = this.dG() + (double)(MathHelper.b(sin) * cos) * 0.1));
                if (blockState.a(Blocks.J)) {
                    serverLevel.a(Particles.ap, d4, d1, d2, 2 + this.ae.a(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                }
            }
            if (this.j <= 0) {
                PlayerFishEvent playerFishEvent;
                this.l = MathHelper.a(this.ae, this.minLureAngle, this.maxLureAngle);
                this.k = MathHelper.a(this.ae, this.minLureTime, this.maxLureTime);
                if (this.f() != null && !(playerFishEvent = new PlayerFishEvent((Player)this.f().getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.LURED)).callEvent()) {
                    this.k = 0;
                    return;
                }
            }
        } else {
            this.resetTimeUntilLured();
        }
    }

    public void resetTimeUntilLured() {
        this.j = MathHelper.a(this.ae, this.minWaitTime, this.maxWaitTime);
        this.j -= this.applyLure ? (this.q >= this.maxWaitTime ? this.j - 1 : this.q) : 0;
    }

    public boolean b(BlockPosition pos) {
        WaterPosition openWaterType = WaterPosition.c;
        for (int i2 = -1; i2 <= 2; ++i2) {
            WaterPosition openWaterTypeForArea = this.a(pos.b(-2, i2, -2), pos.b(2, i2, 2));
            switch (openWaterTypeForArea.ordinal()) {
                case 0: {
                    if (openWaterType != WaterPosition.c) break;
                    return false;
                }
                case 1: {
                    if (openWaterType != WaterPosition.a) break;
                    return false;
                }
                case 2: {
                    return false;
                }
            }
            openWaterType = openWaterTypeForArea;
        }
        return true;
    }

    private WaterPosition a(BlockPosition firstPos, BlockPosition secondPos) {
        return BlockPosition.d(firstPos, secondPos).map(this::c).reduce((firstType, secondType) -> firstType == secondType ? firstType : WaterPosition.c).orElse(WaterPosition.c);
    }

    private WaterPosition c(BlockPosition pos) {
        IBlockData blockState = this.dV().a_(pos);
        if (!blockState.l() && !blockState.a(Blocks.fF)) {
            Fluid fluidState = blockState.y();
            return fluidState.a(TagsFluid.a) && fluidState.b() && blockState.g(this.dV(), pos).c() ? WaterPosition.b : WaterPosition.c;
        }
        return WaterPosition.a;
    }

    public boolean e() {
        return this.m;
    }

    @Override
    public void b(NBTTagCompound compound) {
    }

    @Override
    public void a(NBTTagCompound compound) {
    }

    @Deprecated
    @DoNotUse
    public int a(ItemStack stack) {
        return this.retrieve(stack, EnumHand.a);
    }

    public int retrieve(ItemStack stack, EnumHand hand) {
        EntityHuman playerOwner = this.f();
        if (!this.dV().C && playerOwner != null && !this.a(playerOwner)) {
            PlayerFishEvent playerFishEvent;
            int i2 = 0;
            if (this.n != null) {
                playerFishEvent = new PlayerFishEvent((Player)playerOwner.getBukkitEntity(), (org.bukkit.entity.Entity)this.n.getBukkitEntity(), (FishHook)this.getBukkitEntity(), CraftEquipmentSlot.getHand(hand), PlayerFishEvent.State.CAUGHT_ENTITY);
                if (!playerFishEvent.callEvent()) {
                    return 0;
                }
                if (this.n != null) {
                    this.d(this.n);
                    CriterionTriggers.E.a((EntityPlayer)playerOwner, stack, this, Collections.emptyList());
                    this.dV().a((Entity)this, (byte)31);
                    i2 = this.n instanceof EntityItem ? 3 : 5;
                }
            } else if (this.i > 0) {
                LootParams lootParams = new LootParams.a((WorldServer)this.dV()).a(LootContextParameters.f, this.dt()).a(LootContextParameters.i, stack).a(LootContextParameters.a, this).a((float)this.p + playerOwner.eh()).a(LootContextParameterSets.f);
                LootTable lootTable = this.dV().p().bc().b(LootTables.am);
                ObjectArrayList<ItemStack> randomItems = lootTable.a(lootParams);
                CriterionTriggers.E.a((EntityPlayer)playerOwner, stack, this, (Collection<ItemStack>)randomItems);
                for (ItemStack itemStack : randomItems) {
                    EntityItem itemEntity = new EntityItem(this.dV(), this.dA(), this.dC(), this.dG(), itemStack);
                    PlayerFishEvent playerFishEvent2 = new PlayerFishEvent((Player)playerOwner.getBukkitEntity(), (org.bukkit.entity.Entity)itemEntity.getBukkitEntity(), (FishHook)this.getBukkitEntity(), CraftEquipmentSlot.getHand(hand), PlayerFishEvent.State.CAUGHT_FISH);
                    playerFishEvent2.setExpToDrop(this.ae.a(6) + 1);
                    if (!playerFishEvent2.callEvent()) {
                        return 0;
                    }
                    double d2 = playerOwner.dA() - this.dA();
                    double d1 = playerOwner.dC() - this.dC();
                    double d22 = playerOwner.dG() - this.dG();
                    double d3 = 0.1;
                    itemEntity.n(d2 * 0.1, d1 * 0.1 + Math.sqrt(Math.sqrt(d2 * d2 + d1 * d1 + d22 * d22)) * 0.08, d22 * 0.1);
                    this.dV().b(itemEntity);
                    if (playerFishEvent2.getExpToDrop() > 0) {
                        playerOwner.dV().b(new EntityExperienceOrb(playerOwner.dV(), playerOwner.dA(), playerOwner.dC() + 0.5, playerOwner.dG() + 0.5, playerFishEvent2.getExpToDrop(), ExperienceOrb.SpawnReason.FISHING, this.f(), this));
                    }
                    if (!itemStack.a(TagsItem.aV)) continue;
                    playerOwner.a(StatisticList.R, 1);
                }
                i2 = 1;
            }
            if (this.aH()) {
                playerFishEvent = new PlayerFishEvent((Player)playerOwner.getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), CraftEquipmentSlot.getHand(hand), PlayerFishEvent.State.IN_GROUND);
                if (!playerFishEvent.callEvent()) {
                    return 0;
                }
                i2 = 2;
            }
            if (i2 == 0 && !(playerFishEvent = new PlayerFishEvent((Player)playerOwner.getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), CraftEquipmentSlot.getHand(hand), PlayerFishEvent.State.REEL_IN)).callEvent()) {
                return 0;
            }
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
            return i2;
        }
        return 0;
    }

    @Override
    public void b(byte id) {
        EntityHuman player;
        Entity entity;
        if (id == 31 && this.dV().C && (entity = this.n) instanceof EntityHuman && (player = (EntityHuman)entity).gh()) {
            this.d(this.n);
        }
        super.b(id);
    }

    public void d(Entity entity) {
        Entity owner = this.p();
        if (owner != null) {
            Vec3D vec3 = new Vec3D(owner.dA() - this.dA(), owner.dC() - this.dC(), owner.dG() - this.dG()).c(0.1);
            entity.i(entity.dy().e(vec3));
        }
    }

    @Override
    protected Entity.MovementEmission bf() {
        return Entity.MovementEmission.a;
    }

    @Override
    public void remove(Entity.RemovalReason reason, @Nullable EntityRemoveEvent.Cause cause) {
        this.a((EntityFishingHook)null);
        super.remove(reason, cause);
    }

    @Override
    public void as() {
        this.a((EntityFishingHook)null);
    }

    @Override
    public void c(@Nullable Entity owner) {
        super.c(owner);
        this.a(this);
    }

    private void a(@Nullable EntityFishingHook fishingHook) {
        EntityHuman playerOwner = this.f();
        if (playerOwner != null) {
            playerOwner.ck = fishingHook;
        }
    }

    @Nullable
    public EntityHuman f() {
        EntityHuman player;
        Entity entity = this.p();
        return entity instanceof EntityHuman ? (player = (EntityHuman)entity) : null;
    }

    @Nullable
    public Entity i() {
        return this.n;
    }

    @Override
    public boolean n(boolean allowPassengers) {
        return false;
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entity) {
        Entity owner = this.p();
        return new PacketPlayOutSpawnEntity((Entity)this, entity, owner == null ? this.ao() : owner.ao());
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        if (this.f() == null) {
            int data = packet.p();
            a.error("Failed to recreate fishing hook on client. {} (id: {}) is not a valid owner.", (Object)this.dV().a(data), (Object)data);
            this.discard(null);
        }
    }

    public static final class HookState
    extends Enum<HookState> {
        public static final /* enum */ HookState a = new HookState();
        public static final /* enum */ HookState b = new HookState();
        public static final /* enum */ HookState c = new HookState();
        private static final /* synthetic */ HookState[] d;

        public static HookState[] values() {
            return (HookState[])d.clone();
        }

        public static HookState valueOf(String name) {
            return Enum.valueOf(HookState.class, name);
        }

        private static /* synthetic */ HookState[] a() {
            return new HookState[]{a, b, c};
        }

        static {
            d = HookState.a();
        }
    }

    static final class WaterPosition
    extends Enum<WaterPosition> {
        public static final /* enum */ WaterPosition a = new WaterPosition();
        public static final /* enum */ WaterPosition b = new WaterPosition();
        public static final /* enum */ WaterPosition c = new WaterPosition();
        private static final /* synthetic */ WaterPosition[] d;

        public static WaterPosition[] values() {
            return (WaterPosition[])d.clone();
        }

        public static WaterPosition valueOf(String name) {
            return Enum.valueOf(WaterPosition.class, name);
        }

        private static /* synthetic */ WaterPosition[] a() {
            return new WaterPosition[]{a, b, c};
        }

        static {
            d = WaterPosition.a();
        }
    }
}

