/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import io.papermc.paper.event.entity.WaterBottleSplashEvent;
import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.projectile.EntityProjectileThrowable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityRemoveEvent;

public abstract class EntityPotion
extends EntityProjectileThrowable {
    public static final double a = 4.0;
    protected static final double b = 16.0;
    public static final Predicate<EntityLiving> c = livingEntity -> livingEntity.fr() || livingEntity.bX();
    private static final Predicate<EntityLiving> APPLY_WATER_GET_ENTITIES_PREDICATE = c.or(Axolotl.class::isInstance);

    public EntityPotion(EntityTypes<? extends EntityPotion> entityType, World level) {
        super((EntityTypes<? extends EntityProjectileThrowable>)entityType, level);
    }

    public EntityPotion(EntityTypes<? extends EntityPotion> entityType, World level, EntityLiving owner, ItemStack item) {
        super(entityType, owner, level, item);
    }

    public EntityPotion(EntityTypes<? extends EntityPotion> entityType, World level, double x2, double y2, double z2, ItemStack item) {
        super(entityType, x2, y2, z2, level, item);
    }

    @Override
    protected double bc() {
        return 0.05;
    }

    @Override
    protected void a(MovingObjectPositionBlock result) {
        super.a(result);
        if (!this.dV().C) {
            ItemStack item = this.e();
            EnumDirection direction = result.c();
            BlockPosition blockPos = result.b();
            BlockPosition blockPos1 = blockPos.a(direction);
            PotionContents potionContents = item.a(DataComponents.R, PotionContents.a);
            if (potionContents.a(Potions.a)) {
                this.a(blockPos1);
                this.a(blockPos1.a(direction.g()));
                for (EnumDirection direction1 : EnumDirection.EnumDirectionLimit.a) {
                    this.a(blockPos1.a(direction1));
                }
            }
        }
    }

    @Override
    protected void a(MovingObjectPosition result) {
        super.a(result);
        this.splash(result);
    }

    public void splash(@Nullable MovingObjectPosition result) {
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            ItemStack item = this.e();
            PotionContents potionContents = item.a(DataComponents.R, PotionContents.a);
            boolean showParticles = true;
            showParticles = potionContents.a(Potions.a) ? this.onHitAsWater(serverLevel, result) : this.onHitAsPotion(serverLevel, item, result != null && result.d() == MovingObjectPosition.EnumMovingObjectType.c ? ((MovingObjectPositionEntity)result).a() : null, result);
            if (showParticles) {
                int i2 = potionContents.e().isPresent() && potionContents.e().get().a().c() ? 2007 : 2002;
                serverLevel.c(i2, this.dv(), potionContents.b());
            }
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }

    private boolean onHitAsWater(WorldServer level, @Nullable MovingObjectPosition result) {
        AxisAlignedBB aabb = this.cR().c(4.0, 2.0, 4.0);
        HashMap<LivingEntity, Double> affected = new HashMap<LivingEntity, Double>();
        HashSet<LivingEntity> rehydrate = new HashSet<LivingEntity>();
        HashSet<LivingEntity> extinguish = new HashSet<LivingEntity>();
        for (EntityLiving livingEntity : this.dV().a(EntityLiving.class, aabb, APPLY_WATER_GET_ENTITIES_PREDICATE)) {
            double d2;
            if (livingEntity instanceof Axolotl) {
                Axolotl axolotl = (Axolotl)livingEntity;
                rehydrate.add((LivingEntity)((org.bukkit.entity.Axolotl)axolotl.getBukkitEntity()));
            }
            if (!((d2 = this.g(livingEntity)) < 16.0)) continue;
            if (livingEntity.fr()) {
                affected.put(livingEntity.getBukkitLivingEntity(), 1.0);
            }
            if (!livingEntity.bX() || !livingEntity.bJ()) continue;
            extinguish.add(livingEntity.getBukkitLivingEntity());
        }
        WaterBottleSplashEvent event = CraftEventFactory.callWaterBottleSplashEvent(this, result, affected, rehydrate, extinguish);
        if (!event.isCancelled()) {
            for (LivingEntity affectedEntity : event.getToDamage()) {
                ((CraftLivingEntity)affectedEntity).getHandle().a(level, this.dW().c((Entity)this, this.p()), 1.0f);
            }
            for (LivingEntity toExtinguish : event.getToExtinguish()) {
                ((CraftLivingEntity)toExtinguish).getHandle().aM();
            }
            for (LivingEntity toRehydrate : event.getToRehydrate()) {
                EntityLiving entityLiving = ((CraftLivingEntity)toRehydrate).getHandle();
                if (!(entityLiving instanceof Axolotl)) continue;
                Axolotl axolotl = (Axolotl)entityLiving;
                axolotl.m();
            }
        }
        return !event.isCancelled();
    }

    protected abstract boolean onHitAsPotion(WorldServer var1, ItemStack var2, @Nullable Entity var3, @Nullable MovingObjectPosition var4);

    private void a(BlockPosition pos) {
        IBlockData blockState = this.dV().a_(pos);
        if (blockState.a(TagsBlock.aN)) {
            if (CraftEventFactory.callEntityChangeBlockEvent(this, pos, blockState.y().g())) {
                this.dV().a(pos, false, this);
            }
        } else if (AbstractCandleBlock.c(blockState)) {
            if (CraftEventFactory.callEntityChangeBlockEvent(this, pos, (IBlockData)blockState.b(AbstractCandleBlock.b, false))) {
                AbstractCandleBlock.a(null, blockState, (GeneratorAccess)this.dV(), pos);
            }
        } else if (BlockCampfire.h(blockState) && CraftEventFactory.callEntityChangeBlockEvent(this, pos, (IBlockData)blockState.b(BlockCampfire.b, false))) {
            this.dV().a(null, 1009, pos, 0);
            BlockCampfire.a(this.p(), (GeneratorAccess)this.dV(), pos, blockState);
            this.dV().b(pos, (IBlockData)blockState.b(BlockCampfire.b, false));
        }
    }

    @Override
    public DoubleDoubleImmutablePair a_(EntityLiving entity, DamageSource damageSource) {
        double d2 = entity.dt().d - this.dt().d;
        double d1 = entity.dt().f - this.dt().f;
        return DoubleDoubleImmutablePair.of((double)d2, (double)d1);
    }
}

