/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityShulkerBullet
extends IProjectile {
    private static final double a = 0.15;
    @Nullable
    private Entity b;
    @Nullable
    public EnumDirection c;
    public int d;
    public double e;
    public double f;
    public double g;
    @Nullable
    private UUID h;

    public EntityShulkerBullet(EntityTypes<? extends EntityShulkerBullet> entityType, World level) {
        super((EntityTypes<? extends IProjectile>)entityType, level);
        this.ad = true;
    }

    public EntityShulkerBullet(World level, EntityLiving shooter, Entity finalTarget, EnumDirection.EnumAxis axis) {
        this((EntityTypes<? extends EntityShulkerBullet>)EntityTypes.be, level);
        this.c(shooter);
        Vec3D center = shooter.cR().f();
        this.b(center.d, center.e, center.f, this.dL(), this.dN());
        this.b = finalTarget;
        this.c = EnumDirection.b;
        this.a(axis);
        this.projectileSource = shooter.getBukkitLivingEntity();
    }

    @Nullable
    public Entity getTarget() {
        return this.b;
    }

    public void setTarget(@Nullable Entity finalTarget) {
        this.b = finalTarget;
        this.c = EnumDirection.b;
        this.a(EnumDirection.EnumAxis.a);
    }

    @Override
    public SoundCategory dm() {
        return SoundCategory.f;
    }

    @Override
    protected void b(NBTTagCompound compound) {
        super.b(compound);
        if (this.b != null) {
            compound.a("Target", UUIDUtil.a, this.b.cG());
        }
        compound.b("Dir", EnumDirection.k, this.c);
        compound.a("Steps", this.d);
        compound.a("TXD", this.e);
        compound.a("TYD", this.f);
        compound.a("TZD", this.g);
    }

    @Override
    protected void a(NBTTagCompound compound) {
        super.a(compound);
        this.d = compound.b("Steps", 0);
        this.e = compound.b("TXD", 0.0);
        this.f = compound.b("TYD", 0.0);
        this.g = compound.b("TZD", 0.0);
        this.c = compound.a("Dir", EnumDirection.k).orElse(null);
        this.h = compound.a("Target", UUIDUtil.a).orElse(null);
    }

    @Override
    protected void a(DataWatcher.a builder) {
    }

    @Nullable
    private EnumDirection e() {
        return this.c;
    }

    private void a(@Nullable EnumDirection direction) {
        this.c = direction;
    }

    private void a(@Nullable EnumDirection.EnumAxis axis) {
        BlockPosition blockPos;
        double d2 = 0.5;
        if (this.b == null) {
            blockPos = this.dv().e();
        } else {
            d2 = (double)this.b.dr() * 0.5;
            blockPos = BlockPosition.a(this.b.dA(), this.b.dC() + d2, this.b.dG());
        }
        double d1 = (double)blockPos.u() + 0.5;
        double d22 = (double)blockPos.v() + d2;
        double d3 = (double)blockPos.w() + 0.5;
        EnumDirection direction = null;
        if (!blockPos.a(this.dt(), 2.0)) {
            BlockPosition blockPos1 = this.dv();
            ArrayList list = Lists.newArrayList();
            if (axis != EnumDirection.EnumAxis.a) {
                if (blockPos1.u() < blockPos.u() && this.dV().v(blockPos1.i())) {
                    list.add(EnumDirection.f);
                } else if (blockPos1.u() > blockPos.u() && this.dV().v(blockPos1.h())) {
                    list.add(EnumDirection.e);
                }
            }
            if (axis != EnumDirection.EnumAxis.b) {
                if (blockPos1.v() < blockPos.v() && this.dV().v(blockPos1.d())) {
                    list.add(EnumDirection.b);
                } else if (blockPos1.v() > blockPos.v() && this.dV().v(blockPos1.e())) {
                    list.add(EnumDirection.a);
                }
            }
            if (axis != EnumDirection.EnumAxis.c) {
                if (blockPos1.w() < blockPos.w() && this.dV().v(blockPos1.g())) {
                    list.add(EnumDirection.d);
                } else if (blockPos1.w() > blockPos.w() && this.dV().v(blockPos1.f())) {
                    list.add(EnumDirection.c);
                }
            }
            direction = EnumDirection.b(this.ae);
            if (list.isEmpty()) {
                for (int i2 = 5; !this.dV().v(blockPos1.a(direction)) && i2 > 0; --i2) {
                    direction = EnumDirection.b(this.ae);
                }
            } else {
                direction = (EnumDirection)list.get(this.ae.a(list.size()));
            }
            d1 = this.dA() + (double)direction.j();
            d22 = this.dC() + (double)direction.k();
            d3 = this.dG() + (double)direction.l();
        }
        this.a(direction);
        double d4 = d1 - this.dA();
        double d5 = d22 - this.dC();
        double d6 = d3 - this.dG();
        double squareRoot = Math.sqrt(d4 * d4 + d5 * d5 + d6 * d6);
        if (squareRoot == 0.0) {
            this.e = 0.0;
            this.f = 0.0;
            this.g = 0.0;
        } else {
            this.e = d4 / squareRoot * 0.15;
            this.f = d5 / squareRoot * 0.15;
            this.g = d6 / squareRoot * 0.15;
        }
        this.ar = true;
        this.d = 10 + this.ae.a(5) * 10;
    }

    @Override
    public void dH() {
        if (this.dV().an() == EnumDifficulty.a) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    @Override
    protected double bc() {
        return 0.04;
    }

    @Override
    public void g() {
        Vec3D deltaMovement;
        super.g();
        MovingObjectPosition hitResult = null;
        if (!this.dV().C) {
            if (this.b == null && this.h != null) {
                this.b = ((WorldServer)this.dV()).b(this.h);
                if (this.b == null) {
                    this.h = null;
                }
            }
            if (this.b == null || !this.b.bJ() || this.b instanceof EntityHuman && this.b.ak()) {
                this.be();
            } else {
                this.e = MathHelper.a(this.e * 1.025, -1.0, 1.0);
                this.f = MathHelper.a(this.f * 1.025, -1.0, 1.0);
                this.g = MathHelper.a(this.g * 1.025, -1.0, 1.0);
                deltaMovement = this.dy();
                this.i(deltaMovement.b((this.e - deltaMovement.d) * 0.2, (this.f - deltaMovement.e) * 0.2, (this.g - deltaMovement.f) * 0.2));
            }
            hitResult = ProjectileHelper.a((Entity)this, this::b);
        }
        deltaMovement = this.dy();
        this.b(this.dt().e(deltaMovement));
        this.aI();
        if (this.as != null && this.as.e()) {
            this.bV();
        }
        if (hitResult != null && this.bJ() && hitResult.d() != MovingObjectPosition.EnumMovingObjectType.a) {
            this.preHitTargetOrDeflectSelf(hitResult);
        }
        ProjectileHelper.a((Entity)this, 0.5f);
        if (this.dV().C) {
            this.dV().a(Particles.t, this.dA() - deltaMovement.d, this.dC() - deltaMovement.e + 0.15, this.dG() - deltaMovement.f, 0.0, 0.0, 0.0);
        } else if (this.b != null && !this.b.dQ()) {
            if (this.d > 0) {
                --this.d;
                if (this.d == 0) {
                    this.a(this.c == null ? null : this.c.o());
                }
            }
            if (this.c != null) {
                BlockPosition blockPos = this.dv();
                EnumDirection.EnumAxis axis = this.c.o();
                if (this.dV().a(blockPos.a(this.c), this)) {
                    this.a(axis);
                } else {
                    BlockPosition blockPos1 = this.b.dv();
                    if (axis == EnumDirection.EnumAxis.a && blockPos.u() == blockPos1.u() || axis == EnumDirection.EnumAxis.c && blockPos.w() == blockPos1.w() || axis == EnumDirection.EnumAxis.b && blockPos.v() == blockPos1.v()) {
                        this.a(axis);
                    }
                }
            }
        }
    }

    @Override
    public boolean aK() {
        return !this.dQ();
    }

    @Override
    protected boolean b(Entity target) {
        return super.b(target) && !target.ad;
    }

    @Override
    public boolean bX() {
        return false;
    }

    @Override
    public boolean a(double distance) {
        return distance < 16384.0;
    }

    @Override
    public float bw() {
        return 1.0f;
    }

    @Override
    protected void a(MovingObjectPositionEntity result) {
        super.a(result);
        Entity entity = result.a();
        Entity owner = this.p();
        EntityLiving livingEntity = owner instanceof EntityLiving ? (EntityLiving)owner : null;
        DamageSource damageSource = this.dW().a((Entity)this, livingEntity);
        boolean flag = entity.b(damageSource, 4.0f);
        if (flag) {
            World world = this.dV();
            if (world instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)world;
                EnchantmentManager.a(serverLevel, entity, damageSource);
            }
            if (entity instanceof EntityLiving) {
                EntityLiving livingEntity1 = (EntityLiving)entity;
                livingEntity1.addEffect(new MobEffect(MobEffects.y, 200), (Entity)MoreObjects.firstNonNull((Object)owner, (Object)this), EntityPotionEffectEvent.Cause.ATTACK);
            }
        }
    }

    @Override
    protected void a(MovingObjectPositionBlock result) {
        super.a(result);
        ((WorldServer)this.dV()).a(Particles.w, this.dA(), this.dC(), this.dG(), 2, 0.2, 0.2, 0.2, 0.0);
        this.a(SoundEffects.xE, 1.0f, 1.0f);
    }

    private void f() {
        this.destroy(null);
    }

    private void destroy(@Nullable EntityRemoveEvent.Cause cause) {
        this.discard(cause);
        this.dV().a(GameEvent.o, this.dt(), GameEvent.a.a(this));
    }

    @Override
    protected void a(MovingObjectPosition result) {
        super.a(result);
        this.destroy(EntityRemoveEvent.Cause.HIT);
    }

    @Override
    public boolean bF() {
        return true;
    }

    @Override
    public boolean b(DamageSource damageSource) {
        return true;
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damageSource, amount, false)) {
            return false;
        }
        this.a(SoundEffects.xF, 1.0f, 1.0f);
        level.a(Particles.f, this.dA(), this.dC(), this.dG(), 15, 0.2, 0.2, 0.2, 0.0);
        this.destroy(EntityRemoveEvent.Cause.DEATH);
        return true;
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        double xa = packet.j();
        double ya = packet.k();
        double za = packet.l();
        this.n(xa, ya, za);
    }
}

