/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.projectile.EntityFireball;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;

public class EntityWitherSkull
extends EntityFireball {
    private static final DataWatcherObject<Boolean> d = DataWatcher.a(EntityWitherSkull.class, DataWatcherRegistry.k);
    private static final boolean e = false;

    public EntityWitherSkull(EntityTypes<? extends EntityWitherSkull> entityType, World level) {
        super((EntityTypes<? extends EntityFireball>)entityType, level);
    }

    public EntityWitherSkull(World level, EntityLiving owner, Vec3D movement) {
        super(EntityTypes.bM, owner, movement, level);
    }

    @Override
    protected float l() {
        return this.n() ? 0.73f : super.l();
    }

    @Override
    public boolean bX() {
        return false;
    }

    @Override
    public float a(Explosion explosion, IBlockAccess level, BlockPosition pos, IBlockData blockState, Fluid fluidState, float explosionPower) {
        return this.n() && EntityWither.c(blockState) ? Math.min(0.8f, explosionPower) : explosionPower;
    }

    @Override
    protected void a(MovingObjectPositionEntity result) {
        super.a(result);
        World world = this.dV();
        if (world instanceof WorldServer) {
            boolean flag;
            WorldServer serverLevel = (WorldServer)world;
            Entity var8 = result.a();
            Entity entity = this.p();
            if (entity instanceof EntityLiving) {
                EntityLiving livingEntity = (EntityLiving)entity;
                DamageSource damageSource = this.dW().a(this, (Entity)livingEntity);
                flag = var8.a(serverLevel, damageSource, 8.0f);
                if (flag) {
                    if (var8.bJ()) {
                        EnchantmentManager.a(serverLevel, var8, damageSource);
                    } else {
                        livingEntity.heal(5.0f, EntityRegainHealthEvent.RegainReason.WITHER);
                    }
                }
            } else {
                flag = var8.a(serverLevel, this.dW().q().eventEntityDamager(this), 5.0f);
            }
            if (flag && var8 instanceof EntityLiving) {
                EntityLiving livingEntityx = (EntityLiving)var8;
                int i2 = 0;
                if (this.dV().an() == EnumDifficulty.c) {
                    i2 = 10;
                } else if (this.dV().an() == EnumDifficulty.d) {
                    i2 = 40;
                }
                if (i2 > 0) {
                    livingEntityx.addEffect(new MobEffect(MobEffects.t, 20 * i2, 1), this.y(), EntityPotionEffectEvent.Cause.ATTACK);
                }
            }
        }
    }

    @Override
    protected void a(MovingObjectPosition result) {
        super.a(result);
        if (!this.dV().C) {
            ExplosionPrimeEvent event = new ExplosionPrimeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), 1.0f, false);
            if (event.callEvent()) {
                this.dV().a((Entity)this, this.dA(), this.dC(), this.dG(), event.getRadius(), event.getFire(), World.a.c);
            }
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(d, false);
    }

    public boolean n() {
        return this.al.a(d);
    }

    public void a(boolean invulnerable) {
        this.al.a(d, invulnerable);
    }

    @Override
    protected boolean f() {
        return false;
    }

    @Override
    public void b(NBTTagCompound tag) {
        super.b(tag);
        tag.a("dangerous", this.n());
    }

    @Override
    public void a(NBTTagCompound tag) {
        super.a(tag);
        this.a(tag.b("dangerous", false));
    }
}

