/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.EntityPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.MovingObjectPosition;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.event.entity.LingeringPotionSplashEvent;

public class ThrownLingeringPotion
extends EntityPotion {
    public ThrownLingeringPotion(EntityTypes<? extends ThrownLingeringPotion> entityType, World level) {
        super((EntityTypes<? extends EntityPotion>)entityType, level);
    }

    public ThrownLingeringPotion(World level, EntityLiving owner, ItemStack item) {
        super(EntityTypes.aX, level, owner, item);
    }

    public ThrownLingeringPotion(World level, double x2, double y2, double z2, ItemStack item) {
        super(EntityTypes.aX, level, x2, y2, z2, item);
    }

    @Override
    public Item f() {
        return Items.wC;
    }

    @Override
    public boolean onHitAsPotion(WorldServer level, ItemStack stack, @Nullable Entity entity, @Nullable MovingObjectPosition hitResult) {
        EntityAreaEffectCloud areaEffectCloud = new EntityAreaEffectCloud(this.dV(), this.dA(), this.dC(), this.dG());
        Entity entity2 = this.p();
        if (entity2 instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)entity2;
            areaEffectCloud.a(livingEntity);
        }
        areaEffectCloud.a(3.0f);
        areaEffectCloud.c(-0.5f);
        areaEffectCloud.a(600);
        areaEffectCloud.c(10);
        areaEffectCloud.d(-areaEffectCloud.c() / (float)areaEffectCloud.h());
        areaEffectCloud.c(stack);
        boolean noEffects = this.e().a(DataComponents.R, PotionContents.a).c();
        LingeringPotionSplashEvent event = CraftEventFactory.callLingeringPotionSplashEvent(this, hitResult, areaEffectCloud);
        if (!(event.isCancelled() || areaEffectCloud.dQ() || !event.allowsEmptyCreation() && noEffects && !areaEffectCloud.t.c())) {
            level.b(areaEffectCloud);
        } else {
            areaEffectCloud.discard(null);
        }
        return !event.isCancelled();
    }
}

