/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile.windcharge;

import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.EntityFireball;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.SimpleExplosionDamageCalculator;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityRemoveEvent;

public abstract class AbstractWindCharge
extends EntityFireball
implements ItemSupplier {
    public static final ExplosionDamageCalculator d = new SimpleExplosionDamageCalculator(true, false, Optional.empty(), BuiltInRegistries.e.a(TagsBlock.cF).map(Function.identity()));
    public static final double e = 0.25;

    public AbstractWindCharge(EntityTypes<? extends AbstractWindCharge> entityType, World level) {
        super((EntityTypes<? extends EntityFireball>)entityType, level);
        this.c = 0.0;
    }

    public AbstractWindCharge(EntityTypes<? extends AbstractWindCharge> entityType, World level, Entity owner, double x2, double y2, double z2) {
        super(entityType, x2, y2, z2, level);
        this.c(owner);
        this.c = 0.0;
    }

    AbstractWindCharge(EntityTypes<? extends AbstractWindCharge> entityType, double x2, double y2, double z2, Vec3D movement, World level) {
        super(entityType, x2, y2, z2, movement, level);
        this.c = 0.0;
    }

    @Override
    protected AxisAlignedBB c(Vec3D position) {
        float f2 = this.an().n().a() / 2.0f;
        float height = this.an().n().b();
        float f1 = 0.15f;
        return new AxisAlignedBB(position.d - (double)f2, position.e - (double)0.15f, position.f - (double)f2, position.d + (double)f2, position.e - (double)0.15f + (double)height, position.f + (double)f2);
    }

    @Override
    public boolean i(Entity entity) {
        return !(entity instanceof AbstractWindCharge) && super.i(entity);
    }

    @Override
    protected boolean b(Entity target) {
        return !(target instanceof AbstractWindCharge) && target.an() != EntityTypes.S && super.b(target);
    }

    @Override
    protected void a(MovingObjectPositionEntity result) {
        super.a(result);
        World world = this.dV();
        if (world instanceof WorldServer) {
            DamageSource damageSource;
            EntityLiving livingEntity;
            WorldServer serverLevel = (WorldServer)world;
            Entity entity = this.p();
            EntityLiving livingEntity1 = entity instanceof EntityLiving ? (livingEntity = (EntityLiving)entity) : null;
            Entity entity2 = result.a();
            if (livingEntity1 != null) {
                livingEntity1.B(entity2);
            }
            if (entity2.a(serverLevel, damageSource = this.dW().c((Entity)this, livingEntity1), 1.0f) && entity2 instanceof EntityLiving) {
                EntityLiving livingEntity2 = (EntityLiving)entity2;
                EnchantmentManager.a(serverLevel, (Entity)livingEntity2, damageSource);
            }
            this.a(this.dt());
        }
    }

    @Override
    public void push(double x2, double y2, double z2, @Nullable Entity pushingEntity) {
    }

    public abstract void a(Vec3D var1);

    @Override
    protected void a(MovingObjectPositionBlock result) {
        super.a(result);
        if (!this.dV().C) {
            BaseBlockPosition unitVec3i = result.c().q();
            Vec3D vec3 = Vec3D.a(unitVec3i).d(0.25, 0.25, 0.25);
            Vec3D vec31 = result.g().e(vec3);
            this.a(vec31);
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }

    @Override
    protected void a(MovingObjectPosition result) {
        super.a(result);
        if (!this.dV().C) {
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }

    @Override
    protected boolean f() {
        return false;
    }

    @Override
    public ItemStack e() {
        return ItemStack.l;
    }

    @Override
    protected float l() {
        return 1.0f;
    }

    @Override
    protected float m() {
        return this.l();
    }

    @Override
    @Nullable
    protected ParticleParam i() {
        return null;
    }

    @Override
    public void g() {
        if (!this.dV().C && this.dB() > this.dV().ao() + 30) {
            this.a(this.dt());
            this.discard(EntityRemoveEvent.Cause.OUT_OF_WORLD);
        } else {
            super.g();
        }
    }
}

