/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayInBoatMove;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityWaterAnimal;
import net.minecraft.world.entity.monster.creaking.Creaking;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockWaterLily;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftLocation;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.event.vehicle.VehicleUpdateEvent;

public abstract class AbstractBoat
extends VehicleEntity
implements Leashable {
    private static final DataWatcherObject<Boolean> j = DataWatcher.a(AbstractBoat.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> k = DataWatcher.a(AbstractBoat.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> l = DataWatcher.a(AbstractBoat.class, DataWatcherRegistry.b);
    public static final int a = 0;
    public static final int b = 1;
    private static final int m = 60;
    private static final float n = 0.3926991f;
    public static final double c = 0.7853981852531433;
    public static final int d = 60;
    private final float[] o = new float[2];
    private float p;
    private float q;
    private final InterpolationHandler r = new InterpolationHandler((Entity)this, 3);
    private boolean s;
    private boolean t;
    private boolean u;
    private boolean ay;
    private double az;
    private float aA;
    public EnumStatus aB;
    private EnumStatus aC;
    private double aD;
    private boolean aE;
    private boolean aF;
    private float aG;
    private float aH;
    private float aI;
    @Nullable
    private Leashable.a aJ;
    private final Supplier<Item> aK;
    public double maxSpeed = 0.4;
    public double occupiedDeceleration = 0.2;
    public double unoccupiedDeceleration = -1.0;
    public boolean landBoats = false;
    private Location lastLocation;

    public AbstractBoat(EntityTypes<? extends AbstractBoat> entityType, World level, Supplier<Item> dropItem) {
        super(entityType, level);
        this.aK = dropItem;
        this.I = true;
    }

    public void p(double x2, double y2, double z2) {
        this.a_(x2, y2, z2);
        this.K = x2;
        this.L = y2;
        this.M = z2;
    }

    @Override
    protected Entity.MovementEmission bf() {
        return Entity.MovementEmission.c;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(j, false);
        builder.a(k, false);
        builder.a(l, 0);
    }

    @Override
    public boolean i(Entity entity) {
        return AbstractBoat.a(this, entity);
    }

    public static boolean a(Entity first, Entity second) {
        return (second.bL() || second.bG()) && !first.z(second);
    }

    @Override
    public boolean bL() {
        return true;
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return true;
    }

    @Override
    public Vec3D a(EnumDirection.EnumAxis axis, BlockUtil.Rectangle portal) {
        return EntityLiving.k(super.a(axis, portal));
    }

    protected abstract double b(EntitySize var1);

    @Override
    protected Vec3D a(Entity entity, EntitySize dimensions, float partialTick) {
        float singlePassengerXOffset = this.m();
        if (this.cY().size() > 1) {
            int index = this.cY().indexOf(entity);
            singlePassengerXOffset = index == 0 ? 0.2f : -0.6f;
            if (entity instanceof EntityAnimal) {
                singlePassengerXOffset += 0.2f;
            }
        }
        return new Vec3D(0.0, this.b(dimensions), singlePassengerXOffset).b(-this.dL() * ((float)Math.PI / 180));
    }

    @Override
    public void a(boolean downwards, BlockPosition pos) {
        if (this.dV() instanceof WorldServer) {
            this.aE = true;
            this.aF = downwards;
            if (this.M() == 0) {
                this.m(60);
            }
        }
        if (!this.bm() && this.ae.a(100) == 0) {
            this.dV().a(this.dA(), this.dC(), this.dG(), this.aV(), this.dm(), 1.0f, 0.8f + 0.4f * this.ae.i(), false);
            this.dV().a(Particles.ap, this.dA() + (double)this.ae.i(), this.dC() + 0.7, this.dG() + (double)this.ae.i(), 0.0, 0.0, 0.0);
            this.a(GameEvent.O, (Entity)this.cW());
        }
    }

    @Override
    public void h(Entity entity) {
        if (!this.dV().paperConfig().collisions.allowVehicleCollisions && this.dV().paperConfig().collisions.onlyPlayersCollide && !(entity instanceof EntityHuman)) {
            return;
        }
        if (entity instanceof AbstractBoat) {
            if (entity.cR().b < this.cR().e) {
                VehicleEntityCollisionEvent event;
                if (!this.z(entity) && !(event = new VehicleEntityCollisionEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity())).callEvent()) {
                    return;
                }
                super.h(entity);
            }
        } else if (entity.cR().b <= this.cR().b) {
            VehicleEntityCollisionEvent event;
            if (!this.z(entity) && !(event = new VehicleEntityCollisionEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity())).callEvent()) {
                return;
            }
            super.h(entity);
        }
    }

    @Override
    public void q(float yaw) {
        this.l(-this.I());
        this.d(10);
        this.b(this.G() * 11.0f);
    }

    @Override
    public boolean bF() {
        return !this.dQ();
    }

    @Override
    public InterpolationHandler l_() {
        return this.r;
    }

    @Override
    public EnumDirection cP() {
        return this.cO().h();
    }

    @Override
    public void g() {
        this.aC = this.aB;
        this.aB = this.D();
        this.p = this.aB != EnumStatus.b && this.aB != EnumStatus.c ? 0.0f : (this.p += 1.0f);
        if (!this.dV().C && this.p >= 60.0f) {
            this.bN();
        }
        if (this.H() > 0) {
            this.d(this.H() - 1);
        }
        if (this.G() > 0.0f) {
            this.b(this.G() - 1.0f);
        }
        super.g();
        this.r.e();
        if (this.dg()) {
            if (!(this.cZ() instanceof EntityHuman)) {
                this.a(false, false);
            }
            this.J();
            if (this.dV().C) {
                this.K();
                this.dV().a(new PacketPlayInBoatMove(this.c(0), this.c(1)));
            }
            this.a(EnumMoveType.a, this.dy());
        } else {
            this.i(Vec3D.c);
        }
        Location to = CraftLocation.toBukkit(this.dt(), (org.bukkit.World)this.dV().getWorld(), this.dL(), this.dN());
        Vehicle vehicle = (Vehicle)this.getBukkitEntity();
        new VehicleUpdateEvent(vehicle).callEvent();
        if (this.lastLocation != null && !this.lastLocation.equals((Object)to)) {
            VehicleMoveEvent event = new VehicleMoveEvent(vehicle, this.lastLocation, to);
            event.callEvent();
        }
        this.lastLocation = vehicle.getLocation();
        this.aI();
        this.aI();
        this.C();
        for (int i2 = 0; i2 <= 1; ++i2) {
            if (this.c(i2)) {
                SoundEffect paddleSound;
                if (!this.ba() && this.o[i2] % ((float)Math.PI * 2) <= 0.7853982f && (this.o[i2] + 0.3926991f) % ((float)Math.PI * 2) >= 0.7853982f && (paddleSound = this.f()) != null) {
                    Vec3D viewVector = this.h(1.0f);
                    double d2 = i2 == 1 ? -viewVector.f : viewVector.f;
                    double d1 = i2 == 1 ? viewVector.d : -viewVector.d;
                    this.dV().a(null, this.dA() + d2, this.dC(), this.dG() + d1, paddleSound, this.dm(), 1.0f, 0.8f + 0.4f * this.ae.i());
                }
                this.o[i2] = this.o[i2] + 0.3926991f;
                continue;
            }
            this.o[i2] = 0.0f;
        }
        List<Entity> entities = this.dV().a((Entity)this, this.cR().c(0.2f, -0.01f, 0.2f), IEntitySelector.a(this));
        if (!entities.isEmpty()) {
            boolean flag = !this.dV().C && !(this.cW() instanceof EntityHuman);
            for (Entity entity : entities) {
                if (entity.y(this)) continue;
                if (flag && this.cY().size() < this.n() && !entity.bY() && this.b(entity) && entity instanceof EntityLiving && !(entity instanceof EntityWaterAnimal) && !(entity instanceof EntityHuman) && !(entity instanceof Creaking)) {
                    entity.n(this);
                    continue;
                }
                this.h(entity);
            }
        }
    }

    private void C() {
        if (this.dV().C) {
            int bubbleTime = this.M();
            this.aG = bubbleTime > 0 ? (this.aG += 0.05f) : (this.aG -= 0.1f);
            this.aG = MathHelper.a(this.aG, 0.0f, 1.0f);
            this.aI = this.aH;
            this.aH = 10.0f * (float)Math.sin(0.5 * (double)this.af) * this.aG;
        } else {
            int bubbleTime;
            if (!this.aE) {
                this.m(0);
            }
            if ((bubbleTime = this.M()) > 0) {
                this.m(--bubbleTime);
                int i2 = 60 - bubbleTime - 1;
                if (i2 > 0 && bubbleTime == 0) {
                    this.m(0);
                    Vec3D deltaMovement = this.dy();
                    if (this.aF) {
                        this.i(deltaMovement.b(0.0, -0.7, 0.0));
                        this.bN();
                    } else {
                        this.n(deltaMovement.d, this.a((Entity entity) -> entity instanceof EntityHuman) ? 2.7 : 0.6, deltaMovement.f);
                    }
                }
                this.aE = false;
            }
        }
    }

    @Nullable
    protected SoundEffect f() {
        return switch (this.D().ordinal()) {
            case 0, 1, 2 -> SoundEffects.cm;
            case 3 -> SoundEffects.cl;
            default -> null;
        };
    }

    public void a(boolean left, boolean right) {
        this.al.a(j, left);
        this.al.a(k, right);
    }

    public float a(int side, float partialTick) {
        return this.c(side) ? MathHelper.b(this.o[side] - 0.3926991f, this.o[side], partialTick) : 0.0f;
    }

    @Override
    @Nullable
    public Leashable.a S_() {
        return this.aJ;
    }

    @Override
    public void a(@Nullable Leashable.a leashData) {
        this.aJ = leashData;
    }

    @Override
    public Vec3D cT() {
        return new Vec3D(0.0, 0.88f * this.cS(), this.dq() * 0.64f);
    }

    @Override
    public void b(Entity leashHolder, float distance) {
        Vec3D vec3 = leashHolder.dt().d(this.dt()).d().c((double)distance - 6.0);
        Vec3D deltaMovement = this.dy();
        boolean flag = deltaMovement.b(vec3) > 0.0;
        this.i(deltaMovement.e(vec3.c(flag ? (double)0.15f : (double)0.2f)));
    }

    public EnumStatus D() {
        EnumStatus status = this.F();
        if (status != null) {
            this.az = this.cR().e;
            return status;
        }
        if (this.E()) {
            return EnumStatus.a;
        }
        float groundFriction = this.l();
        if (groundFriction > 0.0f) {
            this.aA = groundFriction;
            return EnumStatus.d;
        }
        return EnumStatus.e;
    }

    public float i() {
        AxisAlignedBB boundingBox = this.cR();
        int floor = MathHelper.a(boundingBox.a);
        int ceil = MathHelper.c(boundingBox.d);
        int floor1 = MathHelper.a(boundingBox.e);
        int ceil1 = MathHelper.c(boundingBox.e - this.aD);
        int floor2 = MathHelper.a(boundingBox.c);
        int ceil2 = MathHelper.c(boundingBox.f);
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        block0: for (int i2 = floor1; i2 < ceil1; ++i2) {
            float f2 = 0.0f;
            for (int i1 = floor; i1 < ceil; ++i1) {
                for (int i22 = floor2; i22 < ceil2; ++i22) {
                    mutableBlockPos.d(i1, i2, i22);
                    Fluid fluidState = this.dV().b_(mutableBlockPos);
                    if (fluidState.a(TagsFluid.a)) {
                        f2 = Math.max(f2, fluidState.a(this.dV(), mutableBlockPos));
                    }
                    if (f2 >= 1.0f) continue block0;
                }
            }
            if (!(f2 < 1.0f)) continue;
            return (float)mutableBlockPos.v() + f2;
        }
        return ceil1 + 1;
    }

    public float l() {
        AxisAlignedBB boundingBox = this.cR();
        AxisAlignedBB aabb = new AxisAlignedBB(boundingBox.a, boundingBox.b - 0.001, boundingBox.c, boundingBox.d, boundingBox.b, boundingBox.f);
        int i2 = MathHelper.a(aabb.a) - 1;
        int i1 = MathHelper.c(aabb.d) + 1;
        int i22 = MathHelper.a(aabb.b) - 1;
        int i3 = MathHelper.c(aabb.e) + 1;
        int i4 = MathHelper.a(aabb.c) - 1;
        int i5 = MathHelper.c(aabb.f) + 1;
        VoxelShape voxelShape = VoxelShapes.a(aabb);
        float f2 = 0.0f;
        int i6 = 0;
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (int i7 = i2; i7 < i1; ++i7) {
            for (int i8 = i4; i8 < i5; ++i8) {
                int i9 = (i7 != i2 && i7 != i1 - 1 ? 0 : 1) + (i8 != i4 && i8 != i5 - 1 ? 0 : 1);
                if (i9 == 2) continue;
                for (int i10 = i22; i10 < i3; ++i10) {
                    if (i9 > 0 && (i10 == i22 || i10 == i3 - 1)) continue;
                    mutableBlockPos.d(i7, i10, i8);
                    IBlockData blockState = this.dV().a_(mutableBlockPos);
                    if (blockState.b() instanceof BlockWaterLily || !VoxelShapes.c(blockState.g(this.dV(), mutableBlockPos).a(mutableBlockPos), voxelShape, OperatorBoolean.i)) continue;
                    f2 += blockState.b().g();
                    ++i6;
                }
            }
        }
        return f2 / (float)i6;
    }

    private boolean E() {
        AxisAlignedBB boundingBox = this.cR();
        int floor = MathHelper.a(boundingBox.a);
        int ceil = MathHelper.c(boundingBox.d);
        int floor1 = MathHelper.a(boundingBox.b);
        int ceil1 = MathHelper.c(boundingBox.b + 0.001);
        int floor2 = MathHelper.a(boundingBox.c);
        int ceil2 = MathHelper.c(boundingBox.f);
        boolean flag = false;
        this.az = -1.7976931348623157E308;
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (int i2 = floor; i2 < ceil; ++i2) {
            for (int i1 = floor1; i1 < ceil1; ++i1) {
                for (int i22 = floor2; i22 < ceil2; ++i22) {
                    mutableBlockPos.d(i2, i1, i22);
                    Fluid fluidState = this.dV().b_(mutableBlockPos);
                    if (!fluidState.a(TagsFluid.a)) continue;
                    float f2 = (float)i1 + fluidState.a(this.dV(), mutableBlockPos);
                    this.az = Math.max((double)f2, this.az);
                    flag |= boundingBox.b < (double)f2;
                }
            }
        }
        return flag;
    }

    @Nullable
    private EnumStatus F() {
        AxisAlignedBB boundingBox = this.cR();
        double d2 = boundingBox.e + 0.001;
        int floor = MathHelper.a(boundingBox.a);
        int ceil = MathHelper.c(boundingBox.d);
        int floor1 = MathHelper.a(boundingBox.e);
        int ceil1 = MathHelper.c(d2);
        int floor2 = MathHelper.a(boundingBox.c);
        int ceil2 = MathHelper.c(boundingBox.f);
        boolean flag = false;
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (int i2 = floor; i2 < ceil; ++i2) {
            for (int i1 = floor1; i1 < ceil1; ++i1) {
                for (int i22 = floor2; i22 < ceil2; ++i22) {
                    mutableBlockPos.d(i2, i1, i22);
                    Fluid fluidState = this.dV().b_(mutableBlockPos);
                    if (!fluidState.a(TagsFluid.a) || !(d2 < (double)((float)mutableBlockPos.v() + fluidState.a(this.dV(), mutableBlockPos)))) continue;
                    if (!fluidState.b()) {
                        return EnumStatus.c;
                    }
                    flag = true;
                }
            }
        }
        return flag ? EnumStatus.b : null;
    }

    @Override
    protected double bc() {
        return 0.04;
    }

    private void J() {
        double d2 = -this.bd();
        double d1 = 0.0;
        float f2 = 0.05f;
        if (this.aC == EnumStatus.e && this.aB != EnumStatus.e && this.aB != EnumStatus.d) {
            this.az = this.e(1.0);
            double d22 = (double)(this.i() - this.dr()) + 0.101;
            if (this.dV().a((Entity)this, this.cR().d(0.0, d22 - this.dC(), 0.0))) {
                this.a(EnumMoveType.a, new Vec3D(0.0, d22 - this.dC(), 0.0));
                this.i(this.dy().d(1.0, 0.0, 1.0));
                this.aD = 0.0;
            }
            this.aB = EnumStatus.a;
        } else {
            if (this.aB == EnumStatus.a) {
                d1 = (this.az - this.dC()) / (double)this.dr();
                f2 = 0.9f;
            } else if (this.aB == EnumStatus.c) {
                d2 = -7.0E-4;
                f2 = 0.9f;
            } else if (this.aB == EnumStatus.b) {
                d1 = 0.01f;
                f2 = 0.45f;
            } else if (this.aB == EnumStatus.e) {
                f2 = 0.9f;
            } else if (this.aB == EnumStatus.d) {
                f2 = this.aA;
                if (this.cW() instanceof EntityHuman) {
                    this.aA /= 2.0f;
                }
            }
            Vec3D deltaMovement = this.dy();
            this.n(deltaMovement.d * (double)f2, deltaMovement.e + d2, deltaMovement.f * (double)f2);
            this.q *= f2;
            if (d1 > 0.0) {
                Vec3D deltaMovement1 = this.dy();
                this.n(deltaMovement1.d, (deltaMovement1.e + d1 * (this.bc() / 0.65)) * 0.75, deltaMovement1.f);
            }
        }
    }

    private void K() {
        if (this.bZ()) {
            float f2 = 0.0f;
            if (this.s) {
                this.q -= 1.0f;
            }
            if (this.t) {
                this.q += 1.0f;
            }
            if (this.t != this.s && !this.u && !this.ay) {
                f2 += 0.005f;
            }
            this.w(this.dL() + this.q);
            if (this.u) {
                f2 += 0.04f;
            }
            if (this.ay) {
                f2 -= 0.005f;
            }
            this.i(this.dy().b(MathHelper.a(-this.dL() * ((float)Math.PI / 180)) * f2, 0.0, MathHelper.b(this.dL() * ((float)Math.PI / 180)) * f2));
            this.a(this.t && !this.s || this.u, this.s && !this.t || this.u);
        }
    }

    protected float m() {
        return 0.0f;
    }

    public boolean b(Entity entity) {
        return entity.dq() < this.dq();
    }

    @Override
    protected void a(Entity passenger, Entity.MoveFunction callback) {
        super.a(passenger, callback);
        if (!passenger.an().a(TagsEntity.s)) {
            passenger.w(passenger.dL() + this.q);
            passenger.r(passenger.cA() + this.q);
            this.c(passenger);
            if (passenger instanceof EntityAnimal && this.cY().size() == this.n()) {
                int i2 = passenger.ao() % 2 == 0 ? 90 : 270;
                passenger.s(((EntityAnimal)passenger).aV + (float)i2);
                passenger.r(passenger.cA() + (float)i2);
            }
        }
    }

    @Override
    public Vec3D b(EntityLiving passenger) {
        Vec3D collisionHorizontalEscapeVector = AbstractBoat.a(this.dq() * MathHelper.g, (double)passenger.dq(), passenger.dL());
        double d2 = this.dA() + collisionHorizontalEscapeVector.d;
        double d1 = this.dG() + collisionHorizontalEscapeVector.f;
        BlockPosition blockPos = BlockPosition.a(d2, this.cR().e, d1);
        BlockPosition blockPos1 = blockPos.e();
        if (!this.dV().A(blockPos1)) {
            double blockFloorHeight1;
            ArrayList list = Lists.newArrayList();
            double blockFloorHeight = this.dV().j(blockPos);
            if (DismountUtil.a(blockFloorHeight)) {
                list.add(new Vec3D(d2, (double)blockPos.v() + blockFloorHeight, d1));
            }
            if (DismountUtil.a(blockFloorHeight1 = this.dV().j(blockPos1))) {
                list.add(new Vec3D(d2, (double)blockPos1.v() + blockFloorHeight1, d1));
            }
            for (EntityPose pose : passenger.fO()) {
                for (Vec3D vec3 : list) {
                    if (!DismountUtil.a(this.dV(), vec3, passenger, pose)) continue;
                    passenger.b(pose);
                    return vec3;
                }
            }
        }
        return super.b(passenger);
    }

    protected void c(Entity entity) {
        entity.s(this.dL());
        float f2 = MathHelper.h(entity.dL() - this.dL());
        float f1 = MathHelper.a(f2, -105.0f, 105.0f);
        entity.N += f1 - f2;
        entity.w(entity.dL() + f1 - f2);
        entity.r(entity.dL());
    }

    @Override
    public void k(Entity entityToUpdate) {
        this.c(entityToUpdate);
    }

    @Override
    protected void b(NBTTagCompound tag) {
        this.a(tag, this.aJ);
    }

    @Override
    protected void a(NBTTagCompound tag) {
        this.c(tag);
    }

    @Override
    public EnumInteractionResult a(EntityHuman player, EnumHand hand) {
        EnumInteractionResult interactionResult = super.a(player, hand);
        if (interactionResult != EnumInteractionResult.e) {
            return interactionResult;
        }
        return (EnumInteractionResult)((Object)(player.fY() || !(this.p < 60.0f) || !this.dV().C && !player.n(this) ? EnumInteractionResult.e : EnumInteractionResult.a));
    }

    @Override
    public void remove(Entity.RemovalReason reason, @Nullable EntityRemoveEvent.Cause eventCause) {
        if (!this.dV().C && reason.a() && this.Q_()) {
            this.x();
        }
        super.remove(reason, eventCause);
    }

    @Override
    protected void a(double y2, boolean onGround, IBlockData state, BlockPosition pos) {
        this.aD = this.dy().e;
        if (!this.bY()) {
            if (onGround) {
                this.j();
            } else if (!this.dV().b_(this.dv().e()).a(TagsFluid.a) && y2 < 0.0) {
                this.Z -= (double)((float)y2);
            }
        }
    }

    public boolean c(int side) {
        return this.al.a(side == 0 ? j : k) != false && this.cW() != null;
    }

    private void m(int bubbleTime) {
        this.al.a(l, bubbleTime);
    }

    private int M() {
        return this.al.a(l);
    }

    public float a(float partialTick) {
        return MathHelper.h(partialTick, this.aI, this.aH);
    }

    @Override
    protected boolean r(Entity passenger) {
        return this.cY().size() < this.n() && !this.a(TagsFluid.a);
    }

    protected int n() {
        return 2;
    }

    @Override
    @Nullable
    public EntityLiving cW() {
        EntityLiving livingEntity;
        Entity entity = this.cZ();
        return entity instanceof EntityLiving ? (livingEntity = (EntityLiving)entity) : super.cW();
    }

    public void a(boolean left, boolean right, boolean up, boolean down) {
        this.s = left;
        this.t = right;
        this.u = up;
        this.ay = down;
    }

    @Override
    public boolean bm() {
        return this.aB == EnumStatus.b || this.aB == EnumStatus.c;
    }

    @Override
    public final Item p() {
        return this.aK.get();
    }

    @Override
    public final ItemStack dI() {
        return new ItemStack(this.aK.get());
    }

    public static final class EnumStatus
    extends Enum<EnumStatus> {
        public static final /* enum */ EnumStatus a = new EnumStatus();
        public static final /* enum */ EnumStatus b = new EnumStatus();
        public static final /* enum */ EnumStatus c = new EnumStatus();
        public static final /* enum */ EnumStatus d = new EnumStatus();
        public static final /* enum */ EnumStatus e = new EnumStatus();
        private static final /* synthetic */ EnumStatus[] f;

        public static EnumStatus[] values() {
            return (EnumStatus[])f.clone();
        }

        public static EnumStatus valueOf(String name) {
            return Enum.valueOf(EnumStatus.class, name);
        }

        private static /* synthetic */ EnumStatus[] a() {
            return new EnumStatus[]{a, b, c, d, e};
        }

        static {
            f = EnumStatus.a();
        }
    }
}

