/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import com.destroystokyo.paper.loottable.PaperLootableInventoryData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerChest;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootTable;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftHumanEntity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.inventory.InventoryHolder;

public abstract class AbstractChestBoat
extends AbstractBoat
implements HasCustomInventoryScreen,
ContainerEntity {
    private static final int j = 27;
    private NonNullList<ItemStack> k = NonNullList.a(27, ItemStack.l);
    @Nullable
    private ResourceKey<LootTable> l;
    private long m;
    final PaperLootableInventoryData lootableData = new PaperLootableInventoryData();
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 99;

    public AbstractChestBoat(EntityTypes<? extends AbstractChestBoat> entityType, World level, Supplier<Item> dropItem) {
        super(entityType, level, dropItem);
    }

    @Override
    protected float m() {
        return 0.15f;
    }

    @Override
    protected int n() {
        return 1;
    }

    @Override
    protected void b(NBTTagCompound tag) {
        super.b(tag);
        this.a(tag, this.dX());
    }

    @Override
    protected void a(NBTTagCompound tag) {
        super.a(tag);
        this.b(tag, this.dX());
    }

    @Override
    public void a(WorldServer level, DamageSource damageSource) {
        this.a(level, this.p());
        this.a(damageSource, level, this);
    }

    @Override
    public void remove(Entity.RemovalReason reason, @Nullable EntityRemoveEvent.Cause cause) {
        if (!this.dV().C && reason.a()) {
            InventoryUtils.a(this.dV(), this, (IInventory)this);
        }
        super.remove(reason, cause);
    }

    @Override
    public EnumInteractionResult a(EntityHuman player, EnumHand hand) {
        World world;
        EnumInteractionResult interactionResult;
        if (!player.fY() && (interactionResult = super.a(player, hand)) != EnumInteractionResult.e) {
            return interactionResult;
        }
        if (this.r(player) && !player.fY()) {
            return EnumInteractionResult.e;
        }
        interactionResult = this.b_(player);
        if (interactionResult.a() && (world = player.dV()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            this.a(GameEvent.k, (Entity)player);
            PiglinAI.a(serverLevel, player, true);
        }
        return interactionResult;
    }

    @Override
    public void b(EntityHuman player) {
        World world = player.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (player.a(this).isPresent()) {
                this.a(GameEvent.k, (Entity)player);
                PiglinAI.a(serverLevel, player, true);
            }
        }
    }

    @Override
    public void a() {
        this.ah_();
    }

    @Override
    public int b() {
        return 27;
    }

    @Override
    public ItemStack a(int slot) {
        return this.g_(slot);
    }

    @Override
    public ItemStack a(int slot, int amount) {
        return this.b(slot, amount);
    }

    @Override
    public ItemStack b(int slot) {
        return this.f_(slot);
    }

    @Override
    public void a(int slot, ItemStack stack) {
        this.c(slot, stack);
    }

    @Override
    public SlotAccess a_(int slot) {
        return this.h_(slot);
    }

    @Override
    public void e() {
    }

    @Override
    public boolean a(EntityHuman player) {
        return this.g(player);
    }

    @Override
    @Nullable
    public Container createMenu(int containerId, PlayerInventory playerInventory, EntityHuman player) {
        if (this.l != null && player.ak()) {
            return null;
        }
        this.e(playerInventory.h);
        return ContainerChest.a(containerId, playerInventory, this);
    }

    public void e(@Nullable EntityHuman player) {
        this.f(player);
    }

    @Override
    @Nullable
    public ResourceKey<LootTable> r() {
        return this.l;
    }

    @Override
    public void a(@Nullable ResourceKey<LootTable> lootTable) {
        this.l = lootTable;
    }

    @Override
    public long s() {
        return this.m;
    }

    @Override
    public void a(long lootTableSeed) {
        this.m = lootTableSeed;
    }

    @Override
    public NonNullList<ItemStack> t() {
        return this.k;
    }

    @Override
    public void u() {
        this.k = NonNullList.a(this.b(), ItemStack.l);
    }

    @Override
    public void c(EntityHuman player) {
        this.dV().a(GameEvent.j, this.dt(), GameEvent.a.a(player));
    }

    @Override
    public PaperLootableInventoryData lootableData() {
        return this.lootableData;
    }

    @Override
    public List<ItemStack> getContents() {
        return this.k;
    }

    @Override
    public void onOpen(CraftHumanEntity player) {
        this.transaction.add(player);
    }

    @Override
    public void onClose(CraftHumanEntity player) {
        this.transaction.remove(player);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    @Nullable
    public InventoryHolder getOwner() {
        InventoryHolder inventoryHolder;
        CraftEntity entity = this.getBukkitEntity();
        return entity instanceof InventoryHolder ? (inventoryHolder = (InventoryHolder)entity) : null;
    }

    @Override
    public int ak_() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    @Override
    public Location getLocation() {
        return this.getBukkitEntity().getLocation();
    }
}

