/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;

public class EntityMinecartTNT
extends EntityMinecartAbstract {
    private static final byte b = 10;
    private static final String c = "explosion_power";
    private static final String d = "explosion_speed_factor";
    private static final String h = "fuse";
    private static final float i = 4.0f;
    private static final float j = 1.0f;
    private static final int k = -1;
    @Nullable
    private DamageSource l;
    public int m = -1;
    public float n = 4.0f;
    public float o = 1.0f;
    public boolean isIncendiary = false;

    public EntityMinecartTNT(EntityTypes<? extends EntityMinecartTNT> entityType, World level) {
        super(entityType, level);
    }

    @Override
    public IBlockData v() {
        return Blocks.cu.m();
    }

    @Override
    public void g() {
        double d2;
        super.g();
        if (this.m > 0) {
            if (this.dV().paperConfig().fixes.tntEntityHeightNerf.test(v2 -> this.dC() > (double)v2)) {
                this.discard(EntityRemoveEvent.Cause.OUT_OF_WORLD);
                return;
            }
            --this.m;
            this.dV().a(Particles.ah, this.dA(), this.dC() + 0.5, this.dG(), 0.0, 0.0, 0.0);
        } else if (this.m == 0) {
            this.a(this.l, this.dy().j());
        }
        if (this.P && (d2 = this.dy().j()) >= (double)0.01f) {
            this.h(d2);
        }
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        EntityArrow abstractArrow;
        Entity entity = damageSource.c();
        if (entity instanceof EntityArrow && (abstractArrow = (EntityArrow)entity).bX()) {
            DamageSource damageSource1 = this.dW().d(this, damageSource.d());
            this.a(damageSource1, abstractArrow.dy().h());
        }
        return super.a(level, damageSource, amount);
    }

    @Override
    public void a(WorldServer level, DamageSource damageSource) {
        double d2 = this.dy().j();
        if (!EntityMinecartTNT.f(damageSource) && !(d2 >= (double)0.01f)) {
            this.a(level, this.p());
        } else if (this.m < 0) {
            this.a(damageSource);
            this.m = this.ae.a(20) + this.ae.a(20);
        }
    }

    @Override
    public Item p() {
        return Items.oy;
    }

    @Override
    public ItemStack dI() {
        return new ItemStack(Items.oy);
    }

    public void h(double radiusModifier) {
        this.a((DamageSource)null, radiusModifier);
    }

    protected void a(@Nullable DamageSource damageSource, double radiusModifier) {
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (serverLevel.O().c(GameRules.ad)) {
                double min = Math.min(Math.sqrt(radiusModifier), 5.0);
                ExplosionPrimeEvent event = new ExplosionPrimeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (float)((double)this.n + (double)this.o * this.ae.j() * 1.5 * min), this.isIncendiary);
                if (!event.callEvent()) {
                    this.m = -1;
                    return;
                }
                serverLevel.a((Entity)this, damageSource, null, this.dA(), this.dC(), this.dG(), event.getRadius(), event.getFire(), World.a.d);
                this.discard(EntityRemoveEvent.Cause.EXPLODE);
            } else if (this.r()) {
                this.discard(null);
            }
        }
    }

    @Override
    public boolean a(double fallDistance, float damageMultiplier, DamageSource damageSource) {
        if (fallDistance >= 3.0) {
            double d2 = fallDistance / 10.0;
            this.h(d2 * d2);
        }
        return super.a(fallDistance, damageMultiplier, damageSource);
    }

    @Override
    public void a(int x2, int y2, int z2, boolean receivingPower) {
        if (receivingPower && this.m < 0) {
            this.a((DamageSource)null);
        }
    }

    @Override
    public void b(byte id) {
        if (id == 10) {
            this.a((DamageSource)null);
        } else {
            super.b(id);
        }
    }

    public void a(@Nullable DamageSource damageSource) {
        WorldServer serverLevel;
        World world = this.dV();
        if (!(world instanceof WorldServer) || (serverLevel = (WorldServer)world).O().c(GameRules.ad)) {
            this.m = 80;
            if (!this.dV().C) {
                if (damageSource != null && this.l == null) {
                    this.l = this.dW().d(this, damageSource.d());
                }
                this.dV().a((Entity)this, (byte)10);
                if (!this.ba()) {
                    this.dV().a(null, this.dA(), this.dC(), this.dG(), SoundEffects.AC, SoundCategory.e, 1.0f, 1.0f);
                }
            }
        }
    }

    public int e() {
        return this.m;
    }

    public boolean r() {
        return this.m > -1;
    }

    @Override
    public float a(Explosion explosion, IBlockAccess level, BlockPosition pos, IBlockData blockState, Fluid fluidState, float explosionPower) {
        return !this.r() || !blockState.a(TagsBlock.P) && !level.a_(pos.d()).a(TagsBlock.P) ? super.a(explosion, level, pos, blockState, fluidState, explosionPower) : 0.0f;
    }

    @Override
    public boolean a(Explosion explosion, IBlockAccess level, BlockPosition pos, IBlockData blockState, float explosionPower) {
        return (!this.r() || !blockState.a(TagsBlock.P) && !level.a_(pos.d()).a(TagsBlock.P)) && super.a(explosion, level, pos, blockState, explosionPower);
    }

    @Override
    protected void a(NBTTagCompound compound) {
        super.a(compound);
        this.m = compound.b(h, -1);
        this.n = MathHelper.a(compound.b(c, 4.0f), 0.0f, 128.0f);
        this.o = MathHelper.a(compound.b(d, 1.0f), 0.0f, 128.0f);
    }

    @Override
    protected void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a(h, this.m);
        if (this.n != 4.0f) {
            compound.a(c, this.n);
        }
        if (this.o != 1.0f) {
            compound.a(d, this.o);
        }
    }

    @Override
    boolean e(DamageSource source) {
        return EntityMinecartTNT.f(source);
    }

    private static boolean f(DamageSource source) {
        boolean bl;
        Entity entity = source.c();
        if (entity instanceof IProjectile) {
            IProjectile projectile = (IProjectile)entity;
            bl = projectile.bX();
        } else {
            bl = source.a(DamageTypeTags.i) || source.a(DamageTypeTags.l);
        }
        return bl;
    }
}

