/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.food;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateHealth;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.food.FoodConstants;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;

public class FoodMetaData {
    private static final int a = 0;
    private static final float b = 0.0f;
    public int c = 20;
    public float d = 5.0f;
    public float e;
    private int f;
    public int saturatedRegenRate = 10;
    public int unsaturatedRegenRate = 80;
    public int starvationRate = 80;

    private void b(int foodLevel, float saturationLevel) {
        this.c = MathHelper.a(foodLevel + this.c, 0, 20);
        this.d = MathHelper.a(saturationLevel + this.d, 0.0f, (float)this.c);
    }

    public void a(int foodLevelModifier, float saturationLevelModifier) {
        this.b(foodLevelModifier, FoodConstants.a(foodLevelModifier, saturationLevelModifier));
    }

    public void a(FoodInfo foodProperties) {
        this.b(foodProperties.a(), foodProperties.b());
    }

    public void eat(FoodInfo foodProperties, ItemStack stack, EntityPlayer serverPlayer) {
        int oldFoodLevel = this.c;
        FoodLevelChangeEvent event = CraftEventFactory.callFoodLevelChangeEvent(serverPlayer, foodProperties.a() + oldFoodLevel, stack);
        if (!event.isCancelled()) {
            this.b(event.getFoodLevel() - oldFoodLevel, foodProperties.b());
        }
        serverPlayer.getBukkitEntity().sendHealthUpdate();
    }

    public void a(EntityPlayer player) {
        boolean _boolean;
        WorldServer serverLevel = player.x();
        EnumDifficulty difficulty = serverLevel.an();
        if (this.e > 4.0f) {
            this.e -= 4.0f;
            if (this.d > 0.0f) {
                this.d = Math.max(this.d - 1.0f, 0.0f);
            } else if (difficulty != EnumDifficulty.a) {
                FoodLevelChangeEvent event = CraftEventFactory.callFoodLevelChangeEvent(player, Math.max(this.c - 1, 0));
                if (!event.isCancelled()) {
                    this.c = event.getFoodLevel();
                }
                player.f.b(new PacketPlayOutUpdateHealth(player.getBukkitEntity().getScaledHealth(), this.c, this.d));
            }
        }
        if ((_boolean = serverLevel.O().c(GameRules.l)) && this.d > 0.0f && player.gv() && this.c >= 20) {
            ++this.f;
            if (this.f >= this.saturatedRegenRate) {
                float min = Math.min(this.d, 6.0f);
                player.heal(min / 6.0f, EntityRegainHealthEvent.RegainReason.SATIATED, true);
                player.causeFoodExhaustion(min, EntityExhaustionEvent.ExhaustionReason.REGEN);
                this.f = 0;
            }
        } else if (_boolean && this.c >= 18 && player.gv()) {
            ++this.f;
            if (this.f >= this.unsaturatedRegenRate) {
                player.heal(1.0f, EntityRegainHealthEvent.RegainReason.SATIATED);
                player.causeFoodExhaustion(player.dV().spigotConfig.regenExhaustion, EntityExhaustionEvent.ExhaustionReason.REGEN);
                this.f = 0;
            }
        } else if (this.c <= 0) {
            ++this.f;
            if (this.f >= this.starvationRate) {
                if (player.eG() > 10.0f || difficulty == EnumDifficulty.d || player.eG() > 1.0f && difficulty == EnumDifficulty.c) {
                    player.a(serverLevel, player.dW().j(), 1.0f);
                }
                this.f = 0;
            }
        } else {
            this.f = 0;
        }
    }

    public void a(NBTTagCompound compoundTag) {
        this.c = compoundTag.b("foodLevel", 20);
        this.f = compoundTag.b("foodTickTimer", 0);
        this.d = compoundTag.b("foodSaturationLevel", 5.0f);
        this.e = compoundTag.b("foodExhaustionLevel", 0.0f);
    }

    public void b(NBTTagCompound compoundTag) {
        compoundTag.a("foodLevel", this.c);
        compoundTag.a("foodTickTimer", this.f);
        compoundTag.a("foodSaturationLevel", this.d);
        compoundTag.a("foodExhaustionLevel", this.e);
    }

    public int a() {
        return this.c;
    }

    public boolean b() {
        return this.c < 20;
    }

    public void a(float exhaustion) {
        this.e = Math.min(this.e + exhaustion, 40.0f);
    }

    public float c() {
        return this.d;
    }

    public void a(int foodLevel) {
        this.c = foodLevel;
    }

    public void b(float saturationLevel) {
        this.d = saturationLevel;
    }
}

