/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.level.World;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftBlockInventoryHolder;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftLocation;
import org.bukkit.inventory.BlockInventoryHolder;
import org.jetbrains.annotations.Nullable;

public interface ContainerAccess {
    public static final ContainerAccess a = new ContainerAccess(){

        @Override
        public <T> Optional<T> a(BiFunction<World, BlockPosition, T> levelPosConsumer) {
            return Optional.empty();
        }

        @Override
        public Location getLocation() {
            return null;
        }
    };

    public static ContainerAccess a(final World level, final BlockPosition pos) {
        return new ContainerAccess(){

            @Override
            public <T> Optional<T> a(BiFunction<World, BlockPosition, T> levelPosConsumer) {
                return Optional.of(levelPosConsumer.apply(level, pos));
            }

            @Override
            public World getWorld() {
                return level;
            }

            @Override
            public BlockPosition getPosition() {
                return pos;
            }

            @Override
            public boolean isBlock() {
                return true;
            }
        };
    }

    public <T> Optional<T> a(BiFunction<World, BlockPosition, T> var1);

    default public <T> T a(BiFunction<World, BlockPosition, T> levelPosConsumer, T defaultValue) {
        return this.a(levelPosConsumer).orElse(defaultValue);
    }

    default public void a(BiConsumer<World, BlockPosition> levelPosConsumer) {
        this.a((World level, BlockPosition pos) -> {
            levelPosConsumer.accept((World)level, (BlockPosition)pos);
            return Optional.empty();
        });
    }

    default public World getWorld() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    default public BlockPosition getPosition() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    default public Location getLocation() {
        return CraftLocation.toBukkit(this.getPosition(), this.getWorld());
    }

    default public boolean isBlock() {
        return false;
    }

    default public @Nullable BlockInventoryHolder createBlockHolder(Container menu) {
        if (!this.isBlock()) {
            return null;
        }
        return new CraftBlockInventoryHolder(this, menu.getBukkitView().getTopInventory());
    }
}

