/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerProperty;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.WeightedRandomEnchant;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockEnchantmentTable;
import net.minecraft.world.level.block.Blocks;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R4.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftInventoryEnchanting;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R4.inventory.view.CraftEnchantmentView;
import org.bukkit.enchantments.EnchantmentOffer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.enchantment.PrepareItemEnchantEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.view.EnchantmentView;

public class ContainerEnchantTable
extends Container {
    static final MinecraftKey p = MinecraftKey.b("container/slot/lapis_lazuli");
    private final IInventory q;
    private final ContainerAccess r;
    private final RandomSource s = RandomSource.a();
    private final ContainerProperty t = ContainerProperty.a();
    public final int[] m = new int[3];
    public final int[] n = new int[]{-1, -1, -1};
    public final int[] o = new int[]{-1, -1, -1};
    @Nullable
    private CraftEnchantmentView view = null;
    private final Player player;

    public ContainerEnchantTable(int containerId, PlayerInventory playerInventory) {
        this(containerId, playerInventory, ContainerAccess.a);
    }

    public ContainerEnchantTable(int containerId, PlayerInventory playerInventory, final ContainerAccess access) {
        super(Containers.n, containerId);
        this.q = new InventorySubcontainer(this.createBlockHolder(access), 2){

            @Override
            public void e() {
                super.e();
                ContainerEnchantTable.this.a(this);
            }

            @Override
            public Location getLocation() {
                return access.getLocation();
            }
        };
        this.r = access;
        this.a(new Slot(this, this.q, 0, 15, 47){

            @Override
            public int a() {
                return 1;
            }
        });
        this.a(new Slot(this, this.q, 1, 35, 47){

            @Override
            public boolean a(net.minecraft.world.item.ItemStack stack) {
                return stack.a(Items.pp);
            }

            @Override
            public MinecraftKey c() {
                return p;
            }
        });
        this.c(playerInventory, 8, 84);
        this.a(ContainerProperty.a(this.m, 0));
        this.a(ContainerProperty.a(this.m, 1));
        this.a(ContainerProperty.a(this.m, 2));
        this.a(this.t).a(playerInventory.h.gs());
        this.a(ContainerProperty.a(this.n, 0));
        this.a(ContainerProperty.a(this.n, 1));
        this.a(ContainerProperty.a(this.n, 2));
        this.a(ContainerProperty.a(this.o, 0));
        this.a(ContainerProperty.a(this.o, 1));
        this.a(ContainerProperty.a(this.o, 2));
        this.player = (Player)playerInventory.h.getBukkitEntity();
    }

    @Override
    public void a(IInventory inventory) {
        if (inventory == this.q) {
            net.minecraft.world.item.ItemStack item = inventory.a(0);
            if (!item.f()) {
                this.r.a((World level, BlockPosition blockPos) -> {
                    Registry<Holder<Enchantment>> holderIdMap = level.J_().f(Registries.aR).t();
                    int i1 = 0;
                    for (BlockPosition blockPos1 : BlockEnchantmentTable.b) {
                        if (!BlockEnchantmentTable.a(level, blockPos, blockPos1)) continue;
                        ++i1;
                    }
                    this.s.b((long)this.t.b());
                    for (int i2 = 0; i2 < 3; ++i2) {
                        this.m[i2] = EnchantmentManager.a(this.s, i2, i1, item);
                        this.n[i2] = -1;
                        this.o[i2] = -1;
                        if (this.m[i2] >= i2 + 1) continue;
                        this.m[i2] = 0;
                    }
                    for (int i2x = 0; i2x < 3; ++i2x) {
                        List<WeightedRandomEnchant> enchantmentList;
                        if (this.m[i2x] <= 0 || (enchantmentList = this.a(level.J_(), item, i2x, this.m[i2x])) == null || enchantmentList.isEmpty()) continue;
                        WeightedRandomEnchant enchantmentInstance = enchantmentList.get(this.s.a(enchantmentList.size()));
                        this.n[i2x] = holderIdMap.a(enchantmentInstance.b());
                        this.o[i2x] = enchantmentInstance.c();
                    }
                    CraftItemStack craftItemStack = CraftItemStack.asCraftMirror(item);
                    EnchantmentOffer[] offers = new EnchantmentOffer[3];
                    for (int j2 = 0; j2 < 3; ++j2) {
                        org.bukkit.enchantments.Enchantment enchantment = this.n[j2] >= 0 ? CraftEnchantment.minecraftHolderToBukkit(holderIdMap.a(this.n[j2])) : null;
                        offers[j2] = enchantment != null ? new EnchantmentOffer(enchantment, this.o[j2], this.m[j2]) : null;
                    }
                    PrepareItemEnchantEvent event = new PrepareItemEnchantEvent(this.player, (EnchantmentView)this.getBukkitView(), this.r.getLocation().getBlock(), (ItemStack)craftItemStack, offers, i1);
                    event.setCancelled(!item.E());
                    level.getCraftServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        for (int j3 = 0; j3 < 3; ++j3) {
                            this.m[j3] = 0;
                            this.n[j3] = -1;
                            this.o[j3] = -1;
                        }
                        return;
                    }
                    for (int j4 = 0; j4 < 3; ++j4) {
                        EnchantmentOffer offer = event.getOffers()[j4];
                        if (offer != null) {
                            this.m[j4] = offer.getCost();
                            this.n[j4] = holderIdMap.a(CraftEnchantment.bukkitToMinecraftHolder(offer.getEnchantment()));
                            this.o[j4] = offer.getEnchantmentLevel();
                            continue;
                        }
                        if (this.n[j4] != -1) {
                            this.m[j4] = 0;
                        }
                        this.n[j4] = -1;
                        this.o[j4] = -1;
                    }
                    this.d();
                });
            } else {
                for (int i2 = 0; i2 < 3; ++i2) {
                    this.m[i2] = 0;
                    this.n[i2] = -1;
                    this.o[i2] = -1;
                }
            }
        }
    }

    @Override
    public boolean a(EntityHuman player, int id) {
        if (id >= 0 && id < this.m.length) {
            net.minecraft.world.item.ItemStack item = this.q.a(0);
            net.minecraft.world.item.ItemStack item1 = this.q.a(1);
            int i2 = id + 1;
            if ((item1.f() || item1.M() < i2) && !player.fV()) {
                return false;
            }
            if (this.m[id] <= 0 || item.f() || (player.cf < i2 || player.cf < this.m[id]) && !player.fV()) {
                return false;
            }
            this.r.a((World level, BlockPosition blockPos) -> {
                net.minecraft.world.item.ItemStack itemStack = item;
                List<WeightedRandomEnchant> enchantmentList = this.a(level.J_(), item, id, this.m[id]);
                Registry<Holder<Enchantment>> registry = level.J_().f(Registries.aR).t();
                HashMap<org.bukkit.enchantments.Enchantment, Integer> enchants = new HashMap<org.bukkit.enchantments.Enchantment, Integer>();
                for (WeightedRandomEnchant instance : enchantmentList) {
                    enchants.put(CraftEnchantment.minecraftHolderToBukkit(instance.b()), instance.c());
                }
                CraftItemStack craftItemStack = CraftItemStack.asCraftMirror(itemStack);
                Holder<Enchantment> holder = registry.a(this.n[id]);
                if (holder == null) {
                    return;
                }
                org.bukkit.enchantments.Enchantment hintedEnchantment = CraftEnchantment.minecraftHolderToBukkit(holder);
                int hintedEnchantmentLevel = this.o[id];
                EnchantItemEvent event = new EnchantItemEvent((Player)player.getBukkitEntity(), (InventoryView)this.getBukkitView(), this.r.getLocation().getBlock(), (ItemStack)craftItemStack, this.m[id], enchants, hintedEnchantment, hintedEnchantmentLevel, id);
                level.getCraftServer().getPluginManager().callEvent((Event)event);
                int itemLevel = event.getExpLevelCost();
                if (event.isCancelled() || itemLevel > player.cf && !player.gk().d || event.getEnchantsToAdd().isEmpty()) {
                    return;
                }
                itemStack = CraftItemStack.getOrCloneOnMutation(craftItemStack, event.getItem());
                if (itemStack != item) {
                    this.q.a(0, itemStack);
                }
                if (itemStack.a(Items.rF)) {
                    itemStack = itemStack.a((IMaterial)Items.vG);
                    this.q.a(0, itemStack);
                }
                for (Map.Entry entry : event.getEnchantsToAdd().entrySet()) {
                    Holder<Enchantment> enchant = CraftEnchantment.bukkitToMinecraftHolder((org.bukkit.enchantments.Enchantment)entry.getKey());
                    if (enchant == null) continue;
                    itemStack.a(enchant, (int)((Integer)entry.getValue()));
                }
                player.a(item, i2);
                item1.a(i2, (EntityLiving)player);
                if (item1.f()) {
                    this.q.a(1, net.minecraft.world.item.ItemStack.l);
                }
                player.a(StatisticList.ak);
                if (player instanceof EntityPlayer) {
                    CriterionTriggers.j.a((EntityPlayer)player, itemStack, i2);
                }
                this.q.e();
                this.t.a(player.gs());
                this.a(this.q);
                level.a(null, (BlockPosition)blockPos, SoundEffects.iv, SoundCategory.e, 1.0f, level.A.i() * 0.1f + 0.9f);
            });
            return true;
        }
        SystemUtils.b(String.valueOf(player.ah()) + " pressed invalid button id: " + id);
        return false;
    }

    private List<WeightedRandomEnchant> a(IRegistryCustom registryAccess, net.minecraft.world.item.ItemStack stack, int slot, int cost) {
        this.s.b((long)(this.t.b() + slot));
        Optional optional = registryAccess.f(Registries.aR).a(EnchantmentTags.k);
        if (optional.isEmpty()) {
            return List.of();
        }
        List<WeightedRandomEnchant> list = EnchantmentManager.b(this.s, stack, cost, ((HolderSet.Named)optional.get()).a());
        if (stack.a(Items.rF) && list.size() > 1) {
            list.remove(this.s.a(list.size()));
        }
        return list;
    }

    public int l() {
        net.minecraft.world.item.ItemStack item = this.q.a(1);
        return item.f() ? 0 : item.M();
    }

    public void setEnchantmentSeed(int seed) {
        this.t.a(seed);
    }

    public int m() {
        return this.t.b();
    }

    @Override
    public void a(EntityHuman player) {
        super.a(player);
        this.r.a((World level, BlockPosition blockPos) -> this.a(player, this.q));
    }

    @Override
    public boolean b(EntityHuman player) {
        if (!this.checkReachable) {
            return true;
        }
        return ContainerEnchantTable.a(this.r, player, Blocks.fQ);
    }

    @Override
    public net.minecraft.world.item.ItemStack b(EntityHuman player, int index) {
        net.minecraft.world.item.ItemStack itemStack = net.minecraft.world.item.ItemStack.l;
        Slot slot = this.k.get(index);
        if (slot != null && slot.h()) {
            net.minecraft.world.item.ItemStack item = slot.g();
            itemStack = item.v();
            if (index == 0) {
                if (!this.a(item, 2, 38, true)) {
                    return net.minecraft.world.item.ItemStack.l;
                }
            } else if (index == 1) {
                if (!this.a(item, 2, 38, true)) {
                    return net.minecraft.world.item.ItemStack.l;
                }
            } else if (item.a(Items.pp)) {
                if (!this.a(item, 1, 2, true)) {
                    return net.minecraft.world.item.ItemStack.l;
                }
            } else {
                if (this.k.get(0).h() || !this.k.get(0).a(item)) {
                    return net.minecraft.world.item.ItemStack.l;
                }
                net.minecraft.world.item.ItemStack itemStack1 = item.c(1);
                item.h(1);
                this.k.get(0).e(itemStack1);
            }
            if (item.f()) {
                slot.e(net.minecraft.world.item.ItemStack.l);
            } else {
                slot.d();
            }
            if (item.M() == itemStack.M()) {
                return net.minecraft.world.item.ItemStack.l;
            }
            slot.a(player, item);
        }
        return itemStack;
    }

    @Override
    public CraftEnchantmentView getBukkitView() {
        if (this.view != null) {
            return this.view;
        }
        CraftInventoryEnchanting inventory = new CraftInventoryEnchanting(this.q);
        this.view = new CraftEnchantmentView((HumanEntity)this.player, inventory, this);
        return this.view;
    }
}

