/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.advancements.critereon.CriterionConditionBlock;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;

public class AdventureModePredicate {
    public static final Codec<AdventureModePredicate> a = ExtraCodecs.c(CriterionConditionBlock.a, ExtraCodecs.b(CriterionConditionBlock.a.listOf())).xmap(AdventureModePredicate::new, adventureModePredicate -> adventureModePredicate.f);
    public static final StreamCodec<RegistryFriendlyByteBuf, AdventureModePredicate> b = StreamCodec.a(CriterionConditionBlock.b.a(ByteBufCodecs.a()), (C adventureModePredicate) -> adventureModePredicate.f, AdventureModePredicate::new);
    public static final IChatBaseComponent c = IChatBaseComponent.c("item.canBreak").a(EnumChatFormat.h);
    public static final IChatBaseComponent d = IChatBaseComponent.c("item.canPlace").a(EnumChatFormat.h);
    private static final IChatBaseComponent e = IChatBaseComponent.c("item.canUse.unknown").a(EnumChatFormat.h);
    public final List<CriterionConditionBlock> f;
    @Nullable
    private List<IChatBaseComponent> g;
    @Nullable
    private ShapeDetectorBlock h;
    private boolean i;
    private boolean j;

    public AdventureModePredicate(List<CriterionConditionBlock> predicates) {
        this.f = predicates;
    }

    private static boolean a(ShapeDetectorBlock first, @Nullable ShapeDetectorBlock second, boolean checkNbt) {
        if (second == null || first.a() != second.a()) {
            return false;
        }
        if (!checkNbt) {
            return true;
        }
        if (first.b() == null && second.b() == null) {
            return true;
        }
        if (first.b() != null && second.b() != null) {
            IRegistryCustom registryAccess = first.c().J_();
            return Objects.equals(first.b().c(registryAccess), second.b().c(registryAccess));
        }
        return false;
    }

    public boolean a(ShapeDetectorBlock block) {
        if (AdventureModePredicate.a(block, this.h, this.j)) {
            return this.i;
        }
        this.h = block;
        this.j = false;
        for (CriterionConditionBlock blockPredicate : this.f) {
            if (!blockPredicate.a(block)) continue;
            this.j |= blockPredicate.a();
            this.i = true;
            return true;
        }
        this.i = false;
        return false;
    }

    private List<IChatBaseComponent> a() {
        if (this.g == null) {
            this.g = AdventureModePredicate.a(this.f);
        }
        return this.g;
    }

    public void a(Consumer<IChatBaseComponent> tooltipAdder) {
        this.a().forEach(tooltipAdder);
    }

    private static List<IChatBaseComponent> a(List<CriterionConditionBlock> predicates) {
        for (CriterionConditionBlock blockPredicate : predicates) {
            if (!blockPredicate.b().isEmpty()) continue;
            return List.of(e);
        }
        return predicates.stream().flatMap(predicate -> predicate.b().orElseThrow().a()).distinct().map(holder -> ((Block)holder.a()).f().a(EnumChatFormat.i)).toList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof AdventureModePredicate)) return false;
        AdventureModePredicate adventureModePredicate = (AdventureModePredicate)other;
        if (!this.f.equals(adventureModePredicate.f)) return false;
        return true;
    }

    public int hashCode() {
        return this.f.hashCode();
    }

    public String toString() {
        return "AdventureModePredicate{predicates=" + String.valueOf(this.f) + "}";
    }
}

