/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.ARGB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.World;
import org.apache.commons.lang3.math.Fraction;

public class BundleItem
extends Item {
    public static final int a = 4;
    public static final int b = 3;
    public static final int c = 12;
    public static final int d = 11;
    private static final int o = ARGB.a(1.0f, 1.0f, 0.33f, 0.33f);
    private static final int p = ARGB.a(1.0f, 0.44f, 0.53f, 1.0f);
    private static final int q = 10;
    private static final int r = 2;
    private static final int s = 200;

    public BundleItem(Item.Info properties) {
        super(properties);
    }

    public static float c(ItemStack stack) {
        BundleContents bundleContents = stack.a(DataComponents.Q, BundleContents.a);
        return bundleContents.f().floatValue();
    }

    @Override
    public boolean a(ItemStack stack, Slot slot, ClickAction action, EntityHuman player) {
        BundleContents bundleContents = stack.a(DataComponents.Q);
        if (bundleContents == null) {
            return false;
        }
        ItemStack item = slot.g();
        BundleContents.a mutable = new BundleContents.a(bundleContents);
        if (action == ClickAction.a && !item.f()) {
            if (mutable.a(slot, player) > 0) {
                BundleItem.b(player);
            } else {
                BundleItem.c(player);
            }
            stack.b(DataComponents.Q, mutable.d());
            this.a(player);
            return true;
        }
        if (action == ClickAction.b && item.f()) {
            ItemStack itemStack = mutable.b();
            if (itemStack != null) {
                ItemStack itemStack1 = slot.d(itemStack);
                if (itemStack1.M() > 0) {
                    mutable.a(itemStack1);
                } else {
                    BundleItem.a(player);
                }
            }
            stack.b(DataComponents.Q, mutable.d());
            this.a(player);
            return true;
        }
        return false;
    }

    @Override
    public boolean a(ItemStack stack, ItemStack other, Slot slot, ClickAction action, EntityHuman player, SlotAccess access) {
        if (action == ClickAction.a && other.f()) {
            BundleItem.a(stack, -1);
            return false;
        }
        BundleContents bundleContents = stack.a(DataComponents.Q);
        if (bundleContents == null) {
            return false;
        }
        BundleContents.a mutable = new BundleContents.a(bundleContents);
        if (action == ClickAction.a && !other.f()) {
            if (slot.b(player) && mutable.a(other) > 0) {
                BundleItem.b(player);
            } else {
                BundleItem.c(player);
            }
            stack.b(DataComponents.Q, mutable.d());
            this.a(player);
            return true;
        }
        if (action == ClickAction.b && other.f()) {
            ItemStack itemStack;
            if (slot.b(player) && (itemStack = mutable.b()) != null) {
                BundleItem.a(player);
                access.a(itemStack);
            }
            stack.b(DataComponents.Q, mutable.d());
            this.a(player);
            return true;
        }
        BundleItem.a(stack, -1);
        return false;
    }

    @Override
    public EnumInteractionResult a(World level, EntityHuman player, EnumHand hand) {
        player.c(hand);
        return EnumInteractionResult.a;
    }

    private void a(World level, EntityHuman player, ItemStack stack) {
        if (this.b(stack, player)) {
            BundleItem.a(level, player);
            player.b(StatisticList.c.b(this));
        }
    }

    @Override
    public boolean d(ItemStack stack) {
        BundleContents bundleContents = stack.a(DataComponents.Q, BundleContents.a);
        return bundleContents.f().compareTo(Fraction.ZERO) > 0;
    }

    @Override
    public int e(ItemStack stack) {
        BundleContents bundleContents = stack.a(DataComponents.Q, BundleContents.a);
        return Math.min(1 + MathHelper.a(bundleContents.f(), 12), 13);
    }

    @Override
    public int f(ItemStack stack) {
        BundleContents bundleContents = stack.a(DataComponents.Q, BundleContents.a);
        return bundleContents.f().compareTo(Fraction.ONE) >= 0 ? o : p;
    }

    public static void a(ItemStack bundle, int selectedItem) {
        BundleContents bundleContents = bundle.a(DataComponents.Q);
        if (bundleContents != null) {
            BundleContents.a mutable = new BundleContents.a(bundleContents);
            mutable.a(selectedItem);
            bundle.b(DataComponents.Q, mutable.d());
        }
    }

    public static boolean g(ItemStack bundle) {
        BundleContents bundleContents = bundle.a(DataComponents.Q);
        return bundleContents != null && bundleContents.h() != -1;
    }

    public static int h(ItemStack bundle) {
        BundleContents bundleContents = bundle.a(DataComponents.Q, BundleContents.a);
        return bundleContents.h();
    }

    public static ItemStack i(ItemStack bundle) {
        BundleContents bundleContents = bundle.a(DataComponents.Q);
        return bundleContents != null && bundleContents.h() != -1 ? bundleContents.a(bundleContents.h()) : ItemStack.l;
    }

    public static int j(ItemStack bundle) {
        BundleContents bundleContents = bundle.a(DataComponents.Q, BundleContents.a);
        return bundleContents.a();
    }

    private boolean b(ItemStack stack, EntityHuman player) {
        BundleContents bundleContents = stack.a(DataComponents.Q);
        if (bundleContents != null && !bundleContents.g()) {
            Optional<ItemStack> optional = BundleItem.a(stack, player, bundleContents);
            if (optional.isPresent()) {
                player.a(optional.get(), true);
                return true;
            }
            return false;
        }
        return false;
    }

    private static Optional<ItemStack> a(ItemStack stack, EntityHuman player, BundleContents bundleContents) {
        BundleContents.a mutable = new BundleContents.a(bundleContents);
        ItemStack itemStack = mutable.b();
        if (itemStack != null) {
            BundleItem.a(player);
            stack.b(DataComponents.Q, mutable.d());
            return Optional.of(itemStack);
        }
        return Optional.empty();
    }

    @Override
    public void a(World level, EntityLiving livingEntity, ItemStack stack, int remainingUseDuration) {
        if (livingEntity instanceof EntityHuman) {
            boolean flag;
            EntityHuman player = (EntityHuman)livingEntity;
            int useDuration = this.a(stack, livingEntity);
            boolean bl = flag = remainingUseDuration == useDuration;
            if (flag || remainingUseDuration < useDuration - 10 && remainingUseDuration % 2 == 0) {
                this.a(level, player, stack);
            }
        }
    }

    @Override
    public int a(ItemStack stack, EntityLiving entity) {
        return 200;
    }

    @Override
    public ItemUseAnimation b(ItemStack stack) {
        return ItemUseAnimation.k;
    }

    @Override
    public Optional<TooltipComponent> k(ItemStack stack) {
        TooltipDisplay tooltipDisplay = stack.a(DataComponents.q, TooltipDisplay.c);
        return !tooltipDisplay.a(DataComponents.Q) ? Optional.empty() : Optional.ofNullable(stack.a(DataComponents.Q)).map(BundleTooltip::new);
    }

    @Override
    public void a(EntityItem itemEntity) {
        BundleContents bundleContents = itemEntity.e().a(DataComponents.Q);
        if (bundleContents != null) {
            itemEntity.e().b(DataComponents.Q, BundleContents.a);
            ItemLiquidUtil.a(itemEntity, bundleContents.d());
        }
    }

    public static List<BundleItem> a() {
        return Stream.of(Items.rM, Items.rN, Items.rO, Items.rP, Items.rQ, Items.rR, Items.rS, Items.rT, Items.rU, Items.rV, Items.rW, Items.sc, Items.rZ, Items.sa, Items.sb, Items.rY, Items.rX).map(item -> (BundleItem)item).toList();
    }

    public static Item a(EnumColor color) {
        return switch (color) {
            default -> throw new MatchException(null, null);
            case EnumColor.a -> Items.rN;
            case EnumColor.b -> Items.rO;
            case EnumColor.c -> Items.rP;
            case EnumColor.d -> Items.rQ;
            case EnumColor.e -> Items.rR;
            case EnumColor.f -> Items.rS;
            case EnumColor.g -> Items.rT;
            case EnumColor.h -> Items.rU;
            case EnumColor.i -> Items.rV;
            case EnumColor.j -> Items.rW;
            case EnumColor.l -> Items.rY;
            case EnumColor.m -> Items.rZ;
            case EnumColor.n -> Items.sa;
            case EnumColor.o -> Items.sb;
            case EnumColor.p -> Items.sc;
            case EnumColor.k -> Items.rX;
        };
    }

    private static void a(Entity entity) {
        entity.a(SoundEffects.ds, 0.8f, 0.8f + entity.dV().G_().i() * 0.4f);
    }

    private static void b(Entity entity) {
        entity.a(SoundEffects.dq, 0.8f, 0.8f + entity.dV().G_().i() * 0.4f);
    }

    private static void c(Entity entity) {
        entity.a(SoundEffects.dr, 1.0f, 1.0f);
    }

    private static void a(World level, Entity entity) {
        level.a(null, entity.dv(), SoundEffects.dp, SoundCategory.h, 0.8f, 0.8f + entity.dV().G_().i() * 0.4f);
    }

    private void a(EntityHuman player) {
        Container abstractContainerMenu = player.bR;
        if (abstractContainerMenu != null) {
            abstractContainerMenu.a(player.gj());
        }
    }
}

