/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.event.entity.EntityLoadCrossbowEvent;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R4.CraftEquipmentSlot;
import org.bukkit.entity.LivingEntity;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ItemCrossbow
extends ItemProjectileWeapon {
    private static final float o = 1.25f;
    public static final int a = 8;
    private boolean p = false;
    private boolean q = false;
    private static final float r = 0.2f;
    private static final float s = 0.5f;
    private static final float t = 3.15f;
    public static final float u = 1.6f;
    public static final float b = 1.6f;
    private static final b v = new b(Optional.of(SoundEffects.gN), Optional.of(SoundEffects.gM), Optional.of(SoundEffects.gL));

    public ItemCrossbow(Item.Info properties) {
        super(properties);
    }

    @Override
    public Predicate<ItemStack> c() {
        return ItemProjectileWeapon.d;
    }

    @Override
    public Predicate<ItemStack> a() {
        return ItemProjectileWeapon.c;
    }

    @Override
    public EnumInteractionResult a(World level, EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        ChargedProjectiles chargedProjectiles = itemInHand.a(DataComponents.P);
        if (chargedProjectiles != null && !chargedProjectiles.b()) {
            this.a(level, player, hand, itemInHand, ItemCrossbow.a(chargedProjectiles), 1.0f, null);
            return EnumInteractionResult.c;
        }
        if (!player.d(itemInHand).f()) {
            this.p = false;
            this.q = false;
            player.c(hand);
            return EnumInteractionResult.c;
        }
        return EnumInteractionResult.d;
    }

    private static float a(ChargedProjectiles projectile) {
        return projectile.a(Items.vE) ? 1.6f : 3.15f;
    }

    @Override
    public boolean a(ItemStack stack, World level, EntityLiving entity, int timeLeft) {
        int i2 = this.a(stack, entity) - timeLeft;
        return ItemCrossbow.a(i2, stack, entity) >= 1.0f && ItemCrossbow.g(stack);
    }

    @Deprecated
    @DoNotUse
    private static boolean a(EntityLiving shooter, ItemStack crossbowStack) {
        return ItemCrossbow.tryLoadProjectiles(shooter, crossbowStack, true);
    }

    private static boolean tryLoadProjectiles(EntityLiving shooter, ItemStack crossbowStack, boolean consume) {
        List<ItemStack> list = ItemCrossbow.draw(crossbowStack, shooter.d(crossbowStack), shooter, consume);
        if (!list.isEmpty()) {
            crossbowStack.b(DataComponents.P, ChargedProjectiles.a(list));
            return true;
        }
        return false;
    }

    public static boolean g(ItemStack crossbowStack) {
        ChargedProjectiles chargedProjectiles = crossbowStack.a(DataComponents.P, ChargedProjectiles.a);
        return !chargedProjectiles.b();
    }

    @Override
    protected void a(EntityLiving shooter, IProjectile projectile, int index, float velocity, float inaccuracy, float angle, @Nullable EntityLiving target) {
        Vector3f projectileShotVector;
        if (target != null) {
            double d2 = target.dA() - shooter.dA();
            double d1 = target.dG() - shooter.dG();
            double squareRoot = Math.sqrt(d2 * d2 + d1 * d1);
            double d22 = target.e(0.3333333333333333) - projectile.dC() + squareRoot * (double)0.2f;
            projectileShotVector = ItemCrossbow.a(shooter, new Vec3D(d2, d22, d1), angle);
        } else {
            Vec3D upVector = shooter.m(1.0f);
            Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(angle * ((float)Math.PI / 180)), upVector.d, upVector.e, upVector.f);
            Vec3D viewVector = shooter.h(1.0f);
            projectileShotVector = viewVector.k().rotate((Quaternionfc)quaternionf);
        }
        projectile.c(projectileShotVector.x(), projectileShotVector.y(), projectileShotVector.z(), velocity, inaccuracy);
        float shotPitch = ItemCrossbow.a(shooter.dY(), index);
        shooter.dV().a(null, shooter.dA(), shooter.dC(), shooter.dG(), SoundEffects.gR, shooter.dm(), 1.0f, shotPitch);
    }

    private static Vector3f a(EntityLiving shooter, Vec3D distance, float angle) {
        Vector3f vector3f = distance.k().normalize();
        Vector3f vector3f1 = new Vector3f((Vector3fc)vector3f).cross((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f));
        if ((double)vector3f1.lengthSquared() <= 1.0E-7) {
            Vec3D upVector = shooter.m(1.0f);
            vector3f1 = new Vector3f((Vector3fc)vector3f).cross((Vector3fc)upVector.k());
        }
        Vector3f vector3f2 = new Vector3f((Vector3fc)vector3f).rotateAxis(1.5707964f, vector3f1.x, vector3f1.y, vector3f1.z);
        return new Vector3f((Vector3fc)vector3f).rotateAxis(angle * ((float)Math.PI / 180), vector3f2.x, vector3f2.y, vector3f2.z);
    }

    @Override
    protected IProjectile a(World level, EntityLiving shooter, ItemStack weapon, ItemStack ammo, boolean isCrit) {
        if (ammo.a(Items.vE)) {
            EntityFireworks entity = new EntityFireworks(level, ammo, shooter, shooter.dA(), shooter.dE() - (double)0.15f, shooter.dG(), true);
            entity.spawningEntity = shooter.cG();
            return entity;
        }
        IProjectile projectile = super.a(level, shooter, weapon, ammo, isCrit);
        if (projectile instanceof EntityArrow) {
            EntityArrow abstractArrow = (EntityArrow)projectile;
            abstractArrow.b(SoundEffects.gK);
        }
        return projectile;
    }

    @Override
    protected int h(ItemStack stack) {
        return stack.a(Items.vE) ? 3 : 1;
    }

    public void a(World level, EntityLiving shooter, EnumHand hand, ItemStack weapon, float velocity, float inaccuracy, @Nullable EntityLiving target) {
        if (level instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)level;
            ChargedProjectiles chargedProjectiles = weapon.b(DataComponents.P, ChargedProjectiles.a);
            if (chargedProjectiles != null && !chargedProjectiles.b()) {
                this.shoot(serverLevel, shooter, hand, weapon, chargedProjectiles.a(), velocity, inaccuracy, shooter instanceof EntityHuman, target, 1.0f);
                if (shooter instanceof EntityPlayer) {
                    EntityPlayer serverPlayer = (EntityPlayer)shooter;
                    CriterionTriggers.G.a(serverPlayer, weapon);
                    serverPlayer.b(StatisticList.c.b(weapon.h()));
                }
            }
        }
    }

    private static float a(RandomSource random, int index) {
        return index == 0 ? 1.0f : ItemCrossbow.a((index & 1) == 1, random);
    }

    private static float a(boolean isHighPitched, RandomSource random) {
        float f2 = isHighPitched ? 0.63f : 0.43f;
        return 1.0f / (random.i() * 0.5f + 1.8f) + f2;
    }

    @Override
    public void a(World level, EntityLiving livingEntity, ItemStack stack, int count) {
        if (!level.C) {
            b chargingSounds = this.i(stack);
            float f2 = (float)(stack.a(livingEntity) - count) / (float)ItemCrossbow.b(stack, livingEntity);
            if (f2 < 0.2f) {
                this.p = false;
                this.q = false;
            }
            if (f2 >= 0.2f && !this.p) {
                this.p = true;
                chargingSounds.a().ifPresent(holder -> level.a(null, livingEntity.dA(), livingEntity.dC(), livingEntity.dG(), (SoundEffect)holder.a(), SoundCategory.h, 0.5f, 1.0f));
            }
            if (f2 >= 0.5f && !this.q) {
                this.q = true;
                chargingSounds.b().ifPresent(sound -> level.a(null, livingEntity.dA(), livingEntity.dC(), livingEntity.dG(), (SoundEffect)sound.a(), SoundCategory.h, 0.5f, 1.0f));
            }
            if (f2 >= 1.0f && !ItemCrossbow.g(stack)) {
                EntityLoadCrossbowEvent event = new EntityLoadCrossbowEvent((LivingEntity)livingEntity.getBukkitLivingEntity(), stack.asBukkitMirror(), CraftEquipmentSlot.getHand(livingEntity.fA()));
                if (!(event.callEvent() && ItemCrossbow.tryLoadProjectiles(livingEntity, stack, event.shouldConsumeItem()) && event.shouldConsumeItem())) {
                    if (livingEntity instanceof EntityPlayer) {
                        EntityPlayer player = (EntityPlayer)livingEntity;
                        player.bR.b();
                    }
                    return;
                }
                chargingSounds.c().ifPresent(sound -> level.a(null, livingEntity.dA(), livingEntity.dC(), livingEntity.dG(), (SoundEffect)sound.a(), livingEntity.dm(), 1.0f, 1.0f / (level.G_().i() * 0.5f + 1.0f) + 0.2f));
            }
        }
    }

    @Override
    public int a(ItemStack stack, EntityLiving entity) {
        return 72000;
    }

    public static int b(ItemStack stack, EntityLiving shooter) {
        float f2 = EnchantmentManager.a(stack, shooter, 1.25f);
        return MathHelper.d(f2 * 20.0f);
    }

    @Override
    public ItemUseAnimation b(ItemStack stack) {
        return ItemUseAnimation.g;
    }

    b i(ItemStack stack) {
        return EnchantmentManager.b(stack, EnchantmentEffectComponents.B).orElse(v);
    }

    private static float a(int timeLeft, ItemStack stack, EntityLiving shooter) {
        float f2 = (float)timeLeft / (float)ItemCrossbow.b(stack, shooter);
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return f2;
    }

    @Override
    public boolean e_(ItemStack stack) {
        return stack.a(this);
    }

    @Override
    public int b() {
        return 8;
    }

    public static final class b
    extends Record {
        private final Optional<Holder<SoundEffect>> b;
        private final Optional<Holder<SoundEffect>> c;
        private final Optional<Holder<SoundEffect>> d;
        public static final Codec<b> a = RecordCodecBuilder.create(instance -> instance.group((App)SoundEffect.b.optionalFieldOf("start").forGetter(b::a), (App)SoundEffect.b.optionalFieldOf("mid").forGetter(b::b), (App)SoundEffect.b.optionalFieldOf("end").forGetter(b::c)).apply((Applicative)instance, b::new));

        public b(Optional<Holder<SoundEffect>> start, Optional<Holder<SoundEffect>> mid, Optional<Holder<SoundEffect>> end) {
            this.b = start;
            this.c = mid;
            this.d = end;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "start;mid;end", "b", "c", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "start;mid;end", "b", "c", "d"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "start;mid;end", "b", "c", "d"}, this, o2);
        }

        public Optional<Holder<SoundEffect>> a() {
            return this.b;
        }

        public Optional<Holder<SoundEffect>> b() {
            return this.c;
        }

        public Optional<Holder<SoundEffect>> c() {
            return this.d;
        }
    }

    public static final class a
    extends Enum<a>
    implements INamable {
        public static final /* enum */ a a = new a("none");
        public static final /* enum */ a b = new a("arrow");
        public static final /* enum */ a c = new a("rocket");
        public static final Codec<a> d;
        private final String e;
        private static final /* synthetic */ a[] f;

        public static a[] values() {
            return (a[])f.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        private a(String name) {
            this.e = name;
        }

        @Override
        public String c() {
            return this.e;
        }

        private static /* synthetic */ a[] a() {
            return new a[]{a, b, c};
        }

        static {
            f = net.minecraft.world.item.ItemCrossbow$a.a();
            d = INamable.a(a::values);
        }
    }
}

