/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.Unit;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.event.entity.EntityShootBowEvent;

public abstract class ItemProjectileWeapon
extends Item {
    public static final Predicate<ItemStack> c = stack -> stack.a(TagsItem.aZ);
    public static final Predicate<ItemStack> d = c.or(stack -> stack.a(Items.vE));

    public ItemProjectileWeapon(Item.Info properties) {
        super(properties);
    }

    public Predicate<ItemStack> c() {
        return this.a();
    }

    public abstract Predicate<ItemStack> a();

    public static ItemStack a(EntityLiving shooter, Predicate<ItemStack> isAmmo) {
        if (isAmmo.test(shooter.b(EnumHand.b))) {
            return shooter.b(EnumHand.b);
        }
        return isAmmo.test(shooter.b(EnumHand.a)) ? shooter.b(EnumHand.a) : ItemStack.l;
    }

    public abstract int b();

    protected void shoot(WorldServer level, EntityLiving shooter, EnumHand hand, ItemStack weapon, List<ItemStack> projectileItems, float velocity, float inaccuracy, boolean isCrit, @Nullable EntityLiving target, float drawStrength) {
        float f2 = EnchantmentManager.a(level, weapon, (Entity)shooter, 0.0f);
        float f1 = projectileItems.size() == 1 ? 0.0f : 2.0f * f2 / (float)(projectileItems.size() - 1);
        float f22 = (float)((projectileItems.size() - 1) % 2) * f1 / 2.0f;
        float f3 = 1.0f;
        for (int i2 = 0; i2 < projectileItems.size(); ++i2) {
            ItemStack itemStack = projectileItems.get(i2);
            if (itemStack.f()) continue;
            float f4 = f22 + f3 * (float)((i2 + 1) / 2) * f1;
            f3 = -f3;
            int i1 = i2;
            IProjectile projectile = this.a(level, shooter, weapon, itemStack, isCrit);
            this.a(shooter, projectile, i1, velocity, inaccuracy, f4, target);
            EntityShootBowEvent event = CraftEventFactory.callEntityShootBowEvent(shooter, weapon, itemStack, projectile, hand, drawStrength, true);
            if (event.isCancelled()) {
                event.getProjectile().remove();
                return;
            }
            if (event.getProjectile() == projectile.getBukkitEntity() && IProjectile.a(projectile, level, itemStack).dQ()) {
                if (shooter instanceof EntityPlayer) {
                    EntityPlayer serverPlayer = (EntityPlayer)shooter;
                    serverPlayer.bR.b();
                }
                return;
            }
            weapon.a(this.h(itemStack), shooter, EntityLiving.d(hand));
            if (weapon.f()) break;
        }
    }

    protected int h(ItemStack stack) {
        return 1;
    }

    protected abstract void a(EntityLiving var1, IProjectile var2, int var3, float var4, float var5, float var6, @Nullable EntityLiving var7);

    protected IProjectile a(World level, EntityLiving shooter, ItemStack weapon, ItemStack ammo, boolean isCrit) {
        ItemArrow arrowItem;
        Item item = ammo.h();
        ItemArrow arrowItem1 = item instanceof ItemArrow ? (arrowItem = (ItemArrow)item) : (ItemArrow)Items.pk;
        EntityArrow abstractArrow = arrowItem1.a(level, ammo, shooter, weapon);
        if (isCrit) {
            abstractArrow.b(true);
        }
        return abstractArrow;
    }

    protected static List<ItemStack> a(ItemStack weapon, ItemStack ammo, EntityLiving shooter) {
        return ItemProjectileWeapon.draw(weapon, ammo, shooter, true);
    }

    protected static List<ItemStack> draw(ItemStack weapon, ItemStack ammo, EntityLiving shooter, boolean consume) {
        int n2;
        if (ammo.f()) {
            return List.of();
        }
        World world = shooter.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            n2 = EnchantmentManager.a(serverLevel, weapon, (Entity)shooter, 1);
        } else {
            n2 = 1;
        }
        int i2 = n2;
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(i2);
        ItemStack itemStack = ammo.v();
        for (int i1 = 0; i1 < i2; ++i1) {
            ItemStack itemStack1 = ItemProjectileWeapon.a(weapon, i1 == 0 ? ammo : itemStack, shooter, i1 > 0 || !consume);
            if (itemStack1.f()) continue;
            list.add(itemStack1);
        }
        return list;
    }

    protected static ItemStack a(ItemStack weapon, ItemStack ammo, EntityLiving shooter, boolean intangable) {
        ItemStack itemStack;
        int i2;
        World world;
        if (!intangable && !shooter.fV() && (world = shooter.dV()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            v0 = EnchantmentManager.a(serverLevel, weapon, ammo, 1);
        } else {
            v0 = i2 = 0;
        }
        if (i2 > ammo.M()) {
            return ItemStack.l;
        }
        if (i2 == 0) {
            itemStack = ammo.c(1);
            itemStack.b(DataComponents.u, Unit.a);
            return itemStack;
        }
        itemStack = ammo.a(i2);
        if (ammo.f() && shooter instanceof EntityHuman) {
            EntityHuman player = (EntityHuman)shooter;
            player.gj().i(ammo);
        }
        return itemStack;
    }
}

