/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import io.papermc.paper.event.entity.EntityDamageItemEvent;
import io.papermc.paper.event.player.PlayerOpenSignEvent;
import io.papermc.paper.util.SafeAutoClosable;
import io.papermc.paper.util.sanitizer.ItemComponentSanitizer;
import io.papermc.paper.util.sanitizer.ItemObfuscationSession;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.util.NullOps;
import net.minecraft.util.Unit;
import net.minecraft.util.UtilColor;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.AdventureModePredicate;
import net.minecraft.world.item.EnumItemRarity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBed;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemBucket;
import net.minecraft.world.item.ItemSign;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.DamageResistant;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.item.component.UseCooldown;
import net.minecraft.world.item.component.UseRemainder;
import net.minecraft.world.item.component.Weapon;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.Repairable;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.Spawner;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockSapling;
import net.minecraft.world.level.block.BlockSign;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.BlockWitherSkull;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftLocation;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockFertilizeEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.slf4j.Logger;

public final class ItemStack
implements DataComponentHolder {
    private static final List<IChatBaseComponent> m = List.of(IChatBaseComponent.c("item.op_warning.line1").a(EnumChatFormat.m, EnumChatFormat.r), IChatBaseComponent.c("item.op_warning.line2").a(EnumChatFormat.m), IChatBaseComponent.c("item.op_warning.line3").a(EnumChatFormat.m));
    private static final IChatBaseComponent n = IChatBaseComponent.c("item.unbreakable").a(EnumChatFormat.j);
    public static final MapCodec<ItemStack> a = MapCodec.recursive((String)"ItemStack", codec -> RecordCodecBuilder.mapCodec(instance -> instance.group((App)Item.e.fieldOf("id").forGetter(ItemStack::i), (App)ExtraCodecs.a(1, 99).fieldOf("count").orElse((Object)1).forGetter(ItemStack::M), (App)DataComponentPatch.b.optionalFieldOf("components", (Object)DataComponentPatch.a).forGetter(stack -> stack.t.g())).apply((Applicative)instance, ItemStack::new)));
    public static final Codec<ItemStack> b = Codec.lazyInitialized(() -> a.codec());
    public static final Codec<ItemStack> c = Codec.lazyInitialized(() -> RecordCodecBuilder.create(instance -> instance.group((App)Item.e.fieldOf("id").forGetter(ItemStack::i), (App)DataComponentPatch.b.optionalFieldOf("components", (Object)DataComponentPatch.a).forGetter(stack -> stack.t.g())).apply((Applicative)instance, (item, components) -> new ItemStack((Holder<Item>)item, 1, (DataComponentPatch)components))));
    public static final Codec<ItemStack> d = b.validate(ItemStack::a);
    public static final Codec<ItemStack> e = c.validate(ItemStack::a);
    public static final Codec<ItemStack> f = ExtraCodecs.g(b).xmap(optional -> optional.orElse(l), stack -> stack.f() ? Optional.empty() : Optional.of(stack));
    public static final Codec<ItemStack> g = Item.e.xmap(ItemStack::new, ItemStack::i);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStack> h = ItemStack.b(DataComponentPatch.c);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStack> i = ItemStack.b(DataComponentPatch.d);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStack> j = new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){

        public ItemStack a(RegistryFriendlyByteBuf buffer) {
            ItemStack itemStack = (ItemStack)h.decode(buffer);
            if (itemStack.f()) {
                throw new DecoderException("Empty ItemStack not allowed");
            }
            return itemStack;
        }

        public void a(RegistryFriendlyByteBuf buffer, ItemStack value) {
            if (value.f()) {
                throw new EncoderException("Empty ItemStack not allowed");
            }
            h.encode(buffer, value);
        }
    };
    public static final StreamCodec<RegistryFriendlyByteBuf, List<ItemStack>> k = h.a(ByteBufCodecs.a(NonNullList::a));
    private static final Logger o = LogUtils.getLogger();
    public static final ItemStack l = new ItemStack((Void)null);
    private static final IChatBaseComponent p = IChatBaseComponent.c("item.disabled").a(EnumChatFormat.m);
    private int q;
    private int r;
    @Deprecated
    @Nullable
    private Item s;
    PatchedDataComponentMap t;
    @Nullable
    private net.minecraft.world.entity.Entity u;
    @Nullable
    private CraftItemStack bukkitStack;

    public static DataResult<ItemStack> a(ItemStack stack) {
        DataResult<Unit> dataResult = ItemStack.a(stack.a());
        if (dataResult.isError()) {
            return dataResult.map(unit -> stack);
        }
        return stack.M() > stack.k() ? DataResult.error(() -> "Item stack with stack size of " + stack.M() + " was larger than maximum: " + stack.k()) : DataResult.success((Object)stack);
    }

    private static StreamCodec<RegistryFriendlyByteBuf, ItemStack> b(final StreamCodec<RegistryFriendlyByteBuf, DataComponentPatch> codec) {
        return new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){

            public ItemStack a(RegistryFriendlyByteBuf buffer) {
                int varInt = buffer.l();
                if (varInt <= 0) {
                    return l;
                }
                Holder holder = (Holder)Item.f.decode(buffer);
                DataComponentPatch dataComponentPatch = (DataComponentPatch)codec.decode(buffer);
                return new ItemStack(holder, varInt, dataComponentPatch);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void a(RegistryFriendlyByteBuf buffer, ItemStack value) {
                if (value.f() || value.h() == null) {
                    buffer.c(0);
                } else {
                    buffer.c(ItemComponentSanitizer.sanitizeCount(ItemObfuscationSession.currentSession(), value, value.M()));
                    Item.f.encode(buffer, value.i());
                    boolean prev = ComponentSerialization.DONT_RENDER_TRANSLATABLES.get();
                    try (SafeAutoClosable ignored = ItemObfuscationSession.withContext(c2 -> c2.itemStack(value));){
                        ComponentSerialization.DONT_RENDER_TRANSLATABLES.set(true);
                        codec.encode(buffer, value.t.g());
                    }
                    finally {
                        ComponentSerialization.DONT_RENDER_TRANSLATABLES.set(prev);
                    }
                }
            }
        };
    }

    public static StreamCodec<RegistryFriendlyByteBuf, ItemStack> a(final StreamCodec<RegistryFriendlyByteBuf, ItemStack> codec) {
        return new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){

            public ItemStack a(RegistryFriendlyByteBuf buffer) {
                ItemStack itemStack = (ItemStack)codec.decode(buffer);
                if (!itemStack.f()) {
                    RegistryOps<Unit> registryOps = buffer.H().a(NullOps.a);
                    b.encodeStart(registryOps, (Object)itemStack).getOrThrow(DecoderException::new);
                }
                return itemStack;
            }

            public void a(RegistryFriendlyByteBuf buffer, ItemStack value) {
                codec.encode(buffer, value);
            }
        };
    }

    public Optional<TooltipComponent> b() {
        return this.h().k(this);
    }

    @Override
    public DataComponentMap a() {
        return !this.f() ? this.t : DataComponentMap.a;
    }

    public DataComponentMap c() {
        return !this.f() ? this.h().f() : DataComponentMap.a;
    }

    public DataComponentPatch d() {
        return !this.f() ? this.t.g() : DataComponentPatch.a;
    }

    public DataComponentMap e() {
        return !this.f() ? this.t.i() : DataComponentMap.a;
    }

    public boolean d(DataComponentType<?> component) {
        return !this.f() && this.t.d(component);
    }

    public ItemStack(IMaterial item) {
        this(item, 1);
    }

    public ItemStack(Holder<Item> tag) {
        this(tag.a(), 1);
    }

    public ItemStack(Holder<Item> tag, int count, DataComponentPatch components) {
        this(tag.a(), count, PatchedDataComponentMap.a(tag.a().f(), components));
    }

    public ItemStack(Holder<Item> item, int count) {
        this(item.a(), count);
    }

    public ItemStack(IMaterial item, int count) {
        this(item, count, new PatchedDataComponentMap(item.h().f()));
    }

    private ItemStack(IMaterial item, int count, PatchedDataComponentMap components) {
        this.s = item.h();
        this.q = count;
        this.t = components;
        this.h().l(this);
    }

    private ItemStack(@Nullable Void unused) {
        this.s = null;
        this.t = new PatchedDataComponentMap(DataComponentMap.a);
    }

    public static DataResult<Unit> a(DataComponentMap components) {
        if (components.c(DataComponents.d) && components.a(DataComponents.c, 1) > 1) {
            return DataResult.error(() -> "Item cannot be both damageable and stackable");
        }
        ItemContainerContents itemContainerContents = components.a(DataComponents.ap, ItemContainerContents.a);
        for (ItemStack itemStack : itemContainerContents.d()) {
            int maxStackSize;
            int count = itemStack.M();
            if (count <= (maxStackSize = itemStack.k())) continue;
            return DataResult.error(() -> "Item stack with count of " + count + " was larger than maximum: " + maxStackSize);
        }
        return DataResult.success((Object)((Object)Unit.a));
    }

    public static Optional<ItemStack> a(HolderLookup.a lookupProvider, NBTBase tag) {
        return b.parse(lookupProvider.a(DynamicOpsNBT.a), (Object)tag).resultOrPartial(itemId -> o.error("Tried to load invalid item: '{}'", itemId));
    }

    public boolean f() {
        return this == l || this.s == Items.a || this.q <= 0;
    }

    public boolean a(FeatureFlagSet enabledFlags) {
        return this.f() || this.h().a(enabledFlags);
    }

    public ItemStack a(int amount) {
        int min = Math.min(amount, this.M());
        ItemStack itemStack = this.c(min);
        this.h(min);
        return itemStack;
    }

    public ItemStack g() {
        if (this.f()) {
            return l;
        }
        ItemStack itemStack = this.v();
        this.e(0);
        return itemStack;
    }

    public Item h() {
        return this.f() ? Items.a : this.s;
    }

    public Holder<Item> i() {
        return this.h().e();
    }

    public boolean a(TagKey<Item> tag) {
        return this.h().e().a(tag);
    }

    public boolean a(Item item) {
        return this.h() == item;
    }

    public boolean a(Predicate<Holder<Item>> item) {
        return item.test(this.h().e());
    }

    public boolean a(Holder<Item> item) {
        return this.h().e() == item;
    }

    public boolean a(HolderSet<Item> item) {
        return item.a(this.i());
    }

    public Stream<TagKey<Item>> j() {
        return this.h().e().c();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnumInteractionResult a(ItemActionContext context) {
        EnumInteractionResult.d success;
        EnumInteractionResult interactionResult;
        EntityHuman player = context.o();
        BlockPosition clickedPos = context.a();
        if (player != null && !player.gk().e && !this.a(new ShapeDetectorBlock(context.q(), clickedPos, false))) {
            return EnumInteractionResult.e;
        }
        Item item = this.h();
        DataComponentPatch previousPatch = this.t.g();
        int oldCount = this.M();
        WorldServer serverLevel = (WorldServer)context.q();
        if (!(item instanceof ItemBucket)) {
            serverLevel.captureBlockStates = true;
            if (item == Items.sG) {
                serverLevel.captureTreeGeneration = true;
            }
        }
        try {
            interactionResult = item.a(context);
        }
        finally {
            serverLevel.captureBlockStates = false;
        }
        DataComponentPatch newPatch = this.t.g();
        int newCount = this.M();
        this.e(oldCount);
        this.restorePatch(previousPatch);
        if (interactionResult.a() && serverLevel.captureTreeGeneration && !serverLevel.capturedBlockStates.isEmpty()) {
            serverLevel.captureTreeGeneration = false;
            Location location = CraftLocation.toBukkit(clickedPos, (World)serverLevel.getWorld());
            TreeType treeType = BlockSapling.treeType;
            BlockSapling.treeType = null;
            ArrayList<CraftBlockState> blocks = new ArrayList<CraftBlockState>(serverLevel.capturedBlockStates.values());
            serverLevel.capturedBlockStates.clear();
            StructureGrowEvent structureEvent = null;
            if (treeType != null) {
                boolean isBonemeal = this.h() == Items.sG;
                structureEvent = new StructureGrowEvent(location, treeType, isBonemeal, (Player)player.getBukkitEntity(), blocks);
                Bukkit.getPluginManager().callEvent((Event)structureEvent);
            }
            BlockFertilizeEvent fertilizeEvent = new BlockFertilizeEvent((org.bukkit.block.Block)CraftBlock.at(serverLevel, clickedPos), (Player)player.getBukkitEntity(), blocks);
            fertilizeEvent.setCancelled(structureEvent != null && structureEvent.isCancelled());
            Bukkit.getPluginManager().callEvent((Event)fertilizeEvent);
            if (!fertilizeEvent.isCancelled()) {
                if (this.M() == oldCount && Objects.equals(this.t.g(), previousPatch)) {
                    this.restorePatch(newPatch);
                    this.e(newCount);
                }
                for (CraftBlockState snapshot : blocks) {
                    snapshot.place(snapshot.getFlags());
                    serverLevel.checkCapturedTreeStateForObserverNotify(clickedPos, snapshot);
                }
                player.b(StatisticList.c.b(item));
            }
            ItemSign.openSign = null;
            return interactionResult;
        }
        serverLevel.captureTreeGeneration = false;
        if (player != null && interactionResult instanceof EnumInteractionResult.d && (success = (EnumInteractionResult.d)interactionResult).c()) {
            EnumHand hand = context.p();
            BlockMultiPlaceEvent placeEvent = null;
            ArrayList<BlockState> blocks = new ArrayList<BlockState>(serverLevel.capturedBlockStates.values());
            serverLevel.capturedBlockStates.clear();
            if (blocks.size() > 1) {
                placeEvent = CraftEventFactory.callBlockMultiPlaceEvent(serverLevel, player, hand, blocks, clickedPos);
            } else if (blocks.size() == 1 && item != Items.rr) {
                placeEvent = CraftEventFactory.callBlockPlaceEvent(serverLevel, player, hand, (BlockState)blocks.getFirst(), clickedPos);
            }
            if (placeEvent != null && (placeEvent.isCancelled() || !placeEvent.canBuild())) {
                interactionResult = EnumInteractionResult.d;
                player.bR.b();
                serverLevel.capturedTileEntities.clear();
                for (BlockState blockstate : blocks) {
                    ((CraftBlockState)blockstate).revertPlace();
                }
                ItemSign.openSign = null;
            } else {
                BlockPosition pos;
                IBlockData state;
                TileEntity te;
                if (this.M() == oldCount && Objects.equals(this.t.g(), previousPatch)) {
                    this.restorePatch(newPatch);
                    this.e(newCount);
                }
                for (Map.Entry<BlockPosition, TileEntity> e2 : serverLevel.capturedTileEntities.entrySet()) {
                    serverLevel.a(e2.getValue());
                }
                for (BlockState blockstate : blocks) {
                    int updateFlags = ((CraftBlockState)blockstate).getFlags();
                    IBlockData oldBlock = ((CraftBlockState)blockstate).getHandle();
                    BlockPosition newPos = ((CraftBlockState)blockstate).getPosition();
                    IBlockData block = serverLevel.a_(newPos);
                    if (!(block.b() instanceof BlockTileEntity)) {
                        block.onPlace(serverLevel, newPos, oldBlock, true, context);
                    }
                    serverLevel.notifyAndUpdatePhysics(newPos, null, oldBlock, block, serverLevel.a_(newPos), updateFlags, 512);
                }
                if (this.s == Items.vw) {
                    BlockPosition bp = clickedPos;
                    if (!serverLevel.a_(clickedPos).v()) {
                        bp = !serverLevel.a_(clickedPos).e() ? null : bp.a(context.k());
                    }
                    if (bp != null && (te = serverLevel.c_(bp)) instanceof TileEntitySkull) {
                        BlockWitherSkull.a((net.minecraft.world.level.World)serverLevel, bp, (TileEntitySkull)te);
                    }
                }
                if (this.s instanceof ItemSign && ItemSign.openSign != null) {
                    try {
                        te = serverLevel.c_(ItemSign.openSign);
                        if (te instanceof TileEntitySign) {
                            TileEntitySign blockEntity = (TileEntitySign)te;
                            Block block = serverLevel.a_(ItemSign.openSign).b();
                            if (block instanceof BlockSign) {
                                BlockSign signBlock = (BlockSign)block;
                                signBlock.openTextEdit(player, blockEntity, true, PlayerOpenSignEvent.Cause.PLACE);
                            }
                        }
                    }
                    finally {
                        ItemSign.openSign = null;
                    }
                }
                if (placeEvent != null && this.s instanceof ItemBed && (state = serverLevel.a_(pos = ((CraftBlock)placeEvent.getBlock()).getPosition())).b() instanceof BlockBed) {
                    serverLevel.a(pos, Blocks.a);
                    state.a((GeneratorAccess)serverLevel, pos, 3);
                }
                if (this.s instanceof ItemBlock && success.paperSuccessContext().placedBlockPosition() != null) {
                    IBlockData state2 = serverLevel.a_(success.paperSuccessContext().placedBlockPosition());
                    SoundEffectType soundType = state2.A();
                    serverLevel.a((net.minecraft.world.entity.Entity)player, clickedPos, soundType.e(), SoundCategory.e, (soundType.a() + 1.0f) / 2.0f, soundType.b() * 0.8f);
                }
                player.b(StatisticList.c.b(item));
            }
        }
        serverLevel.capturedTileEntities.clear();
        serverLevel.capturedBlockStates.clear();
        return interactionResult;
    }

    public float a(IBlockData state) {
        return this.h().a(this, state);
    }

    public EnumInteractionResult a(net.minecraft.world.level.World level, EntityHuman player, EnumHand hand) {
        EnumInteractionResult.d success;
        ItemStack itemStack = this.v();
        boolean flag = this.a(player) <= 0;
        EnumInteractionResult interactionResult = this.h().a(level, player, hand);
        return flag && interactionResult instanceof EnumInteractionResult.d ? success.a((success = (EnumInteractionResult.d)interactionResult).d() == null ? this.a((EntityLiving)player, itemStack) : success.d().a((EntityLiving)player, itemStack)) : interactionResult;
    }

    public ItemStack a(net.minecraft.world.level.World level, EntityLiving livingEntity) {
        ItemStack itemStack = this.v();
        ItemStack itemStack1 = this.h().a(this, level, livingEntity);
        return itemStack1.a(livingEntity, itemStack);
    }

    private ItemStack a(EntityLiving entity, ItemStack stack) {
        UseRemainder useRemainder = stack.a(DataComponents.x);
        UseCooldown useCooldown = stack.a(DataComponents.y);
        int count = stack.M();
        ItemStack itemStack = this;
        if (useRemainder != null) {
            itemStack = useRemainder.a(this, count, entity.fV(), entity::b);
        }
        if (useCooldown != null) {
            useCooldown.a(stack, entity);
        }
        return itemStack;
    }

    public NBTBase b(HolderLookup.a levelRegistryAccess, NBTBase outputTag) {
        if (this.f()) {
            throw new IllegalStateException("Cannot encode empty ItemStack");
        }
        return (NBTBase)b.encode((Object)this, levelRegistryAccess.a(DynamicOpsNBT.a), (Object)outputTag).getOrThrow();
    }

    public NBTBase a(HolderLookup.a levelRegistryAccess) {
        if (this.f()) {
            throw new IllegalStateException("Cannot encode empty ItemStack");
        }
        return (NBTBase)b.encodeStart(levelRegistryAccess.a(DynamicOpsNBT.a), (Object)this).getOrThrow();
    }

    public int k() {
        return this.a(DataComponents.c, Integer.valueOf(1));
    }

    public boolean l() {
        return this.k() > 1 && (!this.m() || !this.n());
    }

    public boolean m() {
        return this.c(DataComponents.d) && !this.c(DataComponents.f) && this.c(DataComponents.e);
    }

    public boolean n() {
        return this.m() && this.o() > 0;
    }

    public int o() {
        return MathHelper.a((int)this.a(DataComponents.e, Integer.valueOf(0)), 0, this.p());
    }

    public void b(int damage) {
        this.b(DataComponents.e, Integer.valueOf(MathHelper.a(damage, 0, this.p())));
    }

    public int p() {
        return this.a(DataComponents.d, Integer.valueOf(0));
    }

    public boolean q() {
        return this.m() && this.o() >= this.p();
    }

    public boolean r() {
        return this.m() && this.o() >= this.p() - 1;
    }

    public void hurtAndBreak(int damage, WorldServer level, @Nullable EntityLiving player, Consumer<Item> onBreak) {
        this.hurtAndBreak(damage, level, player, onBreak, false);
    }

    public void hurtAndBreak(int damage, WorldServer level, @Nullable EntityLiving player, Consumer<Item> onBreak, boolean force) {
        int originalDamage = damage;
        int i2 = this.processDurabilityChange(damage, level, player, force);
        if (i2 > 0 && player instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)player;
            PlayerItemDamageEvent event = new PlayerItemDamageEvent((Player)serverPlayer.getBukkitEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(this), i2, originalDamage);
            event.getPlayer().getServer().getPluginManager().callEvent((Event)event);
            if (i2 != event.getDamage() || event.isCancelled()) {
                serverPlayer.bR.b();
            }
            if (event.isCancelled()) {
                return;
            }
            i2 = event.getDamage();
        } else if (i2 > 0 && player != null) {
            EntityDamageItemEvent event = new EntityDamageItemEvent((Entity)player.getBukkitLivingEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(this), i2);
            if (!event.callEvent()) {
                return;
            }
            i2 = event.getDamage();
        }
        if (i2 != 0) {
            this.applyDamage(this.o() + i2, player, onBreak);
        }
    }

    private int processDurabilityChange(int damage, WorldServer level, @Nullable EntityLiving player) {
        return this.processDurabilityChange(damage, level, player, false);
    }

    private int processDurabilityChange(int damage, WorldServer level, @Nullable EntityLiving player, boolean force) {
        if (!this.m()) {
            return 0;
        }
        if (player instanceof EntityPlayer && player.fV() && !force) {
            return 0;
        }
        return damage > 0 ? EnchantmentManager.a(level, this, damage) : damage;
    }

    private void applyDamage(int damage, @Nullable EntityLiving player, Consumer<Item> onBreak) {
        if (player instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)player;
            CriterionTriggers.u.a(serverPlayer, this, damage);
        }
        this.b(damage);
        if (this.q()) {
            Item item = this.h();
            if (this.q == 1 && player instanceof EntityPlayer) {
                EntityPlayer serverPlayer = (EntityPlayer)player;
                CraftEventFactory.callPlayerItemBreakEvent(serverPlayer, this);
            }
            this.h(1);
            onBreak.accept(item);
        }
    }

    public void a(int damage, EntityHuman player) {
        if (player instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)player;
            int i2 = this.processDurabilityChange(damage, serverPlayer.x(), serverPlayer);
            if (i2 == 0) {
                return;
            }
            int min = Math.min(this.o() + i2, this.p() - 1);
            if (min - this.o() > 0) {
                PlayerItemDamageEvent event = new PlayerItemDamageEvent((Player)serverPlayer.getBukkitEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(this), min - this.o(), damage);
                if (!event.callEvent() || event.getDamage() == 0) {
                    return;
                }
                min = Math.min(this.o() + event.getDamage(), this.p() - 1);
            }
            this.applyDamage(min, serverPlayer, item -> {});
        }
    }

    public void a(int amount, EntityLiving entity, EnumItemSlot slot) {
        this.hurtAndBreak(amount, entity, slot, false);
    }

    public void hurtAndBreak(int amount, EntityLiving entity, EnumItemSlot slot, boolean force) {
        net.minecraft.world.level.World world = entity.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            this.hurtAndBreak(amount, serverLevel, entity, item -> {
                if (slot != null) {
                    entity.a((Item)item, slot);
                }
            }, force);
        }
    }

    public ItemStack a(int amount, IMaterial item, EntityLiving entity, EnumItemSlot slot) {
        this.a(amount, entity, slot);
        if (this.f()) {
            ItemStack itemStack = this.b(item, 1);
            if (itemStack.m()) {
                itemStack.b(0);
            }
            return itemStack;
        }
        return this;
    }

    public boolean s() {
        return this.h().d(this);
    }

    public int t() {
        return this.h().e(this);
    }

    public int u() {
        return this.h().f(this);
    }

    public boolean a(Slot slot, ClickAction action, EntityHuman player) {
        return this.h().a(this, slot, action, player);
    }

    public boolean a(ItemStack stack, Slot slot, ClickAction action, EntityHuman player, SlotAccess access) {
        return this.h().a(this, stack, slot, action, player, access);
    }

    public boolean a(EntityLiving enemy, EntityLiving attacker) {
        Item item = this.h();
        item.a(this, enemy, attacker);
        if (this.c(DataComponents.B)) {
            if (attacker instanceof EntityHuman) {
                EntityHuman player = (EntityHuman)attacker;
                player.b(StatisticList.c.b(item));
            }
            return true;
        }
        return false;
    }

    public void b(EntityLiving enemy, EntityLiving attacker) {
        this.h().b(this, enemy, attacker);
        Weapon weapon = this.a(DataComponents.B);
        if (weapon != null) {
            this.a(weapon.a(), attacker, EnumItemSlot.a);
        }
    }

    public void a(net.minecraft.world.level.World level, IBlockData state, BlockPosition pos, EntityHuman player) {
        Item item = this.h();
        if (item.a(this, level, state, pos, (EntityLiving)player)) {
            player.b(StatisticList.c.b(item));
        }
    }

    public boolean b(IBlockData state) {
        return this.h().b(this, state);
    }

    public EnumInteractionResult a(EntityHuman player, EntityLiving entity, EnumHand usedHand) {
        EnumInteractionResult interactionResult;
        Equippable equippable = this.a(DataComponents.D);
        if (equippable != null && equippable.j() && (interactionResult = equippable.a(player, entity, this)) != EnumInteractionResult.e) {
            return interactionResult;
        }
        return this.h().a(this, player, entity, usedHand);
    }

    public ItemStack v() {
        return this.copy(false);
    }

    public ItemStack copy(boolean originalItem) {
        if (!originalItem && this.f()) {
            return l;
        }
        ItemStack itemStack = new ItemStack(originalItem ? this.s : this.h(), this.q, this.t.h());
        itemStack.d(this.L());
        return itemStack;
    }

    public ItemStack c(int count) {
        if (this.f()) {
            return l;
        }
        ItemStack itemStack = this.v();
        itemStack.e(count);
        return itemStack;
    }

    public ItemStack a(IMaterial item) {
        return this.a(item, this.M());
    }

    public ItemStack a(IMaterial item, int count) {
        return this.f() ? l : this.b(item, count);
    }

    private ItemStack b(IMaterial item, int count) {
        return new ItemStack(item.h().e(), count, this.t.g());
    }

    public static boolean a(ItemStack stack, ItemStack other) {
        return stack == other || stack.M() == other.M() && ItemStack.c(stack, other);
    }

    @Deprecated
    public static boolean a(List<ItemStack> list, List<ItemStack> other) {
        if (list.size() != other.size()) {
            return false;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (ItemStack.a(list.get(i2), other.get(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean b(ItemStack stack, ItemStack other) {
        return stack.a(other.h());
    }

    public static boolean c(ItemStack stack, ItemStack other) {
        return stack.a(other.h()) && (stack.f() && other.f() || Objects.equals(stack.t, other.t));
    }

    public static MapCodec<ItemStack> a(String fieldName) {
        return b.lenientOptionalFieldOf(fieldName).xmap(optional -> optional.orElse(l), stack -> stack.f() ? Optional.empty() : Optional.of(stack));
    }

    public static int b(@Nullable ItemStack stack) {
        if (stack != null) {
            int i2 = 31 + stack.h().hashCode();
            return 31 * i2 + stack.a().hashCode();
        }
        return 0;
    }

    @Deprecated
    public static int a(List<ItemStack> list) {
        int i2 = 0;
        for (ItemStack itemStack : list) {
            i2 = i2 * 31 + ItemStack.b(itemStack);
        }
        return i2;
    }

    public String toString() {
        return this.M() + " " + String.valueOf(this.h());
    }

    public void a(net.minecraft.world.level.World level, net.minecraft.world.entity.Entity entity, @Nullable EnumItemSlot slot) {
        if (this.r > 0) {
            --this.r;
        }
        if (level instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)level;
            this.h().a(this, serverLevel, entity, slot);
        }
    }

    public void a(EntityHuman player, int amount) {
        player.a(StatisticList.b.b(this.h()), amount);
        this.h().c(this, player);
    }

    public void a(net.minecraft.world.level.World level) {
        this.h().a(this, level);
    }

    public int a(EntityLiving entity) {
        return this.h().a(this, entity);
    }

    public ItemUseAnimation w() {
        return this.h().b(this);
    }

    public void a(net.minecraft.world.level.World level, EntityLiving livingEntity, int timeLeft) {
        ItemStack itemStack1;
        ItemStack itemStack = this.v();
        if (this.h().a(this, level, livingEntity, timeLeft) && (itemStack1 = this.a(livingEntity, itemStack)) != this) {
            livingEntity.a(livingEntity.fA(), itemStack1);
        }
    }

    public boolean x() {
        return this.h().e_(this);
    }

    public void restorePatch(DataComponentPatch datacomponentpatch) {
        this.t.b(datacomponentpatch);
    }

    @Nullable
    public <T> T b(DataComponentType<T> component, @Nullable T value) {
        return this.t.b(component, value);
    }

    public <T> void a(DataComponentType<T> componentType, DataComponentGetter componentGetter) {
        this.b(componentType, componentGetter.a(componentType));
    }

    @Nullable
    public <T, U> T a(DataComponentType<T> component, T defaultValue, U updateValue, BiFunction<T, U, T> updater) {
        return this.b(component, updater.apply(this.a(component, defaultValue), updateValue));
    }

    @Nullable
    public <T> T a(DataComponentType<T> component, T defaultValue, UnaryOperator<T> updater) {
        T orDefault = this.a(component, defaultValue);
        return this.b(component, updater.apply(orDefault));
    }

    @Nullable
    public <T> T e(DataComponentType<? extends T> component) {
        return this.t.e(component);
    }

    public void a(DataComponentPatch components) {
        DataComponentPatch patch = this.t.g();
        this.t.a(components);
        Optional optional = ItemStack.a(this).error();
        if (optional.isPresent()) {
            o.error("Failed to apply component patch '{}' to item: '{}'", (Object)components, (Object)((DataResult.Error)optional.get()).message());
            this.t.b(patch);
        } else {
            this.h().l(this);
        }
    }

    public void b(DataComponentPatch components) {
        this.t.a(components);
        this.h().l(this);
    }

    public void b(DataComponentMap components) {
        this.t.a(components);
        this.h().l(this);
    }

    public org.bukkit.inventory.ItemStack asBukkitMirror() {
        return CraftItemStack.asCraftMirror(this);
    }

    public org.bukkit.inventory.ItemStack asBukkitCopy() {
        return CraftItemStack.asCraftMirror(this.v());
    }

    public static ItemStack fromBukkitCopy(org.bukkit.inventory.ItemStack itemstack) {
        return CraftItemStack.asNMSCopy(itemstack);
    }

    public org.bukkit.inventory.ItemStack getBukkitStack() {
        if (this.bukkitStack == null || this.bukkitStack.handle != this) {
            this.bukkitStack = CraftItemStack.asCraftMirror(this);
        }
        return this.bukkitStack;
    }

    public IChatBaseComponent y() {
        IChatBaseComponent customName = this.z();
        return customName != null ? customName : this.A();
    }

    @Nullable
    public IChatBaseComponent z() {
        String string;
        IChatBaseComponent component = this.a(DataComponents.g);
        if (component != null) {
            return component;
        }
        WrittenBookContent writtenBookContent = this.a(DataComponents.V);
        if (writtenBookContent != null && !UtilColor.h(string = writtenBookContent.d().a())) {
            return IChatBaseComponent.b(string);
        }
        return null;
    }

    public IChatBaseComponent A() {
        return this.h().a(this);
    }

    public IChatBaseComponent B() {
        IChatMutableComponent mutableComponent = IChatBaseComponent.i().b(this.y()).a(this.D().a());
        if (this.c(DataComponents.g)) {
            mutableComponent.a(EnumChatFormat.u);
        }
        return mutableComponent;
    }

    public <T extends TooltipProvider> void a(DataComponentType<T> component, Item.b context, TooltipDisplay tooltipDisplay, Consumer<IChatBaseComponent> tooltipAdder, TooltipFlag tooltipFlag) {
        TooltipProvider tooltipProvider = (TooltipProvider)this.a(component);
        if (tooltipProvider != null && tooltipDisplay.a(component)) {
            tooltipProvider.a(context, tooltipAdder, tooltipFlag, this.t);
        }
    }

    public List<IChatBaseComponent> a(Item.b tooltipContext, @Nullable EntityHuman player, TooltipFlag tooltipFlag) {
        TooltipDisplay tooltipDisplay = this.a(DataComponents.q, TooltipDisplay.c);
        if (!tooltipFlag.b() && tooltipDisplay.a()) {
            boolean shouldPrintOpWarning = this.h().a(this, player);
            return shouldPrintOpWarning ? m : List.of();
        }
        ArrayList list = Lists.newArrayList();
        list.add(this.B());
        this.a(tooltipContext, tooltipDisplay, player, tooltipFlag, list::add);
        return list;
    }

    public void a(Item.b context, TooltipDisplay tooltipDisplay, @Nullable EntityHuman playef, TooltipFlag tooltipFlag, Consumer<IChatBaseComponent> tooltipAdder) {
        boolean shouldPrintOpWarning;
        AdventureModePredicate adventureModePredicate1;
        AdventureModePredicate adventureModePredicate;
        this.h().a(this, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.a(DataComponents.aC, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.a(DataComponents.ab, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.a(DataComponents.M, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.a(DataComponents.ar, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.a(DataComponents.at, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.a(DataComponents.ap, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.a(DataComponents.am, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.a(DataComponents.ao, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.a(DataComponents.V, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.a(DataComponents.P, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.a(DataComponents.aj, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.a(DataComponents.ai, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.a(DataComponents.R, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.a(DataComponents.ae, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.a(DataComponents.W, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.a(DataComponents.J, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.a(DataComponents.l, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.a(DataComponents.K, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.a(DataComponents.j, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.a(tooltipAdder, tooltipDisplay, playef);
        if (this.c(DataComponents.f) && tooltipDisplay.a(DataComponents.f)) {
            tooltipAdder.accept(n);
        }
        this.a(DataComponents.ad, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.a(DataComponents.T, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.a(DataComponents.aq, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        if ((this.a(Items.ff) || this.a(Items.zN)) && tooltipDisplay.a(DataComponents.aa)) {
            CustomData customData = this.a(DataComponents.aa, CustomData.a);
            Spawner.a(customData, tooltipAdder, "SpawnData");
        }
        if ((adventureModePredicate = this.a(DataComponents.n)) != null && tooltipDisplay.a(DataComponents.n)) {
            tooltipAdder.accept(CommonComponents.a);
            tooltipAdder.accept(AdventureModePredicate.c);
            adventureModePredicate.a(tooltipAdder);
        }
        if ((adventureModePredicate1 = this.a(DataComponents.m)) != null && tooltipDisplay.a(DataComponents.m)) {
            tooltipAdder.accept(CommonComponents.a);
            tooltipAdder.accept(AdventureModePredicate.d);
            adventureModePredicate1.a(tooltipAdder);
        }
        if (tooltipFlag.a()) {
            if (this.n() && tooltipDisplay.a(DataComponents.e)) {
                tooltipAdder.accept(IChatBaseComponent.a("item.durability", this.p() - this.o(), this.p()));
            }
            tooltipAdder.accept(IChatBaseComponent.b(BuiltInRegistries.g.b(this.h()).toString()).a(EnumChatFormat.i));
            int size = this.t.d();
            if (size > 0) {
                tooltipAdder.accept(IChatBaseComponent.a("item.components", size).a(EnumChatFormat.i));
            }
        }
        if (playef != null && !this.h().a(playef.dV().K())) {
            tooltipAdder.accept(p);
        }
        if (shouldPrintOpWarning = this.h().a(this, playef)) {
            m.forEach(tooltipAdder);
        }
    }

    private void a(Consumer<IChatBaseComponent> tooltipAdder, TooltipDisplay tooltipDisplay, @Nullable EntityHuman player) {
        if (tooltipDisplay.a(DataComponents.o)) {
            for (EquipmentSlotGroup equipmentSlotGroup : EquipmentSlotGroup.values()) {
                MutableBoolean mutableBoolean = new MutableBoolean(true);
                this.a(equipmentSlotGroup, (Holder<AttributeBase> attribute, AttributeModifier modifier) -> {
                    if (mutableBoolean.isTrue()) {
                        tooltipAdder.accept(CommonComponents.a);
                        tooltipAdder.accept(IChatBaseComponent.c("item.modifiers." + equipmentSlotGroup.c()).a(EnumChatFormat.h));
                        mutableBoolean.setFalse();
                    }
                    this.a(tooltipAdder, player, (Holder<AttributeBase>)attribute, (AttributeModifier)modifier);
                });
            }
        }
    }

    private void a(Consumer<IChatBaseComponent> tooltipAdder, @Nullable EntityHuman player, Holder<AttributeBase> attribute, AttributeModifier modifier) {
        double amount = modifier.b();
        boolean flag = false;
        if (player != null) {
            if (modifier.a(Item.h)) {
                amount += player.i(GenericAttributes.c);
                flag = true;
            } else if (modifier.a(Item.i)) {
                amount += player.i(GenericAttributes.e);
                flag = true;
            }
        }
        double d2 = modifier.c() == AttributeModifier.Operation.b || modifier.c() == AttributeModifier.Operation.c ? amount * 100.0 : (attribute.a(GenericAttributes.p) ? amount * 10.0 : amount);
        if (flag) {
            tooltipAdder.accept(CommonComponents.a().b(IChatBaseComponent.a("attribute.modifier.equals." + modifier.c().a(), new Object[]{ItemAttributeModifiers.d.format(d2), IChatBaseComponent.c(attribute.a().c())})).a(EnumChatFormat.c));
        } else if (amount > 0.0) {
            tooltipAdder.accept(IChatBaseComponent.a("attribute.modifier.plus." + modifier.c().a(), new Object[]{ItemAttributeModifiers.d.format(d2), IChatBaseComponent.c(attribute.a().c())}).a(attribute.a().b(true)));
        } else if (amount < 0.0) {
            tooltipAdder.accept(IChatBaseComponent.a("attribute.modifier.take." + modifier.c().a(), new Object[]{ItemAttributeModifiers.d.format(-d2), IChatBaseComponent.c(attribute.a().c())}).a(attribute.a().b(false)));
        }
    }

    public boolean C() {
        Boolean _boolean = this.a(DataComponents.t);
        return _boolean != null ? _boolean.booleanValue() : this.h().d_(this);
    }

    public EnumItemRarity D() {
        EnumItemRarity rarity = this.a(DataComponents.k, EnumItemRarity.a);
        if (!this.F()) {
            return rarity;
        }
        return switch (rarity) {
            case EnumItemRarity.a, EnumItemRarity.b -> EnumItemRarity.c;
            case EnumItemRarity.c -> EnumItemRarity.d;
            default -> rarity;
        };
    }

    public boolean E() {
        if (!this.c(DataComponents.C)) {
            return false;
        }
        ItemEnchantments itemEnchantments = this.a(DataComponents.l);
        return itemEnchantments != null && itemEnchantments.d();
    }

    public void a(Holder<Enchantment> enchantment, int level) {
        EnchantmentManager.a(this, (ItemEnchantments.a enchantments) -> enchantments.b(enchantment, level));
    }

    public boolean F() {
        return !this.a(DataComponents.l, ItemEnchantments.a).d();
    }

    public ItemEnchantments G() {
        return this.a(DataComponents.l, ItemEnchantments.a);
    }

    public boolean H() {
        return this.u instanceof EntityItemFrame;
    }

    public void a(@Nullable net.minecraft.world.entity.Entity entity) {
        if (!this.f()) {
            this.u = entity;
        }
    }

    @Nullable
    public EntityItemFrame I() {
        return this.u instanceof EntityItemFrame ? (EntityItemFrame)this.J() : null;
    }

    @Nullable
    public net.minecraft.world.entity.Entity J() {
        return !this.f() ? this.u : null;
    }

    public void a(EquipmentSlotGroup slotGroup, BiConsumer<Holder<AttributeBase>, AttributeModifier> action) {
        ItemAttributeModifiers itemAttributeModifiers = this.a(DataComponents.o, ItemAttributeModifiers.a);
        itemAttributeModifiers.a(slotGroup, action);
        EnchantmentManager.a(this, slotGroup, action);
    }

    public void a(EnumItemSlot equipmentSLot, BiConsumer<Holder<AttributeBase>, AttributeModifier> action) {
        ItemAttributeModifiers itemAttributeModifiers = this.a(DataComponents.o, ItemAttributeModifiers.a);
        itemAttributeModifiers.a(equipmentSLot, action);
        EnchantmentManager.a(this, equipmentSLot, action);
    }

    @Deprecated
    public void setItem(Item item) {
        this.bukkitStack = null;
        this.s = item;
        DataComponentPatch patch = this.d();
        this.t = new PatchedDataComponentMap(this.s.f());
        this.b(patch);
    }

    public IChatBaseComponent K() {
        IChatMutableComponent mutableComponent = IChatBaseComponent.i().b(this.y());
        if (this.c(DataComponents.g)) {
            mutableComponent.a(EnumChatFormat.u);
        }
        IChatMutableComponent mutableComponent1 = ChatComponentUtils.a(mutableComponent);
        if (!this.f()) {
            mutableComponent1.a(this.D().a()).a(style -> style.a(new ChatHoverable.d(this)));
        }
        return mutableComponent1;
    }

    public boolean a(ShapeDetectorBlock block) {
        AdventureModePredicate adventureModePredicate = this.a(DataComponents.m);
        return adventureModePredicate != null && adventureModePredicate.a(block);
    }

    public boolean b(ShapeDetectorBlock block) {
        AdventureModePredicate adventureModePredicate = this.a(DataComponents.n);
        return adventureModePredicate != null && adventureModePredicate.a(block);
    }

    public int L() {
        return this.r;
    }

    public void d(int popTime) {
        this.r = popTime;
    }

    public int M() {
        return this.f() ? 0 : this.q;
    }

    public void e(int count) {
        this.q = count;
    }

    public void f(int maxSize) {
        if (!this.f() && this.M() > maxSize) {
            this.e(maxSize);
        }
    }

    public void g(int increment) {
        this.e(this.M() + increment);
    }

    public void h(int decrement) {
        this.g(-decrement);
    }

    public void a(int amount, @Nullable EntityLiving entity) {
        if (!(entity != null && entity.fV() || this == l)) {
            this.h(amount);
        }
    }

    public ItemStack b(int amount, @Nullable EntityLiving entity) {
        ItemStack itemStack = this.c(amount);
        this.a(amount, entity);
        return itemStack;
    }

    public void b(net.minecraft.world.level.World level, EntityLiving livingEntity, int remainingUseDuration) {
        Consumable consumable = this.a(DataComponents.w);
        if (consumable != null && consumable.a(remainingUseDuration)) {
            consumable.a(livingEntity.dY(), livingEntity, this, 5);
        }
        this.h().a(level, livingEntity, this, remainingUseDuration);
    }

    public void a(EntityItem itemEntity) {
        this.h().a(itemEntity);
    }

    public boolean a(DamageSource damageSource) {
        DamageResistant damageResistant = this.a(DataComponents.z);
        return damageResistant == null || !damageResistant.a(damageSource);
    }

    public boolean c(ItemStack item) {
        Repairable repairable = this.a(DataComponents.E);
        return repairable != null && repairable.a(item);
    }

    public boolean a(IBlockData state, net.minecraft.world.level.World level, BlockPosition pos, EntityHuman player) {
        return this.h().a(this, state, level, pos, (EntityLiving)player);
    }
}

