/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.alchemy;

import io.papermc.paper.potion.PaperPotionMix;
import io.papermc.paper.potion.PotionMix;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.IMaterial;
import org.bukkit.NamespacedKey;

public class PotionBrewer {
    public static final int a = 20;
    public static final PotionBrewer b = new PotionBrewer(List.of(), List.of(), List.of());
    private final List<RecipeItemStack> c;
    private final List<PredicatedCombination<PotionRegistry>> d;
    private final List<PredicatedCombination<Item>> e;
    private final Object2ObjectLinkedOpenHashMap<NamespacedKey, PaperPotionMix> customMixes = new Object2ObjectLinkedOpenHashMap();

    PotionBrewer(List<RecipeItemStack> containers, List<PredicatedCombination<PotionRegistry>> potionMixes, List<PredicatedCombination<Item>> containerMixes) {
        this.c = containers;
        this.d = potionMixes;
        this.e = containerMixes;
    }

    public boolean a(ItemStack stack) {
        return this.b(stack) || this.c(stack) || this.isCustomIngredient(stack);
    }

    private boolean d(ItemStack stack) {
        for (RecipeItemStack ingredient : this.c) {
            if (!ingredient.a(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean b(ItemStack stack) {
        for (PredicatedCombination<Item> mix : this.e) {
            if (!mix.b.a(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean c(ItemStack stack) {
        for (PredicatedCombination<PotionRegistry> mix : this.d) {
            if (!mix.b.a(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean a(Holder<PotionRegistry> potion) {
        for (PredicatedCombination<PotionRegistry> mix : this.d) {
            if (!mix.c.a(potion)) continue;
            return true;
        }
        return false;
    }

    public boolean a(ItemStack reagent, ItemStack potionItem) {
        if (this.hasCustomMix(reagent, potionItem)) {
            return true;
        }
        return this.d(reagent) && (this.b(reagent, potionItem) || this.c(reagent, potionItem));
    }

    public boolean b(ItemStack reagent, ItemStack potionItem) {
        for (PredicatedCombination<Item> mix : this.e) {
            if (!reagent.a(mix.a) || !mix.b.a(potionItem)) continue;
            return true;
        }
        return false;
    }

    public boolean c(ItemStack reagent, ItemStack potionItem) {
        Optional<Holder<PotionRegistry>> optional = reagent.a(DataComponents.R, PotionContents.a).e();
        if (optional.isEmpty()) {
            return false;
        }
        for (PredicatedCombination<PotionRegistry> mix : this.d) {
            if (!mix.a.a(optional.get()) || !mix.b.a(potionItem)) continue;
            return true;
        }
        return false;
    }

    public ItemStack d(ItemStack potion, ItemStack potionItem) {
        if (potionItem.f()) {
            return potionItem;
        }
        for (PaperPotionMix mix : this.customMixes.values()) {
            if (!mix.input().test(potionItem) || !mix.ingredient().test(potion)) continue;
            return mix.result().v();
        }
        Optional<Holder<PotionRegistry>> optional = potionItem.a(DataComponents.R, PotionContents.a).e();
        if (optional.isEmpty()) {
            return potionItem;
        }
        for (PredicatedCombination<Item> predicatedCombination : this.e) {
            if (!potionItem.a(predicatedCombination.a) || !predicatedCombination.b.a(potion)) continue;
            return PotionContents.a((Item)predicatedCombination.c.a(), optional.get());
        }
        for (PredicatedCombination<FeatureElement> predicatedCombination : this.d) {
            if (!predicatedCombination.a.a(optional.get()) || !predicatedCombination.b.a(potion)) continue;
            return PotionContents.a(potionItem.h(), predicatedCombination.c);
        }
        return potionItem;
    }

    public static PotionBrewer a(FeatureFlagSet enabledFeatures) {
        a builder = new a(enabledFeatures);
        PotionBrewer.a(builder);
        return builder.a();
    }

    public static void a(a builder) {
        builder.a(Items.tt);
        builder.a(Items.wz);
        builder.a(Items.wC);
        builder.a(Items.tt, Items.qi, Items.wz);
        builder.a(Items.wz, Items.wy, Items.wC);
        builder.a(Potions.a, Items.sg, Potions.c);
        builder.a(Potions.a, Items.ml, Potions.b);
        builder.a(Potions.a, Items.tr, Potions.d);
        builder.a(Items.vk, Potions.Q);
        builder.a(Items.ms, Potions.S);
        builder.a(Items.b, Potions.T);
        builder.a(Items.cT, Potions.R);
        builder.a(Potions.d, Items.vu, Potions.e);
        builder.a(Potions.e, Items.ml, Potions.f);
        builder.a(Potions.e, Items.tv, Potions.g);
        builder.a(Potions.f, Items.tv, Potions.h);
        builder.a(Potions.g, Items.ml, Potions.h);
        builder.a(Items.tx, Potions.l);
        builder.a(Potions.l, Items.ml, Potions.m);
        builder.a(Items.vO, Potions.i);
        builder.a(Potions.i, Items.ml, Potions.j);
        builder.a(Potions.i, Items.sg, Potions.k);
        builder.a(Potions.i, Items.tv, Potions.q);
        builder.a(Potions.j, Items.tv, Potions.r);
        builder.a(Potions.q, Items.ml, Potions.r);
        builder.a(Potions.q, Items.sg, Potions.s);
        builder.a(Potions.d, Items.pc, Potions.t);
        builder.a(Potions.t, Items.ml, Potions.u);
        builder.a(Potions.t, Items.sg, Potions.v);
        builder.a(Potions.n, Items.tv, Potions.q);
        builder.a(Potions.o, Items.tv, Potions.r);
        builder.a(Items.sI, Potions.n);
        builder.a(Potions.n, Items.ml, Potions.o);
        builder.a(Potions.n, Items.sg, Potions.p);
        builder.a(Potions.d, Items.sk, Potions.w);
        builder.a(Potions.w, Items.ml, Potions.x);
        builder.a(Items.tB, Potions.y);
        builder.a(Potions.y, Items.sg, Potions.z);
        builder.a(Potions.y, Items.tv, Potions.A);
        builder.a(Potions.z, Items.tv, Potions.B);
        builder.a(Potions.A, Items.sg, Potions.B);
        builder.a(Potions.C, Items.tv, Potions.A);
        builder.a(Potions.D, Items.tv, Potions.A);
        builder.a(Potions.E, Items.tv, Potions.B);
        builder.a(Items.tu, Potions.C);
        builder.a(Potions.C, Items.ml, Potions.D);
        builder.a(Potions.C, Items.sg, Potions.E);
        builder.a(Items.tp, Potions.F);
        builder.a(Potions.F, Items.ml, Potions.G);
        builder.a(Potions.F, Items.sg, Potions.H);
        builder.a(Items.tw, Potions.I);
        builder.a(Potions.I, Items.ml, Potions.J);
        builder.a(Potions.I, Items.sg, Potions.K);
        builder.a(Potions.a, Items.tv, Potions.L);
        builder.a(Potions.L, Items.ml, Potions.M);
        builder.a(Potions.d, Items.oC, Potions.O);
        builder.a(Potions.O, Items.ml, Potions.P);
    }

    public boolean isCustomIngredient(ItemStack stack) {
        for (PaperPotionMix mix : this.customMixes.values()) {
            if (!mix.ingredient().test(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean isCustomInput(ItemStack stack) {
        for (PaperPotionMix mix : this.customMixes.values()) {
            if (!mix.input().test(stack)) continue;
            return true;
        }
        return false;
    }

    private boolean hasCustomMix(ItemStack input, ItemStack ingredient) {
        for (PaperPotionMix mix : this.customMixes.values()) {
            if (!mix.input().test(input) || !mix.ingredient().test(ingredient)) continue;
            return true;
        }
        return false;
    }

    public void addPotionMix(PotionMix mix) {
        if (this.customMixes.containsKey((Object)mix.getKey())) {
            throw new IllegalArgumentException("Duplicate recipe ignored with ID " + String.valueOf(mix.getKey()));
        }
        this.customMixes.putAndMoveToFirst((Object)mix.getKey(), (Object)new PaperPotionMix(mix));
    }

    public boolean removePotionMix(NamespacedKey key) {
        return this.customMixes.remove((Object)key) != null;
    }

    public PotionBrewer reload(FeatureFlagSet flags) {
        return PotionBrewer.a(flags);
    }

    record PredicatedCombination<T>(Holder<T> a, RecipeItemStack b, Holder<T> c) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{PredicatedCombination.class, "from;ingredient;to", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PredicatedCombination.class, "from;ingredient;to", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PredicatedCombination.class, "from;ingredient;to", "a", "b", "c"}, this, o2);
        }
    }

    public static class a {
        private final List<RecipeItemStack> a = new ArrayList<RecipeItemStack>();
        private final List<PredicatedCombination<PotionRegistry>> b = new ArrayList<PredicatedCombination<PotionRegistry>>();
        private final List<PredicatedCombination<Item>> c = new ArrayList<PredicatedCombination<Item>>();
        private final FeatureFlagSet d;

        public a(FeatureFlagSet enabledFeatures) {
            this.d = enabledFeatures;
        }

        private static void b(Item item) {
            if (!(item instanceof ItemPotion)) {
                throw new IllegalArgumentException("Expected a potion, got: " + String.valueOf(BuiltInRegistries.g.b(item)));
            }
        }

        public void a(Item input, Item reagent, Item result) {
            if (input.a(this.d) && reagent.a(this.d) && result.a(this.d)) {
                net.minecraft.world.item.alchemy.PotionBrewer$a.b(input);
                net.minecraft.world.item.alchemy.PotionBrewer$a.b(result);
                this.c.add(new PredicatedCombination<Item>(input.e(), RecipeItemStack.a((IMaterial)reagent), result.e()));
            }
        }

        public void a(Item container) {
            if (container.a(this.d)) {
                net.minecraft.world.item.alchemy.PotionBrewer$a.b(container);
                this.a.add(RecipeItemStack.a((IMaterial)container));
            }
        }

        public void a(Holder<PotionRegistry> input, Item reagent, Holder<PotionRegistry> result) {
            if (input.a().a(this.d) && reagent.a(this.d) && result.a().a(this.d)) {
                this.b.add(new PredicatedCombination<PotionRegistry>(input, RecipeItemStack.a((IMaterial)reagent), result));
            }
        }

        public void a(Item reagent, Holder<PotionRegistry> result) {
            if (result.a().a(this.d)) {
                this.a(Potions.a, reagent, Potions.b);
                this.a(Potions.d, reagent, result);
            }
        }

        public PotionBrewer a() {
            return new PotionBrewer(List.copyOf(this.a), List.copyOf(this.b), List.copyOf(this.c));
        }
    }
}

