/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import com.mojang.serialization.MapLike;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.TileEntity;
import org.slf4j.Logger;

public final class CustomData {
    private static final Logger e = LogUtils.getLogger();
    public static final CustomData a = new CustomData(new NBTTagCompound());
    private static final String f = "id";
    public static ThreadLocal<Boolean> SERIALIZE_CUSTOM_AS_SNBT = ThreadLocal.withInitial(() -> false);
    public static final Codec<CustomData> b = Codec.either(NBTTagCompound.a, MojangsonParser.e).xmap(Either::unwrap, data -> {
        if (!SERIALIZE_CUSTOM_AS_SNBT.get().booleanValue()) {
            return Either.left(data);
        }
        return Either.right(data);
    }).xmap(CustomData::new, customData -> customData.g);
    public static final Codec<CustomData> c = b.validate(data -> data.e().i(f).isPresent() ? DataResult.success((Object)data) : DataResult.error(() -> "Missing id for entity in: " + String.valueOf(data)));
    @Deprecated
    public static final StreamCodec<ByteBuf, CustomData> d = ByteBufCodecs.s.a(CustomData::new, (? super O data) -> data.g);
    private final NBTTagCompound g;

    private CustomData(NBTTagCompound tag) {
        this.g = tag;
    }

    public static CustomData a(NBTTagCompound tag) {
        return new CustomData(tag.l());
    }

    public boolean b(NBTTagCompound tag) {
        return GameProfileSerializer.a((NBTBase)tag, this.g, true);
    }

    public static void a(DataComponentType<CustomData> componentType, ItemStack stack, Consumer<NBTTagCompound> updater) {
        CustomData customData = stack.a(componentType, a).a(updater);
        if (customData.g.j()) {
            stack.e(componentType);
        } else {
            stack.b(componentType, customData);
        }
    }

    public static void a(DataComponentType<CustomData> componentType, ItemStack stack, NBTTagCompound tag) {
        if (!tag.j()) {
            stack.b(componentType, CustomData.a(tag));
        } else {
            stack.e(componentType);
        }
    }

    public CustomData a(Consumer<NBTTagCompound> updater) {
        NBTTagCompound compoundTag = this.g.l();
        updater.accept(compoundTag);
        return new CustomData(compoundTag);
    }

    @Nullable
    public MinecraftKey a() {
        return this.g.a(f, MinecraftKey.a).orElse(null);
    }

    @Nullable
    public <T> T a(HolderLookup.a registries, ResourceKey<? extends IRegistry<T>> registryKey) {
        MinecraftKey resourceLocation = this.a();
        return resourceLocation == null ? null : registries.a(registryKey).flatMap(registryLookup -> registryLookup.a(ResourceKey.a(registryKey, resourceLocation))).map(Holder::a).orElse(null);
    }

    public void a(Entity entity) {
        NBTTagCompound compoundTag = entity.h(new NBTTagCompound());
        UUID uuid = entity.cG();
        compoundTag.a(this.g);
        entity.i(compoundTag);
        entity.a_(uuid);
    }

    public boolean a(TileEntity blockEntity, HolderLookup.a levelRegistry) {
        NBTTagCompound compoundTag = blockEntity.e(levelRegistry);
        NBTTagCompound compoundTag1 = compoundTag.l();
        compoundTag.a(this.g);
        if (!compoundTag.equals(compoundTag1)) {
            try {
                blockEntity.d(compoundTag, levelRegistry);
                blockEntity.e();
                return true;
            }
            catch (Exception var8) {
                e.warn("Failed to apply custom data to block entity at {}", (Object)blockEntity.ax_(), (Object)var8);
                try {
                    blockEntity.d(compoundTag1, levelRegistry);
                }
                catch (Exception var7) {
                    e.warn("Failed to rollback block entity at {} after failure", (Object)blockEntity.ax_(), (Object)var7);
                }
            }
        }
        return false;
    }

    public <T> DataResult<CustomData> a(DynamicOps<NBTBase> ops, MapEncoder<T> encoder, T value) {
        return encoder.encode(value, ops, ops.mapBuilder()).build((Object)this.g).map(tag -> new CustomData((NBTTagCompound)tag));
    }

    public <T> DataResult<T> a(MapDecoder<T> decoder) {
        return this.a(DynamicOpsNBT.a, decoder);
    }

    public <T> DataResult<T> a(DynamicOps<NBTBase> ops, MapDecoder<T> decoder) {
        MapLike mapLike = (MapLike)ops.getMap((Object)this.g).getOrThrow();
        return decoder.decode(ops, mapLike);
    }

    public int b() {
        return this.g.i();
    }

    public boolean c() {
        return this.g.j();
    }

    public NBTTagCompound d() {
        return this.g.l();
    }

    public boolean a(String key) {
        return this.g.b(key);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (other == this) return true;
        if (!(other instanceof CustomData)) return false;
        CustomData customData = (CustomData)other;
        if (!this.g.equals(customData.g)) return false;
        return true;
    }

    public int hashCode() {
        return this.g.hashCode();
    }

    public String toString() {
        return this.g.toString();
    }

    @Deprecated
    public NBTTagCompound e() {
        return this.g;
    }
}

