/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.TooltipProvider;

public final class Fireworks
extends Record
implements TooltipProvider {
    private final int d;
    private final List<FireworkExplosion> e;
    public static final int a = 256;
    public static final Codec<Fireworks> b = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.k.optionalFieldOf("flight_duration", (Object)0).forGetter(Fireworks::a), (App)FireworkExplosion.c.sizeLimitedListOf(256).optionalFieldOf("explosions", List.of()).forGetter(Fireworks::b)).apply((Applicative)instance, Fireworks::new));
    public static final StreamCodec<ByteBuf, Fireworks> c = StreamCodec.a(ByteBufCodecs.h, Fireworks::a, FireworkExplosion.d.a(ByteBufCodecs.c(256)), Fireworks::b, Fireworks::new);

    public Fireworks(int flightDuration, List<FireworkExplosion> explosions) {
        if (explosions.size() > 256) {
            throw new IllegalArgumentException("Got " + explosions.size() + " explosions, but maximum is 256");
        }
        this.d = flightDuration;
        this.e = explosions;
    }

    @Override
    public void a(Item.b context, Consumer<IChatBaseComponent> tooltipAdder, TooltipFlag flag, DataComponentGetter componentGetter) {
        if (this.d > 0) {
            tooltipAdder.accept(IChatBaseComponent.c("item.minecraft.firework_rocket.flight").b(CommonComponents.v).f(String.valueOf(this.d)).a(EnumChatFormat.h));
        }
        FireworkExplosion fireworkExplosion = null;
        int i2 = 0;
        for (FireworkExplosion fireworkExplosion1 : this.e) {
            if (fireworkExplosion == null) {
                fireworkExplosion = fireworkExplosion1;
                i2 = 1;
                continue;
            }
            if (fireworkExplosion.equals(fireworkExplosion1)) {
                ++i2;
                continue;
            }
            Fireworks.a(tooltipAdder, fireworkExplosion, i2);
            fireworkExplosion = fireworkExplosion1;
            i2 = 1;
        }
        if (fireworkExplosion != null) {
            Fireworks.a(tooltipAdder, fireworkExplosion, i2);
        }
    }

    private static void a(Consumer<IChatBaseComponent> tooltipAdder, FireworkExplosion explosion, int count) {
        IChatMutableComponent name = explosion.a().a();
        if (count == 1) {
            tooltipAdder.accept(IChatBaseComponent.a("item.minecraft.firework_rocket.single_star", name).a(EnumChatFormat.h));
        } else {
            tooltipAdder.accept(IChatBaseComponent.a("item.minecraft.firework_rocket.multiple_stars", count, name).a(EnumChatFormat.h));
        }
        explosion.a(component -> tooltipAdder.accept(IChatBaseComponent.b("  ").b((IChatBaseComponent)component)));
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{Fireworks.class, "flightDuration;explosions", "d", "e"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Fireworks.class, "flightDuration;explosions", "d", "e"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Fireworks.class, "flightDuration;explosions", "d", "e"}, this, o2);
    }

    public int a() {
        return this.d;
    }

    public List<FireworkExplosion> b() {
        return this.e;
    }
}

