/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.google.common.collect.Iterables;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;

public final class ItemContainerContents
implements TooltipProvider {
    private static final int d = -1;
    public static final int e = 256;
    public static final ItemContainerContents a = new ItemContainerContents(NonNullList.a());
    public static final Codec<ItemContainerContents> b = net.minecraft.world.item.component.ItemContainerContents$a.a.sizeLimitedListOf(256).xmap(ItemContainerContents::b, ItemContainerContents::f);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemContainerContents> c = ItemStack.h.a(ByteBufCodecs.c(256)).a(ByteBufCodecs::increaseDepth).a(ItemContainerContents::new, contents -> contents.f);
    public final NonNullList<ItemStack> f;
    private final int g;

    private ItemContainerContents(NonNullList<ItemStack> items) {
        if (items.size() > 256) {
            throw new IllegalArgumentException("Got " + items.size() + " items, but maximum is 256");
        }
        this.f = items;
        this.g = ItemStack.a(items);
    }

    private ItemContainerContents(int size) {
        this(NonNullList.a(size, ItemStack.l));
    }

    private ItemContainerContents(List<ItemStack> size) {
        this(size.size());
        for (int i2 = 0; i2 < size.size(); ++i2) {
            this.f.set(i2, size.get(i2));
        }
    }

    private static ItemContainerContents b(List<a> slots) {
        OptionalInt optionalInt = slots.stream().mapToInt(a::a).max();
        if (optionalInt.isEmpty()) {
            return a;
        }
        ItemContainerContents itemContainerContents = new ItemContainerContents(optionalInt.getAsInt() + 1);
        for (a slot : slots) {
            itemContainerContents.f.set(slot.a(), slot.b());
        }
        return itemContainerContents;
    }

    public static ItemContainerContents a(List<ItemStack> items) {
        int i2 = ItemContainerContents.c(items);
        if (i2 == -1) {
            return a;
        }
        ItemContainerContents itemContainerContents = new ItemContainerContents(i2 + 1);
        for (int i1 = 0; i1 <= i2; ++i1) {
            itemContainerContents.f.set(i1, items.get(i1).v());
        }
        return itemContainerContents;
    }

    private static int c(List<ItemStack> items) {
        for (int i2 = items.size() - 1; i2 >= 0; --i2) {
            if (items.get(i2).f()) continue;
            return i2;
        }
        return -1;
    }

    private List<a> f() {
        ArrayList<a> list = new ArrayList<a>();
        for (int i2 = 0; i2 < this.f.size(); ++i2) {
            ItemStack itemStack = this.f.get(i2);
            if (itemStack.f()) continue;
            list.add(new a(i2, itemStack));
        }
        return list;
    }

    public void a(NonNullList<ItemStack> list) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ItemStack itemStack = i2 < this.f.size() ? this.f.get(i2) : ItemStack.l;
            list.set(i2, itemStack.v());
        }
    }

    public ItemStack a() {
        return this.f.isEmpty() ? ItemStack.l : this.f.get(0).v();
    }

    public Stream<ItemStack> b() {
        return this.f.stream().map(ItemStack::v);
    }

    public Stream<ItemStack> c() {
        return this.f.stream().filter(stack -> !stack.f()).map(ItemStack::v);
    }

    public Iterable<ItemStack> d() {
        return Iterables.filter(this.f, stack -> !stack.f());
    }

    public Iterable<ItemStack> e() {
        return Iterables.transform(this.d(), ItemStack::v);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof ItemContainerContents)) return false;
        ItemContainerContents itemContainerContents = (ItemContainerContents)other;
        if (!ItemStack.a(this.f, itemContainerContents.f)) return false;
        return true;
    }

    public int hashCode() {
        return this.g;
    }

    @Override
    public void a(Item.b context, Consumer<IChatBaseComponent> tooltipAdder, TooltipFlag flag, DataComponentGetter componentGetter) {
        int i2 = 0;
        int i1 = 0;
        for (ItemStack itemStack : this.d()) {
            ++i1;
            if (i2 > 4) continue;
            ++i2;
            tooltipAdder.accept(IChatBaseComponent.a("item.container.item_count", itemStack.y(), itemStack.M()));
        }
        if (i1 - i2 > 0) {
            tooltipAdder.accept(IChatBaseComponent.a("item.container.more_items", i1 - i2).a(EnumChatFormat.u));
        }
    }

    static final class a
    extends Record {
        private final int b;
        private final ItemStack c;
        public static final Codec<a> a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)255).fieldOf("slot").forGetter(a::a), (App)ItemStack.b.fieldOf("item").forGetter(a::b)).apply((Applicative)instance, a::new));

        a(int index, ItemStack item) {
            this.b = index;
            this.c = item;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "index;item", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "index;item", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "index;item", "b", "c"}, this, o2);
        }

        public int a() {
            return this.b;
        }

        public ItemStack b() {
            return this.c;
        }
    }
}

