/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.item.crafting.display.SmithingRecipeDisplay;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimMaterials;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftSmithingTrimRecipe;
import org.bukkit.craftbukkit.v1_21_R4.inventory.trim.CraftTrimPattern;
import org.bukkit.inventory.Recipe;

public class SmithingTrimRecipe
implements SmithingRecipe {
    final RecipeItemStack d;
    final RecipeItemStack e;
    final RecipeItemStack f;
    final Holder<TrimPattern> g;
    @Nullable
    private PlacementInfo h;
    final boolean copyDataComponents;

    public SmithingTrimRecipe(RecipeItemStack template, RecipeItemStack base, RecipeItemStack addition, Holder<TrimPattern> pattern) {
        this(template, base, addition, pattern, true);
    }

    public SmithingTrimRecipe(RecipeItemStack template, RecipeItemStack base, RecipeItemStack addition, Holder<TrimPattern> pattern, boolean copyDataComponents) {
        this.copyDataComponents = copyDataComponents;
        this.d = template;
        this.e = base;
        this.f = addition;
        this.g = pattern;
    }

    @Override
    public ItemStack a(SmithingRecipeInput input, HolderLookup.a registries) {
        return SmithingTrimRecipe.applyTrim(registries, input.d(), input.e(), this.g, this.copyDataComponents);
    }

    public static ItemStack a(HolderLookup.a registries, ItemStack base, ItemStack addition, Holder<TrimPattern> pattern) {
        return SmithingTrimRecipe.applyTrim(registries, base, addition, pattern, true);
    }

    public static ItemStack applyTrim(HolderLookup.a registries, ItemStack base, ItemStack addition, Holder<TrimPattern> pattern, boolean copyDataComponents) {
        Optional<Holder<TrimMaterial>> fromIngredient = TrimMaterials.a(registries, addition);
        if (fromIngredient.isPresent()) {
            ArmorTrim armorTrim1;
            ArmorTrim armorTrim = base.a(DataComponents.W);
            if (Objects.equals(armorTrim, armorTrim1 = new ArmorTrim(fromIngredient.get(), pattern))) {
                return ItemStack.l;
            }
            ItemStack itemStack = copyDataComponents ? base.c(1) : new ItemStack(base.h(), 1);
            itemStack.b(DataComponents.W, armorTrim1);
            return itemStack;
        }
        return ItemStack.l;
    }

    @Override
    public Optional<RecipeItemStack> c() {
        return Optional.of(this.d);
    }

    @Override
    public RecipeItemStack f() {
        return this.e;
    }

    @Override
    public Optional<RecipeItemStack> k() {
        return Optional.of(this.f);
    }

    @Override
    public RecipeSerializer<SmithingTrimRecipe> a() {
        return RecipeSerializer.u;
    }

    @Override
    public PlacementInfo al_() {
        if (this.h == null) {
            this.h = PlacementInfo.b(List.of(this.d, this.e, this.f));
        }
        return this.h;
    }

    @Override
    public List<RecipeDisplay> g() {
        SlotDisplay slotDisplay = this.e.c();
        SlotDisplay slotDisplay1 = this.f.c();
        SlotDisplay slotDisplay2 = this.d.c();
        return List.of(new SmithingRecipeDisplay(slotDisplay2, slotDisplay, slotDisplay1, new SlotDisplay.g(slotDisplay, slotDisplay1, this.g), new SlotDisplay.d(Items.xB)));
    }

    @Override
    public Recipe toBukkitRecipe(NamespacedKey id) {
        return new CraftSmithingTrimRecipe(id, CraftRecipe.toBukkit(this.d), CraftRecipe.toBukkit(this.e), CraftRecipe.toBukkit(this.f), CraftTrimPattern.minecraftHolderToBukkit(this.g), this.copyDataComponents);
    }

    public static class a
    implements RecipeSerializer<SmithingTrimRecipe> {
        private static final MapCodec<SmithingTrimRecipe> x = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RecipeItemStack.d.fieldOf("template").forGetter(recipe -> recipe.d), (App)RecipeItemStack.d.fieldOf("base").forGetter(recipe -> recipe.e), (App)RecipeItemStack.d.fieldOf("addition").forGetter(recipe -> recipe.f), (App)TrimPattern.c.fieldOf("pattern").forGetter(recipe -> recipe.g)).apply((Applicative)instance, SmithingTrimRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SmithingTrimRecipe> w = StreamCodec.a(RecipeItemStack.a, recipe -> recipe.d, RecipeItemStack.a, recipe -> recipe.e, RecipeItemStack.a, recipe -> recipe.f, TrimPattern.d, recipe -> recipe.g, SmithingTrimRecipe::new);

        @Override
        public MapCodec<SmithingTrimRecipe> a() {
            return x;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, SmithingTrimRecipe> b() {
            return w;
        }
    }
}

