/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import ca.spottedleaf.moonrise.patches.chunk_system.world.ChunkSystemEntityGetter;
import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.entity.HumanEntity;

public interface IEntityAccess
extends ChunkSystemEntityGetter {
    public List<Entity> a(@Nullable Entity var1, AxisAlignedBB var2, Predicate<? super Entity> var3);

    public <T extends Entity> List<T> a(EntityTypeTest<Entity, T> var1, AxisAlignedBB var2, Predicate<? super T> var3);

    default public <T extends Entity> List<T> a(Class<T> entityClass, AxisAlignedBB area, Predicate<? super T> filter) {
        return this.a((EntityTypeTest<Entity, T>)EntityTypeTest.a(entityClass), area, filter);
    }

    public List<? extends EntityHuman> z();

    default public List<Entity> a_(@Nullable Entity entity, AxisAlignedBB area) {
        return this.a(entity, area, IEntitySelector.f);
    }

    @Override
    default public List<Entity> moonrise$getHardCollidingEntities(Entity entity, AxisAlignedBB box, Predicate<? super Entity> predicate) {
        return this.a(entity, box, predicate);
    }

    default public boolean a(@Nullable Entity entity, VoxelShape voxel) {
        if (voxel.c()) {
            return true;
        }
        AxisAlignedBB singleAABB = voxel.moonrise$getSingleAABBRepresentation();
        List<Entity> entities = this.a_(entity, singleAABB == null ? voxel.a() : singleAABB.c(-1.0E-7, -1.0E-7, -1.0E-7));
        int len = entities.size();
        for (int i2 = 0; i2 < len; ++i2) {
            AxisAlignedBB entityBB;
            Entity otherEntity = entities.get(i2);
            if (otherEntity.dQ() || !otherEntity.I || entity != null && otherEntity.z(entity) || singleAABB == null && (CollisionUtil.isEmpty(entityBB = otherEntity.cR()) || !CollisionUtil.voxelShapeIntersectNoEmpty(voxel, entityBB))) continue;
            return false;
        }
        return true;
    }

    default public <T extends Entity> List<T> a(Class<T> entityClass, AxisAlignedBB area) {
        return this.a(entityClass, area, IEntitySelector.f);
    }

    default public List<VoxelShape> c(@Nullable Entity entity, AxisAlignedBB collisionBox) {
        if (CollisionUtil.isEmpty(collisionBox)) {
            return new ArrayList<VoxelShape>();
        }
        collisionBox = collisionBox.c(-1.0E-7, -1.0E-7, -1.0E-7);
        List<Entity> entities = entity != null && entity.moonrise$isHardColliding() ? this.a(entity, collisionBox, null) : this.moonrise$getHardCollidingEntities(entity, collisionBox, null);
        ArrayList<VoxelShape> ret = new ArrayList<VoxelShape>(Math.min(25, entities.size()));
        int len = entities.size();
        for (int i2 = 0; i2 < len; ++i2) {
            Entity otherEntity = entities.get(i2);
            if (otherEntity.ak() || (entity != null || !otherEntity.bL()) && (entity == null || !entity.i(otherEntity))) continue;
            ret.add(VoxelShapes.a(otherEntity.cR()));
        }
        return ret;
    }

    @Nullable
    default public EntityHuman findNearbyPlayer(Entity entity, double maxDistance, @Nullable Predicate<Entity> predicate) {
        return this.a(entity.dA(), entity.dC(), entity.dG(), maxDistance, predicate);
    }

    @Nullable
    default public EntityHuman a(double x2, double y2, double z2, double distance, @Nullable Predicate<Entity> predicate) {
        double d2 = -1.0;
        EntityHuman player = null;
        for (EntityHuman entityHuman : this.z()) {
            if (predicate != null && !predicate.test(entityHuman)) continue;
            double d1 = entityHuman.h(x2, y2, z2);
            if (!(distance < 0.0) && !(d1 < distance * distance) || d2 != -1.0 && !(d1 < d2)) continue;
            d2 = d1;
            player = entityHuman;
        }
        return player;
    }

    default public List<HumanEntity> findNearbyBukkitPlayers(double x2, double y2, double z2, double radius, boolean notSpectator) {
        return this.findNearbyBukkitPlayers(x2, y2, z2, radius, notSpectator ? IEntitySelector.f : IEntitySelector.e);
    }

    default public List<HumanEntity> findNearbyBukkitPlayers(double x2, double y2, double z2, double radius, @Nullable Predicate<Entity> predicate) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (EntityHuman entityHuman : this.z()) {
            if (predicate != null && !predicate.test(entityHuman)) continue;
            double distanceSquared = entityHuman.h(x2, y2, z2);
            if (!(radius < 0.0) && !(distanceSquared < radius * radius)) continue;
            builder.add((Object)entityHuman.getBukkitEntity());
        }
        return builder.build();
    }

    @Nullable
    default public EntityHuman a(Entity entity, double distance) {
        return this.a(entity.dA(), entity.dC(), entity.dG(), distance, false);
    }

    @Nullable
    default public EntityHuman a(double x2, double y2, double z2, double distance, boolean creativePlayers) {
        Predicate<Entity> predicate = creativePlayers ? IEntitySelector.e : IEntitySelector.f;
        return this.a(x2, y2, z2, distance, predicate);
    }

    default public boolean hasNearbyAlivePlayerThatAffectsSpawning(double x2, double y2, double z2, double range) {
        for (EntityHuman entityHuman : this.z()) {
            if (!IEntitySelector.PLAYER_AFFECTS_SPAWNING.test(entityHuman)) continue;
            double distanceSqr = entityHuman.h(x2, y2, z2);
            if (!(range < 0.0) && !(distanceSqr < range * range)) continue;
            return true;
        }
        return false;
    }

    default public boolean a(double x2, double y2, double z2, double distance) {
        for (EntityHuman entityHuman : this.z()) {
            if (!IEntitySelector.f.test(entityHuman) || !IEntitySelector.b.test(entityHuman)) continue;
            double d2 = entityHuman.h(x2, y2, z2);
            if (!(distance < 0.0) && !(d2 < distance * distance)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    default public EntityHuman a(UUID uniqueId) {
        for (int i2 = 0; i2 < this.z().size(); ++i2) {
            EntityHuman player = this.z().get(i2);
            if (!uniqueId.equals(player.cG())) continue;
            return player;
        }
        return null;
    }

    @Nullable
    default public EntityHuman getGlobalPlayerByUUID(UUID uuid) {
        return this.a(uuid);
    }
}

