/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.destroystokyo.paper.event.entity.PreSpawnerSpawnEvent;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftLocation;
import org.bukkit.event.entity.CreatureSpawnEvent;

public abstract class MobSpawnerAbstract {
    public static final String b = "SpawnData";
    private static final int a = 1;
    private static final int c = 20;
    private static final int d = 200;
    private static final int e = 800;
    private static final int f = 4;
    private static final int g = 6;
    private static final int h = 16;
    private static final int i = 4;
    public int j = 20;
    public WeightedList<MobSpawnerData> k = WeightedList.a();
    @Nullable
    public MobSpawnerData l;
    private double m;
    private double n;
    public int o = 200;
    public int p = 800;
    public int q = 4;
    @Nullable
    private Entity r;
    public int s = 6;
    public int t = 16;
    public int u = 4;
    private int tickDelay = 0;

    public void a(EntityTypes<?> type, @Nullable World level, RandomSource random, BlockPosition pos) {
        this.a(level, random, pos).a().a("id", BuiltInRegistries.f.b(type).toString());
        this.k = WeightedList.a();
    }

    public boolean c(World level, BlockPosition pos) {
        return level.hasNearbyAlivePlayerThatAffectsSpawning((double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, this.t);
    }

    public void a(World level, BlockPosition pos) {
        if (!this.c(level, pos)) {
            this.n = this.m;
        } else if (this.r != null) {
            RandomSource random = level.G_();
            double d2 = (double)pos.u() + random.j();
            double d1 = (double)pos.v() + random.j();
            double d22 = (double)pos.w() + random.j();
            level.a(Particles.ah, d2, d1, d22, 0.0, 0.0, 0.0);
            level.a(Particles.F, d2, d1, d22, 0.0, 0.0, 0.0);
            if (this.j > 0) {
                --this.j;
            }
            this.n = this.m;
            this.m = (this.m + (double)(1000.0f / ((float)this.j + 200.0f))) % 360.0;
        }
    }

    public void a(WorldServer serverLevel, BlockPosition pos) {
        if (this.q <= 0 || this.s <= 0) {
            return;
        }
        if (this.j > 0 && --this.tickDelay > 0) {
            return;
        }
        this.tickDelay = serverLevel.paperConfig().tickRates.mobSpawner;
        if (this.tickDelay == -1) {
            return;
        }
        if (this.c(serverLevel, pos)) {
            if (this.j < -this.tickDelay) {
                this.d(serverLevel, pos);
            }
            if (this.j > 0) {
                this.j -= this.tickDelay;
            } else {
                boolean flag = false;
                RandomSource random = serverLevel.G_();
                MobSpawnerData nextSpawnData = this.a((World)serverLevel, random, pos);
                for (int i2 = 0; i2 < this.q; ++i2) {
                    MobSpawnerData.a customSpawnRules;
                    NBTTagCompound entityToSpawn = nextSpawnData.a();
                    Optional<EntityTypes<?>> optional = EntityTypes.a(entityToSpawn);
                    if (optional.isEmpty()) {
                        this.d(serverLevel, pos);
                        return;
                    }
                    Vec3D vec3 = entityToSpawn.a("Pos", Vec3D.a).orElseGet(() -> new Vec3D((double)pos.u() + (random.j() - random.j()) * (double)this.u + 0.5, pos.v() + random.a(3) - 1, (double)pos.w() + (random.j() - random.j()) * (double)this.u + 0.5));
                    if (!serverLevel.b(optional.get().a(vec3.d, vec3.e, vec3.f))) continue;
                    BlockPosition blockPos = BlockPosition.a(vec3);
                    if (!nextSpawnData.b().isPresent() ? !EntityPositionTypes.a(optional.get(), serverLevel, EntitySpawnReason.c, blockPos, serverLevel.G_()) : !optional.get().f().d() && serverLevel.an() == EnumDifficulty.a || !(customSpawnRules = nextSpawnData.b().get()).a(blockPos, serverLevel)) continue;
                    PreSpawnerSpawnEvent event = new PreSpawnerSpawnEvent(CraftLocation.toBukkit(vec3, (org.bukkit.World)serverLevel.getWorld()), CraftEntityType.minecraftToBukkit(optional.get()), CraftLocation.toBukkit(pos, (World)serverLevel));
                    if (!event.callEvent()) {
                        flag = true;
                        if (!event.shouldAbortSpawn()) continue;
                        break;
                    }
                    Entity entity = EntityTypes.a(entityToSpawn, (World)serverLevel, EntitySpawnReason.c, entity1 -> {
                        entity1.b(vec3.d, vec3.e, vec3.f, entity1.dL(), entity1.dN());
                        return entity1;
                    });
                    if (entity == null) {
                        this.d(serverLevel, pos);
                        return;
                    }
                    int size = serverLevel.a(EntityTypeTest.b(entity.getClass()), new AxisAlignedBB(pos.u(), pos.v(), pos.w(), pos.u() + 1, pos.v() + 1, pos.w() + 1).g(this.u), IEntitySelector.f).size();
                    if (size >= this.s) {
                        this.d(serverLevel, pos);
                        return;
                    }
                    entity.preserveMotion = true;
                    entity.b(entity.dA(), entity.dC(), entity.dG(), random.i() * 360.0f, 0.0f);
                    if (entity instanceof EntityInsentient) {
                        boolean flag1;
                        EntityInsentient mob = (EntityInsentient)entity;
                        if (nextSpawnData.b().isEmpty() && !mob.a((GeneratorAccess)serverLevel, EntitySpawnReason.c) || !mob.a((IWorldReader)serverLevel)) continue;
                        boolean bl = flag1 = nextSpawnData.a().i() == 1 && nextSpawnData.a().i("id").isPresent();
                        if (flag1) {
                            ((EntityInsentient)entity).a((WorldAccess)serverLevel, serverLevel.d_(entity.dv()), EntitySpawnReason.c, null);
                        }
                        nextSpawnData.c().ifPresent(mob::a);
                        if (mob.dV().spigotConfig.nerfSpawnerMobs) {
                            mob.aware = false;
                        }
                    }
                    entity.spawnedViaMobSpawner = true;
                    entity.spawnReason = CreatureSpawnEvent.SpawnReason.SPAWNER;
                    flag = true;
                    if (CraftEventFactory.callSpawnerSpawnEvent(entity, pos).isCancelled()) continue;
                    if (!serverLevel.tryAddFreshEntityWithPassengers(entity, CreatureSpawnEvent.SpawnReason.SPAWNER)) {
                        this.d(serverLevel, pos);
                        return;
                    }
                    serverLevel.c(2004, pos, 0);
                    serverLevel.a(entity, GameEvent.t, blockPos);
                    if (!(entity instanceof EntityInsentient)) continue;
                    ((EntityInsentient)entity).T();
                }
                if (flag) {
                    this.d(serverLevel, pos);
                }
            }
        }
    }

    public void d(World level, BlockPosition pos) {
        RandomSource randomSource = level.A;
        this.j = this.p <= this.o ? this.o : this.o + randomSource.a(this.p - this.o);
        this.k.a(randomSource).ifPresent(spawnData -> this.a(level, pos, (MobSpawnerData)spawnData));
        this.a(level, pos, 1);
    }

    public void a(@Nullable World level, BlockPosition pos, NBTTagCompound tag) {
        this.j = tag.b("Paper.Delay", (int)tag.b("Delay", (short)20));
        tag.a(b, MobSpawnerData.b).ifPresent(spawnData -> this.a(level, pos, (MobSpawnerData)spawnData));
        this.k = tag.a("SpawnPotentials", MobSpawnerData.c).orElseGet(() -> WeightedList.a(this.l != null ? this.l : new MobSpawnerData()));
        this.o = tag.b("Paper.MinSpawnDelay", tag.b("MinSpawnDelay", 200));
        this.p = tag.b("Paper.MaxSpawnDelay", tag.b("MaxSpawnDelay", 800));
        this.q = tag.b("SpawnCount", 4);
        this.s = tag.b("MaxNearbyEntities", 6);
        this.t = tag.b("RequiredPlayerRange", 16);
        this.u = tag.b("SpawnRange", 4);
        this.r = null;
    }

    public NBTTagCompound a(NBTTagCompound tag) {
        if (this.j > Short.MAX_VALUE) {
            tag.a("Paper.Delay", this.j);
        }
        tag.a("Delay", (short)Math.min(Short.MAX_VALUE, this.j));
        if (this.o > Short.MAX_VALUE || this.p > Short.MAX_VALUE) {
            tag.a("Paper.MinSpawnDelay", this.o);
            tag.a("Paper.MaxSpawnDelay", this.p);
        }
        tag.a("MinSpawnDelay", (short)Math.min(Short.MAX_VALUE, this.o));
        tag.a("MaxSpawnDelay", (short)Math.min(Short.MAX_VALUE, this.p));
        tag.a("SpawnCount", (short)this.q);
        tag.a("MaxNearbyEntities", (short)this.s);
        tag.a("RequiredPlayerRange", (short)this.t);
        tag.a("SpawnRange", (short)this.u);
        tag.b(b, MobSpawnerData.b, this.l);
        tag.a("SpawnPotentials", MobSpawnerData.c, this.k);
        return tag;
    }

    @Nullable
    public Entity b(World level, BlockPosition pos) {
        if (this.r == null) {
            NBTTagCompound entityToSpawn = this.a(level, level.G_(), pos).a();
            if (entityToSpawn.i("id").isEmpty()) {
                return null;
            }
            this.r = EntityTypes.a(entityToSpawn, level, EntitySpawnReason.c, Function.identity());
            if (entityToSpawn.i() != 1 || this.r instanceof EntityInsentient) {
                // empty if block
            }
        }
        return this.r;
    }

    public boolean a(World level, int id) {
        if (id == 1) {
            if (level.C) {
                this.j = this.o;
            }
            return true;
        }
        return false;
    }

    public void a(@Nullable World level, BlockPosition pos, MobSpawnerData nextSpawnData) {
        this.l = nextSpawnData;
    }

    private MobSpawnerData a(@Nullable World level, RandomSource random, BlockPosition pos) {
        if (this.l != null) {
            return this.l;
        }
        this.a(level, pos, this.k.a(random).orElseGet(MobSpawnerData::new));
        return this.l;
    }

    public abstract void a(World var1, BlockPosition var2, int var3);

    public double a() {
        return this.m;
    }

    public double b() {
        return this.n;
    }
}

