/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import ca.spottedleaf.moonrise.patches.collisions.ExplosionBlockCache;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.event.entity.EntityKnockbackEvent;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.item.EntityTNTPrimed;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.ExplosionDamageCalculatorEntity;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDirectional;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.block.BlockTNT;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.piston.TileEntityPiston;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.Location;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftVector;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.TNTPrimeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;

public class ServerExplosion
implements Explosion {
    private static final ExplosionDamageCalculator a = new ExplosionDamageCalculator();
    private static final int b = 16;
    private static final float c = 2.0f;
    private final boolean d;
    private final Explosion.Effect e;
    private final WorldServer f;
    private final Vec3D g;
    @Nullable
    private final Entity h;
    private final float i;
    private final DamageSource j;
    private final ExplosionDamageCalculator k;
    private final Map<EntityHuman, Vec3D> l = new HashMap<EntityHuman, Vec3D>();
    public boolean wasCanceled = false;
    public float yield;
    public boolean excludeSourceFromDamage = true;
    private static final double[] CACHED_RAYS;
    private static final int CHUNK_CACHE_SHIFT = 2;
    private static final int CHUNK_CACHE_MASK = 3;
    private static final int CHUNK_CACHE_WIDTH = 4;
    private static final int BLOCK_EXPLOSION_CACHE_SHIFT = 3;
    private static final int BLOCK_EXPLOSION_CACHE_MASK = 7;
    private static final int BLOCK_EXPLOSION_CACHE_WIDTH = 8;
    private static final Float ZERO_RESISTANCE;
    private Long2ObjectOpenHashMap<ExplosionBlockCache> blockCache = null;
    private long[] chunkPosCache = null;
    private Chunk[] chunkCache = null;
    private ExplosionBlockCache[] directMappedBlockCache;
    private BlockPosition.MutableBlockPosition mutablePos;

    private ExplosionBlockCache getOrCacheExplosionBlock(int x2, int y2, int z2, long key, boolean calculateResistance) {
        ExplosionBlockCache ret = (ExplosionBlockCache)this.blockCache.get(key);
        if (ret != null) {
            return ret;
        }
        BlockPosition pos = new BlockPosition(x2, y2, z2);
        if (!this.f.k(pos)) {
            ret = new ExplosionBlockCache(key, pos, null, null, 0.0f, true);
        } else {
            Chunk chunk;
            int chunkCacheKey = x2 >> 4 & 3 | z2 >> 4 << 2 & 0xC;
            long chunkKey = CoordinateUtils.getChunkKey(x2 >> 4, z2 >> 4);
            if (this.chunkPosCache[chunkCacheKey] == chunkKey) {
                chunk = this.chunkCache[chunkCacheKey];
            } else {
                this.chunkPosCache[chunkCacheKey] = chunkKey;
                this.chunkCache[chunkCacheKey] = chunk = this.f.d(x2 >> 4, z2 >> 4);
            }
            IBlockData blockState = chunk.moonrise$getBlock(x2, y2, z2);
            Fluid fluidState = blockState.y();
            Optional<Float> resistance = !calculateResistance ? Optional.empty() : this.k.a((Explosion)this, (IBlockAccess)this.f, pos, blockState, fluidState);
            ret = new ExplosionBlockCache(key, pos, blockState, fluidState, (resistance.orElse(ZERO_RESISTANCE).floatValue() + 0.3f) * 0.3f, false);
        }
        this.blockCache.put(key, (Object)ret);
        return ret;
    }

    private boolean clipsAnything(Vec3D from, Vec3D to, CollisionUtil.LazyEntityCollisionContext context, ExplosionBlockCache[] blockCache, BlockPosition.MutableBlockPosition currPos) {
        double adjX = 1.0E-7 * (from.d - to.d);
        double adjY = 1.0E-7 * (from.e - to.e);
        double adjZ = 1.0E-7 * (from.f - to.f);
        if (adjX == 0.0 && adjY == 0.0 && adjZ == 0.0) {
            return false;
        }
        double toXAdj = to.d - adjX;
        double toYAdj = to.e - adjY;
        double toZAdj = to.f - adjZ;
        double fromXAdj = from.d + adjX;
        double fromYAdj = from.e + adjY;
        double fromZAdj = from.f + adjZ;
        int currX = MathHelper.a(fromXAdj);
        int currY = MathHelper.a(fromYAdj);
        int currZ = MathHelper.a(fromZAdj);
        double diffX = toXAdj - fromXAdj;
        double diffY = toYAdj - fromYAdj;
        double diffZ = toZAdj - fromZAdj;
        double dxDouble = Math.signum(diffX);
        double dyDouble = Math.signum(diffY);
        double dzDouble = Math.signum(diffZ);
        int dx = (int)dxDouble;
        int dy = (int)dyDouble;
        int dz = (int)dzDouble;
        double normalizedDiffX = diffX == 0.0 ? Double.MAX_VALUE : dxDouble / diffX;
        double normalizedDiffY = diffY == 0.0 ? Double.MAX_VALUE : dyDouble / diffY;
        double normalizedDiffZ = diffZ == 0.0 ? Double.MAX_VALUE : dzDouble / diffZ;
        double normalizedCurrX = normalizedDiffX * (diffX > 0.0 ? 1.0 - MathHelper.e(fromXAdj) : MathHelper.e(fromXAdj));
        double normalizedCurrY = normalizedDiffY * (diffY > 0.0 ? 1.0 - MathHelper.e(fromYAdj) : MathHelper.e(fromYAdj));
        double normalizedCurrZ = normalizedDiffZ * (diffZ > 0.0 ? 1.0 - MathHelper.e(fromZAdj) : MathHelper.e(fromZAdj));
        while (true) {
            IBlockData blockState;
            currPos.d(currX, currY, currZ);
            long key = BlockPosition.a(currX, currY, currZ);
            int cacheKey = currX & 7 | (currY & 7) << 3 | (currZ & 7) << 6;
            ExplosionBlockCache cachedBlock = blockCache[cacheKey];
            if (cachedBlock == null || cachedBlock.key != key) {
                blockCache[cacheKey] = cachedBlock = this.getOrCacheExplosionBlock(currX, currY, currZ, key, false);
            }
            if ((blockState = cachedBlock.blockState) != null && !blockState.moonrise$emptyContextCollisionShape()) {
                VoxelShape collision = cachedBlock.cachedCollisionShape;
                if (collision == null) {
                    collision = blockState.moonrise$getConstantContextCollisionShape();
                    if (collision == null) {
                        collision = blockState.b((IBlockAccess)this.f, (BlockPosition)currPos, context);
                        if (!context.isDelegated()) {
                            cachedBlock.cachedCollisionShape = collision;
                        }
                    } else {
                        cachedBlock.cachedCollisionShape = collision;
                    }
                }
                if (!collision.c() && collision.a(from, to, currPos) != null) {
                    return true;
                }
            }
            if (normalizedCurrX > 1.0 && normalizedCurrY > 1.0 && normalizedCurrZ > 1.0) {
                return false;
            }
            if (normalizedCurrX < normalizedCurrY) {
                if (normalizedCurrX < normalizedCurrZ) {
                    currX += dx;
                    normalizedCurrX += normalizedDiffX;
                    continue;
                }
                currZ += dz;
                normalizedCurrZ += normalizedDiffZ;
                continue;
            }
            if (normalizedCurrY < normalizedCurrZ) {
                currY += dy;
                normalizedCurrY += normalizedDiffY;
                continue;
            }
            currZ += dz;
            normalizedCurrZ += normalizedDiffZ;
        }
    }

    private float getSeenFraction(Vec3D source, Entity target, ExplosionBlockCache[] blockCache, BlockPosition.MutableBlockPosition blockPos) {
        AxisAlignedBB boundingBox = target.cR();
        double diffX = boundingBox.d - boundingBox.a;
        double diffY = boundingBox.e - boundingBox.b;
        double diffZ = boundingBox.f - boundingBox.c;
        double incX = 1.0 / (diffX * 2.0 + 1.0);
        double incY = 1.0 / (diffY * 2.0 + 1.0);
        double incZ = 1.0 / (diffZ * 2.0 + 1.0);
        if (incX < 0.0 || incY < 0.0 || incZ < 0.0) {
            return 0.0f;
        }
        double offX = (1.0 - Math.floor(1.0 / incX) * incX) * 0.5 + boundingBox.a;
        double offY = boundingBox.b;
        double offZ = (1.0 - Math.floor(1.0 / incZ) * incZ) * 0.5 + boundingBox.c;
        CollisionUtil.LazyEntityCollisionContext context = new CollisionUtil.LazyEntityCollisionContext(target);
        int totalRays = 0;
        int missedRays = 0;
        for (double dx = 0.0; dx <= 1.0; dx += incX) {
            double fromX = Math.fma(dx, diffX, offX);
            for (double dy = 0.0; dy <= 1.0; dy += incY) {
                double fromY = Math.fma(dy, diffY, offY);
                for (double dz = 0.0; dz <= 1.0; dz += incZ) {
                    ++totalRays;
                    Vec3D from = new Vec3D(fromX, fromY, Math.fma(dz, diffZ, offZ));
                    if (this.clipsAnything(from, source, context, blockCache, blockPos)) continue;
                    ++missedRays;
                }
            }
        }
        return (float)missedRays / (float)totalRays;
    }

    public ServerExplosion(WorldServer level, @Nullable Entity source, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator damageCalculator, Vec3D center, float radius, boolean fire, Explosion.Effect blockInteraction) {
        this.f = level;
        this.h = source;
        this.i = (float)Math.max((double)radius, 0.0);
        this.g = center;
        this.d = fire;
        this.e = blockInteraction;
        this.j = damageSource == null ? level.al().a(this) : damageSource;
        this.k = damageCalculator == null ? this.b(source) : damageCalculator;
        this.yield = this.e == Explosion.Effect.c ? 1.0f / this.i : 1.0f;
    }

    private ExplosionDamageCalculator b(@Nullable Entity entity) {
        return entity == null ? a : new ExplosionDamageCalculatorEntity(entity);
    }

    public static float a(Vec3D explosionVector, Entity entity) {
        AxisAlignedBB boundingBox = entity.cR();
        double d2 = 1.0 / ((boundingBox.d - boundingBox.a) * 2.0 + 1.0);
        double d1 = 1.0 / ((boundingBox.e - boundingBox.b) * 2.0 + 1.0);
        double d22 = 1.0 / ((boundingBox.f - boundingBox.c) * 2.0 + 1.0);
        double d3 = (1.0 - Math.floor(1.0 / d2) * d2) / 2.0;
        double d4 = (1.0 - Math.floor(1.0 / d22) * d22) / 2.0;
        if (!(d2 < 0.0 || d1 < 0.0 || d22 < 0.0)) {
            int i2 = 0;
            int i1 = 0;
            for (double d5 = 0.0; d5 <= 1.0; d5 += d2) {
                for (double d6 = 0.0; d6 <= 1.0; d6 += d1) {
                    for (double d7 = 0.0; d7 <= 1.0; d7 += d22) {
                        double d8 = MathHelper.d(d5, boundingBox.a, boundingBox.d);
                        double d9 = MathHelper.d(d6, boundingBox.b, boundingBox.e);
                        double d10 = MathHelper.d(d7, boundingBox.c, boundingBox.f);
                        Vec3D vec3 = new Vec3D(d8 + d3, d9, d10 + d4);
                        if (entity.dV().a(new RayTrace(vec3, explosionVector, RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, entity)).d() == MovingObjectPosition.EnumMovingObjectType.a) {
                            ++i2;
                        }
                        ++i1;
                    }
                }
            }
            return (float)i2 / (float)i1;
        }
        return 0.0f;
    }

    @Override
    public float e() {
        return this.i;
    }

    @Override
    public Vec3D f() {
        return this.g;
    }

    private List<BlockPosition> m() {
        ObjectArrayList ret = new ObjectArrayList();
        Vec3D center = this.g;
        ExplosionBlockCache[] blockCache = this.directMappedBlockCache;
        int blockX = MathHelper.a(center.d);
        int blockY = MathHelper.a(center.e);
        int blockZ = MathHelper.a(center.f);
        long key = BlockPosition.a(blockX, blockY, blockZ);
        ExplosionBlockCache initialCache = this.getOrCacheExplosionBlock(blockX, blockY, blockZ, key, true);
        int ray = 0;
        int len = CACHED_RAYS.length;
        block0: while (ray < len) {
            ExplosionBlockCache cachedBlock = initialCache;
            double currX = center.d;
            double currY = center.e;
            double currZ = center.f;
            double incX = CACHED_RAYS[ray];
            double incY = CACHED_RAYS[ray + 1];
            double incZ = CACHED_RAYS[ray + 2];
            ray += 3;
            float power = this.i * (0.7f + this.f.A.i() * 0.6f);
            do {
                int cacheKey;
                int blockZ2;
                int blockY2;
                int blockX2;
                long key2;
                if (cachedBlock.key != (key2 = BlockPosition.a(blockX2 = MathHelper.a(currX), blockY2 = MathHelper.a(currY), blockZ2 = MathHelper.a(currZ))) && ((cachedBlock = blockCache[cacheKey = blockX2 & 7 | (blockY2 & 7) << 3 | (blockZ2 & 7) << 6]) == null || cachedBlock.key != key2)) {
                    blockCache[cacheKey] = cachedBlock = this.getOrCacheExplosionBlock(blockX2, blockY2, blockZ2, key2, true);
                }
                if (cachedBlock.outOfWorld) continue block0;
                IBlockData iblockdata = cachedBlock.blockState;
                if ((power -= cachedBlock.resistance) > 0.0f && cachedBlock.shouldExplode == null) {
                    boolean shouldExplode = iblockdata.isDestroyable() && this.k.a((Explosion)this, (IBlockAccess)this.f, cachedBlock.immutablePos, cachedBlock.blockState, power);
                    Boolean bl = cachedBlock.shouldExplode = shouldExplode ? Boolean.TRUE : Boolean.FALSE;
                    if (shouldExplode && (this.d || !cachedBlock.blockState.l())) {
                        TileEntityPiston blockEntity;
                        TileEntity extension;
                        ret.add((Object)cachedBlock.immutablePos);
                        if (!GlobalConfiguration.get().unsupportedSettings.allowHeadlessPistons && iblockdata.b() == Blocks.ca && (extension = this.f.c_(cachedBlock.immutablePos)) instanceof TileEntityPiston && (blockEntity = (TileEntityPiston)extension).d()) {
                            EnumDirection direction = iblockdata.c(BlockDirectional.a);
                            ret.add((Object)cachedBlock.immutablePos.a(direction.g()));
                        }
                    }
                }
                currX += incX;
                currY += incY;
                currZ += incZ;
            } while ((power -= 0.22500001f) > 0.0f);
        }
        return ret;
    }

    private void n() {
        float f2 = this.i * 2.0f;
        int floor = MathHelper.a(this.g.d - (double)f2 - 1.0);
        int floor1 = MathHelper.a(this.g.d + (double)f2 + 1.0);
        int floor2 = MathHelper.a(this.g.e - (double)f2 - 1.0);
        int floor3 = MathHelper.a(this.g.e + (double)f2 + 1.0);
        int floor4 = MathHelper.a(this.g.f - (double)f2 - 1.0);
        int floor5 = MathHelper.a(this.g.f + (double)f2 + 1.0);
        List<Entity> list = this.f.a(this.excludeSourceFromDamage ? this.h : null, new AxisAlignedBB(floor, floor2, floor4, floor1, floor3, floor5), entity -> entity.bJ() && !entity.ak());
        for (Entity entity2 : list) {
            EntityHuman player;
            double d5;
            float f1;
            double d3;
            double d2;
            double d1;
            double squareRoot;
            double d4;
            if (entity2.a(this) || !((d4 = Math.sqrt(entity2.g(this.g)) / (double)f2) <= 1.0) || (squareRoot = Math.sqrt((d1 = entity2.dA() - this.g.d) * d1 + (d2 = (entity2 instanceof EntityTNTPrimed ? entity2.dC() : entity2.dE()) - this.g.e) * d2 + (d3 = entity2.dG() - this.g.f) * d3)) == 0.0) continue;
            d1 /= squareRoot;
            d2 /= squareRoot;
            d3 /= squareRoot;
            boolean shouldDamageEntity = this.k.a(this, entity2);
            float knockbackMultiplier = this.k.a(entity2);
            float f3 = f1 = !shouldDamageEntity && knockbackMultiplier == 0.0f ? 0.0f : this.getBlockDensity(this.g, entity2);
            if (shouldDamageEntity) {
                if (entity2 instanceof EntityComplexPart) continue;
                entity2.lastDamageCancelled = false;
                if (entity2 instanceof EntityEnderDragon) {
                    for (EntityComplexPart dragonPart : ((EntityEnderDragon)entity2).gq()) {
                        if (!list.contains(dragonPart)) continue;
                        dragonPart.a(this.f, this.j, this.k.a(this, dragonPart, f1));
                    }
                } else {
                    entity2.a(this.f, this.j, this.k.a(this, entity2, f1));
                }
                if (entity2.lastDamageCancelled) continue;
            }
            double d42 = (1.0 - d4) * (double)f1 * (double)knockbackMultiplier;
            if (entity2 instanceof EntityLiving) {
                EntityLiving livingEntity = (EntityLiving)entity2;
                d5 = entity2 instanceof EntityHuman && this.f.paperConfig().environment.disableExplosionKnockback ? 0.0 : d42 * (1.0 - livingEntity.h(GenericAttributes.i));
            } else {
                d5 = d42;
            }
            Vec3D vec3 = new Vec3D(d1 *= d5, d2 *= d5, d3 *= d5);
            if (entity2 instanceof EntityLiving) {
                EntityKnockbackEvent event = CraftEventFactory.callEntityKnockbackEvent((CraftLivingEntity)entity2.getBukkitEntity(), this.h, this.j.d() != null ? this.j.d() : this.h, EntityKnockbackEvent.Cause.EXPLOSION, d5, vec3);
                vec3 = event.isCancelled() ? Vec3D.c : CraftVector.toVec3(event.getKnockback());
            }
            entity2.h(vec3);
            if (!(!(entity2 instanceof EntityHuman) || (player = (EntityHuman)entity2).ak() || player.gz() && player.gk().b || this.f.paperConfig().environment.disableExplosionKnockback)) {
                this.l.put(player, vec3);
            }
            entity2.b_(this.h);
        }
    }

    private void a(List<BlockPosition> blocks) {
        List bukkitBlocks;
        ArrayList list = new ArrayList();
        SystemUtils.c(blocks, this.f.A);
        Location location = CraftLocation.toBukkit(this.g, (org.bukkit.World)this.f.getWorld());
        ObjectArrayList blockList = new ObjectArrayList();
        for (int i1 = blocks.size() - 1; i1 >= 0; --i1) {
            CraftBlock bblock = CraftBlock.at(this.f, blocks.get(i1));
            if (bblock.getType().isAir()) continue;
            blockList.add(bblock);
        }
        if (this.h != null) {
            EntityExplodeEvent event = CraftEventFactory.callEntityExplodeEvent(this.h, (List<org.bukkit.block.Block>)blockList, this.yield, this.b());
            this.wasCanceled = event.isCancelled();
            bukkitBlocks = event.blockList();
            this.yield = event.getYield();
        } else {
            org.bukkit.block.Block block = location.getBlock();
            BlockState blockState = this.j.causingBlockSnapshot() != null ? this.j.causingBlockSnapshot() : block.getState();
            BlockExplodeEvent event = CraftEventFactory.callBlockExplodeEvent(block, blockState, (List<org.bukkit.block.Block>)blockList, this.yield, this.b());
            this.wasCanceled = event.isCancelled();
            bukkitBlocks = event.blockList();
            this.yield = event.getYield();
        }
        blocks.clear();
        for (org.bukkit.block.Block bblock : bukkitBlocks) {
            blocks.add(((CraftBlock)bblock).getPosition());
        }
        if (this.wasCanceled) {
            return;
        }
        for (BlockPosition blockPos : blocks) {
            IBlockData state = this.f.a_(blockPos);
            Block block = state.b();
            if (this.f.O().c(GameRules.ad) && block instanceof BlockTNT) {
                BlockPosition sourceBlock;
                Entity sourceEntity = this.h == null ? null : this.h;
                BlockPosition blockPosition = sourceBlock = sourceEntity == null ? BlockPosition.a(this.g) : null;
                if (!CraftEventFactory.callTNTPrimeEvent(this.f, blockPos, TNTPrimeEvent.PrimeCause.EXPLOSION, sourceEntity, sourceBlock)) {
                    this.f.a(blockPos, Blocks.a.m(), state, 3);
                    continue;
                }
            }
            this.f.a_(blockPos).a(this.f, blockPos, this, (itemStack, blockPos1) -> ServerExplosion.a(list, itemStack, blockPos1));
        }
        for (a stackCollector : list) {
            Block.a((World)this.f, stackCollector.a, stackCollector.b);
        }
    }

    private void b(List<BlockPosition> blocks) {
        for (BlockPosition blockPos : blocks) {
            if (this.f.A.a(3) != 0 || !this.f.a_(blockPos).l() || !this.f.a_(blockPos.e()).s() || CraftEventFactory.callBlockIgniteEvent((World)this.f, blockPos, this).isCancelled()) continue;
            this.f.b(blockPos, BlockFireAbstract.a(this.f, blockPos));
        }
    }

    public void i() {
        if (this.i < 0.1f) {
            return;
        }
        this.blockCache = new Long2ObjectOpenHashMap();
        this.chunkPosCache = new long[16];
        Arrays.fill(this.chunkPosCache, ChunkCoordIntPair.c);
        this.chunkCache = new Chunk[16];
        this.directMappedBlockCache = new ExplosionBlockCache[512];
        this.mutablePos = new BlockPosition.MutableBlockPosition();
        this.f.a(this.h, GameEvent.w, this.g);
        List<BlockPosition> list = this.m();
        this.n();
        if (this.o()) {
            GameProfilerFiller profilerFiller = Profiler.a();
            profilerFiller.a("explosion_blocks");
            this.a(list);
            profilerFiller.c();
        }
        if (this.d) {
            this.b(list);
        }
        this.blockCache = null;
        this.chunkPosCache = null;
        this.chunkCache = null;
        this.directMappedBlockCache = null;
        this.mutablePos = null;
    }

    private static void a(List<a> stackCollectors, ItemStack stack, BlockPosition pos) {
        for (a stackCollector : stackCollectors) {
            stackCollector.a(stack);
            if (!stack.f()) continue;
            return;
        }
        stackCollectors.add(new a(pos, stack));
    }

    private boolean o() {
        return this.e != Explosion.Effect.a;
    }

    public Map<EntityHuman, Vec3D> j() {
        return this.l;
    }

    @Override
    public WorldServer a() {
        return this.f;
    }

    @Override
    @Nullable
    public EntityLiving c() {
        return Explosion.a(this.h);
    }

    @Override
    @Nullable
    public Entity d() {
        return this.h;
    }

    public DamageSource k() {
        return this.j;
    }

    @Override
    public Explosion.Effect b() {
        return this.e;
    }

    @Override
    public boolean g() {
        return this.e == Explosion.Effect.d && (this.h == null || this.h.an() != EntityTypes.t || this.f.O().c(GameRules.d));
    }

    @Override
    public boolean h() {
        boolean flag1;
        boolean _boolean = this.f.O().c(GameRules.d);
        boolean flag = this.h == null || !this.h.bi();
        boolean bl = flag1 = this.h == null || this.h.an() != EntityTypes.t && this.h.an() != EntityTypes.bI;
        return _boolean ? flag && flag1 : this.e.a() && flag && flag1;
    }

    public boolean l() {
        return this.i < 2.0f || !this.o();
    }

    private float getBlockDensity(Vec3D vec3d, Entity entity) {
        if (!this.f.paperConfig().environment.optimizeExplosions) {
            return this.getSeenFraction(vec3d, entity, this.directMappedBlockCache, this.mutablePos);
        }
        CacheKey key = new CacheKey(this, entity.cR());
        Float blockDensity = this.f.explosionDensityCache.get(key);
        if (blockDensity == null) {
            blockDensity = Float.valueOf(this.getSeenFraction(vec3d, entity, this.directMappedBlockCache, this.mutablePos));
            this.f.explosionDensityCache.put(key, blockDensity);
        }
        return blockDensity.floatValue();
    }

    static {
        DoubleArrayList rayCoords = new DoubleArrayList();
        for (int x2 = 0; x2 <= 15; ++x2) {
            for (int y2 = 0; y2 <= 15; ++y2) {
                for (int z2 = 0; z2 <= 15; ++z2) {
                    if (x2 != 0 && x2 != 15 && y2 != 0 && y2 != 15 && z2 != 0 && z2 != 15) continue;
                    double xDir = (float)x2 / 15.0f * 2.0f - 1.0f;
                    double yDir = (float)y2 / 15.0f * 2.0f - 1.0f;
                    double zDir = (float)z2 / 15.0f * 2.0f - 1.0f;
                    double mag = Math.sqrt(xDir * xDir + yDir * yDir + zDir * zDir);
                    rayCoords.add(xDir / mag * (double)0.3f);
                    rayCoords.add(yDir / mag * (double)0.3f);
                    rayCoords.add(zDir / mag * (double)0.3f);
                }
            }
        }
        CACHED_RAYS = rayCoords.toDoubleArray();
        ZERO_RESISTANCE = Float.valueOf(-0.3f);
    }

    static class a {
        final BlockPosition a;
        ItemStack b;

        a(BlockPosition pos, ItemStack stack) {
            this.a = pos;
            this.b = stack;
        }

        public void a(ItemStack stack) {
            if (EntityItem.a(this.b, stack)) {
                this.b = EntityItem.a(this.b, stack, 16);
            }
        }
    }

    static class CacheKey {
        private final World world;
        private final double posX;
        private final double posY;
        private final double posZ;
        private final double minX;
        private final double minY;
        private final double minZ;
        private final double maxX;
        private final double maxY;
        private final double maxZ;

        public CacheKey(Explosion explosion, AxisAlignedBB aabb) {
            this.world = explosion.a();
            this.posX = explosion.f().d;
            this.posY = explosion.f().e;
            this.posZ = explosion.f().f;
            this.minX = aabb.a;
            this.minY = aabb.b;
            this.minZ = aabb.c;
            this.maxX = aabb.d;
            this.maxY = aabb.e;
            this.maxZ = aabb.f;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o2;
            if (Double.compare(cacheKey.posX, this.posX) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.posY, this.posY) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.posZ, this.posZ) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.minX, this.minX) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.minY, this.minY) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.minZ, this.minZ) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.maxX, this.maxX) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.maxY, this.maxY) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.maxZ, this.maxZ) != 0) {
                return false;
            }
            return this.world.equals(cacheKey.world);
        }

        public int hashCode() {
            int result = this.world.hashCode();
            long temp = Double.doubleToLongBits(this.posX);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.posY);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.posZ);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.minX);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.minY);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.minZ);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.maxX);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.maxY);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.maxZ);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }
    }
}

