/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import ca.spottedleaf.moonrise.common.list.ReferenceList;
import ca.spottedleaf.moonrise.common.misc.NearbyPlayers;
import com.destroystokyo.paper.event.entity.PreCreatureSpawnEvent;
import com.destroystokyo.paper.exception.ServerInternalException;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.animal.EntityOcelot;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.LocalMobCapCalculator;
import net.minecraft.world.level.SpawnerCreatureProbabilities;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.structures.NetherFortressStructure;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftSpawnCategory;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.slf4j.Logger;

public final class SpawnerCreature {
    private static final Logger d = LogUtils.getLogger();
    private static final int e = 24;
    public static final int a = 8;
    public static final int b = 128;
    public static final int c = MathHelper.d(8.0f / MathHelper.g);
    static final int f = (int)Math.pow(17.0, 2.0);
    public static final EnumCreatureType[] g = (EnumCreatureType[])Stream.of(EnumCreatureType.values()).filter(category -> category != EnumCreatureType.h).toArray(EnumCreatureType[]::new);

    private SpawnerCreature() {
    }

    public static d a(int spawnableChunkCount, Iterable<Entity> entities, b chunkGetter, LocalMobCapCalculator calculator) {
        return SpawnerCreature.createState(spawnableChunkCount, entities, chunkGetter, calculator, false);
    }

    public static d createState(int spawnableChunkCount, Iterable<Entity> entities, b chunkGetter, LocalMobCapCalculator calculator, boolean countMobs) {
        SpawnerCreatureProbabilities potentialCalculator = new SpawnerCreatureProbabilities();
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        for (Entity entity : entities) {
            EnumCreatureType category;
            EntityInsentient mob;
            if (entity instanceof EntityInsentient && ((mob = (EntityInsentient)entity).gd() || mob.Y()) || (category = entity.an().f()) == EnumCreatureType.h || !entity.dV().paperConfig().entities.spawning.countAllMobsForSpawning && entity.spawnReason != CreatureSpawnEvent.SpawnReason.NATURAL && entity.spawnReason != CreatureSpawnEvent.SpawnReason.CHUNK_GEN) continue;
            BlockPosition blockPos = entity.dv();
            chunkGetter.query(ChunkCoordIntPair.a(blockPos), chunk -> {
                BiomeSettingsMobs.b mobSpawnCost = SpawnerCreature.a(blockPos, (IChunkAccess)chunk).b().a(entity.an());
                if (mobSpawnCost != null) {
                    potentialCalculator.a(entity.dv(), mobSpawnCost.b());
                }
                if (calculator != null && entity instanceof EntityInsentient) {
                    calculator.a(chunk.f(), category);
                }
                map.addTo((Object)category, 1);
                if (countMobs) {
                    chunk.r.m().a.updatePlayerMobTypeMap(entity);
                }
            });
        }
        return new d(spawnableChunkCount, (Object2IntOpenHashMap<EnumCreatureType>)map, potentialCalculator, calculator);
    }

    static BiomeBase a(BlockPosition pos, IChunkAccess chunk) {
        return chunk.getNoiseBiome(QuartPos.a(pos.u()), QuartPos.a(pos.v()), QuartPos.a(pos.w())).a();
    }

    public static List<EnumCreatureType> getFilteredSpawningCategories(d spawnState, boolean spawnFriendlies, boolean spawnEnemies, boolean spawnPassives, WorldServer level) {
        WorldData worlddata = level.C_();
        ArrayList<EnumCreatureType> list = new ArrayList<EnumCreatureType>(g.length);
        for (EnumCreatureType mobCategory : g) {
            boolean spawnThisTick = true;
            int limit = mobCategory.b();
            SpawnCategory spawnCategory = CraftSpawnCategory.toBukkit(mobCategory);
            if (CraftSpawnCategory.isValidForLimits(spawnCategory)) {
                spawnThisTick = level.ticksPerSpawnCategory.getLong((Object)spawnCategory) != 0L && worlddata.c() % level.ticksPerSpawnCategory.getLong((Object)spawnCategory) == 0L;
                limit = level.getWorld().getSpawnLimit(spawnCategory);
            }
            if (!spawnThisTick || limit == 0 || !spawnFriendlies && mobCategory.d() || !spawnEnemies && !mobCategory.d() || !spawnPassives && mobCategory.e() || !level.paperConfig().entities.spawning.perPlayerMobSpawns && !spawnState.canSpawnForCategoryGlobal(mobCategory, limit)) continue;
            list.add(mobCategory);
        }
        return list;
    }

    public static void a(WorldServer level, Chunk chunk, d spawnState, List<EnumCreatureType> categories) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("spawner");
        for (EnumCreatureType mobCategory : categories) {
            boolean canSpawn;
            int maxSpawns = Integer.MAX_VALUE;
            if (level.paperConfig().entities.spawning.perPlayerMobSpawns) {
                int limit = mobCategory.b();
                SpawnCategory spawnCategory = CraftSpawnCategory.toBukkit(mobCategory);
                if (CraftSpawnCategory.isValidForLimits(spawnCategory)) {
                    limit = level.getWorld().getSpawnLimit(spawnCategory);
                }
                int minDiff = Integer.MAX_VALUE;
                ReferenceList<EntityPlayer> inRange = level.moonrise$getNearbyPlayers().getPlayers(chunk.f(), NearbyPlayers.NearbyMapType.TICK_VIEW_DISTANCE);
                if (inRange != null) {
                    EntityPlayer[] backingSet = inRange.getRawDataUnchecked();
                    int len = inRange.size();
                    for (int k2 = 0; k2 < len; ++k2) {
                        minDiff = Math.min(limit - level.m().a.getMobCountNear(backingSet[k2], mobCategory), minDiff);
                    }
                }
                maxSpawns = minDiff == Integer.MAX_VALUE ? 0 : minDiff;
                canSpawn = maxSpawns > 0;
            } else {
                canSpawn = spawnState.a(mobCategory, chunk.f());
            }
            if (!canSpawn) continue;
            SpawnerCreature.spawnCategoryForChunk(mobCategory, level, chunk, spawnState::a, spawnState::a, maxSpawns, level.paperConfig().entities.spawning.perPlayerMobSpawns ? level.m().a::updatePlayerMobTypeMap : null);
        }
        profilerFiller.c();
    }

    public static int globalLimitForCategory(WorldServer level, EnumCreatureType category, int spawnableChunkCount) {
        int categoryLimit = level.getWorld().getSpawnLimitUnsafe(CraftSpawnCategory.toBukkit(category));
        if (categoryLimit < 1) {
            return categoryLimit;
        }
        return categoryLimit * spawnableChunkCount / f;
    }

    public static void a(EnumCreatureType category, WorldServer level, Chunk chunk, c filter, a callback) {
        SpawnerCreature.spawnCategoryForChunk(category, level, chunk, filter, callback, Integer.MAX_VALUE, null);
    }

    public static void spawnCategoryForChunk(EnumCreatureType category, WorldServer level, Chunk chunk, c filter, a callback, int maxSpawns, Consumer<Entity> trackEntity) {
        BlockPosition randomPosWithin = SpawnerCreature.a((World)level, chunk);
        if (randomPosWithin.v() >= level.K_() + 1) {
            SpawnerCreature.spawnCategoryForPosition(category, level, chunk, randomPosWithin, filter, callback, maxSpawns, trackEntity);
        }
    }

    @VisibleForDebug
    public static void a(EnumCreatureType category, WorldServer level, BlockPosition pos) {
        SpawnerCreature.a(category, level, level.z(pos), pos, (EntityTypes<?> entityType, BlockPosition spawnPos, IChunkAccess chunk) -> true, (EntityInsentient mob, IChunkAccess chunk) -> {});
    }

    public static void a(EnumCreatureType category, WorldServer level, IChunkAccess chunk, BlockPosition pos, c filter, a callback) {
        SpawnerCreature.spawnCategoryForPosition(category, level, chunk, pos, filter, callback, Integer.MAX_VALUE, null);
    }

    public static void spawnCategoryForPosition(EnumCreatureType category, WorldServer level, IChunkAccess chunk, BlockPosition pos, c filter, a callback, int maxSpawns, @Nullable Consumer<Entity> trackEntity) {
        StructureManager structureManager = level.b();
        ChunkGenerator generator = level.m().g();
        int y2 = pos.v();
        IBlockData blockState = level.getBlockStateIfLoadedAndInBounds(pos);
        if (blockState != null && !blockState.d(chunk, pos)) {
            BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
            int i2 = 0;
            block0: for (int i1 = 0; i1 < 3; ++i1) {
                int x2 = pos.u();
                int z2 = pos.w();
                int i22 = 6;
                BiomeSettingsMobs.c spawnerData = null;
                GroupDataEntity spawnGroupData = null;
                int ceil = MathHelper.f(level.A.i() * 4.0f);
                int i3 = 0;
                for (int i4 = 0; i4 < ceil; ++i4) {
                    PreSpawnStatus doSpawning;
                    mutableBlockPos.d(x2 += level.A.a(6) - level.A.a(6), y2, z2 += level.A.a(6) - level.A.a(6));
                    double d2 = (double)x2 + 0.5;
                    double d1 = (double)z2 + 0.5;
                    EntityHuman nearestPlayer = level.a(d2, (double)y2, d1, -1.0, false);
                    if (nearestPlayer == null) continue;
                    double d22 = nearestPlayer.h(d2, y2, d1);
                    if (!level.isLoadedAndInBounds(mutableBlockPos) || !SpawnerCreature.a(level, chunk, mutableBlockPos, d22)) continue;
                    if (spawnerData == null) {
                        Optional<BiomeSettingsMobs.c> randomSpawnMobAt = SpawnerCreature.a(level, structureManager, generator, category, level.A, (BlockPosition)mutableBlockPos);
                        if (randomSpawnMobAt.isEmpty()) continue block0;
                        spawnerData = randomSpawnMobAt.get();
                        ceil = spawnerData.b() + level.A.a(1 + spawnerData.c() - spawnerData.b());
                    }
                    if ((doSpawning = SpawnerCreature.isValidSpawnPostitionForType(level, category, structureManager, generator, spawnerData, mutableBlockPos, d22)) == PreSpawnStatus.ABORT || doSpawning == PreSpawnStatus.CANCELLED) {
                        level.m().a.updateFailurePlayerMobTypeMap(mutableBlockPos.u() >> 4, mutableBlockPos.w() >> 4, category);
                    }
                    if (doSpawning == PreSpawnStatus.ABORT) {
                        return;
                    }
                    if (doSpawning != PreSpawnStatus.SUCCESS || !filter.test(spawnerData.a(), mutableBlockPos, chunk)) continue;
                    EntityInsentient mobForSpawn = SpawnerCreature.a(level, spawnerData.a());
                    if (mobForSpawn == null) {
                        return;
                    }
                    mobForSpawn.b(d2, y2, d1, level.A.i() * 360.0f, 0.0f);
                    if (!SpawnerCreature.a(level, mobForSpawn, d22)) continue;
                    spawnGroupData = mobForSpawn.a((WorldAccess)level, level.d_(mobForSpawn.dv()), EntitySpawnReason.a, spawnGroupData);
                    level.addFreshEntityWithPassengers(mobForSpawn, mobForSpawn instanceof EntityOcelot && !((Ageable)mobForSpawn.getBukkitEntity()).isAdult() ? CreatureSpawnEvent.SpawnReason.OCELOT_BABY : CreatureSpawnEvent.SpawnReason.NATURAL);
                    if (!mobForSpawn.dQ()) {
                        ++i2;
                        ++i3;
                        callback.run(mobForSpawn, chunk);
                        if (trackEntity != null) {
                            trackEntity.accept(mobForSpawn);
                        }
                    }
                    if (i2 >= mobForSpawn.fX() || i2 >= maxSpawns) {
                        return;
                    }
                    if (mobForSpawn.q(i3)) continue block0;
                }
            }
        }
    }

    private static boolean a(WorldServer level, IChunkAccess chunk, BlockPosition.MutableBlockPosition pos, double distance) {
        if (distance <= 576.0) {
            return false;
        }
        if (level.aa().a(new Vec3D((double)pos.u() + 0.5, pos.v(), (double)pos.w() + 0.5), 24.0)) {
            return false;
        }
        ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(pos);
        return Objects.equals(chunkPos, chunk.f()) || level.c(chunkPos);
    }

    private static PreSpawnStatus isValidSpawnPostitionForType(WorldServer level, EnumCreatureType category, StructureManager structureManager, ChunkGenerator generator, BiomeSettingsMobs.c data, BlockPosition.MutableBlockPosition pos, double distance) {
        EntityTypes<?> entityType = data.a();
        PreCreatureSpawnEvent event = new PreCreatureSpawnEvent(CraftLocation.toBukkit((BlockPosition)pos, (World)level), CraftEntityType.minecraftToBukkit(entityType), CreatureSpawnEvent.SpawnReason.NATURAL);
        if (!event.callEvent()) {
            if (event.shouldAbortSpawn()) {
                return PreSpawnStatus.ABORT;
            }
            return PreSpawnStatus.CANCELLED;
        }
        boolean success = !(entityType.f() == EnumCreatureType.h || !entityType.e() && distance > (double)(entityType.f().f() * entityType.f().f()) || !entityType.c() || !SpawnerCreature.a(level, structureManager, generator, category, data, (BlockPosition)pos) || !EntityPositionTypes.a(entityType, level, pos) || !EntityPositionTypes.a(entityType, level, EntitySpawnReason.a, pos, level.A) || !level.b(entityType.a((double)pos.u() + 0.5, pos.v(), (double)pos.w() + 0.5)));
        return success ? PreSpawnStatus.SUCCESS : PreSpawnStatus.FAIL;
    }

    @Nullable
    private static EntityInsentient a(WorldServer level, EntityTypes<?> entityType) {
        try {
            Object obj = entityType.a(level, EntitySpawnReason.a);
            if (obj instanceof EntityInsentient) {
                EntityInsentient mob = (EntityInsentient)obj;
                return mob;
            }
            d.warn("Can't spawn entity of type: {}", (Object)BuiltInRegistries.f.b(entityType));
        }
        catch (Exception var4) {
            d.warn("Failed to create mob", (Throwable)var4);
            ServerInternalException.reportInternalException((Throwable)var4);
        }
        return null;
    }

    private static boolean a(WorldServer level, EntityInsentient mob, double distance) {
        return !(distance > (double)(mob.an().f().f() * mob.an().f().f()) && mob.h(distance) || !mob.a((GeneratorAccess)level, EntitySpawnReason.a) || !mob.a((IWorldReader)level));
    }

    private static Optional<BiomeSettingsMobs.c> a(WorldServer level, StructureManager structureManager, ChunkGenerator generator, EnumCreatureType category, RandomSource random, BlockPosition pos) {
        Holder<BiomeBase> biome = level.u(pos);
        return category == EnumCreatureType.g && biome.a(BiomeTags.ao) && random.i() < 0.98f ? Optional.empty() : SpawnerCreature.a(level, structureManager, generator, category, pos, biome).a(random);
    }

    private static boolean a(WorldServer level, StructureManager structureManager, ChunkGenerator generator, EnumCreatureType category, BiomeSettingsMobs.c data, BlockPosition pos) {
        return SpawnerCreature.a(level, structureManager, generator, category, pos, null).b(data);
    }

    private static WeightedList<BiomeSettingsMobs.c> a(WorldServer level, StructureManager structureManager, ChunkGenerator generator, EnumCreatureType cetagory, BlockPosition pos, @Nullable Holder<BiomeBase> biome) {
        return SpawnerCreature.a(pos, level, cetagory, structureManager) ? NetherFortressStructure.d : generator.a(biome != null ? biome : level.u(pos), structureManager, cetagory, pos);
    }

    public static boolean a(BlockPosition pos, WorldServer level, EnumCreatureType category, StructureManager structureManager) {
        if (category == EnumCreatureType.a && level.a_(pos.e()).a(Blocks.fM)) {
            Structure structure = structureManager.b().f(Registries.be).c(BuiltinStructures.o);
            return structure != null && structureManager.a(pos, structure).b();
        }
        return false;
    }

    private static BlockPosition a(World level, Chunk chunk) {
        ChunkCoordIntPair pos = chunk.f();
        int i2 = pos.d() + level.A.a(16);
        int i1 = pos.e() + level.A.a(16);
        int i22 = chunk.a(HeightMap.Type.b, i2, i1) + 1;
        int i3 = MathHelper.b(level.A, level.K_(), i22);
        return new BlockPosition(i2, i3, i1);
    }

    public static boolean a(IBlockAccess block, BlockPosition pos, IBlockData blockState, Fluid fluidState, EntityTypes<?> entityType) {
        return !blockState.m(block, pos) && !blockState.p() && fluidState.c() && !blockState.a(TagsBlock.aZ) && !entityType.a(blockState);
    }

    public static void a(WorldAccess levelAccessor, Holder<BiomeBase> biome, ChunkCoordIntPair chunkPos, RandomSource random) {
        BiomeSettingsMobs mobSettings = biome.a().b();
        WeightedList<BiomeSettingsMobs.c> mobs = mobSettings.a(EnumCreatureType.b);
        if (!mobs.c()) {
            int minBlockX = chunkPos.d();
            int minBlockZ = chunkPos.e();
            while (random.i() < mobSettings.a()) {
                Optional<BiomeSettingsMobs.c> random1 = mobs.a(random);
                if (random1.isEmpty()) continue;
                BiomeSettingsMobs.c spawnerData = random1.get();
                int i2 = spawnerData.b() + random.a(1 + spawnerData.c() - spawnerData.b());
                GroupDataEntity spawnGroupData = null;
                int i1 = minBlockX + random.a(16);
                int i22 = minBlockZ + random.a(16);
                int i3 = i1;
                int i4 = i22;
                for (int i5 = 0; i5 < i2; ++i5) {
                    boolean flag = false;
                    for (int i6 = 0; !flag && i6 < 4; ++i6) {
                        BlockPosition topNonCollidingPos = SpawnerCreature.a((IWorldReader)levelAccessor, spawnerData.a(), i1, i22);
                        if (spawnerData.a().c() && EntityPositionTypes.a(spawnerData.a(), levelAccessor, topNonCollidingPos)) {
                            EntityInsentient mob;
                            Object entity;
                            float width = spawnerData.a().l();
                            double d2 = MathHelper.a((double)i1, (double)minBlockX + (double)width, (double)minBlockX + 16.0 - (double)width);
                            double d1 = MathHelper.a((double)i22, (double)minBlockZ + (double)width, (double)minBlockZ + 16.0 - (double)width);
                            if (!levelAccessor.b(spawnerData.a().a(d2, topNonCollidingPos.v(), d1)) || !EntityPositionTypes.a(spawnerData.a(), levelAccessor, EntitySpawnReason.b, BlockPosition.a(d2, (double)topNonCollidingPos.v(), d1), levelAccessor.G_())) continue;
                            try {
                                entity = spawnerData.a().a(levelAccessor.a(), EntitySpawnReason.a);
                            }
                            catch (Exception var27) {
                                d.warn("Failed to create mob", (Throwable)var27);
                                ServerInternalException.reportInternalException((Throwable)var27);
                                continue;
                            }
                            if (entity == null) continue;
                            ((Entity)entity).b(d2, topNonCollidingPos.v(), d1, random.i() * 360.0f, 0.0f);
                            if (entity instanceof EntityInsentient && (mob = (EntityInsentient)entity).a(levelAccessor, EntitySpawnReason.b) && mob.a(levelAccessor)) {
                                spawnGroupData = mob.a(levelAccessor, levelAccessor.d_(mob.dv()), EntitySpawnReason.b, spawnGroupData);
                                levelAccessor.addFreshEntityWithPassengers(mob, CreatureSpawnEvent.SpawnReason.CHUNK_GEN);
                                flag = true;
                            }
                        }
                        i1 += random.a(5) - random.a(5);
                        i22 += random.a(5) - random.a(5);
                        while (i1 < minBlockX || i1 >= minBlockX + 16 || i22 < minBlockZ || i22 >= minBlockZ + 16) {
                            i1 = i3 + random.a(5) - random.a(5);
                            i22 = i4 + random.a(5) - random.a(5);
                        }
                    }
                }
            }
        }
    }

    private static BlockPosition a(IWorldReader level, EntityTypes<?> entityType, int x2, int z2) {
        int height = level.a(EntityPositionTypes.b(entityType), x2, z2);
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition(x2, height, z2);
        if (level.F_().h()) {
            do {
                mutableBlockPos.c(EnumDirection.a);
            } while (!level.a_(mutableBlockPos).l());
            do {
                mutableBlockPos.c(EnumDirection.a);
            } while (level.a_(mutableBlockPos).l() && mutableBlockPos.v() > level.K_());
        }
        return EntityPositionTypes.a(entityType).a(level, mutableBlockPos.j());
    }

    @FunctionalInterface
    public static interface b {
        public void query(long var1, Consumer<Chunk> var3);
    }

    public static class d {
        private final int a;
        private final Object2IntOpenHashMap<EnumCreatureType> b;
        private final SpawnerCreatureProbabilities c;
        private final Object2IntMap<EnumCreatureType> d;
        private final LocalMobCapCalculator e;
        @Nullable
        private BlockPosition f;
        @Nullable
        private EntityTypes<?> g;
        private double h;

        d(int spawnableChunkCount, Object2IntOpenHashMap<EnumCreatureType> mobCategoryCounts, SpawnerCreatureProbabilities spawnPotential, LocalMobCapCalculator localMobCapCalculator) {
            this.a = spawnableChunkCount;
            this.b = mobCategoryCounts;
            this.c = spawnPotential;
            this.e = localMobCapCalculator;
            this.d = Object2IntMaps.unmodifiable(mobCategoryCounts);
        }

        private boolean a(EntityTypes<?> entityType, BlockPosition pos, IChunkAccess chunk) {
            double charge;
            this.f = pos;
            this.g = entityType;
            BiomeSettingsMobs.b mobSpawnCost = SpawnerCreature.a(pos, chunk).b().a(entityType);
            if (mobSpawnCost == null) {
                this.h = 0.0;
                return true;
            }
            this.h = charge = mobSpawnCost.b();
            double potentialEnergyChange = this.c.b(pos, charge);
            return potentialEnergyChange <= mobSpawnCost.a();
        }

        private void a(EntityInsentient mob, IChunkAccess chunk) {
            BiomeSettingsMobs.b mobSpawnCost;
            EntityTypes<?> type = mob.an();
            BlockPosition blockPos = mob.dv();
            double d2 = blockPos.equals(this.f) && type == this.g ? this.h : ((mobSpawnCost = SpawnerCreature.a(blockPos, chunk).b().a(type)) != null ? mobSpawnCost.b() : 0.0);
            this.c.a(blockPos, d2);
            EnumCreatureType category = type.f();
            this.b.addTo((Object)category, 1);
            if (this.e != null) {
                this.e.a(new ChunkCoordIntPair(blockPos), category);
            }
        }

        public int a() {
            return this.a;
        }

        public Object2IntMap<EnumCreatureType> b() {
            return this.d;
        }

        boolean canSpawnForCategoryGlobal(EnumCreatureType category, int limit) {
            int i2 = limit * this.a / f;
            return this.b.getInt((Object)category) < i2;
        }

        boolean a(EnumCreatureType category, ChunkCoordIntPair chunkPos) {
            return this.e.a(category, chunkPos);
        }
    }

    @FunctionalInterface
    public static interface c {
        public boolean test(EntityTypes<?> var1, BlockPosition var2, IChunkAccess var3);
    }

    @FunctionalInterface
    public static interface a {
        public void run(EntityInsentient var1, IChunkAccess var2);
    }

    private static enum PreSpawnStatus {
        FAIL,
        SUCCESS,
        CANCELLED,
        ABORT;

    }
}

