/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.patches.chunk_system.ticket.ChunkSystemTicketStorage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.ArraySetSorted;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.level.saveddata.SavedDataType;
import org.bukkit.plugin.Plugin;
import org.slf4j.Logger;

public class TicketStorage
extends PersistentBase
implements ChunkSystemTicketStorage {
    private static final int c = 4;
    private static final Logger d = LogUtils.getLogger();
    private static final Codec<Pair<ChunkCoordIntPair, Ticket>> e = Codec.mapPair((MapCodec)ChunkCoordIntPair.a.fieldOf("chunk_pos"), Ticket.a).codec();
    public static final Codec<TicketStorage> a = RecordCodecBuilder.create(instance -> instance.group((App)e.listOf().optionalFieldOf("tickets", List.of()).forGetter(TicketStorage::h)).apply((Applicative)instance, TicketStorage::a));
    public static final SavedDataType<TicketStorage> b = new SavedDataType<TicketStorage>("chunks", TicketStorage::new, a, DataFixTypes.i);
    private final Long2ObjectOpenHashMap<List<Ticket>> g;
    @Nullable
    private a i;
    @Nullable
    private a j;
    private PlayerChunkMap chunkMap;

    @Override
    public final PlayerChunkMap moonrise$getChunkMap() {
        return this.chunkMap;
    }

    @Override
    public final void moonrise$setChunkMap(PlayerChunkMap chunkMap) {
        this.chunkMap = chunkMap;
    }

    private TicketStorage(Long2ObjectOpenHashMap<List<Ticket>> tickets, Long2ObjectOpenHashMap<List<Ticket>> deactivatedTickets) {
        this.g = deactivatedTickets;
    }

    public TicketStorage() {
        this((Long2ObjectOpenHashMap<List<Ticket>>)new Long2ObjectOpenHashMap(4), (Long2ObjectOpenHashMap<List<Ticket>>)new Long2ObjectOpenHashMap());
    }

    private static TicketStorage a(List<Pair<ChunkCoordIntPair, Ticket>> packed) {
        Long2ObjectOpenHashMap map = new Long2ObjectOpenHashMap();
        for (Pair<ChunkCoordIntPair, Ticket> pair : packed) {
            ChunkCoordIntPair chunkPos = (ChunkCoordIntPair)pair.getFirst();
            List list = (List)map.computeIfAbsent(chunkPos.a(), l2 -> new ObjectArrayList(4));
            list.add((Ticket)pair.getSecond());
        }
        return new TicketStorage((Long2ObjectOpenHashMap<List<Ticket>>)new Long2ObjectOpenHashMap(4), (Long2ObjectOpenHashMap<List<Ticket>>)map);
    }

    private List<Pair<ChunkCoordIntPair, Ticket>> h() {
        ArrayList<Pair<ChunkCoordIntPair, Ticket>> list = new ArrayList<Pair<ChunkCoordIntPair, Ticket>>();
        this.a((ChunkCoordIntPair chunkPos, Ticket ticket) -> {
            if (ticket.a().e()) {
                list.add(new Pair(chunkPos, ticket));
            }
        });
        return list;
    }

    private void redirectRegularTickets(BiConsumer<ChunkCoordIntPair, Ticket> consumer, Long2ObjectOpenHashMap<List<Ticket>> ticketsParam) {
        if (ticketsParam != null) {
            throw new IllegalStateException("Bad injection point");
        }
        Long2ObjectOpenHashMap<ArraySetSorted<Ticket>> tickets = this.chunkMap.t.moonrise$getChunkTaskScheduler().chunkHolderManager.getTicketsCopy();
        ObjectIterator iterator = tickets.long2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iterator.next();
            long pos = entry.getLongKey();
            ArraySetSorted chunkTickets = (ArraySetSorted)entry.getValue();
            ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(pos);
            for (Ticket ticket : chunkTickets) {
                consumer.accept(chunkPos, ticket);
            }
        }
    }

    private void a(BiConsumer<ChunkCoordIntPair, Ticket> action) {
        this.redirectRegularTickets(action, null);
        TicketStorage.a(action, this.g);
    }

    private static void a(BiConsumer<ChunkCoordIntPair, Ticket> action, Long2ObjectOpenHashMap<List<Ticket>> tickets) {
        for (Long2ObjectMap.Entry entry : Long2ObjectMaps.fastIterable(tickets)) {
            ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(entry.getLongKey());
            for (Ticket ticket : (List)entry.getValue()) {
                action.accept(chunkPos, ticket);
            }
        }
    }

    public void a() {
        for (Long2ObjectMap.Entry entry : Long2ObjectMaps.fastIterable(this.g)) {
            for (Ticket ticket : (List)entry.getValue()) {
                this.a(entry.getLongKey(), ticket);
            }
        }
        this.g.clear();
    }

    public void a(@Nullable a loadingChunkUpdatedListener) {
    }

    public void b(@Nullable a simulationChunkUpdatedListener) {
    }

    public boolean b() {
        return this.chunkMap.t.moonrise$getChunkTaskScheduler().chunkHolderManager.hasTickets();
    }

    public List<Ticket> a(long chunkPos) {
        return this.chunkMap.t.moonrise$getChunkTaskScheduler().chunkHolderManager.getTicketsAt(CoordinateUtils.getChunkX(chunkPos), CoordinateUtils.getChunkZ(chunkPos));
    }

    private List<Ticket> b(long chunkPos) {
        throw new UnsupportedOperationException();
    }

    public void a(TicketType ticketType, ChunkCoordIntPair chunkPos, int radius) {
        Ticket ticket = new Ticket(ticketType, ChunkLevel.a(FullChunkStatus.b) - radius);
        this.a(chunkPos.a(), ticket);
    }

    public void a(Ticket ticket, ChunkCoordIntPair chunkPos) {
        this.a(chunkPos.a(), ticket);
    }

    public boolean a(long chunkPos, Ticket ticket) {
        boolean ret = this.chunkMap.t.moonrise$getChunkTaskScheduler().chunkHolderManager.addTicketAtLevel(ticket.a(), chunkPos, ticket.b(), ticket.moonrise$getIdentifier());
        this.f();
        return ret;
    }

    private static boolean a(Ticket first, Ticket second) {
        return second.a() == first.a() && second.b() == first.b() && Objects.equals(second.getIdentifier(), first.getIdentifier());
    }

    public int a(long chunkPos, boolean requireSimulation) {
        return TicketStorage.a(this.a(chunkPos), requireSimulation);
    }

    private static int a(List<Ticket> tickets, boolean requireSimulation) {
        Ticket lowestTicket = TicketStorage.b(tickets, requireSimulation);
        return lowestTicket == null ? ChunkLevel.b + 1 : lowestTicket.b();
    }

    @Nullable
    private static Ticket b(@Nullable List<Ticket> tickets, boolean requireSimulation) {
        if (tickets == null) {
            return null;
        }
        Ticket ticket = null;
        for (Ticket ticket1 : tickets) {
            if (ticket != null && ticket1.b() >= ticket.b()) continue;
            if (requireSimulation && ticket1.a().b()) {
                ticket = ticket1;
                continue;
            }
            if (requireSimulation || !ticket1.a().a()) continue;
            ticket = ticket1;
        }
        return ticket;
    }

    public void b(TicketType ticketType, ChunkCoordIntPair chunkPos, int radius) {
        Ticket ticket = new Ticket(ticketType, ChunkLevel.a(FullChunkStatus.b) - radius);
        this.b(chunkPos.a(), ticket);
    }

    public void b(Ticket ticket, ChunkCoordIntPair chunkPos) {
        this.b(chunkPos.a(), ticket);
    }

    public boolean b(long chunkPos, Ticket ticket) {
        boolean ret = this.chunkMap.t.moonrise$getChunkTaskScheduler().chunkHolderManager.removeTicketAtLevel(ticket.a(), chunkPos, ticket.b(), ticket.moonrise$getIdentifier());
        if (ret) {
            this.f();
        }
        return ret;
    }

    private void i() {
        throw new UnsupportedOperationException();
    }

    public String b(long chunkPos, boolean requireSimulation) {
        List<Ticket> tickets = this.a(chunkPos);
        Ticket lowestTicket = TicketStorage.b(tickets, requireSimulation);
        return lowestTicket == null ? "no_ticket" : lowestTicket.toString();
    }

    public void c() {
        this.chunkMap.t.moonrise$getChunkTaskScheduler().chunkHolderManager.tick();
        this.f();
    }

    public void d() {
    }

    public void a(Predicate<Ticket> predicate, @Nullable Long2ObjectOpenHashMap<List<Ticket>> tickets) {
        throw new UnsupportedOperationException();
    }

    public void a(int level, TicketType type) {
        throw new UnsupportedOperationException();
    }

    public boolean a(ChunkCoordIntPair chunkPos, boolean add) {
        Ticket ticket = new Ticket(TicketType.f, PlayerChunkMap.c);
        return add ? this.a(chunkPos.a(), ticket) : this.b(chunkPos.a(), ticket);
    }

    public LongSet e() {
        Long2IntOpenHashMap forced = this.chunkMap.t.moonrise$getChunkTaskScheduler().chunkHolderManager.getTicketCounters(0L);
        if (forced == null) {
            return LongSet.of();
        }
        return forced.keySet();
    }

    private LongSet a(Predicate<Ticket> predicate) {
        throw new UnsupportedOperationException();
    }

    public boolean addPluginRegionTicket(ChunkCoordIntPair pos, Plugin value) {
        return this.a(pos.a(), new Ticket(TicketType.PLUGIN_TICKET, PlayerChunkMap.c, value));
    }

    public boolean removePluginRegionTicket(ChunkCoordIntPair pos, Plugin value) {
        return this.b(pos.a(), new Ticket(TicketType.PLUGIN_TICKET, PlayerChunkMap.c, value));
    }

    public void removeAllPluginRegionTickets(TicketType ticketType, int ticketLevel, Plugin ticketIdentifier) {
        this.chunkMap.t.moonrise$getChunkTaskScheduler().chunkHolderManager.removeAllTicketsFor(ticketType, ticketLevel, ticketIdentifier);
    }

    @FunctionalInterface
    public static interface a {
        public void update(long var1, int var3, boolean var4);
    }
}

