/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.AbstractIterator;
import io.papermc.paper.util.MCUtil;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.CursorPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapeCollisionEntity;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class VoxelShapeSpliterator<T>
extends AbstractIterator<T> {
    private final AxisAlignedBB a;
    private final VoxelShapeCollision b;
    private final CursorPosition c;
    private final BlockPosition.MutableBlockPosition d;
    private final VoxelShape e;
    private final ICollisionAccess f;
    private final boolean g;
    @Nullable
    private IBlockAccess h;
    private long i;
    private final BiFunction<BlockPosition.MutableBlockPosition, VoxelShape, T> j;

    public VoxelShapeSpliterator(ICollisionAccess collisionGetter, @Nullable Entity entity, AxisAlignedBB box, boolean onlySuffocatingBlocks, BiFunction<BlockPosition.MutableBlockPosition, VoxelShape, T> resultProvider) {
        this(collisionGetter, entity == null ? VoxelShapeCollision.a() : VoxelShapeCollision.a(entity), box, onlySuffocatingBlocks, resultProvider);
    }

    public VoxelShapeSpliterator(ICollisionAccess collisionGetter, VoxelShapeCollision context, AxisAlignedBB box, boolean onlySuffocatingBlocks, BiFunction<BlockPosition.MutableBlockPosition, VoxelShape, T> resultProvider) {
        this.b = context;
        this.d = new BlockPosition.MutableBlockPosition();
        this.e = VoxelShapes.a(box);
        this.f = collisionGetter;
        this.a = box;
        this.g = onlySuffocatingBlocks;
        this.j = resultProvider;
        int i2 = MathHelper.a(box.a - 1.0E-7) - 1;
        int i1 = MathHelper.a(box.d + 1.0E-7) + 1;
        int i22 = MathHelper.a(box.b - 1.0E-7) - 1;
        int i3 = MathHelper.a(box.e + 1.0E-7) + 1;
        int i4 = MathHelper.a(box.c - 1.0E-7) - 1;
        int i5 = MathHelper.a(box.f + 1.0E-7) + 1;
        this.c = new CursorPosition(i2, i22, i4, i1, i3, i5);
    }

    @Nullable
    private IBlockAccess a(int x2, int z2) {
        IBlockAccess chunkForCollisions;
        int sectionPosX = SectionPosition.a(x2);
        int sectionPosZ = SectionPosition.a(z2);
        long packedChunkPos = ChunkCoordIntPair.c(sectionPosX, sectionPosZ);
        if (this.h != null && this.i == packedChunkPos) {
            return this.h;
        }
        this.h = chunkForCollisions = this.f.c(sectionPosX, sectionPosZ);
        this.i = packedChunkPos;
        return chunkForCollisions;
    }

    protected T computeNext() {
        while (this.c.a()) {
            IBlockData blockState;
            Entity entity;
            int i2;
            int i1;
            int i3;
            int x2 = i3 = this.c.b();
            int y2 = i1 = this.c.c();
            int z2 = i2 = this.c.d();
            int nextType = this.c.e();
            if (nextType == 3) continue;
            VoxelShapeCollision voxelShapeCollision = this.b;
            if (voxelShapeCollision instanceof VoxelShapeCollisionEntity) {
                VoxelShapeCollisionEntity entityContext = (VoxelShapeCollisionEntity)voxelShapeCollision;
                entity = entityContext.d();
            } else {
                entity = null;
            }
            Entity source = entity;
            boolean far = source != null && MCUtil.distanceSq(source.dA(), y2, source.dG(), x2, y2, z2) > 14.0;
            this.d.d(x2, y2, z2);
            if (this.f instanceof RegionLimitedWorldAccess) {
                IBlockAccess blockGetter = this.a(x2, z2);
                if (blockGetter == null) continue;
                blockState = blockGetter.a_(this.d);
            } else {
                blockState = !far && source instanceof EntityPlayer || source != null && source.collisionLoadChunks ? this.f.a_(this.d) : this.f.getBlockStateIfLoaded(this.d);
            }
            if (blockState == null) {
                if (source instanceof EntityPlayer && !source.dV().paperConfig().chunks.preventMovingIntoUnloadedChunks) continue;
                return this.j.apply(new BlockPosition.MutableBlockPosition(x2, y2, z2), VoxelShapes.a(far ? source.cR() : new AxisAlignedBB(new BlockPosition(x2, y2, z2))));
            }
            if (nextType == 1 && !blockState.i() || nextType == 2 && !blockState.a(Blocks.ca)) continue;
            VoxelShape collisionShape = this.b.a(blockState, this.f, this.d);
            if (collisionShape == VoxelShapes.b()) {
                if (!this.a.a(i3, i1, i2, (double)i3 + 1.0, (double)i1 + 1.0, (double)i2 + 1.0)) continue;
                return this.j.apply(this.d, collisionShape.a(this.d));
            }
            VoxelShape voxelShape = collisionShape.a(this.d);
            if (voxelShape.c() || !VoxelShapes.c(voxelShape, this.e, OperatorBoolean.i)) continue;
            return this.j.apply(this.d, voxelShape);
        }
        return (T)this.endOfData();
    }
}

