/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.QuartPos;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;

public class Climate {
    private static final boolean b = false;
    private static final float c = 10000.0f;
    @VisibleForTesting
    protected static final int a = 7;

    public static h a(float temperature, float humidity, float continentalness, float erosion, float depth, float weirdness) {
        return new h(Climate.a(temperature), Climate.a(humidity), Climate.a(continentalness), Climate.a(erosion), Climate.a(depth), Climate.a(weirdness));
    }

    public static d a(float temperature, float humidity, float continentalness, float erosion, float depth, float weirdness, float offset) {
        return new d(net.minecraft.world.level.biome.Climate$b.a(temperature), net.minecraft.world.level.biome.Climate$b.a(humidity), net.minecraft.world.level.biome.Climate$b.a(continentalness), net.minecraft.world.level.biome.Climate$b.a(erosion), net.minecraft.world.level.biome.Climate$b.a(depth), net.minecraft.world.level.biome.Climate$b.a(weirdness), Climate.a(offset));
    }

    public static d a(b temperature, b humidity, b continentalness, b erosion, b depth, b weirdness, float offset) {
        return new d(temperature, humidity, continentalness, erosion, depth, weirdness, Climate.a(offset));
    }

    public static long a(float coord) {
        return (long)(coord * 10000.0f);
    }

    public static float a(long coord) {
        return (float)coord / 10000.0f;
    }

    public static Sampler a() {
        DensityFunction densityFunction = DensityFunctions.a();
        return new Sampler(densityFunction, densityFunction, densityFunction, densityFunction, densityFunction, densityFunction, List.of());
    }

    public static BlockPosition a(List<d> points, Sampler sampler) {
        return new g(points, (Sampler)sampler).b.a();
    }

    public static final class h
    extends Record {
        private final long a;
        private final long b;
        private final long c;
        private final long d;
        private final long e;
        private final long f;

        public h(long temperature, long humidity, long continentalness, long erosion, long depth, long weirdness) {
            this.a = temperature;
            this.b = humidity;
            this.c = continentalness;
            this.d = erosion;
            this.e = depth;
            this.f = weirdness;
        }

        @VisibleForTesting
        protected long[] a() {
            return new long[]{this.a, this.b, this.c, this.d, this.e, this.f, 0L};
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{h.class, "temperature;humidity;continentalness;erosion;depth;weirdness", "a", "b", "c", "d", "e", "f"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{h.class, "temperature;humidity;continentalness;erosion;depth;weirdness", "a", "b", "c", "d", "e", "f"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{h.class, "temperature;humidity;continentalness;erosion;depth;weirdness", "a", "b", "c", "d", "e", "f"}, this, o2);
        }

        public long b() {
            return this.a;
        }

        public long c() {
            return this.b;
        }

        public long d() {
            return this.c;
        }

        public long e() {
            return this.d;
        }

        public long f() {
            return this.e;
        }

        public long g() {
            return this.f;
        }
    }

    public record d(b b, b c, b d, b e, b f, b g, long h) {
        public static final Codec<d> a = RecordCodecBuilder.create(instance -> instance.group((App)net.minecraft.world.level.biome.Climate$b.a.fieldOf("temperature").forGetter(point -> point.b), (App)net.minecraft.world.level.biome.Climate$b.a.fieldOf("humidity").forGetter(point -> point.c), (App)net.minecraft.world.level.biome.Climate$b.a.fieldOf("continentalness").forGetter(point -> point.d), (App)net.minecraft.world.level.biome.Climate$b.a.fieldOf("erosion").forGetter(point -> point.e), (App)net.minecraft.world.level.biome.Climate$b.a.fieldOf("depth").forGetter(point -> point.f), (App)net.minecraft.world.level.biome.Climate$b.a.fieldOf("weirdness").forGetter(point -> point.g), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("offset").xmap(Climate::a, Climate::a).forGetter(point -> point.h)).apply((Applicative)instance, d::new));

        long a(h point) {
            return MathHelper.b(this.b.a(point.a)) + MathHelper.b(this.c.a(point.b)) + MathHelper.b(this.d.a(point.c)) + MathHelper.b(this.e.a(point.d)) + MathHelper.b(this.f.a(point.e)) + MathHelper.b(this.g.a(point.f)) + MathHelper.b(this.h);
        }

        protected List<b> a() {
            return ImmutableList.of((Object)this.b, (Object)this.c, (Object)this.d, (Object)this.e, (Object)this.f, (Object)this.g, (Object)new b(this.h, this.h));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "temperature;humidity;continentalness;erosion;depth;weirdness;offset", "b", "c", "d", "e", "f", "g", "h"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "temperature;humidity;continentalness;erosion;depth;weirdness;offset", "b", "c", "d", "e", "f", "g", "h"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "temperature;humidity;continentalness;erosion;depth;weirdness;offset", "b", "c", "d", "e", "f", "g", "h"}, this, o2);
        }
    }

    public static final class b
    extends Record {
        private final long b;
        private final long c;
        public static final Codec<b> a = ExtraCodecs.a(Codec.floatRange((float)-2.0f, (float)2.0f), "min", "max", (min, max) -> min.compareTo((Float)max) > 0 ? DataResult.error(() -> "Cannon construct interval, min > max (" + min + " > " + max + ")") : DataResult.success((Object)new b(Climate.a(min.floatValue()), Climate.a(max.floatValue()))), climateParameter -> Float.valueOf(Climate.a(climateParameter.a())), climateParameter -> Float.valueOf(Climate.a(climateParameter.b())));

        public b(long min, long max) {
            this.b = min;
            this.c = max;
        }

        public static b a(float value) {
            return net.minecraft.world.level.biome.Climate$b.a(value, value);
        }

        public static b a(float min, float max) {
            if (min > max) {
                throw new IllegalArgumentException("min > max: " + min + " " + max);
            }
            return new b(Climate.a(min), Climate.a(max));
        }

        public static b a(b min, b max) {
            if (min.a() > max.b()) {
                throw new IllegalArgumentException("min > max: " + String.valueOf(min) + " " + String.valueOf(max));
            }
            return new b(min.a(), max.b());
        }

        @Override
        public String toString() {
            return this.b == this.c ? String.format(Locale.ROOT, "%d", this.b) : String.format(Locale.ROOT, "[%d-%d]", this.b, this.c);
        }

        public long a(long pointValue) {
            long l2 = pointValue - this.c;
            long l1 = this.b - pointValue;
            return l2 > 0L ? l2 : Math.max(l1, 0L);
        }

        public long a(b parameter) {
            long l2 = parameter.a() - this.c;
            long l1 = this.b - parameter.b();
            return l2 > 0L ? l2 : Math.max(l1, 0L);
        }

        public b b(@Nullable b param) {
            return param == null ? this : new b(Math.min(this.b, param.a()), Math.max(this.c, param.b()));
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "min;max", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "min;max", "b", "c"}, this, o2);
        }

        public long a() {
            return this.b;
        }

        public long b() {
            return this.c;
        }
    }

    public record Sampler(DensityFunction a, DensityFunction b, DensityFunction c, DensityFunction d, DensityFunction e, DensityFunction f, List<d> g) {
        private final DensityFunction a;
        private final DensityFunction b;
        private final DensityFunction c;
        private final DensityFunction d;
        private final DensityFunction e;
        private final DensityFunction f;
        private final List<d> g;

        public h a(int x2, int y2, int z2) {
            int blockPosX = QuartPos.c(x2);
            int blockPosY = QuartPos.c(y2);
            int blockPosZ = QuartPos.c(z2);
            DensityFunction.e singlePointContext = new DensityFunction.e(blockPosX, blockPosY, blockPosZ);
            return Climate.a((float)this.a.a(singlePointContext), (float)this.b.a(singlePointContext), (float)this.c.a(singlePointContext), (float)this.d.a(singlePointContext), (float)this.e.a(singlePointContext), (float)this.f.a(singlePointContext));
        }

        public BlockPosition a() {
            return this.g.isEmpty() ? BlockPosition.c : Climate.a(this.g, this);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Sampler.class, "temperature;humidity;continentalness;erosion;depth;weirdness;spawnTarget", "a", "b", "c", "d", "e", "f", "g"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Sampler.class, "temperature;humidity;continentalness;erosion;depth;weirdness;spawnTarget", "a", "b", "c", "d", "e", "f", "g"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Sampler.class, "temperature;humidity;continentalness;erosion;depth;weirdness;spawnTarget", "a", "b", "c", "d", "e", "f", "g"}, this, o2);
        }

        public DensityFunction b() {
            return this.a;
        }

        public DensityFunction c() {
            return this.b;
        }

        public DensityFunction d() {
            return this.c;
        }

        public DensityFunction e() {
            return this.d;
        }

        public DensityFunction f() {
            return this.e;
        }

        public DensityFunction g() {
            return this.f;
        }

        public List<d> h() {
            return this.g;
        }
    }

    static class g {
        private static final long a = 2048L;
        a b;

        g(List<d> points, Sampler sampler) {
            this.b = g.a(points, sampler, 0, 0);
            this.a(points, sampler, 2048.0f, 512.0f);
            this.a(points, sampler, 512.0f, 32.0f);
        }

        private void a(List<d> point, Sampler sampler, float max, float min) {
            float f2 = 0.0f;
            float f1 = min;
            BlockPosition blockPos = this.b.a();
            while (f1 <= max) {
                int i1;
                int i2 = blockPos.u() + (int)(Math.sin(f2) * (double)f1);
                a spawnPositionAndFitness = g.a(point, sampler, i2, i1 = blockPos.w() + (int)(Math.cos(f2) * (double)f1));
                if (spawnPositionAndFitness.b() < this.b.b()) {
                    this.b = spawnPositionAndFitness;
                }
                if (!((double)(f2 += min / f1) > Math.PI * 2)) continue;
                f2 = 0.0f;
                f1 += min;
            }
        }

        private static a a(List<d> points, Sampler sampler, int x2, int z2) {
            h targetPoint = sampler.a(QuartPos.a(x2), 0, QuartPos.a(z2));
            h targetPoint1 = new h(targetPoint.b(), targetPoint.c(), targetPoint.d(), targetPoint.e(), 0L, targetPoint.g());
            long l2 = Long.MAX_VALUE;
            for (d parameterPoint : points) {
                l2 = Math.min(l2, parameterPoint.a(targetPoint1));
            }
            long l1 = MathHelper.b((long)x2) + MathHelper.b((long)z2);
            long l22 = l2 * MathHelper.b(2048L) + l1;
            return new a(new BlockPosition(x2, 0, z2), l22);
        }

        record a(BlockPosition a, long b) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "location;fitness", "a", "b"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "location;fitness", "a", "b"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "location;fitness", "a", "b"}, this, o2);
            }
        }
    }

    protected static final class e<T> {
        private static final int a = 6;
        private final b<T> b;
        private final ThreadLocal<a<T>> c = new ThreadLocal();

        private e(b<T> root) {
            this.b = root;
        }

        public static <T> e<T> a(List<Pair<d, T>> nodes) {
            if (nodes.isEmpty()) {
                throw new IllegalArgumentException("Need at least one value to build the search tree.");
            }
            int size = ((d)nodes.get(0).getFirst()).a().size();
            if (size != 7) {
                throw new IllegalStateException("Expecting parameter space to be 7, got " + size);
            }
            List list = nodes.stream().map(node -> new a<Object>((d)node.getFirst(), node.getSecond())).collect(Collectors.toCollection(ArrayList::new));
            return new e<T>(e.a(size, list));
        }

        private static <T> b<T> a(int paramSpaceSize, List<? extends b<T>> children) {
            if (children.isEmpty()) {
                throw new IllegalStateException("Need at least one child to build a node");
            }
            if (children.size() == 1) {
                return children.get(0);
            }
            if (children.size() <= 6) {
                children.sort(Comparator.comparingLong(child -> {
                    long l2 = 0L;
                    for (int i2 = 0; i2 < paramSpaceSize; ++i2) {
                        net.minecraft.world.level.biome.Climate$b parameter = child.a[i2];
                        l2 += Math.abs((parameter.a() + parameter.b()) / 2L);
                    }
                    return l2;
                }));
                return new c(children);
            }
            long l2 = Long.MAX_VALUE;
            int i2 = -1;
            List<c<T>> list = null;
            for (int i1 = 0; i1 < paramSpaceSize; ++i1) {
                e.a(children, paramSpaceSize, i1, false);
                List<c<T>> list1 = e.b(children);
                long l1 = 0L;
                for (c<T> subTree : list1) {
                    l1 += e.a(subTree.a);
                }
                if (l2 <= l1) continue;
                l2 = l1;
                i2 = i1;
                list = list1;
            }
            e.a(list, paramSpaceSize, i2, true);
            return new c(list.stream().map(subTree1 -> e.a(paramSpaceSize, Arrays.asList(subTree1.b))).collect(Collectors.toList()));
        }

        private static <T> void a(List<? extends b<T>> children, int paramSpaceSize, int size, boolean absolute) {
            Comparator<b<b<T>>> comparator = e.a(size, absolute);
            for (int i2 = 1; i2 < paramSpaceSize; ++i2) {
                comparator = comparator.thenComparing(e.a((size + i2) % paramSpaceSize, absolute));
            }
            children.sort(comparator);
        }

        private static <T> Comparator<b<T>> a(int size, boolean absolute) {
            return Comparator.comparingLong(node -> {
                net.minecraft.world.level.biome.Climate$b parameter = node.a[size];
                long l2 = (parameter.a() + parameter.b()) / 2L;
                return absolute ? Math.abs(l2) : l2;
            });
        }

        private static <T> List<c<T>> b(List<? extends b<T>> nodes) {
            ArrayList list = Lists.newArrayList();
            ArrayList list1 = Lists.newArrayList();
            int i2 = (int)Math.pow(6.0, Math.floor(Math.log((double)nodes.size() - 0.01) / Math.log(6.0)));
            for (b<T> node : nodes) {
                list1.add(node);
                if (list1.size() < i2) continue;
                list.add(new c(list1));
                list1 = Lists.newArrayList();
            }
            if (!list1.isEmpty()) {
                list.add(new c(list1));
            }
            return list;
        }

        private static long a(net.minecraft.world.level.biome.Climate$b[] parameters) {
            long l2 = 0L;
            for (net.minecraft.world.level.biome.Climate$b parameter : parameters) {
                l2 += Math.abs(parameter.b() - parameter.a());
            }
            return l2;
        }

        static <T> List<net.minecraft.world.level.biome.Climate$b> c(List<? extends b<T>> children) {
            if (children.isEmpty()) {
                throw new IllegalArgumentException("SubTree needs at least one child");
            }
            int i2 = 7;
            ArrayList list = Lists.newArrayList();
            for (int i1 = 0; i1 < 7; ++i1) {
                list.add(null);
            }
            for (b<T> node : children) {
                for (int i22 = 0; i22 < 7; ++i22) {
                    list.set(i22, node.a[i22].b((net.minecraft.world.level.biome.Climate$b)list.get(i22)));
                }
            }
            return list;
        }

        public T a(h targetPoint, net.minecraft.world.level.biome.Climate$a<T> distanceMetric) {
            long[] longs = targetPoint.a();
            a<T> leaf = this.b.a(longs, this.c.get(), distanceMetric);
            this.c.set(leaf);
            return leaf.b;
        }

        static abstract class b<T> {
            protected final net.minecraft.world.level.biome.Climate$b[] a;

            protected b(List<net.minecraft.world.level.biome.Climate$b> parameters) {
                this.a = parameters.toArray(new net.minecraft.world.level.biome.Climate$b[0]);
            }

            protected abstract a<T> a(long[] var1, @Nullable a<T> var2, net.minecraft.world.level.biome.Climate$a<T> var3);

            protected long a(long[] values) {
                long l2 = 0L;
                for (int i2 = 0; i2 < 7; ++i2) {
                    l2 += MathHelper.b(this.a[i2].a(values[i2]));
                }
                return l2;
            }

            public String toString() {
                return Arrays.toString(this.a);
            }
        }

        static final class c<T>
        extends b<T> {
            final b<T>[] b;

            protected c(List<? extends b<T>> children) {
                this(e.c(children), children);
            }

            protected c(List<net.minecraft.world.level.biome.Climate$b> parameters, List<? extends b<T>> children) {
                super(parameters);
                this.b = children.toArray(new b[0]);
            }

            @Override
            protected a<T> a(long[] searchedValues, @Nullable a<T> leaf, net.minecraft.world.level.biome.Climate$a<T> metric) {
                long l2 = leaf == null ? Long.MAX_VALUE : metric.distance(leaf, searchedValues);
                a<T> leaf1 = leaf;
                for (b<T> node : this.b) {
                    long l22;
                    long l1 = metric.distance(node, searchedValues);
                    if (l2 <= l1) continue;
                    a<T> leaf2 = node.a(searchedValues, leaf1, metric);
                    long l3 = l22 = node == leaf2 ? l1 : metric.distance(leaf2, searchedValues);
                    if (l2 <= l22) continue;
                    l2 = l22;
                    leaf1 = leaf2;
                }
                return leaf1;
            }
        }

        static final class a<T>
        extends b<T> {
            final T b;

            a(d parameters, T value) {
                super(parameters.a());
                this.b = value;
            }

            @Override
            protected a<T> a(long[] searchedValues, @Nullable a<T> leaf, net.minecraft.world.level.biome.Climate$a<T> metric) {
                return this;
            }
        }
    }

    public static class c<T> {
        private final List<Pair<d, T>> a;
        private final e<T> b;

        public static <T> Codec<c<T>> a(MapCodec<T> codec) {
            return ExtraCodecs.b(RecordCodecBuilder.create(instance -> instance.group((App)d.a.fieldOf("parameters").forGetter(Pair::getFirst), (App)codec.forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::of)).listOf()).xmap(c::new, c::a);
        }

        public c(List<Pair<d, T>> values) {
            this.a = values;
            this.b = e.a(values);
        }

        public List<Pair<d, T>> a() {
            return this.a;
        }

        public T a(h targetPoint) {
            return this.c(targetPoint);
        }

        @VisibleForTesting
        public T b(h targetPoint) {
            Iterator<Pair<d, T>> iterator = this.a().iterator();
            Pair<d, T> pair = iterator.next();
            long l2 = ((d)pair.getFirst()).a(targetPoint);
            Object second = pair.getSecond();
            while (iterator.hasNext()) {
                Pair<d, T> pair1 = iterator.next();
                long l1 = ((d)pair1.getFirst()).a(targetPoint);
                if (l1 >= l2) continue;
                l2 = l1;
                second = pair1.getSecond();
            }
            return (T)second;
        }

        public T c(h targetPoint) {
            return this.a(targetPoint, e.b::a);
        }

        protected T a(h targetPoint, a<T> distanceMetric) {
            return this.b.a(targetPoint, distanceMetric);
        }
    }

    static interface a<T> {
        public long distance(e.b<T> var1, long[] var2);
    }
}

