/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.InventoryLargeChest;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.animal.EntityCat;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerChest;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockChestAbstract;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.DoubleBlockFinder;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityChest;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyChestType;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockChest
extends BlockChestAbstract<TileEntityChest>
implements IBlockWaterlogged {
    public static final MapCodec<BlockChest> b = BlockChest.b(properties -> new BlockChest(() -> TileEntityTypes.b, (BlockBase.Info)properties));
    public static final BlockStateEnum<EnumDirection> c = BlockFacingHorizontal.e;
    public static final BlockStateEnum<BlockPropertyChestType> d = BlockProperties.bf;
    public static final BlockStateBoolean e = BlockProperties.I;
    public static final int f = 1;
    private static final VoxelShape g = Block.b(14.0, 0.0, 14.0);
    private static final Map<EnumDirection, VoxelShape> h = VoxelShapes.c(Block.a(14.0, 0.0, 14.0, 0.0, 15.0));
    private static final DoubleBlockFinder.Combiner<TileEntityChest, Optional<IInventory>> i = new DoubleBlockFinder.Combiner<TileEntityChest, Optional<IInventory>>(){

        @Override
        public Optional<IInventory> a(TileEntityChest first, TileEntityChest second) {
            return Optional.of(new InventoryLargeChest(first, second));
        }

        @Override
        public Optional<IInventory> a(TileEntityChest single) {
            return Optional.of(single);
        }

        public Optional<IInventory> a() {
            return Optional.empty();
        }
    };
    public static DoubleBlockFinder.Combiner<TileEntityChest, Optional<ITileInventory>> D = new DoubleBlockFinder.Combiner<TileEntityChest, Optional<ITileInventory>>(){

        @Override
        public Optional<ITileInventory> a(final TileEntityChest first, final TileEntityChest second) {
            final InventoryLargeChest container = new InventoryLargeChest(first, second);
            return Optional.of(DoubleInventory.wrap(new ITileInventory(){

                @Override
                @Nullable
                public Container createMenu(int containerId, PlayerInventory playerInventory, EntityHuman player) {
                    if (first.d(player) && second.d(player)) {
                        first.d_(playerInventory.h);
                        second.d_(playerInventory.h);
                        return ContainerChest.b(containerId, playerInventory, container);
                    }
                    return null;
                }

                @Override
                public IChatBaseComponent P_() {
                    if (first.g_()) {
                        return first.P_();
                    }
                    return second.g_() ? second.P_() : IChatBaseComponent.c("container.chestDouble");
                }
            }, container));
        }

        @Override
        public Optional<ITileInventory> a(TileEntityChest single) {
            return Optional.of(single);
        }

        public Optional<ITileInventory> a() {
            return Optional.empty();
        }
    };

    @Override
    public MapCodec<? extends BlockChest> a() {
        return b;
    }

    protected BlockChest(Supplier<TileEntityTypes<? extends TileEntityChest>> blockEntityType, BlockBase.Info properties) {
        super(properties, blockEntityType);
        this.l((IBlockData)((IBlockData)((IBlockData)this.C.b().b(c, EnumDirection.c)).b(d, BlockPropertyChestType.a)).b(e, false));
    }

    public static DoubleBlockFinder.BlockType h(IBlockData state) {
        BlockPropertyChestType chestType = state.c(d);
        if (chestType == BlockPropertyChestType.a) {
            return DoubleBlockFinder.BlockType.a;
        }
        return chestType == BlockPropertyChestType.c ? DoubleBlockFinder.BlockType.b : DoubleBlockFinder.BlockType.c;
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (state.c(e).booleanValue()) {
            scheduledTickAccess.a(pos, FluidTypes.c, FluidTypes.c.a(level));
        }
        if (neighborState.a(this) && direction.o().d()) {
            BlockPropertyChestType chestType = neighborState.c(d);
            if (state.c(d) == BlockPropertyChestType.a && chestType != BlockPropertyChestType.a && state.c(c) == neighborState.c(c) && BlockChest.i(neighborState) == direction.g()) {
                return (IBlockData)state.b(d, chestType.a());
            }
        } else if (BlockChest.i(state) == direction) {
            return (IBlockData)state.b(d, BlockPropertyChestType.a);
        }
        return super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return switch (state.c(d)) {
            default -> throw new MatchException(null, null);
            case BlockPropertyChestType.a -> g;
            case BlockPropertyChestType.b, BlockPropertyChestType.c -> h.get(BlockChest.i(state));
        };
    }

    public static EnumDirection i(IBlockData state) {
        EnumDirection direction = state.c(c);
        return state.c(d) == BlockPropertyChestType.b ? direction.h() : direction.i();
    }

    @Override
    public IBlockData a(BlockActionContext context) {
        EnumDirection direction;
        BlockPropertyChestType chestType = BlockPropertyChestType.a;
        EnumDirection opposite = context.g().g();
        Fluid fluidState = context.q().b_(context.a());
        boolean isSecondaryUseActive = context.h();
        EnumDirection clickedFace = context.k();
        if (clickedFace.o().d() && isSecondaryUseActive && (direction = this.a(context, clickedFace.g())) != null && direction.o() != clickedFace.o()) {
            opposite = direction;
            BlockPropertyChestType blockPropertyChestType = chestType = direction.i() == clickedFace.g() ? BlockPropertyChestType.c : BlockPropertyChestType.b;
        }
        if (chestType == BlockPropertyChestType.a && !isSecondaryUseActive) {
            if (opposite == this.a(context, opposite.h())) {
                chestType = BlockPropertyChestType.b;
            } else if (opposite == this.a(context, opposite.i())) {
                chestType = BlockPropertyChestType.c;
            }
        }
        return (IBlockData)((IBlockData)((IBlockData)this.m().b(c, opposite)).b(d, chestType)).b(e, fluidState.a() == FluidTypes.c);
    }

    @Override
    protected Fluid b_(IBlockData state) {
        return state.c(e) != false ? FluidTypes.c.a(false) : super.b_(state);
    }

    @Nullable
    private EnumDirection a(BlockActionContext context, EnumDirection direction) {
        IBlockData blockState = context.q().a_(context.a().a(direction));
        return blockState.a(this) && blockState.c(d) == BlockPropertyChestType.a ? blockState.c(c) : null;
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, boolean movedByPiston) {
        InventoryUtils.a(state, level, pos);
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World level, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hitResult) {
        if (level instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)level;
            ITileInventory menuProvider = this.b(state, level, pos);
            if (menuProvider != null && player.a(menuProvider).isPresent()) {
                player.b(this.c());
                PiglinAI.a(serverLevel, player, true);
            }
        }
        return EnumInteractionResult.a;
    }

    protected Statistic<MinecraftKey> c() {
        return StatisticList.i.b(StatisticList.ao);
    }

    public TileEntityTypes<? extends TileEntityChest> d() {
        return this.a.get();
    }

    @Nullable
    public static IInventory a(BlockChest chest, IBlockData state, World level, BlockPosition pos, boolean override) {
        return chest.a(state, level, pos, override).apply(i).orElse(null);
    }

    @Override
    public DoubleBlockFinder.Result<? extends TileEntityChest> a(IBlockData state, World level, BlockPosition pos, boolean override) {
        BiPredicate<GeneratorAccess, BlockPosition> biPredicate = override ? (levelAccessor, blockPos) -> false : BlockChest::a;
        return DoubleBlockFinder.a(this.a.get(), BlockChest::h, BlockChest::i, c, state, level, pos, biPredicate);
    }

    @Override
    @Nullable
    public ITileInventory b(IBlockData state, World level, BlockPosition pos) {
        return this.getMenuProvider(state, level, pos, false);
    }

    @Nullable
    public ITileInventory getMenuProvider(IBlockData state, World level, BlockPosition pos, boolean ignoreObstructions) {
        return this.a(state, level, pos, ignoreObstructions).apply(D).orElse(null);
    }

    public static DoubleBlockFinder.Combiner<TileEntityChest, Float2FloatFunction> a(final LidBlockEntity lid) {
        return new DoubleBlockFinder.Combiner<TileEntityChest, Float2FloatFunction>(){

            @Override
            public Float2FloatFunction a(TileEntityChest first, TileEntityChest second) {
                return partialTicks -> Math.max(first.a(partialTicks), second.a(partialTicks));
            }

            @Override
            public Float2FloatFunction a(TileEntityChest single) {
                return single::a;
            }

            public Float2FloatFunction a() {
                return lid::a;
            }
        };
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityChest(pos, state);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> a(World level, IBlockData state, TileEntityTypes<T> blockEntityType) {
        return level.C ? BlockChest.a(blockEntityType, this.d(), TileEntityChest::a) : null;
    }

    public static boolean a(GeneratorAccess level, BlockPosition pos) {
        return BlockChest.a((IBlockAccess)level, pos) || BlockChest.b(level, pos);
    }

    public static boolean a(IBlockAccess level, BlockPosition pos) {
        BlockPosition blockPos = pos.d();
        return level.a_(blockPos).d(level, blockPos);
    }

    private static boolean b(GeneratorAccess level, BlockPosition pos) {
        if (level.getMinecraftWorld().paperConfig().entities.behavior.disableChestCatDetection) {
            return false;
        }
        List<EntityCat> entitiesOfClass = level.a(EntityCat.class, new AxisAlignedBB(pos.u(), pos.v() + 1, pos.w(), pos.u() + 1, pos.v() + 2, pos.w() + 1));
        if (!entitiesOfClass.isEmpty()) {
            for (EntityCat cat : entitiesOfClass) {
                if (!cat.u()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean c_(IBlockData state) {
        return true;
    }

    @Override
    protected int a(IBlockData blockState, World level, BlockPosition pos) {
        return Container.b(BlockChest.a(this, blockState, level, pos, false));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.b(c, rotation.a(state.c(c)));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(c)));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(c, d, e);
    }

    @Override
    protected boolean a(IBlockData state, PathMode pathComputationType) {
        return false;
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        TileEntity blockEntity = level.c_(pos);
        if (blockEntity instanceof TileEntityChest) {
            ((TileEntityChest)blockEntity).k();
        }
    }

    public static class DoubleInventory
    implements ITileInventory {
        private final ITileInventory delegate;
        public final InventoryLargeChest container;

        private DoubleInventory(ITileInventory delegate, InventoryLargeChest container) {
            this.delegate = delegate;
            this.container = container;
        }

        public static DoubleInventory wrap(ITileInventory delegate, InventoryLargeChest container) {
            return new DoubleInventory(delegate, container);
        }

        @Override
        @Nullable
        public Container createMenu(int syncId, PlayerInventory playerInventory, EntityHuman player) {
            return this.delegate.createMenu(syncId, playerInventory, player);
        }

        @Override
        public IChatBaseComponent P_() {
            return this.delegate.P_();
        }
    }
}

