/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFenceGate;
import net.minecraft.world.level.block.BlockIronBars;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyWallHeight;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockCobbleWall
extends Block
implements IBlockWaterlogged {
    public static final MapCodec<BlockCobbleWall> a = BlockCobbleWall.b(BlockCobbleWall::new);
    public static final BlockStateBoolean b = BlockProperties.L;
    public static final BlockStateEnum<BlockPropertyWallHeight> c = BlockProperties.Z;
    public static final BlockStateEnum<BlockPropertyWallHeight> d = BlockProperties.aa;
    public static final BlockStateEnum<BlockPropertyWallHeight> e = BlockProperties.ab;
    public static final BlockStateEnum<BlockPropertyWallHeight> f = BlockProperties.ac;
    public static final Map<EnumDirection, BlockStateEnum<BlockPropertyWallHeight>> g = ImmutableMap.copyOf((Map)Maps.newEnumMap(Map.of(EnumDirection.c, d, EnumDirection.f, c, EnumDirection.d, e, EnumDirection.e, f)));
    public static final BlockStateBoolean h = BlockProperties.I;
    private final Function<IBlockData, VoxelShape> i;
    private final Function<IBlockData, VoxelShape> D;
    private static final VoxelShape R = Block.b(2.0, 0.0, 16.0);
    private static final Map<EnumDirection, VoxelShape> S = VoxelShapes.c(Block.b(2.0, 16.0, 0.0, 9.0));

    public MapCodec<BlockCobbleWall> a() {
        return a;
    }

    public BlockCobbleWall(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.C.b().b(b, true)).b(d, BlockPropertyWallHeight.a)).b(c, BlockPropertyWallHeight.a)).b(e, BlockPropertyWallHeight.a)).b(f, BlockPropertyWallHeight.a)).b(h, false));
        this.i = this.a(16.0f, 14.0f);
        this.D = this.a(24.0f, 24.0f);
    }

    private Function<IBlockData, VoxelShape> a(float height, float width) {
        VoxelShape voxelShape = Block.b(8.0, 0.0, height);
        int i2 = 6;
        Map<EnumDirection, VoxelShape> map = VoxelShapes.c(Block.a(6.0, 0.0, (double)width, 0.0, 11.0));
        Map<EnumDirection, VoxelShape> map1 = VoxelShapes.c(Block.a(6.0, 0.0, (double)height, 0.0, 11.0));
        return this.a((IBlockData state) -> {
            VoxelShape voxelShape1 = state.c(b) != false ? voxelShape : VoxelShapes.a();
            for (Map.Entry<EnumDirection, BlockStateEnum<BlockPropertyWallHeight>> entry : g.entrySet()) {
                voxelShape1 = VoxelShapes.a(voxelShape1, switch ((BlockPropertyWallHeight)state.c(entry.getValue())) {
                    default -> throw new MatchException(null, null);
                    case BlockPropertyWallHeight.a -> VoxelShapes.a();
                    case BlockPropertyWallHeight.b -> (VoxelShape)map.get(entry.getKey());
                    case BlockPropertyWallHeight.c -> (VoxelShape)map1.get(entry.getKey());
                });
            }
            return voxelShape1;
        }, h);
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return this.i.apply(state);
    }

    @Override
    protected VoxelShape b(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return this.D.apply(state);
    }

    @Override
    protected boolean a(IBlockData state, PathMode pathComputationType) {
        return false;
    }

    private boolean a(IBlockData state, boolean sideSolid, EnumDirection direction) {
        Block block = state.b();
        boolean flag = block instanceof BlockFenceGate && BlockFenceGate.a(state, direction);
        return state.a(TagsBlock.N) || !BlockCobbleWall.k(state) && sideSolid || block instanceof BlockIronBars || flag;
    }

    @Override
    public IBlockData a(BlockActionContext context) {
        World level = context.q();
        BlockPosition clickedPos = context.a();
        Fluid fluidState = context.q().b_(context.a());
        BlockPosition blockPos = clickedPos.f();
        BlockPosition blockPos1 = clickedPos.i();
        BlockPosition blockPos2 = clickedPos.g();
        BlockPosition blockPos3 = clickedPos.h();
        BlockPosition blockPos4 = clickedPos.d();
        IBlockData blockState = level.a_(blockPos);
        IBlockData blockState1 = level.a_(blockPos1);
        IBlockData blockState2 = level.a_(blockPos2);
        IBlockData blockState3 = level.a_(blockPos3);
        IBlockData blockState4 = level.a_(blockPos4);
        boolean flag = this.a(blockState, blockState.c((IBlockAccess)level, blockPos, EnumDirection.d), EnumDirection.d);
        boolean flag1 = this.a(blockState1, blockState1.c((IBlockAccess)level, blockPos1, EnumDirection.e), EnumDirection.e);
        boolean flag2 = this.a(blockState2, blockState2.c((IBlockAccess)level, blockPos2, EnumDirection.c), EnumDirection.c);
        boolean flag3 = this.a(blockState3, blockState3.c((IBlockAccess)level, blockPos3, EnumDirection.f), EnumDirection.f);
        IBlockData blockState5 = (IBlockData)this.m().b(h, fluidState.a() == FluidTypes.c);
        return this.a(level, blockState5, blockPos4, blockState4, flag, flag1, flag2, flag3);
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (state.c(h).booleanValue()) {
            scheduledTickAccess.a(pos, FluidTypes.c, FluidTypes.c.a(level));
        }
        if (direction == EnumDirection.a) {
            return super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
        }
        return direction == EnumDirection.b ? this.a(level, state, neighborPos, neighborState) : this.a(level, pos, state, neighborPos, neighborState, direction);
    }

    private static boolean a(IBlockData state, IBlockState<BlockPropertyWallHeight> heightProperty) {
        return state.c(heightProperty) != BlockPropertyWallHeight.a;
    }

    private static boolean a(VoxelShape firstShape, VoxelShape secondShape) {
        return !VoxelShapes.c(secondShape, firstShape, OperatorBoolean.e);
    }

    private IBlockData a(IWorldReader level, IBlockData state, BlockPosition pos, IBlockData secondState) {
        boolean isConnected = BlockCobbleWall.a(state, d);
        boolean isConnected1 = BlockCobbleWall.a(state, c);
        boolean isConnected2 = BlockCobbleWall.a(state, e);
        boolean isConnected3 = BlockCobbleWall.a(state, f);
        return this.a(level, state, pos, secondState, isConnected, isConnected1, isConnected2, isConnected3);
    }

    private IBlockData a(IWorldReader level, BlockPosition firstPos, IBlockData firstState, BlockPosition secondPos, IBlockData secondState, EnumDirection dir) {
        EnumDirection opposite = dir.g();
        boolean flag = dir == EnumDirection.c ? this.a(secondState, secondState.c((IBlockAccess)level, secondPos, opposite), opposite) : BlockCobbleWall.a(firstState, d);
        boolean flag1 = dir == EnumDirection.f ? this.a(secondState, secondState.c((IBlockAccess)level, secondPos, opposite), opposite) : BlockCobbleWall.a(firstState, c);
        boolean flag2 = dir == EnumDirection.d ? this.a(secondState, secondState.c((IBlockAccess)level, secondPos, opposite), opposite) : BlockCobbleWall.a(firstState, e);
        boolean flag3 = dir == EnumDirection.e ? this.a(secondState, secondState.c((IBlockAccess)level, secondPos, opposite), opposite) : BlockCobbleWall.a(firstState, f);
        BlockPosition blockPos = firstPos.d();
        IBlockData blockState = level.a_(blockPos);
        return this.a(level, firstState, blockPos, blockState, flag, flag1, flag2, flag3);
    }

    private IBlockData a(IWorldReader level, IBlockData state, BlockPosition pos, IBlockData neighbour, boolean northConnection, boolean eastConnection, boolean southConnection, boolean westConnection) {
        VoxelShape faceShape = neighbour.g(level, pos).a(EnumDirection.a);
        IBlockData blockState = this.a(state, northConnection, eastConnection, southConnection, westConnection, faceShape);
        return (IBlockData)blockState.b(b, this.a(blockState, neighbour, faceShape));
    }

    private boolean a(IBlockData state, IBlockData neighbour, VoxelShape shape) {
        boolean flag5;
        boolean flag;
        boolean bl = flag = neighbour.b() instanceof BlockCobbleWall && neighbour.c(b) != false;
        if (flag) {
            return true;
        }
        BlockPropertyWallHeight wallSide = state.c(d);
        BlockPropertyWallHeight wallSide1 = state.c(e);
        BlockPropertyWallHeight wallSide2 = state.c(c);
        BlockPropertyWallHeight wallSide3 = state.c(f);
        boolean flag1 = wallSide1 == BlockPropertyWallHeight.a;
        boolean flag2 = wallSide3 == BlockPropertyWallHeight.a;
        boolean flag3 = wallSide2 == BlockPropertyWallHeight.a;
        boolean flag4 = wallSide == BlockPropertyWallHeight.a;
        boolean bl2 = flag5 = flag4 && flag1 && flag2 && flag3 || flag4 != flag1 || flag2 != flag3;
        if (flag5) {
            return true;
        }
        boolean flag6 = wallSide == BlockPropertyWallHeight.c && wallSide1 == BlockPropertyWallHeight.c || wallSide2 == BlockPropertyWallHeight.c && wallSide3 == BlockPropertyWallHeight.c;
        return !flag6 && (neighbour.a(TagsBlock.aR) || BlockCobbleWall.a(shape, R));
    }

    private IBlockData a(IBlockData state, boolean northConnection, boolean eastConnection, boolean southConnection, boolean westConnection, VoxelShape wallShape) {
        return (IBlockData)((IBlockData)((IBlockData)((IBlockData)state.b(d, this.a(northConnection, wallShape, S.get(EnumDirection.c)))).b(c, this.a(eastConnection, wallShape, S.get(EnumDirection.f)))).b(e, this.a(southConnection, wallShape, S.get(EnumDirection.d)))).b(f, this.a(westConnection, wallShape, S.get(EnumDirection.e)));
    }

    private BlockPropertyWallHeight a(boolean allowConnection, VoxelShape shape, VoxelShape neighbourShape) {
        if (allowConnection) {
            return BlockCobbleWall.a(shape, neighbourShape) ? BlockPropertyWallHeight.c : BlockPropertyWallHeight.b;
        }
        return BlockPropertyWallHeight.a;
    }

    @Override
    protected Fluid b_(IBlockData state) {
        return state.c(h) != false ? FluidTypes.c.a(false) : super.b_(state);
    }

    @Override
    protected boolean e_(IBlockData state) {
        return state.c(h) == false;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, d, c, f, e, h);
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        switch (rotation) {
            case c: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)state.b(d, state.c(e))).b(c, state.c(f))).b(e, state.c(d))).b(f, state.c(c));
            }
            case d: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)state.b(d, state.c(c))).b(c, state.c(e))).b(e, state.c(f))).b(f, state.c(d));
            }
            case b: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)state.b(d, state.c(f))).b(c, state.c(d))).b(e, state.c(c))).b(f, state.c(e));
            }
        }
        return state;
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        switch (mirror) {
            case b: {
                return (IBlockData)((IBlockData)state.b(d, state.c(e))).b(e, state.c(d));
            }
            case c: {
                return (IBlockData)((IBlockData)state.b(c, state.c(f))).b(f, state.c(c));
            }
        }
        return super.a(state, mirror);
    }
}

