/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.core.dispenser.DispenseBehaviorProjectile;
import net.minecraft.core.dispenser.EquipmentDispenseItemBehavior;
import net.minecraft.core.dispenser.IDispenseBehavior;
import net.minecraft.core.dispenser.SourceBlock;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDirectional;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityDispenser;
import net.minecraft.world.level.block.entity.TileEntityDropper;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.slf4j.Logger;

public class BlockDispenser
extends BlockTileEntity {
    private static final Logger e = LogUtils.getLogger();
    public static final MapCodec<BlockDispenser> a = BlockDispenser.b(BlockDispenser::new);
    public static final BlockStateEnum<EnumDirection> b = BlockDirectional.a;
    public static final BlockStateBoolean c = BlockProperties.G;
    private static final DispenseBehaviorItem f = new DispenseBehaviorItem();
    public static final Map<Item, IDispenseBehavior> d = new IdentityHashMap<Item, IDispenseBehavior>();
    private static final int g = 4;

    public MapCodec<? extends BlockDispenser> a() {
        return a;
    }

    public static void a(IMaterial item, IDispenseBehavior behavior) {
        d.put(item.h(), behavior);
    }

    public static void a(IMaterial item) {
        d.put(item.h(), new DispenseBehaviorProjectile(item.h()));
    }

    protected BlockDispenser(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)((IBlockData)this.C.b().b(b, EnumDirection.c)).b(c, false));
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World level, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hitResult) {
        TileEntityDispenser dispenserBlockEntity;
        TileEntity tileEntity;
        if (!level.C && (tileEntity = level.c_(pos)) instanceof TileEntityDispenser && player.a(dispenserBlockEntity = (TileEntityDispenser)tileEntity).isPresent()) {
            player.a(dispenserBlockEntity instanceof TileEntityDropper ? StatisticList.ac : StatisticList.ae);
        }
        return EnumInteractionResult.a;
    }

    public void a(WorldServer level, IBlockData state, BlockPosition pos) {
        TileEntityDispenser dispenserBlockEntity = level.a(pos, TileEntityTypes.f).orElse(null);
        if (dispenserBlockEntity == null) {
            e.warn("Ignoring dispensing attempt for Dispenser without matching block entity at {}", (Object)pos);
        } else {
            SourceBlock blockSource = new SourceBlock(level, pos, state, dispenserBlockEntity);
            int randomSlot = dispenserBlockEntity.a(level.A);
            if (randomSlot < 0) {
                if (CraftEventFactory.handleBlockFailedDispenseEvent(level, pos)) {
                    level.c(1001, pos, 0);
                    level.a(GameEvent.a, pos, GameEvent.a.a(dispenserBlockEntity.m()));
                }
            } else {
                ItemStack item = dispenserBlockEntity.a(randomSlot);
                IDispenseBehavior dispenseMethod = this.a((World)level, item);
                if (dispenseMethod != IDispenseBehavior.b) {
                    if (!CraftEventFactory.handleBlockPreDispenseEvent(level, pos, item, randomSlot)) {
                        return;
                    }
                    dispenserBlockEntity.a(randomSlot, dispenseMethod.dispense(blockSource, item));
                }
            }
        }
    }

    public static IDispenseBehavior getDispenseBehavior(SourceBlock pointer, ItemStack stack) {
        return ((BlockDispenser)pointer.d().b()).a((World)pointer.b(), stack);
    }

    protected IDispenseBehavior a(World level, ItemStack item) {
        if (!item.a(level.K())) {
            return f;
        }
        IDispenseBehavior dispenseItemBehavior = d.get(item.h());
        return dispenseItemBehavior != null ? dispenseItemBehavior : BlockDispenser.a(item);
    }

    private static IDispenseBehavior a(ItemStack stack) {
        return stack.c(DataComponents.D) ? EquipmentDispenseItemBehavior.c : f;
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        boolean flag = level.D(pos) || level.D(pos.d());
        boolean triggeredValue = state.c(c);
        if (flag && !triggeredValue) {
            level.a(pos, (Block)this, 4);
            level.a(pos, (IBlockData)state.b(c, true), 2);
        } else if (!flag && triggeredValue) {
            level.a(pos, (IBlockData)state.b(c, false), 2);
        }
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        this.a(level, state, pos);
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityDispenser(pos, state);
    }

    @Override
    public IBlockData a(BlockActionContext context) {
        return (IBlockData)this.m().b(b, context.d().g());
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, boolean movedByPiston) {
        InventoryUtils.a(state, level, pos);
    }

    public static IPosition a(SourceBlock blockSource) {
        return BlockDispenser.a(blockSource, 0.7, Vec3D.c);
    }

    public static IPosition a(SourceBlock blockSource, double multiplier, Vec3D offset) {
        EnumDirection direction = blockSource.d().c(b);
        return blockSource.a().b(multiplier * (double)direction.j() + offset.a(), multiplier * (double)direction.k() + offset.b(), multiplier * (double)direction.l() + offset.c());
    }

    @Override
    protected boolean c_(IBlockData state) {
        return true;
    }

    @Override
    protected int a(IBlockData blockState, World level, BlockPosition pos) {
        return Container.a(level.c_(pos));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.b(b, rotation.a(state.c(b)));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(b)));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, c);
    }
}

