/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.TileInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerEnchantTable;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityEnchantTable;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockEnchantmentTable
extends BlockTileEntity {
    public static final MapCodec<BlockEnchantmentTable> a = BlockEnchantmentTable.b(BlockEnchantmentTable::new);
    public static final List<BlockPosition> b = BlockPosition.a(-2, 0, -2, 2, 1, 2).filter(blockPos -> Math.abs(blockPos.u()) == 2 || Math.abs(blockPos.w()) == 2).map(BlockPosition::j).toList();
    private static final VoxelShape c = Block.b(16.0, 0.0, 12.0);

    public MapCodec<BlockEnchantmentTable> a() {
        return a;
    }

    protected BlockEnchantmentTable(BlockBase.Info properties) {
        super(properties);
    }

    public static boolean a(World level, BlockPosition enchantingTablePos, BlockPosition bookshelfPos) {
        return level.a_(enchantingTablePos.a(bookshelfPos)).a(TagsBlock.cC) && level.a_(enchantingTablePos.b(bookshelfPos.u() / 2, bookshelfPos.v(), bookshelfPos.w() / 2)).a(TagsBlock.cD);
    }

    @Override
    protected boolean g_(IBlockData state) {
        return true;
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return c;
    }

    @Override
    public void a(IBlockData state, World level, BlockPosition pos, RandomSource random) {
        super.a(state, level, pos, random);
        for (BlockPosition blockPos : b) {
            if (random.a(16) != 0 || !BlockEnchantmentTable.a(level, pos, blockPos)) continue;
            level.a(Particles.s, (double)pos.u() + 0.5, (double)pos.v() + 2.0, (double)pos.w() + 0.5, (double)((float)blockPos.u() + random.i()) - 0.5, (double)((float)blockPos.v() - random.i() - 1.0f), (double)((float)blockPos.w() + random.i()) - 0.5);
        }
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityEnchantTable(pos, state);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> a(World level, IBlockData state, TileEntityTypes<T> blockEntityType) {
        return level.C ? BlockEnchantmentTable.a(blockEntityType, TileEntityTypes.n, TileEntityEnchantTable::a) : null;
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World level, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hitResult) {
        if (!level.C) {
            player.a(state.b(level, pos));
        }
        return EnumInteractionResult.a;
    }

    @Override
    @Nullable
    public ITileInventory b(IBlockData state, World level, BlockPosition pos) {
        TileEntity blockEntity = level.c_(pos);
        if (blockEntity instanceof TileEntityEnchantTable) {
            IChatBaseComponent displayName = ((INamableTileEntity)((Object)blockEntity)).P_();
            return new TileInventory((containerId, playerInventory, player) -> new ContainerEnchantTable(containerId, playerInventory, ContainerAccess.a(level, pos)), displayName);
        }
        return null;
    }

    @Override
    protected boolean a(IBlockData state, PathMode pathComputationType) {
        return false;
    }
}

