/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import java.util.Set;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityEnderPortal;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.feature.EndPlatformFeature;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.Location;
import org.bukkit.PortalType;
import org.bukkit.craftbukkit.v1_21_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftPortalEvent;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftLocation;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPortalEnterEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class BlockEnderPortal
extends BlockTileEntity
implements Portal {
    public static final MapCodec<BlockEnderPortal> a = BlockEnderPortal.b(BlockEnderPortal::new);
    private static final VoxelShape b = Block.b(16.0, 6.0, 12.0);

    public MapCodec<BlockEnderPortal> a() {
        return a;
    }

    protected BlockEnderPortal(BlockBase.Info properties) {
        super(properties);
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityEnderPortal(pos, state);
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return b;
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, net.minecraft.world.entity.Entity entity) {
        return state.f(level, pos);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, net.minecraft.world.entity.Entity entity, InsideBlockEffectApplier effectApplier) {
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(level, pos)).callEvent()) {
            return;
        }
        if (!entity.n(false)) return;
        EntityPortalEnterEvent event = new EntityPortalEnterEvent((Entity)entity.getBukkitEntity(), CraftLocation.toBukkit(pos, level), PortalType.ENDER);
        level.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        if (!level.C && level.aj() == World.k && entity instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)entity;
            if (!serverPlayer.i) {
                if (level.paperConfig().misc.disableEndCredits) {
                    serverPlayer.i = true;
                    return;
                }
                serverPlayer.m();
                return;
            }
        }
        entity.a(this, pos);
    }

    @Override
    public TeleportTransition a(WorldServer level, net.minecraft.world.entity.Entity entity, BlockPosition pos) {
        Set<Relative> set;
        float f2;
        ResourceKey<World> resourceKey = level.getTypeKey() == WorldDimension.d ? World.i : World.k;
        WorldServer level1 = level.p().a(resourceKey);
        if (level1 == null) {
            return null;
        }
        boolean flag = resourceKey == World.k;
        BlockPosition blockPos = flag ? WorldServer.a : level1.aa();
        Vec3D bottomCenter = blockPos.c();
        if (flag) {
            EndPlatformFeature.createEndPlatform(level1, BlockPosition.a(bottomCenter).e(), true, entity);
            f2 = EnumDirection.e.p();
            set = Relative.a(Relative.l, Set.of(Relative.e));
            if (entity instanceof EntityPlayer) {
                bottomCenter = bottomCenter.a(0.0, 1.0, 0.0);
            }
        } else {
            f2 = 0.0f;
            set = Relative.a(Relative.l, Relative.k);
            if (entity instanceof EntityPlayer) {
                EntityPlayer serverPlayer = (EntityPlayer)entity;
                return serverPlayer.findRespawnPositionAndUseSpawnBlock(false, TeleportTransition.a, PlayerRespawnEvent.RespawnReason.END_PORTAL);
            }
            bottomCenter = entity.a(level1, blockPos).c();
        }
        set.removeAll(Relative.k);
        float absoluteYaw = flag ? f2 : entity.dL() + f2;
        CraftPortalEvent event = entity.callPortalEvent(entity, CraftLocation.toBukkit(bottomCenter, (org.bukkit.World)level1.getWorld(), absoluteYaw, entity.dN()), PlayerTeleportEvent.TeleportCause.END_PORTAL, 0, 0);
        if (event == null) {
            return null;
        }
        Location to = event.getTo();
        return new TeleportTransition(((CraftWorld)to.getWorld()).getHandle(), CraftLocation.toVec3(to), Vec3D.c, to.getYaw(), to.getPitch(), set, TeleportTransition.b.then(TeleportTransition.c), PlayerTeleportEvent.TeleportCause.END_PORTAL);
    }

    @Override
    public void a(IBlockData state, World level, BlockPosition pos, RandomSource random) {
        double d2 = (double)pos.u() + random.j();
        double d1 = (double)pos.v() + 0.8;
        double d22 = (double)pos.w() + random.j();
        level.a(Particles.ah, d2, d1, d22, 0.0, 0.0, 0.0);
    }

    @Override
    protected ItemStack a(IWorldReader level, BlockPosition pos, IBlockData state, boolean includeData) {
        return ItemStack.l;
    }

    @Override
    protected boolean a(IBlockData state, FluidType fluid) {
        return false;
    }

    @Override
    protected EnumRenderType a_(IBlockData state) {
        return EnumRenderType.a;
    }
}

