/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.IFluidSource;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypeFlowing;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;

public class BlockFluids
extends Block
implements IFluidSource {
    private static final Codec<FluidTypeFlowing> f = BuiltInRegistries.c.q().comapFlatMap(fluid -> {
        DataResult dataResult;
        if (fluid instanceof FluidTypeFlowing) {
            FluidTypeFlowing flowingFluid = (FluidTypeFlowing)fluid;
            dataResult = DataResult.success((Object)flowingFluid);
        } else {
            dataResult = DataResult.error(() -> "Not a flowing fluid: " + String.valueOf(fluid));
        }
        return dataResult;
    }, flowingFluid -> flowingFluid);
    public static final MapCodec<BlockFluids> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)f.fieldOf("fluid").forGetter(liquidBlock -> liquidBlock.c), BlockFluids.t()).apply((Applicative)instance, BlockFluids::new));
    public static final BlockStateInteger b = BlockProperties.aS;
    protected final FluidTypeFlowing c;
    private final List<Fluid> g;
    public static final VoxelShape d = Block.b(16.0, 0.0, 8.0);
    public static final ImmutableList<EnumDirection> e = ImmutableList.of((Object)EnumDirection.a, (Object)EnumDirection.d, (Object)EnumDirection.c, (Object)EnumDirection.f, (Object)EnumDirection.e);

    public MapCodec<BlockFluids> a() {
        return a;
    }

    protected BlockFluids(FluidTypeFlowing fluid, BlockBase.Info properties) {
        super(properties);
        this.c = fluid;
        this.g = Lists.newArrayList();
        this.g.add(fluid.a(false));
        for (int i2 = 1; i2 < 8; ++i2) {
            this.g.add(fluid.a(8 - i2, false));
        }
        this.g.add(fluid.a(8, true));
        this.l((IBlockData)this.C.b().b(b, 0));
    }

    @Override
    protected VoxelShape b(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return context.a(d, pos, true) && state.c(b) == 0 && context.a(level.b_(pos.d()), state.y()) ? d : VoxelShapes.a();
    }

    @Override
    protected boolean f(IBlockData state) {
        return state.y().f();
    }

    @Override
    protected void b(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        state.y().a(level, pos, random);
    }

    @Override
    protected boolean e_(IBlockData state) {
        return false;
    }

    @Override
    protected boolean a(IBlockData state, PathMode pathComputationType) {
        return !this.c.a(TagsFluid.b);
    }

    @Override
    protected Fluid b_(IBlockData state) {
        int levelValue = state.c(b);
        return this.g.get(Math.min(levelValue, 8));
    }

    @Override
    protected boolean b(IBlockData state, IBlockData adjacentBlockState, EnumDirection side) {
        return adjacentBlockState.y().a().a(this.c);
    }

    @Override
    protected EnumRenderType a_(IBlockData state) {
        return EnumRenderType.a;
    }

    @Override
    protected List<ItemStack> a(IBlockData state, LootParams.a params) {
        return Collections.emptyList();
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return VoxelShapes.a();
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, IBlockData oldState, boolean isMoving) {
        if (this.a(level, pos, state)) {
            level.a(pos, state.y().a(), this.getFlowSpeed(level, pos));
        }
    }

    public int getFlowSpeed(World level, BlockPosition pos) {
        if (BuiltInRegistries.c.e(this.c).a(TagsFluid.a) && (BlockFluids.isLava(level, pos.d(1)) || BlockFluids.isLava(level, pos.e(1)) || BlockFluids.isLava(level, pos.f(1)) || BlockFluids.isLava(level, pos.g(1)))) {
            return level.paperConfig().environment.waterOverLavaFlowSpeed;
        }
        return this.c.a(level);
    }

    private static boolean isLava(World level, BlockPosition pos) {
        Fluid fluidState = level.getFluidIfLoaded(pos);
        return fluidState != null && fluidState.a(TagsFluid.b);
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (state.y().b() || neighborState.y().b()) {
            scheduledTickAccess.a(pos, state.y().a(), this.c.a(level));
        }
        return super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        if (this.a(level, pos, state)) {
            level.a(pos, state.y().a(), this.getFlowSpeed(level, pos));
        }
    }

    private boolean a(World level, BlockPosition pos, IBlockData state) {
        if (this.c.a(TagsFluid.b)) {
            boolean isSoulSoil = level.a_(pos.e()).a(Blocks.eo);
            for (EnumDirection direction : e) {
                BlockPosition blockPos = pos.a(direction.g());
                if (level.b_(blockPos).a(TagsFluid.a)) {
                    Block block;
                    Block block2 = block = level.b_(pos).b() ? Blocks.cy : Blocks.m;
                    if (CraftEventFactory.handleBlockFormEvent(level, pos, block.m(), 3)) {
                        this.a(level, pos);
                    }
                    return false;
                }
                if (!isSoulSoil || !level.a_(blockPos).a(Blocks.nC)) continue;
                if (CraftEventFactory.handleBlockFormEvent(level, pos, Blocks.ep.m(), 3)) {
                    this.a(level, pos);
                }
                return false;
            }
        }
        return true;
    }

    private void a(GeneratorAccess level, BlockPosition pos) {
        level.c(1501, pos, 0);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{b});
    }

    @Override
    public ItemStack a(@Nullable EntityLiving owner, GeneratorAccess level, BlockPosition pos, IBlockData state) {
        if (state.c(b) == 0) {
            level.a(pos, Blocks.a.m(), 11);
            return new ItemStack(this.c.a());
        }
        return ItemStack.l;
    }

    @Override
    public Optional<SoundEffect> ap_() {
        return this.c.j();
    }
}

