/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import io.papermc.paper.event.entity.EntityPortalReadyEvent;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.portal.BlockPortalShape;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.PortalType;
import org.bukkit.craftbukkit.v1_21_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftPortalEvent;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftLocation;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityPortalEnterEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.slf4j.Logger;

public class BlockPortal
extends Block
implements Portal {
    private static final Logger c = LogUtils.getLogger();
    public static final MapCodec<BlockPortal> a = BlockPortal.b(BlockPortal::new);
    public static final BlockStateEnum<EnumDirection.EnumAxis> b = BlockProperties.J;
    private static final Map<EnumDirection.EnumAxis, VoxelShape> d = VoxelShapes.a(Block.a(4.0, 16.0, 0.0, 16.0));

    public MapCodec<BlockPortal> a() {
        return a;
    }

    public BlockPortal(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)this.C.b().b(b, EnumDirection.EnumAxis.a));
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return d.get(state.c(b));
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, net.minecraft.world.entity.Entity entity) {
        return state.f(level, pos);
    }

    @Override
    protected void b(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        if (level.spigotConfig.enableZombiePigmenPortalSpawns && level.F_().j() && level.O().c(GameRules.f) && random.a(2000) < level.an().a() && level.g(pos)) {
            EntityPigZombie entity;
            while (level.a_(pos).a(this)) {
                pos = pos.e();
            }
            if (level.a_(pos).a((IBlockAccess)level, pos, EntityTypes.bS) && (entity = EntityTypes.bS.spawn(level, pos.d(), EntitySpawnReason.d, CreatureSpawnEvent.SpawnReason.NETHER_PORTAL)) != null) {
                net.minecraft.world.entity.Entity vehicle;
                entity.ay();
                entity.fromNetherPortal = true;
                if (level.paperConfig().entities.behavior.nerfPigmenFromNetherPortals) {
                    ((EntityInsentient)entity).aware = false;
                }
                if ((vehicle = entity.dk()) != null) {
                    vehicle.ay();
                }
            }
        }
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        EnumDirection.EnumAxis axis = direction.o();
        EnumDirection.EnumAxis axis1 = state.c(b);
        boolean flag = axis1 != axis && axis.d();
        return !flag && !neighborState.a(this) && !BlockPortalShape.a(level, pos, axis1).b() ? Blocks.a.m() : super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, net.minecraft.world.entity.Entity entity, InsideBlockEffectApplier effectApplier) {
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(level, pos)).callEvent()) {
            return;
        }
        if (entity.n(false)) {
            EntityPortalEnterEvent event = new EntityPortalEnterEvent((Entity)entity.getBukkitEntity(), CraftLocation.toBukkit(pos, level), PortalType.NETHER);
            level.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            entity.a(this, pos);
        }
    }

    @Override
    public int a(WorldServer level, net.minecraft.world.entity.Entity entity) {
        int n2;
        if (entity instanceof EntityHuman) {
            EntityHuman player = (EntityHuman)entity;
            n2 = Math.max(0, level.O().d(player.gk().a ? GameRules.H : GameRules.G));
        } else {
            n2 = 0;
        }
        return n2;
    }

    @Override
    @Nullable
    public TeleportTransition a(WorldServer level, net.minecraft.world.entity.Entity entity, BlockPosition pos) {
        CraftPortalEvent event;
        ResourceKey<World> resourceKey = level.getTypeKey() == WorldDimension.c ? World.i : World.j;
        WorldServer level1 = level.p().a(resourceKey);
        EntityPortalReadyEvent portalReadyEvent = new EntityPortalReadyEvent((Entity)entity.getBukkitEntity(), (org.bukkit.World)(level1 == null ? null : level1.getWorld()), PortalType.NETHER);
        if (!portalReadyEvent.callEvent()) {
            entity.as = null;
            return null;
        }
        WorldServer worldServer = level1 = portalReadyEvent.getTargetWorld() == null ? null : ((CraftWorld)portalReadyEvent.getTargetWorld()).getHandle();
        if (level1 == null) {
            return null;
        }
        boolean flag = level1.getTypeKey() == WorldDimension.c;
        WorldBorder worldBorder = level1.E_();
        double teleportationScale = DimensionManager.a(level.F_(), level1.F_());
        BlockPosition blockPos = worldBorder.b(entity.dA() * teleportationScale, entity.dC(), entity.dG() * teleportationScale);
        int portalSearchRadius = level1.paperConfig().environment.portalSearchRadius;
        if (entity.dV().paperConfig().environment.portalSearchVanillaDimensionScaling && flag) {
            portalSearchRadius = (int)((double)portalSearchRadius / level1.F_().k());
        }
        if ((event = entity.callPortalEvent(entity, CraftLocation.toBukkit(blockPos, (org.bukkit.World)level1.getWorld()), PlayerTeleportEvent.TeleportCause.NETHER_PORTAL, portalSearchRadius, level1.paperConfig().environment.portalCreateRadius)) == null) {
            return null;
        }
        level1 = ((CraftWorld)event.getTo().getWorld()).getHandle();
        worldBorder = level1.E_();
        blockPos = worldBorder.b(event.getTo().getX(), event.getTo().getY(), event.getTo().getZ());
        return this.getExitPortal(level1, entity, pos, blockPos, flag, worldBorder, event.getSearchRadius(), event.getCanCreatePortal(), event.getCreationRadius());
    }

    @Nullable
    private TeleportTransition getExitPortal(WorldServer level, net.minecraft.world.entity.Entity entity, BlockPosition pos, BlockPosition exitPos, boolean isNether, WorldBorder worldBorder, int searchRadius, boolean canCreatePortal, int createRadius) {
        TeleportTransition.a postTeleportTransition;
        BlockUtil.Rectangle largestRectangleAround;
        Optional<BlockPosition> optional = level.q().findClosestPortalPosition(exitPos, worldBorder, searchRadius);
        if (optional.isPresent()) {
            BlockPosition blockPos = optional.get();
            IBlockData blockState = level.a_(blockPos);
            largestRectangleAround = BlockUtil.a(blockPos, blockState.c(BlockProperties.J), 21, EnumDirection.EnumAxis.b, 21, (BlockPosition blockPos1) -> level.a_((BlockPosition)blockPos1) == blockState);
            postTeleportTransition = TeleportTransition.b.then(entity1 -> entity1.f(blockPos));
        } else if (canCreatePortal) {
            EnumDirection.EnumAxis axis = entity.dV().a_(pos).d(b).orElse(EnumDirection.EnumAxis.a);
            Optional<BlockUtil.Rectangle> optional1 = level.q().createPortal(exitPos, axis, entity, createRadius);
            if (optional1.isEmpty()) {
                return null;
            }
            largestRectangleAround = optional1.get();
            postTeleportTransition = TeleportTransition.b.then(TeleportTransition.c);
        } else {
            return null;
        }
        return BlockPortal.a(entity, pos, largestRectangleAround, level, postTeleportTransition);
    }

    private static TeleportTransition a(net.minecraft.world.entity.Entity entity, BlockPosition pos, BlockUtil.Rectangle rectangle, WorldServer level, TeleportTransition.a postTeleportTransition) {
        Vec3D relativePortalPosition;
        EnumDirection.EnumAxis axis;
        IBlockData blockState = entity.dV().a_(pos);
        if (blockState.b(BlockProperties.J)) {
            axis = blockState.c(BlockProperties.J);
            BlockUtil.Rectangle largestRectangleAround = BlockUtil.a(pos, axis, 21, EnumDirection.EnumAxis.b, 21, (BlockPosition blockPos) -> entity.dV().a_((BlockPosition)blockPos) == blockState);
            relativePortalPosition = entity.a(axis, largestRectangleAround);
        } else {
            axis = EnumDirection.EnumAxis.a;
            relativePortalPosition = new Vec3D(0.5, 0.0, 0.0);
        }
        return BlockPortal.a(level, rectangle, axis, relativePortalPosition, entity, postTeleportTransition);
    }

    private static TeleportTransition a(WorldServer level, BlockUtil.Rectangle rectangle, EnumDirection.EnumAxis axis, Vec3D offset, net.minecraft.world.entity.Entity entity, TeleportTransition.a postTeleportTransition) {
        BlockPosition blockPos = rectangle.a;
        IBlockData blockState = level.a_(blockPos);
        EnumDirection.EnumAxis axis1 = blockState.d(BlockProperties.J).orElse(EnumDirection.EnumAxis.a);
        double d2 = rectangle.b;
        double d1 = rectangle.c;
        EntitySize dimensions = entity.a(entity.at());
        int i2 = axis == axis1 ? 0 : 90;
        double d22 = (double)dimensions.a() / 2.0 + (d2 - (double)dimensions.a()) * offset.a();
        double d3 = (d1 - (double)dimensions.b()) * offset.b();
        double d4 = 0.5 + offset.c();
        boolean flag = axis1 == EnumDirection.EnumAxis.a;
        Vec3D vec3 = new Vec3D((double)blockPos.u() + (flag ? d22 : d4), (double)blockPos.v() + d3, (double)blockPos.w() + (flag ? d4 : d22));
        Vec3D vec31 = BlockPortalShape.a(vec3, level, entity, dimensions);
        return new TeleportTransition(level, vec31, Vec3D.c, i2, 0.0f, Relative.a(Relative.l, Relative.k), postTeleportTransition, PlayerTeleportEvent.TeleportCause.NETHER_PORTAL);
    }

    @Override
    public Portal.a b() {
        return Portal.a.a;
    }

    @Override
    public void a(IBlockData state, World level, BlockPosition pos, RandomSource random) {
        if (random.a(100) == 0) {
            level.a((double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, SoundEffects.vv, SoundCategory.e, 0.5f, random.i() * 0.4f + 0.8f, false);
        }
        for (int i2 = 0; i2 < 4; ++i2) {
            double d2 = (double)pos.u() + random.j();
            double d1 = (double)pos.v() + random.j();
            double d22 = (double)pos.w() + random.j();
            double d3 = ((double)random.i() - 0.5) * 0.5;
            double d4 = ((double)random.i() - 0.5) * 0.5;
            double d5 = ((double)random.i() - 0.5) * 0.5;
            int i1 = random.a(2) * 2 - 1;
            if (!level.a_(pos.h()).a(this) && !level.a_(pos.i()).a(this)) {
                d2 = (double)pos.u() + 0.5 + 0.25 * (double)i1;
                d3 = random.i() * 2.0f * (float)i1;
            } else {
                d22 = (double)pos.w() + 0.5 + 0.25 * (double)i1;
                d5 = random.i() * 2.0f * (float)i1;
            }
            level.a(Particles.af, d2, d1, d22, d3, d4, d5);
        }
    }

    @Override
    protected ItemStack a(IWorldReader level, BlockPosition pos, IBlockData state, boolean includeData) {
        return ItemStack.l;
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rot) {
        switch (rot) {
            case d: 
            case b: {
                switch (state.c(b)) {
                    case a: {
                        return (IBlockData)state.b(b, EnumDirection.EnumAxis.c);
                    }
                    case c: {
                        return (IBlockData)state.b(b, EnumDirection.EnumAxis.a);
                    }
                }
                return state;
            }
        }
        return state;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{b});
    }
}

