/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDiodeAbstract;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityComparator;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyComparatorMode;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.ticks.TickListPriority;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;

public class BlockRedstoneComparator
extends BlockDiodeAbstract
implements ITileEntity {
    public static final MapCodec<BlockRedstoneComparator> a = BlockRedstoneComparator.b(BlockRedstoneComparator::new);
    public static final BlockStateEnum<BlockPropertyComparatorMode> b = BlockProperties.bg;

    public MapCodec<BlockRedstoneComparator> a() {
        return a;
    }

    public BlockRedstoneComparator(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)((IBlockData)((IBlockData)this.C.b().b(BlockFacingHorizontal.e, EnumDirection.c)).b(BlockDiodeAbstract.c, false)).b(b, BlockPropertyComparatorMode.a));
    }

    @Override
    protected int h(IBlockData state) {
        return 2;
    }

    @Override
    public IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        return direction == EnumDirection.a && !this.a(level, neighborPos, neighborState) ? Blocks.a.m() : super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    protected int a(IBlockAccess level, BlockPosition pos, IBlockData state) {
        TileEntity blockEntity = level.c_(pos);
        return blockEntity instanceof TileEntityComparator ? ((TileEntityComparator)blockEntity).a() : 0;
    }

    private int e(World level, BlockPosition pos, IBlockData state) {
        int inputSignal = this.b(level, pos, state);
        if (inputSignal == 0) {
            return 0;
        }
        int alternateSignal = this.a((SignalGetter)level, pos, state);
        if (alternateSignal > inputSignal) {
            return 0;
        }
        return state.c(b) == BlockPropertyComparatorMode.b ? inputSignal - alternateSignal : inputSignal;
    }

    @Override
    protected boolean a(World level, BlockPosition pos, IBlockData state) {
        int inputSignal = this.b(level, pos, state);
        if (inputSignal == 0) {
            return false;
        }
        int alternateSignal = this.a((SignalGetter)level, pos, state);
        return inputSignal > alternateSignal || inputSignal == alternateSignal && state.c(b) == BlockPropertyComparatorMode.a;
    }

    @Override
    protected int b(World level, BlockPosition pos, IBlockData state) {
        int i2 = super.b(level, pos, state);
        EnumDirection direction = state.c(BlockFacingHorizontal.e);
        BlockPosition blockPos = pos.a(direction);
        IBlockData blockState = level.a_(blockPos);
        if (blockState.q()) {
            i2 = blockState.a(level, blockPos);
        } else if (i2 < 15 && blockState.d(level, blockPos)) {
            blockPos = blockPos.a(direction);
            blockState = level.a_(blockPos);
            EntityItemFrame itemFrame = this.a(level, direction, blockPos);
            int max = Math.max(itemFrame == null ? Integer.MIN_VALUE : itemFrame.y(), blockState.q() ? blockState.a(level, blockPos) : Integer.MIN_VALUE);
            if (max != Integer.MIN_VALUE) {
                i2 = max;
            }
        }
        return i2;
    }

    @Nullable
    private EntityItemFrame a(World level, EnumDirection facing, BlockPosition pos) {
        List<EntityItemFrame> entitiesOfClass = level.a(EntityItemFrame.class, new AxisAlignedBB(pos.u(), pos.v(), pos.w(), pos.u() + 1, pos.v() + 1, pos.w() + 1), (? super T itemFrame) -> itemFrame != null && itemFrame.cO() == facing);
        return entitiesOfClass.size() == 1 ? entitiesOfClass.get(0) : null;
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World level, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hitResult) {
        if (!player.gk().e) {
            return EnumInteractionResult.e;
        }
        float f2 = (state = (IBlockData)state.a(b)).c(b) == BlockPropertyComparatorMode.b ? 0.55f : 0.5f;
        level.a((Entity)player, pos, SoundEffects.fv, SoundCategory.e, 0.3f, f2);
        level.a(pos, state, 2);
        this.f(level, pos, state);
        return EnumInteractionResult.a;
    }

    @Override
    protected void c(World level, BlockPosition pos, IBlockData state) {
        if (!level.U().b(pos, this)) {
            int i1;
            int i2 = this.e(level, pos, state);
            TileEntity blockEntity = level.c_(pos);
            int n2 = i1 = blockEntity instanceof TileEntityComparator ? ((TileEntityComparator)blockEntity).a() : 0;
            if (i2 != i1 || state.c(BlockDiodeAbstract.c).booleanValue() != this.a(level, pos, state)) {
                TickListPriority tickPriority = this.b((IBlockAccess)level, pos, state) ? TickListPriority.c : TickListPriority.d;
                level.a(pos, (Block)this, 2, tickPriority);
            }
        }
    }

    private void f(World level, BlockPosition pos, IBlockData state) {
        int i2 = this.e(level, pos, state);
        TileEntity blockEntity = level.c_(pos);
        int i1 = 0;
        if (blockEntity instanceof TileEntityComparator) {
            TileEntityComparator comparatorBlockEntity = (TileEntityComparator)blockEntity;
            i1 = comparatorBlockEntity.a();
            comparatorBlockEntity.a(i2);
        }
        if (i1 != i2 || state.c(b) == BlockPropertyComparatorMode.a) {
            boolean shouldTurnOn = this.a(level, pos, state);
            boolean poweredValue = state.c(BlockDiodeAbstract.c);
            if (poweredValue && !shouldTurnOn) {
                if (CraftEventFactory.callRedstoneChange(level, pos, 15, 0).getNewCurrent() != 0) {
                    return;
                }
                level.a(pos, (IBlockData)state.b(BlockDiodeAbstract.c, false), 2);
            } else if (!poweredValue && shouldTurnOn) {
                if (CraftEventFactory.callRedstoneChange(level, pos, 0, 15).getNewCurrent() != 15) {
                    return;
                }
                level.a(pos, (IBlockData)state.b(BlockDiodeAbstract.c, true), 2);
            }
            this.d(level, pos, state);
        }
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        this.f(level, pos, state);
    }

    @Override
    protected boolean a(IBlockData state, World level, BlockPosition pos, int id, int param) {
        super.a(state, level, pos, id, param);
        TileEntity blockEntity = level.c_(pos);
        return blockEntity != null && blockEntity.a_(id, param);
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityComparator(pos, state);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(BlockFacingHorizontal.e, b, BlockDiodeAbstract.c);
    }
}

