/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleParamRedstone;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockRedstoneTorch;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class BlockRedstoneOre
extends Block {
    public static final MapCodec<BlockRedstoneOre> a = BlockRedstoneOre.b(BlockRedstoneOre::new);
    public static final BlockStateBoolean b = BlockRedstoneTorch.b;

    public MapCodec<BlockRedstoneOre> a() {
        return a;
    }

    public BlockRedstoneOre(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)this.m().b(b, false));
    }

    @Override
    protected void a_(IBlockData state, World level, BlockPosition pos, EntityHuman player) {
        BlockRedstoneOre.interact(state, level, pos, player);
        super.a_(state, level, pos, player);
    }

    @Override
    public void a(World level, BlockPosition pos, IBlockData state, net.minecraft.world.entity.Entity entity) {
        if (!entity.cd()) {
            if (entity instanceof EntityHuman) {
                EntityHuman player = (EntityHuman)entity;
                PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent(player, Action.PHYSICAL, pos, null, null, null);
                if (!event.isCancelled()) {
                    BlockRedstoneOre.interact(level.a_(pos), level, pos, entity);
                }
            } else {
                EntityInteractEvent event = new EntityInteractEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(level, pos));
                level.getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    BlockRedstoneOre.interact(level.a_(pos), level, pos, entity);
                }
            }
        }
        super.a(level, pos, state, entity);
    }

    @Override
    protected EnumInteractionResult a(ItemStack stack, IBlockData state, World level, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hitResult) {
        if (level.C) {
            BlockRedstoneOre.a(level, pos);
        } else {
            BlockRedstoneOre.interact(state, level, pos, player);
        }
        return (EnumInteractionResult)((Object)(stack.h() instanceof ItemBlock && new BlockActionContext(player, hand, stack, hitResult).b() ? EnumInteractionResult.e : EnumInteractionResult.a));
    }

    private static void interact(IBlockData state, World level, BlockPosition pos, net.minecraft.world.entity.Entity entity) {
        BlockRedstoneOre.a(level, pos);
        if (!state.c(b).booleanValue()) {
            if (!CraftEventFactory.callEntityChangeBlockEvent(entity, pos, (IBlockData)state.b(b, true))) {
                return;
            }
            level.a(pos, (IBlockData)state.b(b, true), 3);
        }
    }

    @Override
    protected boolean f(IBlockData state) {
        return state.c(b);
    }

    @Override
    protected void b(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        if (state.c(b).booleanValue()) {
            if (CraftEventFactory.callBlockFadeEvent(level, pos, (IBlockData)state.b(b, false)).isCancelled()) {
                return;
            }
            level.a(pos, (IBlockData)state.b(b, false), 3);
        }
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, ItemStack stack, boolean dropExperience) {
        super.a(state, level, pos, stack, dropExperience);
    }

    @Override
    public int getExpDrop(IBlockData state, WorldServer level, BlockPosition pos, ItemStack stack, boolean dropExperience) {
        if (dropExperience) {
            return this.tryDropExperience(level, pos, stack, UniformInt.a(1, 5));
        }
        return 0;
    }

    @Override
    public void a(IBlockData state, World level, BlockPosition pos, RandomSource random) {
        if (state.c(b).booleanValue()) {
            BlockRedstoneOre.a(level, pos);
        }
    }

    private static void a(World level, BlockPosition pos) {
        double d2 = 0.5625;
        RandomSource randomSource = level.A;
        for (EnumDirection direction : EnumDirection.values()) {
            BlockPosition blockPos = pos.a(direction);
            if (level.a_(blockPos).s()) continue;
            EnumDirection.EnumAxis axis = direction.o();
            double d1 = axis == EnumDirection.EnumAxis.a ? 0.5 + 0.5625 * (double)direction.j() : (double)randomSource.i();
            double d22 = axis == EnumDirection.EnumAxis.b ? 0.5 + 0.5625 * (double)direction.k() : (double)randomSource.i();
            double d3 = axis == EnumDirection.EnumAxis.c ? 0.5 + 0.5625 * (double)direction.l() : (double)randomSource.i();
            level.a(ParticleParamRedstone.b, (double)pos.u() + d1, (double)pos.v() + d22, (double)pos.w() + d3, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{b});
    }
}

