/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import io.papermc.paper.configuration.WorldConfiguration;
import io.papermc.paper.redstone.RedstoneWireTurbo;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleParamRedstone;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ARGB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDirectional;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockTrapdoor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyRedstoneSide;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.redstone.DefaultRedstoneWireEvaluator;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.ExperimentalRedstoneWireEvaluator;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.level.redstone.RedstoneWireEvaluator;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlock;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;

public class BlockRedstoneWire
extends Block {
    public static final MapCodec<BlockRedstoneWire> a = BlockRedstoneWire.b(BlockRedstoneWire::new);
    public static final BlockStateEnum<BlockPropertyRedstoneSide> b = BlockProperties.ae;
    public static final BlockStateEnum<BlockPropertyRedstoneSide> c = BlockProperties.ad;
    public static final BlockStateEnum<BlockPropertyRedstoneSide> d = BlockProperties.af;
    public static final BlockStateEnum<BlockPropertyRedstoneSide> e = BlockProperties.ag;
    public static final BlockStateInteger f = BlockProperties.aW;
    public static final Map<EnumDirection, BlockStateEnum<BlockPropertyRedstoneSide>> g = ImmutableMap.copyOf((Map)Maps.newEnumMap(Map.of(EnumDirection.c, b, EnumDirection.f, c, EnumDirection.d, d, EnumDirection.e, e)));
    private static final int[] h = SystemUtils.a(new int[16], (? super T ints) -> {
        for (int i2 = 0; i2 <= 15; ++i2) {
            float f2;
            float f1 = f2 * 0.6f + ((f2 = (float)i2 / 15.0f) > 0.0f ? 0.4f : 0.3f);
            float f22 = MathHelper.a(f2 * f2 * 0.7f - 0.5f, 0.0f, 1.0f);
            float f3 = MathHelper.a(f2 * f2 * 0.6f - 0.7f, 0.0f, 1.0f);
            ints[i2] = ARGB.a(1.0f, f1, f22, f3);
        }
    });
    private static final float i = 0.2f;
    private final Function<IBlockData, VoxelShape> D;
    private final IBlockData R;
    private final RedstoneWireEvaluator S = new DefaultRedstoneWireEvaluator(this);
    public boolean T = true;
    RedstoneWireTurbo turbo = new RedstoneWireTurbo(this);

    public MapCodec<BlockRedstoneWire> a() {
        return a;
    }

    public BlockRedstoneWire(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.C.b().b(b, BlockPropertyRedstoneSide.c)).b(c, BlockPropertyRedstoneSide.c)).b(d, BlockPropertyRedstoneSide.c)).b(e, BlockPropertyRedstoneSide.c)).b(f, 0));
        this.D = this.b();
        this.R = (IBlockData)((IBlockData)((IBlockData)((IBlockData)this.m().b(b, BlockPropertyRedstoneSide.b)).b(c, BlockPropertyRedstoneSide.b)).b(d, BlockPropertyRedstoneSide.b)).b(e, BlockPropertyRedstoneSide.b);
    }

    private Function<IBlockData, VoxelShape> b() {
        boolean i2 = true;
        int i1 = 10;
        VoxelShape voxelShape = Block.b(10.0, 0.0, 1.0);
        Map<EnumDirection, VoxelShape> map = VoxelShapes.c(Block.a(10.0, 0.0, 1.0, 0.0, 8.0));
        Map<EnumDirection, VoxelShape> map1 = VoxelShapes.c(Block.b(10.0, 16.0, 0.0, 1.0));
        return this.a((IBlockData blockState) -> {
            VoxelShape voxelShape1 = voxelShape;
            for (Map.Entry<EnumDirection, BlockStateEnum<BlockPropertyRedstoneSide>> entry : g.entrySet()) {
                voxelShape1 = switch ((BlockPropertyRedstoneSide)blockState.c(entry.getValue())) {
                    default -> throw new MatchException(null, null);
                    case BlockPropertyRedstoneSide.a -> VoxelShapes.a(voxelShape1, (VoxelShape)map.get(entry.getKey()), (VoxelShape)map1.get(entry.getKey()));
                    case BlockPropertyRedstoneSide.b -> VoxelShapes.a(voxelShape1, (VoxelShape)map.get(entry.getKey()));
                    case BlockPropertyRedstoneSide.c -> voxelShape1;
                };
            }
            return voxelShape1;
        }, f);
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return this.D.apply(state);
    }

    @Override
    public IBlockData a(BlockActionContext context) {
        return this.a((IBlockAccess)context.q(), this.R, context.a());
    }

    private IBlockData a(IBlockAccess level, IBlockData state, BlockPosition pos) {
        boolean flag1;
        boolean isDot = BlockRedstoneWire.r(state);
        state = this.b(level, (IBlockData)this.m().b(f, state.c(f)), pos);
        if (isDot && BlockRedstoneWire.r(state)) {
            return state;
        }
        boolean isConnected = state.c(b).a();
        boolean isConnected1 = state.c(d).a();
        boolean isConnected2 = state.c(c).a();
        boolean isConnected3 = state.c(e).a();
        boolean flag = !isConnected && !isConnected1;
        boolean bl = flag1 = !isConnected2 && !isConnected3;
        if (!isConnected3 && flag) {
            state = (IBlockData)state.b(e, BlockPropertyRedstoneSide.b);
        }
        if (!isConnected2 && flag) {
            state = (IBlockData)state.b(c, BlockPropertyRedstoneSide.b);
        }
        if (!isConnected && flag1) {
            state = (IBlockData)state.b(b, BlockPropertyRedstoneSide.b);
        }
        if (!isConnected1 && flag1) {
            state = (IBlockData)state.b(d, BlockPropertyRedstoneSide.b);
        }
        return state;
    }

    private IBlockData b(IBlockAccess level, IBlockData state, BlockPosition pos) {
        boolean flag = !level.a_(pos.d()).d(level, pos);
        for (EnumDirection direction : EnumDirection.EnumDirectionLimit.a) {
            if (((BlockPropertyRedstoneSide)state.c(g.get(direction))).a()) continue;
            BlockPropertyRedstoneSide connectingSide = this.a(level, pos, direction, flag);
            state = (IBlockData)state.b(g.get(direction), connectingSide);
        }
        return state;
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (direction == EnumDirection.a) {
            return !this.a((IBlockAccess)level, neighborPos, neighborState) ? Blocks.a.m() : state;
        }
        if (direction == EnumDirection.b) {
            return this.a((IBlockAccess)level, state, pos);
        }
        BlockPropertyRedstoneSide connectingSide = this.a((IBlockAccess)level, pos, direction);
        return connectingSide.a() == ((BlockPropertyRedstoneSide)state.c(g.get(direction))).a() && !BlockRedstoneWire.q(state) ? (IBlockData)state.b(g.get(direction), connectingSide) : this.a((IBlockAccess)level, (IBlockData)((IBlockData)this.R.b(f, state.c(f))).b(g.get(direction), connectingSide), pos);
    }

    private static boolean q(IBlockData state) {
        return state.c(b).a() && state.c(d).a() && state.c(c).a() && state.c(e).a();
    }

    private static boolean r(IBlockData state) {
        return !state.c(b).a() && !state.c(d).a() && !state.c(c).a() && !state.c(e).a();
    }

    @Override
    protected void a(IBlockData state, GeneratorAccess level, BlockPosition pos, int flags, int recursionLeft) {
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (EnumDirection direction : EnumDirection.EnumDirectionLimit.a) {
            BlockPropertyRedstoneSide redstoneSide = (BlockPropertyRedstoneSide)state.c(g.get(direction));
            if (redstoneSide == BlockPropertyRedstoneSide.c || level.a_(mutableBlockPos.a((BaseBlockPosition)pos, direction)).a(this)) continue;
            mutableBlockPos.c(EnumDirection.a);
            IBlockData blockState = level.a_(mutableBlockPos);
            if (blockState.a(this)) {
                BlockPosition blockPos = mutableBlockPos.a(direction.g());
                level.a(direction.g(), (BlockPosition)mutableBlockPos, blockPos, level.a_(blockPos), flags, recursionLeft);
            }
            mutableBlockPos.a((BaseBlockPosition)pos, direction).c(EnumDirection.b);
            IBlockData blockState1 = level.a_(mutableBlockPos);
            if (!blockState1.a(this)) continue;
            BlockPosition blockPos1 = mutableBlockPos.a(direction.g());
            level.a(direction.g(), (BlockPosition)mutableBlockPos, blockPos1, level.a_(blockPos1), flags, recursionLeft);
        }
    }

    private BlockPropertyRedstoneSide a(IBlockAccess level, BlockPosition pos, EnumDirection face) {
        return this.a(level, pos, face, !level.a_(pos.d()).d(level, pos));
    }

    private BlockPropertyRedstoneSide a(IBlockAccess level, BlockPosition pos, EnumDirection direction, boolean nonNormalCubeAbove) {
        BlockPosition blockPos = pos.a(direction);
        IBlockData blockState = level.a_(blockPos);
        if (nonNormalCubeAbove) {
            boolean flag;
            boolean bl = flag = blockState.b() instanceof BlockTrapdoor || this.a(level, blockPos, blockState);
            if (flag && BlockRedstoneWire.o(level.a_(blockPos.d()))) {
                if (blockState.c(level, blockPos, direction.g())) {
                    return BlockPropertyRedstoneSide.a;
                }
                return BlockPropertyRedstoneSide.b;
            }
        }
        return !BlockRedstoneWire.a(blockState, direction) && (blockState.d(level, blockPos) || !BlockRedstoneWire.o(level.a_(blockPos.e()))) ? BlockPropertyRedstoneSide.c : BlockPropertyRedstoneSide.b;
    }

    @Override
    public boolean a(IBlockData state, IWorldReader level, BlockPosition pos) {
        BlockPosition blockPos = pos.e();
        IBlockData blockState = level.a_(blockPos);
        return this.a((IBlockAccess)level, blockPos, blockState);
    }

    private boolean a(IBlockAccess level, BlockPosition pos, IBlockData state) {
        return state.c(level, pos, EnumDirection.b) || state.a(Blocks.hD);
    }

    private void updateSurroundingRedstone(World worldIn, BlockPosition pos, IBlockData state, @Nullable Orientation orientation, boolean blockAdded) {
        if (worldIn.paperConfig().misc.redstoneImplementation == WorldConfiguration.Misc.RedstoneImplementation.EIGENCRAFT) {
            BlockPosition source = null;
            if (orientation != null) {
                source = pos.a(orientation.b().g());
            }
            this.turbo.updateSurroundingRedstone(worldIn, pos, state, source);
            return;
        }
        this.a(worldIn, pos, state, orientation, blockAdded);
    }

    public IBlockData calculateCurrentChanges(World level, BlockPosition pos, IBlockData state) {
        int newPower;
        int oldPower = state.c(f);
        if (oldPower != (newPower = ((DefaultRedstoneWireEvaluator)this.S).c(level, pos))) {
            BlockRedstoneEvent event = new BlockRedstoneEvent((org.bukkit.block.Block)CraftBlock.at(level, pos), oldPower, newPower);
            level.getCraftServer().getPluginManager().callEvent((Event)event);
            newPower = event.getNewCurrent();
            if (level.a_(pos) == state && level.a(pos, state = (IBlockData)state.b(f, newPower), 18)) {
                this.turbo.updateNeighborShapes(level, pos, state);
            }
        }
        return state;
    }

    private void a(World level, BlockPosition pos, IBlockData state, @Nullable Orientation orientation, boolean updateShape) {
        if (BlockRedstoneWire.a(level)) {
            new ExperimentalRedstoneWireEvaluator(this).a(level, pos, state, orientation, updateShape);
        } else {
            this.S.a(level, pos, state, orientation, updateShape);
        }
    }

    public int a(World level, BlockPosition pos) {
        this.T = false;
        int bestNeighborSignal = level.E(pos);
        this.T = true;
        return bestNeighborSignal;
    }

    private void b(World level, BlockPosition pos) {
        if (level.a_(pos).a(this)) {
            level.a(pos, this);
            for (EnumDirection direction : EnumDirection.values()) {
                level.a(pos.a(direction), this);
            }
        }
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, IBlockData oldState, boolean isMoving) {
        if (!oldState.a(state.b()) && !level.C) {
            if (level.paperConfig().misc.redstoneImplementation == WorldConfiguration.Misc.RedstoneImplementation.ALTERNATE_CURRENT) {
                level.getWireHandler().onWireAdded(pos, state);
            } else {
                this.updateSurroundingRedstone(level, pos, state, null, true);
            }
            for (EnumDirection direction : EnumDirection.EnumDirectionLimit.b) {
                level.a(pos.a(direction), this);
            }
            this.c(level, pos);
        }
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, boolean movedByPiston) {
        if (!movedByPiston) {
            for (EnumDirection direction : EnumDirection.values()) {
                level.a(pos.a(direction), this);
            }
            if (level.paperConfig().misc.redstoneImplementation == WorldConfiguration.Misc.RedstoneImplementation.ALTERNATE_CURRENT) {
                level.getWireHandler().onWireRemoved(pos, state);
            } else {
                this.updateSurroundingRedstone(level, pos, state, null, false);
            }
            this.c(level, pos);
        }
    }

    private void c(World level, BlockPosition pos) {
        for (EnumDirection direction : EnumDirection.EnumDirectionLimit.a) {
            this.b(level, pos.a(direction));
        }
        for (EnumDirection direction : EnumDirection.EnumDirectionLimit.a) {
            BlockPosition blockPos = pos.a(direction);
            if (level.a_(blockPos).d(level, blockPos)) {
                this.b(level, blockPos.d());
                continue;
            }
            this.b(level, blockPos.e());
        }
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        if (!level.C) {
            if (level.paperConfig().misc.redstoneImplementation == WorldConfiguration.Misc.RedstoneImplementation.ALTERNATE_CURRENT) {
                level.getWireHandler().onWireUpdated(pos, state, orientation);
            } else if (neighborBlock != this || !BlockRedstoneWire.a(level)) {
                if (state.a((IWorldReader)level, pos)) {
                    this.updateSurroundingRedstone(level, pos, state, orientation, false);
                } else {
                    BlockRedstoneWire.c(state, level, pos);
                    level.a(pos, false);
                }
            }
        }
    }

    private static boolean a(World level) {
        return level.K().b(FeatureFlags.c);
    }

    @Override
    protected int b(IBlockData blockState, IBlockAccess blockAccess, BlockPosition pos, EnumDirection side) {
        return !this.T ? 0 : blockState.a(blockAccess, pos, side);
    }

    @Override
    protected int a(IBlockData blockState, IBlockAccess blockAccess, BlockPosition pos, EnumDirection side) {
        if (this.T && side != EnumDirection.a) {
            int powerValue = blockState.c(f);
            if (powerValue == 0) {
                return 0;
            }
            return side != EnumDirection.b && !((BlockPropertyRedstoneSide)this.a(blockAccess, blockState, pos).c(g.get(side.g()))).a() ? 0 : powerValue;
        }
        return 0;
    }

    protected static boolean o(IBlockData state) {
        return BlockRedstoneWire.a(state, null);
    }

    protected static boolean a(IBlockData state, @Nullable EnumDirection direction) {
        if (state.a(Blocks.cH)) {
            return true;
        }
        if (state.a(Blocks.ey)) {
            EnumDirection direction1 = state.c(BlockFacingHorizontal.e);
            return direction1 == direction || direction1.g() == direction;
        }
        return state.a(Blocks.lu) ? direction == state.c(BlockDirectional.a) : state.p() && direction != null;
    }

    @Override
    protected boolean f_(IBlockData state) {
        return this.T;
    }

    public static int b(int power) {
        return h[power];
    }

    private static void a(World level, RandomSource random, BlockPosition pos, int color, EnumDirection direction, EnumDirection perpendicularDirection, float start, float end) {
        float f2 = end - start;
        if (!(random.i() >= 0.2f * f2)) {
            float f1 = 0.4375f;
            float f22 = start + f2 * random.i();
            double d2 = 0.5 + (double)(0.4375f * (float)direction.j()) + (double)(f22 * (float)perpendicularDirection.j());
            double d1 = 0.5 + (double)(0.4375f * (float)direction.k()) + (double)(f22 * (float)perpendicularDirection.k());
            double d22 = 0.5 + (double)(0.4375f * (float)direction.l()) + (double)(f22 * (float)perpendicularDirection.l());
            level.a(new ParticleParamRedstone(color, 1.0f), (double)pos.u() + d2, (double)pos.v() + d1, (double)pos.w() + d22, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void a(IBlockData state, World level, BlockPosition pos, RandomSource random) {
        int powerValue = state.c(f);
        if (powerValue != 0) {
            block4: for (EnumDirection direction : EnumDirection.EnumDirectionLimit.a) {
                BlockPropertyRedstoneSide redstoneSide = (BlockPropertyRedstoneSide)state.c(g.get(direction));
                switch (redstoneSide) {
                    case a: {
                        BlockRedstoneWire.a(level, random, pos, h[powerValue], direction, EnumDirection.b, -0.5f, 0.5f);
                    }
                    case b: {
                        BlockRedstoneWire.a(level, random, pos, h[powerValue], EnumDirection.a, direction, 0.0f, 0.5f);
                        continue block4;
                    }
                }
                BlockRedstoneWire.a(level, random, pos, h[powerValue], EnumDirection.a, direction, 0.0f, 0.3f);
            }
        }
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        switch (rotation) {
            case c: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)state.b(b, state.c(d))).b(c, state.c(e))).b(d, state.c(b))).b(e, state.c(c));
            }
            case d: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)state.b(b, state.c(c))).b(c, state.c(d))).b(d, state.c(e))).b(e, state.c(b));
            }
            case b: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)state.b(b, state.c(e))).b(c, state.c(b))).b(d, state.c(c))).b(e, state.c(d));
            }
        }
        return state;
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        switch (mirror) {
            case b: {
                return (IBlockData)((IBlockData)state.b(b, state.c(d))).b(d, state.c(b));
            }
            case c: {
                return (IBlockData)((IBlockData)state.b(c, state.c(e))).b(e, state.c(c));
            }
        }
        return super.a(state, mirror);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, c, d, e, f);
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World level, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hitResult) {
        if (!player.gk().e) {
            return EnumInteractionResult.e;
        }
        if (BlockRedstoneWire.q(state) || BlockRedstoneWire.r(state)) {
            IBlockData blockState = BlockRedstoneWire.q(state) ? this.m() : this.R;
            blockState = (IBlockData)blockState.b(f, state.c(f));
            if ((blockState = this.a((IBlockAccess)level, blockState, pos)) != state) {
                level.a(pos, blockState, 3);
                this.a(level, pos, state, blockState);
                return EnumInteractionResult.a;
            }
        }
        return EnumInteractionResult.e;
    }

    private void a(World level, BlockPosition pos, IBlockData oldState, IBlockData newState) {
        Orientation orientation = ExperimentalRedstoneUtils.a(level, null, EnumDirection.b);
        for (EnumDirection direction : EnumDirection.EnumDirectionLimit.a) {
            BlockPosition blockPos = pos.a(direction);
            if (((BlockPropertyRedstoneSide)oldState.c(g.get(direction))).a() == ((BlockPropertyRedstoneSide)newState.c(g.get(direction))).a() || !level.a_(blockPos).d(level, blockPos)) continue;
            level.a(blockPos, newState.b(), direction.g(), ExperimentalRedstoneUtils.a(orientation, direction));
        }
    }
}

