/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.event.player.PlayerOpenSignEvent;
import java.util.Arrays;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SignApplicator;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyWood;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftSign;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerSignOpenEvent;

public abstract class BlockSign
extends BlockTileEntity
implements IBlockWaterlogged {
    public static final BlockStateBoolean d = BlockProperties.I;
    private static final VoxelShape a = Block.b(8.0, 0.0, 16.0);
    private final BlockPropertyWood b;

    protected BlockSign(BlockPropertyWood type, BlockBase.Info properties) {
        super(properties);
        this.b = type;
    }

    protected abstract MapCodec<? extends BlockSign> a();

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (state.c(d).booleanValue()) {
            scheduledTickAccess.a(pos, FluidTypes.c, FluidTypes.c.a(level));
        }
        return super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return a;
    }

    @Override
    public boolean a(IBlockData state) {
        return true;
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntitySign(pos, state);
    }

    @Override
    protected EnumInteractionResult a(ItemStack stack, IBlockData state, World level, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hitResult) {
        TileEntity tileEntity = level.c_(pos);
        if (tileEntity instanceof TileEntitySign) {
            boolean flag;
            SignApplicator signApplicator;
            TileEntitySign signBlockEntity = (TileEntitySign)tileEntity;
            Item item = stack.h();
            SignApplicator signApplicator1 = item instanceof SignApplicator ? (signApplicator = (SignApplicator)((Object)item)) : null;
            boolean bl = flag = signApplicator1 != null && player.gw();
            if (!level.C) {
                if (flag && !signBlockEntity.u() && !this.a(player, signBlockEntity)) {
                    boolean isFacingFrontText = signBlockEntity.a(player);
                    if (signApplicator1.a(signBlockEntity.a(isFacingFrontText), player) && signApplicator1.a(level, signBlockEntity, isFacingFrontText, player)) {
                        signBlockEntity.a(player, level, pos, isFacingFrontText);
                        player.b(StatisticList.c.b(stack.h()));
                        level.a(GameEvent.c, signBlockEntity.ax_(), GameEvent.a.a(player, signBlockEntity.m()));
                        stack.a(1, (EntityLiving)player);
                        return EnumInteractionResult.a;
                    }
                    return EnumInteractionResult.f;
                }
                return EnumInteractionResult.f;
            }
            return !flag && !signBlockEntity.u() ? EnumInteractionResult.c : EnumInteractionResult.a;
        }
        return EnumInteractionResult.e;
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World level, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hitResult) {
        TileEntity tileEntity = level.c_(pos);
        if (tileEntity instanceof TileEntitySign) {
            TileEntitySign signBlockEntity = (TileEntitySign)tileEntity;
            if (level.C) {
                SystemUtils.b(new IllegalStateException("Expected to only call this on server"));
            }
            boolean isFacingFrontText = signBlockEntity.a(player);
            boolean flag = signBlockEntity.a(player, level, pos, isFacingFrontText);
            if (signBlockEntity.u()) {
                level.a(null, signBlockEntity.ax_(), signBlockEntity.d(), SoundCategory.e);
                return EnumInteractionResult.b;
            }
            if (flag) {
                return EnumInteractionResult.b;
            }
            if (!this.a(player, signBlockEntity) && player.gw() && this.b(player, signBlockEntity, isFacingFrontText)) {
                this.openTextEdit(player, signBlockEntity, isFacingFrontText, PlayerOpenSignEvent.Cause.INTERACT);
                return EnumInteractionResult.b;
            }
            return EnumInteractionResult.e;
        }
        return EnumInteractionResult.e;
    }

    private boolean b(EntityHuman player, TileEntitySign signEntity, boolean isFrontText) {
        SignText text = signEntity.a(isFrontText);
        return Arrays.stream(text.b(player.W())).allMatch(line -> line.equals(CommonComponents.a) || line.b() instanceof LiteralContents);
    }

    public abstract float h(IBlockData var1);

    public Vec3D o(IBlockData state) {
        return new Vec3D(0.5, 0.5, 0.5);
    }

    @Override
    protected Fluid b_(IBlockData state) {
        return state.c(d) != false ? FluidTypes.c.a(false) : super.b_(state);
    }

    public BlockPropertyWood d() {
        return this.b;
    }

    public static BlockPropertyWood a(Block block) {
        BlockPropertyWood woodType = block instanceof BlockSign ? ((BlockSign)block).d() : BlockPropertyWood.b;
        return woodType;
    }

    @Deprecated
    @DoNotUse
    public void a(EntityHuman player, TileEntitySign signEntity, boolean isFrontText) {
        this.openTextEdit(player, signEntity, isFrontText, PlayerOpenSignEvent.Cause.UNKNOWN);
    }

    public void openTextEdit(EntityHuman player, TileEntitySign signEntity, boolean isFrontText, PlayerOpenSignEvent.Cause cause) {
        CraftBlock bukkitBlock;
        CraftSign bukkitSign;
        Player bukkitPlayer = (Player)player.getBukkitEntity();
        PlayerOpenSignEvent event = new PlayerOpenSignEvent(bukkitPlayer, (Sign)(bukkitSign = (CraftSign)CraftBlockStates.getBlockState(bukkitBlock = CraftBlock.at(signEntity.i(), signEntity.ax_()))), isFrontText ? Side.FRONT : Side.BACK, cause);
        if (!event.callEvent()) {
            return;
        }
        if (PlayerSignOpenEvent.getHandlerList().getRegisteredListeners().length > 0) {
            PlayerSignOpenEvent.Cause legacyCause;
            switch (cause) {
                default: {
                    throw new MatchException(null, null);
                }
                case PLACE: {
                    PlayerSignOpenEvent.Cause cause2 = PlayerSignOpenEvent.Cause.PLACE;
                    break;
                }
                case PLUGIN: {
                    PlayerSignOpenEvent.Cause cause2 = PlayerSignOpenEvent.Cause.PLUGIN;
                    break;
                }
                case INTERACT: {
                    PlayerSignOpenEvent.Cause cause2 = PlayerSignOpenEvent.Cause.INTERACT;
                    break;
                }
                case UNKNOWN: {
                    PlayerSignOpenEvent.Cause cause2 = legacyCause = PlayerSignOpenEvent.Cause.UNKNOWN;
                }
            }
            if (!CraftEventFactory.callPlayerSignOpenEvent(player, signEntity, isFrontText, legacyCause)) {
                return;
            }
        }
        signEntity.a(player.cG());
        player.a(signEntity, isFrontText);
    }

    private boolean a(EntityHuman player, TileEntitySign signEntity) {
        UUID playerWhoMayEdit = signEntity.t();
        return playerWhoMayEdit != null && !playerWhoMayEdit.equals(player.cG());
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> a(World level, IBlockData state, TileEntityTypes<T> blockEntityType) {
        return null;
    }
}

