/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.item.EntityTNTPrimed;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.event.block.TNTPrimeEvent;

public class BlockTNT
extends Block {
    public static final MapCodec<BlockTNT> a = BlockTNT.b(BlockTNT::new);
    public static final BlockStateBoolean b = BlockProperties.H;

    public MapCodec<BlockTNT> a() {
        return a;
    }

    public BlockTNT(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)this.m().b(b, false));
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, IBlockData oldState, boolean isMoving) {
        if (!oldState.a(state.b()) && level.D(pos) && BlockTNT.prime(level, pos, () -> CraftEventFactory.callTNTPrimeEvent(level, pos, TNTPrimeEvent.PrimeCause.REDSTONE, null, null))) {
            level.a(pos, false);
        }
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        if (level.D(pos) && BlockTNT.prime(level, pos, () -> CraftEventFactory.callTNTPrimeEvent(level, pos, TNTPrimeEvent.PrimeCause.REDSTONE, null, null))) {
            level.a(pos, false);
        }
    }

    @Override
    public IBlockData a(World level, BlockPosition pos, IBlockData state, EntityHuman player) {
        if (!level.A_() && !player.gk().d && state.c(b).booleanValue()) {
            BlockTNT.prime(level, pos, () -> CraftEventFactory.callTNTPrimeEvent(level, pos, TNTPrimeEvent.PrimeCause.BLOCK_BREAK, player, null));
        }
        return super.a(level, pos, state, player);
    }

    @Override
    public void a(WorldServer level, BlockPosition pos, Explosion explosion) {
        if (level.O().c(GameRules.ad)) {
            EntityTNTPrimed primedTnt = new EntityTNTPrimed(level, (double)pos.u() + 0.5, pos.v(), (double)pos.w() + 0.5, explosion.c());
            int fuse = primedTnt.f();
            primedTnt.b((short)(level.A.a(fuse / 4) + fuse / 8));
            level.b(primedTnt);
        }
    }

    public static boolean a(World level, BlockPosition pos) {
        return BlockTNT.prime(level, pos, null, () -> true);
    }

    public static boolean prime(World level, BlockPosition pos, BooleanSupplier event) {
        return BlockTNT.prime(level, pos, null, event);
    }

    private static boolean prime(World level, BlockPosition pos, @Nullable EntityLiving entity, BooleanSupplier event) {
        WorldServer serverLevel;
        if (level instanceof WorldServer && (serverLevel = (WorldServer)level).O().c(GameRules.ad) && event.getAsBoolean()) {
            EntityTNTPrimed primedTnt = new EntityTNTPrimed(level, (double)pos.u() + 0.5, pos.v(), (double)pos.w() + 0.5, entity);
            level.b(primedTnt);
            level.a(null, primedTnt.dA(), primedTnt.dC(), primedTnt.dG(), SoundEffects.AC, SoundCategory.e, 1.0f, 1.0f);
            level.a((Entity)entity, GameEvent.I, pos);
            return true;
        }
        return false;
    }

    @Override
    protected EnumInteractionResult a(ItemStack stack, IBlockData state, World level, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hitResult) {
        WorldServer serverLevel;
        if (!stack.a(Items.pg) && !stack.a(Items.vg)) {
            return super.a(stack, state, level, pos, player, hand, hitResult);
        }
        if (BlockTNT.prime(level, pos, player, () -> CraftEventFactory.callTNTPrimeEvent(level, pos, TNTPrimeEvent.PrimeCause.PLAYER, player, null))) {
            level.a(pos, Blocks.a.m(), 11);
            Item item = stack.h();
            if (stack.a(Items.pg)) {
                stack.a(1, (EntityLiving)player, EntityLiving.d(hand));
            } else {
                stack.a(1, (EntityLiving)player);
            }
            player.b(StatisticList.c.b(item));
        } else if (level instanceof WorldServer && !(serverLevel = (WorldServer)level).O().c(GameRules.ad)) {
            player.a(IChatBaseComponent.c("block.minecraft.tnt.disabled"), true);
            return EnumInteractionResult.e;
        }
        return EnumInteractionResult.a;
    }

    @Override
    protected void a(World level, IBlockData state, MovingObjectPositionBlock hit, IProjectile projectile) {
        if (level instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)level;
            BlockPosition blockPos = hit.b();
            Entity owner = projectile.p();
            if (projectile.bX() && projectile.c(serverLevel, blockPos) && BlockTNT.prime(level, blockPos, owner instanceof EntityLiving ? (EntityLiving)owner : null, () -> CraftEventFactory.callEntityChangeBlockEvent(projectile, blockPos, state.y().g()) && CraftEventFactory.callTNTPrimeEvent(level, blockPos, TNTPrimeEvent.PrimeCause.PROJECTILE, projectile, null))) {
                level.a(blockPos, false);
            }
        }
    }

    @Override
    public boolean a(Explosion explosion) {
        return false;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{b});
    }
}

