/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.FluidTypes;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;

public class BlockTallPlant
extends VegetationBlock {
    public static final MapCodec<BlockTallPlant> a = BlockTallPlant.b(BlockTallPlant::new);
    public static final BlockStateEnum<BlockPropertyDoubleBlockHalf> b = BlockProperties.ah;

    public MapCodec<? extends BlockTallPlant> a() {
        return a;
    }

    public BlockTallPlant(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)this.C.b().b(b, BlockPropertyDoubleBlockHalf.b));
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        BlockPropertyDoubleBlockHalf doubleBlockHalf = state.c(b);
        if (direction.o() != EnumDirection.EnumAxis.b || doubleBlockHalf == BlockPropertyDoubleBlockHalf.b != (direction == EnumDirection.b) || neighborState.a(this) && neighborState.c(b) != doubleBlockHalf) {
            return doubleBlockHalf == BlockPropertyDoubleBlockHalf.b && direction == EnumDirection.a && !state.a(level, pos) ? Blocks.a.m() : super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
        }
        return Blocks.a.m();
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext context) {
        BlockPosition clickedPos = context.a();
        World level = context.q();
        return clickedPos.v() < level.ao() && level.a_(clickedPos.d()).a(context) ? super.a(context) : null;
    }

    @Override
    public void a(World level, BlockPosition pos, IBlockData state, EntityLiving placer, ItemStack stack) {
        BlockPosition blockPos = pos.d();
        level.a(blockPos, BlockTallPlant.b(level, blockPos, (IBlockData)this.m().b(b, BlockPropertyDoubleBlockHalf.a)), 3);
    }

    @Override
    protected boolean a(IBlockData state, IWorldReader level, BlockPosition pos) {
        if (state.c(b) != BlockPropertyDoubleBlockHalf.a) {
            return super.a(state, level, pos);
        }
        IBlockData blockState = level.a_(pos.e());
        return blockState.a(this) && blockState.c(b) == BlockPropertyDoubleBlockHalf.b;
    }

    public static void a(GeneratorAccess level, IBlockData state, BlockPosition pos, int flags) {
        BlockPosition blockPos = pos.d();
        level.a(pos, BlockTallPlant.b(level, pos, (IBlockData)state.b(b, BlockPropertyDoubleBlockHalf.b)), flags);
        level.a(blockPos, BlockTallPlant.b(level, blockPos, (IBlockData)state.b(b, BlockPropertyDoubleBlockHalf.a)), flags);
    }

    public static IBlockData b(IWorldReader level, BlockPosition pos, IBlockData state) {
        return state.b(BlockProperties.I) ? (IBlockData)state.b(BlockProperties.I, level.A(pos)) : state;
    }

    @Override
    public IBlockData a(World level, BlockPosition pos, IBlockData state, EntityHuman player) {
        if (!level.C) {
            if (player.gl()) {
                BlockTallPlant.b(level, pos, state, player);
            } else {
                BlockTallPlant.a(state, level, pos, null, (Entity)player, player.fb());
            }
        }
        return super.a(level, pos, state, player);
    }

    @Override
    public void playerDestroy(World level, EntityHuman player, BlockPosition pos, IBlockData state, @Nullable TileEntity te, ItemStack stack, boolean includeDrops, boolean dropExp) {
        super.playerDestroy(level, player, pos, Blocks.a.m(), te, stack, includeDrops, dropExp);
    }

    protected static void b(World level, BlockPosition pos, IBlockData state, EntityHuman player) {
        BlockPosition blockPos;
        IBlockData blockState;
        if (((WorldServer)level).hasPhysicsEvent && CraftEventFactory.callBlockPhysicsEvent(level, pos).isCancelled()) {
            return;
        }
        BlockPropertyDoubleBlockHalf doubleBlockHalf = state.c(b);
        if (doubleBlockHalf == BlockPropertyDoubleBlockHalf.a && (blockState = level.a_(blockPos = pos.e())).a(state.b()) && blockState.c(b) == BlockPropertyDoubleBlockHalf.b) {
            IBlockData blockState1 = blockState.y().b(FluidTypes.c) ? Blocks.J.m() : Blocks.a.m();
            level.a(blockPos, blockState1, 35);
            level.a((Entity)player, 2001, blockPos, Block.j(blockState));
        }
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{b});
    }

    @Override
    protected long a(IBlockData state, BlockPosition pos) {
        return MathHelper.b(pos.u(), pos.c(state.c(b) == BlockPropertyDoubleBlockHalf.b ? 0 : 1).v(), pos.w());
    }
}

