/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.block.TargetHitEvent;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlock;
import org.bukkit.entity.Projectile;

public class BlockTarget
extends Block {
    public static final MapCodec<BlockTarget> a = BlockTarget.b(BlockTarget::new);
    private static final BlockStateInteger b = BlockProperties.aW;
    private static final int c = 20;
    private static final int d = 8;

    public MapCodec<BlockTarget> a() {
        return a;
    }

    public BlockTarget(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)this.C.b().b(b, 0));
    }

    @Override
    protected void a(World level, IBlockData state, MovingObjectPositionBlock hit, IProjectile projectile) {
        int i2 = BlockTarget.a((GeneratorAccess)level, state, hit, projectile);
    }

    private static void awardTargetHitCriteria(IProjectile projectile, MovingObjectPositionBlock hit, int i2) {
        Entity entity = projectile.p();
        if (entity instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)entity;
            serverPlayer.a(StatisticList.aE);
            CriterionTriggers.M.a(serverPlayer, projectile, hit.g(), i2);
        }
    }

    private static int a(GeneratorAccess level, IBlockData state, MovingObjectPositionBlock hit, Entity projectile) {
        int redstoneStrength = BlockTarget.a(hit, hit.g());
        int i2 = projectile instanceof EntityArrow ? 20 : 8;
        boolean shouldAward = false;
        if (projectile instanceof IProjectile) {
            CraftBlock craftBlock = CraftBlock.at(level, hit.b());
            BlockFace blockFace = CraftBlock.notchToBlockFace(hit.c());
            TargetHitEvent targetHitEvent = new TargetHitEvent((Projectile)projectile.getBukkitEntity(), (org.bukkit.block.Block)craftBlock, blockFace, redstoneStrength);
            if (targetHitEvent.callEvent()) {
                redstoneStrength = targetHitEvent.getSignalStrength();
                shouldAward = true;
            } else {
                return redstoneStrength;
            }
        }
        if (!level.U().a(hit.b(), state.b())) {
            BlockTarget.a(level, state, redstoneStrength, hit.b(), i2);
        }
        if (shouldAward) {
            BlockTarget.awardTargetHitCriteria((IProjectile)projectile, hit, redstoneStrength);
        }
        return redstoneStrength;
    }

    private static int a(MovingObjectPositionBlock hit, Vec3D hitLocation) {
        EnumDirection direction = hit.c();
        double abs = Math.abs(MathHelper.e(hitLocation.d) - 0.5);
        double abs1 = Math.abs(MathHelper.e(hitLocation.e) - 0.5);
        double abs2 = Math.abs(MathHelper.e(hitLocation.f) - 0.5);
        EnumDirection.EnumAxis axis = direction.o();
        double max = axis == EnumDirection.EnumAxis.b ? Math.max(abs, abs2) : (axis == EnumDirection.EnumAxis.c ? Math.max(abs, abs1) : Math.max(abs1, abs2));
        return Math.max(1, MathHelper.c(15.0 * MathHelper.a((0.5 - max) / 0.5, 0.0, 1.0)));
    }

    private static void a(GeneratorAccess level, IBlockData state, int power, BlockPosition pos, int waitTime) {
        level.a(pos, (IBlockData)state.b(b, power), 3);
        level.a(pos, state.b(), waitTime);
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        if (state.c(b) != 0) {
            level.a(pos, (IBlockData)state.b(b, 0), 3);
        }
    }

    @Override
    protected int a(IBlockData blockState, IBlockAccess blockAccess, BlockPosition pos, EnumDirection side) {
        return blockState.c(b);
    }

    @Override
    protected boolean f_(IBlockData state) {
        return true;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{b});
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, IBlockData oldState, boolean isMoving) {
        if (!(level.A_() || state.a(oldState.b()) || state.c(b) <= 0 || level.U().a(pos, this))) {
            level.a(pos, (IBlockData)state.b(b, 0), 18);
        }
    }
}

